/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.locator;

import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.locator.LocatorImpl;
import javax.tv.locator.MalformedLocatorException;
import org.bluray.net.BDLocator;
import org.videolan.Logger;

public class LocatorFactoryImpl
extends LocatorFactory {
    private static final Logger logger = Logger.getLogger(LocatorFactoryImpl.class.getName());

    @Override
    public Locator createLocator(String url) throws MalformedLocatorException {
        if (url == null) {
            logger.error("null locator");
            throw new NullPointerException("Source Locator is null");
        }
        if (url.startsWith("bd:/")) {
            try {
                return new BDLocator(url);
            }
            catch (org.davic.net.InvalidLocatorException ex) {
                logger.error("invalid locator: " + url);
                throw new MalformedLocatorException(ex.getMessage());
            }
        }
        logger.error("unknown locator type: " + url);
        return new LocatorImpl(url);
    }

    @Override
    public Locator[] transformLocator(Locator source) throws InvalidLocatorException {
        if (source == null) {
            logger.error("null locator");
            throw new NullPointerException("Source Locator is null");
        }
        if (source instanceof BDLocator) {
            return new Locator[]{source};
        }
        logger.error("unsupported locator: " + source);
        throw new InvalidLocatorException(source, "Source locator is invalid.");
    }
}

