/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.SpartanArchive;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SpartanReader
extends AtomSetCollectionReader {
    public void initializeReader() throws Exception {
        String string = "Cartesian Coordinates (Ang";
        if (this.isSpartanArchive(string)) {
            Hashtable hashtable = new Hashtable();
            SpartanArchive spartanArchive = new SpartanArchive(this, this.atomSetCollection, hashtable);
            int n = spartanArchive.readArchive(this.line, true, 0, true);
            if (n > 0) {
                this.atomSetCollection.setAtomSetName("Spartan file");
            }
        } else if (this.line.indexOf(string) >= 0) {
            this.readAtoms();
            this.discardLinesUntilContains("Vibrational Frequencies");
            if (this.line != null) {
                this.readFrequencies();
            }
        }
        this.continuing = false;
    }

    private boolean isSpartanArchive(String string) throws Exception {
        String string2 = "";
        while (this.readLine() != null) {
            if (this.line.equals("GEOMETRY")) {
                this.line = string2;
                return true;
            }
            if (this.line.indexOf(string) >= 0) {
                return false;
            }
            string2 = this.line;
        }
        return false;
    }

    private void readAtoms() throws Exception {
        this.discardLinesUntilBlank();
        while (this.readLine() != null && this.parseInt(this.line, 0, 3) > 0) {
            String string = this.parseToken(this.line, 4, 6);
            String string2 = this.parseToken(this.line, 7, 13);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.atomName = string2;
            atom.set(this.parseFloat(this.line, 17, 30), this.parseFloat(this.line, 31, 44), this.parseFloat(this.line, 45, 58));
        }
    }

    private void readFrequencies() throws Exception {
        int n = this.atomSetCollection.getFirstAtomSetAtomCount();
        block0: while (true) {
            float f;
            int n2;
            this.discardLinesUntilNonBlank();
            int n3 = this.vibrationNumber;
            this.next[0] = 16;
            boolean[] blArray = new boolean[3];
            for (n2 = 0; n2 < 3 && !Float.isNaN(f = this.parseFloat()); ++n2) {
                boolean bl = blArray[n2] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[n2] || this.vibrationNumber <= 1) continue;
                this.atomSetCollection.cloneFirstAtomSet();
            }
            if (n2 == 0) {
                return;
            }
            this.discardLines(2);
            int n4 = 0;
            while (true) {
                if (n4 >= n) continue block0;
                this.readLine();
                for (int i = 0; i < n2; ++i) {
                    int n5 = i * 23 + 10;
                    float f2 = this.parseFloat(this.line, n5, n5 + 7);
                    float f3 = this.parseFloat(this.line, n5 + 7, n5 + 14);
                    float f4 = this.parseFloat(this.line, n5 + 14, n5 + 21);
                    if (blArray[i]) continue;
                    this.atomSetCollection.addVibrationVector(n4 + (n3 + i) * n, f2, f3, f4);
                }
                ++n4;
            }
            break;
        }
    }
}

