// Copyright 2025 the Fearless_SIMD Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

#![expect(
    missing_docs,
    clippy::cast_possible_truncation,
    clippy::unseparated_literal_suffix,
    trivial_numeric_casts,
    reason = "TODO: https://github.com/linebender/fearless_simd/issues/40"
)]
#![cfg_attr(
    target_arch = "x86_64",
    expect(
        clippy::should_implement_trait,
        clippy::missing_transmute_annotations,
        clippy::useless_transmute,
        clippy::new_without_default,
        clippy::unnecessary_cast,
        reason = "TODO: https://github.com/linebender/fearless_simd/issues/40"
    )
)]
#![cfg_attr(
    target_arch = "wasm32",
    expect(
        clippy::should_implement_trait,
        clippy::missing_transmute_annotations,
        clippy::useless_transmute,
        clippy::new_without_default,
        clippy::unnecessary_cast,
        reason = "TODO: https://github.com/linebender/fearless_simd/issues/40"
    )
)]
#![cfg_attr(
    all(
        feature = "std",
        all(not(target_arch = "x86_64"), not(target_arch = "wasm32"))
    ),
    expect(
        clippy::missing_safety_doc,
        clippy::should_implement_trait,
        clippy::missing_transmute_annotations,
        clippy::useless_transmute,
        clippy::new_without_default,
        clippy::unnecessary_cast,
        reason = "TODO: https://github.com/linebender/fearless_simd/issues/40"
    )
)]

//! A module containing generated files
//!
//! All files in this subdirectory are autogenerated by the `fearless_simd_gen` crate.

#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
mod avx2;
mod fallback;
#[cfg(target_arch = "aarch64")]
mod neon;
mod ops;
mod simd_trait;
mod simd_types;
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
mod sse4_2;
#[cfg(all(target_arch = "wasm32", target_feature = "simd128"))]
mod wasm;

#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
pub use avx2::*;
pub use fallback::*;
#[cfg(target_arch = "aarch64")]
pub use neon::*;
pub use simd_trait::*;
pub use simd_types::*;
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
pub use sse4_2::*;
#[cfg(all(target_arch = "wasm32", target_feature = "simd128"))]
pub use wasm::*;
