% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_logical.R
\name{sparse_logical}
\alias{sparse_logical}
\title{Create sparse logical vector}
\usage{
sparse_logical(values, positions, length, default = FALSE)
}
\arguments{
\item{values}{logical vector, values of non-zero entries.}

\item{positions}{integer vector, indices of non-zero entries.}

\item{length}{integer value, Length of vector.}

\item{default}{logical value, value at indices not specified by \code{positions}.
Defaults to \code{FALSE}. Cannot be \code{NA}.}
}
\value{
sparse logical vector
}
\description{
Construction of vectors where only values and positions are recorded. The
Length and default values determine all other information.
}
\details{
\code{values} and \code{positions} are expected to be the same length, and are allowed
to both have zero length.

Allowed values for \code{value} are logical values. Missing values such as \code{NA}
and \code{NA_real_} are allowed. Everything else is disallowed, The values are
also not allowed to take the same value as \code{default}.

\code{positions} should be integers or integer-like doubles. Everything else is
not allowed. Positions should furthermore be positive (\code{0} not allowed),
unique, and in increasing order. Lastly they should all be smaller that
\code{length}.

For developers:

setting \code{options("sparsevctrs.verbose_materialize" = TRUE)} will print a
message each time a sparse vector has been forced to materialize.
}
\examples{
sparse_logical(logical(), integer(), 10)

sparse_logical(c(TRUE, NA, TRUE), c(2, 5, 10), 10)

str(
  sparse_logical(c(TRUE, NA, TRUE), c(2, 5, 10), 1000000000)
)
}
\seealso{
\code{\link[=sparse_double]{sparse_double()}} \code{\link[=sparse_integer]{sparse_integer()}} \code{\link[=sparse_character]{sparse_character()}}
}
