% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{network.layout}
\alias{network.layout}
\alias{network.layout.circle}
\alias{network.layout.fruchtermanreingold}
\alias{network.layout.kamadakawai}
\title{Vertex Layout Functions for plot.network}
\usage{
network.layout.circle(nw, layout.par)

network.layout.fruchtermanreingold(nw, layout.par)

network.layout.kamadakawai(nw, layout.par)
}
\arguments{
\item{nw}{a network object, as passed by \code{\link{plot.network}}.}

\item{layout.par}{a list of parameters.}
}
\value{
A matrix whose rows contain the x,y coordinates of the vertices of
\code{d}.
}
\description{
Various functions which generate vertex layouts for the
\code{\link{plot.network}} visualization routine.
}
\details{
Vertex layouts for network visualization pose a difficult problem -- there
is no single, ``good'' layout algorithm, and many different approaches may
be valuable under different circumstances.  With this in mind,
\code{\link{plot.network}} allows for the use of arbitrary vertex layout
algorithms via the \code{network.layout.*} family of routines.  When called,
\code{\link{plot.network}} searches for a \code{network.layout} function
whose fourth name matches its \code{mode} argument (see
\code{\link{plot.network}} help for more information); this function is then
used to generate the layout for the resulting plot.  In addition to the
routines documented here, users may add their own layout functions as
needed.  The requirements for a \code{network.layout} function are as
follows:
\enumerate{
\item the first argument, \code{nw}, must be a network object;
\item the second argument, \code{layout.par}, must be a list of parameters
(or \code{NULL}, if no parameters are specified); and
\item the return value must be a real matrix of dimension \code{c(2,network.size(nw))},
whose rows contain the vertex coordinates.
}
Other than this, anything goes.  (In particular, note that \code{layout.par}
could be used to pass additional matrices or other information, if needed.
Alternately, it is possible to make layout methods that respond to
covariates on the network object, which are maintained intact by
plot.network.)

The \code{network.layout} functions currently supplied by default are as
follows (with \code{n==network.size(nw)}):
\describe{
\item{circle}{ This function places vertices uniformly in a circle; it takes no arguments.}
\item{fruchtermanreingold}{ This function generates a layout using a variant of Fruchterman and Reingold's force-directed placement algorithm.  It takes the following arguments:
\describe{
\item{layout.par$niter}{ This argument controls the number of iterations to be employed.  Larger values take longer, but will provide a more refined layout.  (Defaults to 500.) }
\item{layout.par$max.delta}{ Sets the maximum change in position for any given iteration.  (Defaults to \code{n}.)}
\item{layout.par$area}{ Sets the "area" parameter for the F-R algorithm. (Defaults to \code{n^2}.)}
\item{layout.par$cool.exp}{ Sets the cooling exponent for the annealer. (Defaults to 3.)}
\item{layout.par$repulse.rad}{ Determines the radius at which vertex-vertex repulsion cancels out attraction of adjacent vertices. (Defaults to \code{area*log(n)}.)}
\item{layout.par$ncell}{ To speed calculations on large graphs, the plot region is divided at each iteration into \code{ncell} by \code{ncell} \dQuote{cells}, which are used to define neighborhoods for force calculation.  Moderate numbers of cells result in fastest performance; too few cells (down to 1, which produces \dQuote{pure} F-R results) can yield odd layouts, while too many will result in long layout times.  (Defaults to \code{n^0.4}.)}
\item{layout.par$cell.jitter}{ Jitter factor (in units of cell width) used in assigning vertices to cells. Small values may generate \dQuote{grid-like} anomalies for graphs with many isolates.  (Defaults to \code{0.5}.)}
\item{layout.par$cell.pointpointrad}{ Squared \dQuote{radius} (in units of cells) such that exact point interaction calculations are used for all vertices belonging to any two cells less than or equal to this distance apart.  Higher values approximate the true F-R solution, but increase computational cost.  (Defaults to \code{0}.)}
\item{layout.par$cell.pointcellrad}{ Squared \dQuote{radius} (in units of cells) such that approximate point/cell interaction calculations are used for all vertices belonging to any two cells less than or equal to this distance apart (and not within the point/point radius). Higher values provide somewhat better approximations to the true F-R solution at slightly increased computational cost.  (Defaults to \code{18}.)}
\item{layout.par$cell.cellcellrad}{ Squared \dQuote{radius} (in units of cells) such that approximate cell/cell interaction calculations are used for all vertices belonging to any two cells less than or equal to this distance apart (and not within the point/point or point/cell radii). Higher values provide somewhat better approximations to the true F-R solution at slightly increased computational cost.  Note that cells beyond this radius (if any) do not interact, save through edge attraction. (Defaults to \code{ncell^2}.)}
\item{layout.par$seed.coord}{ A two-column matrix of initial vertex coordinates.  (Defaults to a random circular layout.) }
}
}
\item{kamadakawai}{ This function generates a vertex layout using a version of the Kamada-Kawai force-directed placement algorithm.  It takes the following arguments:
\describe{
\item{layout.par$niter}{ This argument controls the number of iterations to be employed.  (Defaults to 1000.) }
\item{layout.par$sigma}{ Sets the base standard deviation of position change proposals.  (Defaults to \code{n/4}.)}
\item{layout.par$initemp}{ Sets the initial "temperature" for the annealing algorithm. (Defaults to 10.)}
\item{layout.par$cool.exp}{ Sets the cooling exponent for the annealer. (Defaults to 0.99.)}
\item{layout.par$kkconst}{ Sets the Kamada-Kawai vertex attraction constant.  (Defaults to \code{n)^2}.)}
\item{layout.par$elen}{ Provides the matrix of interpoint distances to be approximated.  (Defaults to the geodesic distances of \code{nw} after symmetrizing, capped at \code{sqrt(n)}.)}
\item{layout.par$seed.coord}{ A two-column matrix of initial vertex coordinates.  (Defaults to a gaussian layout.) }
}
}
}
}
\note{
The \code{network.layout} routines shown here are adapted directly
from the \code{\link[sna]{gplot.layout}} routines of the \code{sna} package.
}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\doi{10.18637/jss.v024.i02}

Fruchterman, T.M.J. and Reingold, E.M.  (1991).  \dQuote{Graph Drawing by
Force-directed Placement.} \emph{Software - Practice and Experience,}
21(11):1129-1164.

Kamada, T. and Kawai, S.  (1989). \dQuote{An Algorithm for Drawing General
Undirected Graphs.} \emph{Information Processing Letters,} 31(1):7-15.
}
\seealso{
\code{\link{plot.network}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu}
}
\keyword{dplot}
\keyword{graphs}
