% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-paths.R
\name{pathing}
\alias{pathing}
\alias{set_latte_path}
\alias{set_4ti2_path}
\alias{get_4ti2_path}
\alias{get_latte_path}
\alias{has_4ti2}
\alias{has_latte}
\alias{missing_4ti2_stop}
\alias{missing_latte_stop}
\title{Set paths to LattE and 4ti2 executables}
\usage{
set_latte_path(path)

set_4ti2_path(path)

get_4ti2_path()

get_latte_path()

has_4ti2()

has_latte()

missing_4ti2_stop()

missing_latte_stop()
}
\arguments{
\item{path}{A character string, the path to a 4ti2 function (e.g. \code{markov})
for setting 4ti2's path or a LattE function (e.g. \code{count}) for LattE's path}
}
\value{
A logical(1) or character(1) containing the path.
}
\description{
These are helper functions that deal with pathing to external programs and
asking if they are present. When latte is loaded it attempts to find LattE
and 4ti2 executables by looking for environment variables specifying them,
i.e. their paths as specified in your \code{.Renviron} file.
}
\details{
For easiest use, you'll want to specify the paths of LattE and 4ti2
executables in your \verb{~/.Renviron} file. They should look something like

\verb{LATTE=/Applications/latte/bin}

\verb{FOURTITWO=/Applications/latte/bin}

You can set these permanently with \code{\link[usethis:edit]{usethis::edit_r_environ()}}.

You can change these for the current session using, e.g., \code{\link[=set_latte_path]{set_latte_path()}},
which accepts a character string or, if missing, uses \code{\link[=file.choose]{file.choose()}} to let
you interactively; you just select an arbitrary executable.
}
\examples{


has_4ti2()
if (has_4ti2()) get_4ti2_path()

has_latte()
if (has_4ti2()) get_latte_path()


# you can set these paths permanently with the following. note that you'll 
# need to re-start the R session afterwards or simply pass the path into, 
# e.g., set_latte_path(). see below for more details on that.
if (interactive()) edit_r_environ()


# you can change these in your current session with set_latte_path() and
if (had_latte <- has_latte()) old_latte_path <- get_latte_path()
set_latte_path("/path/to/latte")
get_latte_path()

if (had_latte) set_latte_path(old_latte_path)
get_latte_path()

}
\author{
David Kahle \email{david@kahle.io}
}
