% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff_str}
\alias{diff_str}
\title{Compare two character strings, character by character}
\usage{
diff_str(old, new, max_dist = Inf)
}
\arguments{
\item{old}{First string, must not be \code{NA}.}

\item{new}{Second string, must not be \code{NA}.}

\item{max_dist}{Maximum distance to consider, or \code{Inf} for no limit.
If the LCS edit distance is larger than this, then the function
throws an error with class \code{"cli_diff_max_dist"}. (If you specify
\code{Inf} the real limit is \code{.Machine$integer.max} but to reach this the
function would have to run a very long time.)}
}
\value{
A list that is a \code{cli_diff_str} object and also a
\code{cli_diff_chr} object, see \link{diff_str} for the details about its
structure.
}
\description{
Characters are defined by UTF-8 graphemes.
}
\examples{
str1 <- "abcdefghijklmnopqrstuvwxyz"
str2 <- "PREabcdefgMIDDLEnopqrstuvwxyzPOST"
diff_str(str1, str2)
}
\seealso{
The diffobj package for a much more comprehensive set of
\code{diff}-like tools.

Other diff functions in cli: 
\code{\link{diff_chr}()}
}
\concept{diff functions in cli}
