
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2451178.1,
          {0.3461,-0.00105,115.2731,0.24113,0.000839,0.1168}, /*cmx*/
          {-1.299408,-3.9649,-0.7944,-2.5379}, /*cfx*/
          {0.0743,-0.00047,190.5676,0.0467,0.000113,0.2383}, /*cmy*/
          {-5.909846,-3.9828,-0.6805,-4.3462}, /*cfy*/
          {-0.2755,0.0046,153.0009,0.17359,0.000577,0.1406}, /*cmz*/
          {-1.14065,-0.7314,-3.969,-0.8169} /*cfz*/
     },
     {
          2451436.1,
          {0.346,-0.00519,110.712,0.07677,0.000248,0.7467}, /*cmx*/
          {-5.282446,-1.0947,-2.2147,-0.8041}, /*cfx*/
          {-0.1755,-0.00053,190.1068,0.08031,0.000306,0.2468}, /*cmy*/
          {-3.578965,-5.1665,-1.9443,-1.1924}, /*cfy*/
          {-0.0521,0.00469,156.7028,0.07055,0.000304,0.3952}, /*cmz*/
          {-5.082421,-6.2659,-4.0391,-3.6858} /*cfz*/
     },
     {
          2451694.1,
          {0.8483,-0.00495,86.508,0.1995,0.000735,0.3147}, /*cmx*/
          {-3.146737,-2.5315,-5.5913,-4.143}, /*cfx*/
          {0.2947,-0.00404,188.8461,0.03069,2.7e-05,0.136}, /*cmy*/
          {-1.266652,-2.7352,-3.2031,-3.2914}, /*cfy*/
          {-0.0842,0.00404,172.9447,0.10483,0.000354,0.2041}, /*cmz*/
          {-2.76686,-5.7289,-2.8802,-4.3127} /*cfz*/
     },
     {
          2451952.1,
          {-0.711,0.00537,88.2264,0.13607,0.000617,0.1098}, /*cmx*/
          {-0.882404,-3.4907,-0.2756,-0.9555}, /*cfx*/
          {0.0211,-0.00143,188.7284,0.08921,0.000316,0.2661}, /*cmy*/
          {-5.287897,-3.5973,-0.4399,-4.2177}, /*cfy*/
          {0.4587,-0.00035,171.7258,0.09865,0.00039,0.0735}, /*cmz*/
          {-0.497749,-5.9861,-2.9359,-5.1132} /*cfz*/
     },
     {
          2452210.1,
          {-0.5264,0.00087,92.7604,0.20726,0.000368,0.7905}, /*cmx*/
          {-4.798751,-0.9085,-3.8699,-0.7655}, /*cfx*/
          {-0.2883,-0.00144,188.9553,0.03047,0.00021,0.448}, /*cmy*/
          {-2.973354,-4.9782,-1.521,-0.6954}, /*cfy*/
          {0.8099,-0.00274,169.2922,0.08841,0.000222,0.2652}, /*cmz*/
          {-4.470932,-4.7077,-2.1175,-3.4055} /*cfz*/
     },
     {
          2452468.1,
          {-0.0424,0.00234,72.1996,0.18572,0.000895,0.4242}, /*cmx*/
          {-2.709299,-1.9528,-5.048,-4.0582}, /*cfx*/
          {0.0386,-0.00303,187.6783,0.08491,0.000223,0.1556}, /*cmy*/
          {-0.629188,-2.1492,-5.1856,-1.5119}, /*cfy*/
          {0.8141,-0.00374,180.4192,0.10267,0.000374,0.2305}, /*cmz*/
          {-2.130768,-4.4811,-1.6656,-3.6272} /*cfz*/
     },
     {
          2452726.1,
          {-1.5295,0.0127,63.6536,0.01232,0.000217,0.0814}, /*cmx*/
          {-0.575193,-0.8118,-5.6987,-4.4921}, /*cfx*/
          {-0.5839,0.00244,186.5057,0.06464,0.000321,0.2006}, /*cmy*/
          {-4.631494,-2.9883,-6.0876,-3.8945}, /*cfy*/
          {0.8136,-0.00486,184.6527,0.07169,0.000328,0.0999}, /*cmz*/
          {-6.144292,-4.5661,-1.6524,-5.9815} /*cfz*/
     },
     {
          2452984.1,
          {-0.8551,0.0051,73.2585,0.28594,0.000775,0.5554}, /*cmx*/
          {-4.407751,-0.4929,-3.634,-0.7}, /*cfx*/
          {-0.9257,0.00293,187.7144,0.06803,0.000107,0.4309}, /*cmy*/
          {-2.351414,-0.455,-3.4386,-0.4627}, /*cfy*/
          {0.7611,-0.00487,180.2162,0.08254,0.000233,0.1591}, /*cmz*/
          {-3.852213,-3.7094,-0.9871,-0.9557} /*cfz*/
     },
     {
          2453242.1,
          {0.1653,0.00282,60.5508,0.09335,0.000712,0.6843}, /*cmx*/
          {-2.317753,-1.5368,-4.5794,-3.9303}, /*cfx*/
          {-0.3866,0.00062,186.0362,0.10397,0.000405,0.0819}, /*cmy*/
          {-6.275127,-1.5086,-4.6098,-0.8536}, /*cfy*/
          {0.5137,-0.0034,186.1281,0.09035,0.00031,0.1197}, /*cmz*/
          {-1.507664,-3.4174,-0.565,-2.1614} /*cfz*/
     },
     {
          2453500.1,
          {-0.9625,0.01051,50.2865,0.11796,0.000248,0.3283}, /*cmx*/
          {-0.412814,-5.4839,-2.3392,-3.9521}, /*cfx*/
          {-0.882,0.00547,185.4359,0.00853,0.000176,0.3039}, /*cmy*/
          {-3.957285,-1.6133,-5.3851,-3.5903}, /*cfy*/
          {0.151,-0.0017,190.0208,0.03866,0.000228,0.1349}, /*cmz*/
          {-5.504474,-3.5668,-0.7158,-0.4748} /*cfz*/
     },
     {
          2453758.1,
          {-0.1422,0.00155,55.4293,0.25804,0.000866,0.3065}, /*cmx*/
          {-4.215525,-6.248,-3.0991,-0.6964}, /*cfx*/
          {-0.934,0.0041,185.354,0.12506,0.000351,0.1703}, /*cmy*/
          {-1.70032,-0.0622,-3.2209,-0.2283}, /*cfy*/
          {0.0602,-0.00121,188.6438,0.05446,0.000127,0.2954}, /*cmz*/
          {-3.226038,-2.1294,-5.4578,-0.4312} /*cfz*/
     },
     {
          2454016.1,
          {1.0964,-0.00352,52.1914,0.07177,0.000196,0.8054}, /*cmx*/
          {-1.995762,-3.7213,-4.1603,-3.8551}, /*cfx*/
          {-0.1264,-5e-05,185.2555,0.06646,0.000368,0.1398}, /*cmy*/
          {-5.635271,-1.0131,-4.0806,-4.5065}, /*cfy*/
          {-0.1224,0.001,189.3616,0.07355,0.000282,0.0715}, /*cmz*/
          {-0.892605,-2.3237,-5.5506,-1.6639} /*cfz*/
     },
     {
          2454274.1,
          {0.2936,0.00076,51.0954,0.20079,0.000726,0.3496}, /*cmx*/
          {-0.285197,-4.7493,-1.6029,-3.7157}, /*cfx*/
          {-0.3775,0.00275,184.3407,0.06364,0.000103,0.2989}, /*cmy*/
          {-3.283398,-4.7996,-1.4794,-3.5298}, /*cfy*/
          {-0.4836,0.00308,190.977,0.02478,4.9e-05,0.0791}, /*cmz*/
          {-4.861053,-0.4333,-5.7919,-1.2464} /*cfz*/
     },
     {
          2454532.1,
          {0.9414,-0.00736,49.9891,0.1631,0.00072,0.3786}, /*cmx*/
          {-4.254618,-5.5198,-2.3929,-0.8238}, /*cfx*/
          {-0.3433,0.00044,184.0796,0.12128,0.000442,0.1001}, /*cmy*/
          {-1.019308,-5.692,-2.5353,-1.2815}, /*cfy*/
          {-0.1719,0.00045,191.0024,0.07875,0.000261,0.2315}, /*cmz*/
          {-2.596668,-0.8685,-3.9795,-0.2287} /*cfz*/
     },
     {
          2454790.1,
          {1.5982,-0.00911,49.9571,0.2089,0.00034,0.5525}, /*cmx*/
          {-1.804591,-3.4278,-0.4344,-3.773}, /*cfx*/
          {0.4084,-0.00388,184.4096,0.0187,0.000122,0.2451}, /*cmy*/
          {-4.993102,-3.4363,-3.2685,-4.2335}, /*cfy*/
          {-0.0301,0.00125,191.0956,0.04663,0.000237,0.1047}, /*cmz*/
          {-0.275899,-2.0287,-4.9603,-4.1906} /*cfz*/
     },
     {
          2455048.1,
          {0.4791,-0.00334,59.0639,0.20099,0.000909,0.0849}, /*cmx*/
          {-0.02459,-4.188,-1.0848,-2.5151}, /*cfx*/
          {0.1002,-0.00128,183.9043,0.12007,0.000379,0.2095}, /*cmy*/
          {-2.614333,-4.1921,-1.0579,-3.6455}, /*cfy*/
          {-0.481,0.00365,189.0467,0.06278,0.000137,0.0878}, /*cmz*/
          {-4.227264,-5.5169,-1.9537,-1.9412} /*cfz*/
     },
     {
          2455306.1,
          {0.9258,-0.00987,62.4357,0.0535,0.000383,0.6928}, /*cmx*/
          {-4.164222,-4.4734,-1.6821,-0.7867}, /*cfx*/
          {0.0779,-0.00355,184.5847,0.08616,0.000414,0.2708}, /*cmy*/
          {-0.330357,-4.9615,-1.8584,-1.2322}, /*cfy*/
          {0.012,-0.00123,186.9091,0.06797,0.000292,0.1354}, /*cmz*/
          {-1.957398,-0.2229,-3.2399,-0.5156} /*cfz*/
     },
     {
          2455564.1,
          {1.0394,-0.00732,57.9287,0.25996,0.000658,0.1632}, /*cmx*/
          {-1.680384,-2.8848,-6.089,-3.5645}, /*cfx*/
          {0.5468,-0.00594,183.5962,0.08125,0.00012,0.1344}, /*cmy*/
          {-4.335729,-2.9716,-0.1796,-3.9492}, /*cfy*/
          {0.4254,-0.00229,189.7993,0.06504,0.000164,0.3037}, /*cmz*/
          {-5.943259,-2.9446,-5.6101,-4.1306} /*cfz*/
     },
     {
          2451178.5,
          {0.5279,0.00023,160.9693,0.35471,0.001243,0.2265}, /*cmx*/
          {-0.484506,-3.0996,-6.2217,-5.6206}, /*cfx*/
          {0.5748,0.00112,264.9596,0.04119,0.000119,0.3069}, /*cmy*/
          {-5.093218,-3.2412,-0.0478,-3.7416}, /*cfy*/
          {1.2733,-0.00204,213.806,0.22257,0.000774,0.4004}, /*cmz*/
          {-0.317942,-0.0456,-3.2225,-3.5813} /*cfz*/
     },
     {
          2451420.5,
          {1.7343,-0.00588,151.3591,0.02599,0.000555,0.9839}, /*cmx*/
          {-4.305363,-5.776,-0.7553,-2.342}, /*cfx*/
          {0.6187,0.00027,264.7118,0.07996,0.000294,0.5704}, /*cmy*/
          {-2.586974,-4.1156,-0.8483,-4.9144}, /*cfy*/
          {0.6306,0.00194,220.394,0.06296,0.000444,0.683}, /*cmz*/
          {-4.090774,-5.7896,-3.4716,-6.0729} /*cfz*/
     },
     {
          2451662.5,
          {1.1149,0.00087,123.1616,0.16811,0.000436,0.0633}, /*cmx*/
          {-1.987164,-1.0464,-3.955,-0.5473}, /*cfx*/
          {0.7193,0.00095,262.3275,0.01985,0.000188,0.7584}, /*cmy*/
          {-0.099156,-5.6583,-1.8606,-5.8099}, /*cfy*/
          {0.8159,0.00027,239.955,0.08211,0.00019,0.5236}, /*cmz*/
          {-1.591419,-4.6108,-2.0274,-0.9434} /*cfz*/
     },
     {
          2451904.5,
          {0.3381,0.00221,135.1076,0.34903,0.00112,0.5255}, /*cmx*/
          {-5.712326,-2.0045,-5.1546,-5.5384}, /*cfx*/
          {0.4847,0.00177,263.6051,0.05942,0.000152,0.5488}, /*cmy*/
          {-3.915884,-2.1158,-5.29,-0.2516}, /*cfy*/
          {0.9132,0.00145,231.8781,0.17897,0.000555,0.2217}, /*cmz*/
          {-5.411862,-5.065,-1.963,-2.7176} /*cfz*/
     },
     {
          2452146.5,
          {1.2739,-0.0074,120.5449,0.11359,0.000996,1.2062}, /*cmx*/
          {-3.297622,-2.5921,-5.7108,-2.5665}, /*cfx*/
          {0.6221,-0.0007,262.6177,0.0967,0.000386,0.6797}, /*cmy*/
          {-1.399659,-2.8806,-5.9267,-2.3748}, /*cfy*/
          {0.8099,0.00398,240.5551,0.10394,0.000525,0.7919}, /*cmz*/
          {-2.894799,-4.9335,-2.1826,-4.9276} /*cfz*/
     },
     {
          2452388.5,
          {1.878,-0.00939,97.5088,0.14653,0.000325,1.784}, /*cmx*/
          {-1.0037,-0.4295,-3.6593,-2.5415}, /*cfx*/
          {0.9986,-0.00313,260.9372,0.00592,0.000123,0.9279}, /*cmy*/
          {-5.186842,-1.1677,-0.2832,-3.0041}, /*cfy*/
          {0.7987,0.00363,253.1183,0.06199,0.000261,1.0933}, /*cmz*/
          {-0.409132,-4.1079,-1.5937,-5.4513} /*cfz*/
     },
     {
          2452630.5,
          {1.0135,-0.00283,111.7193,0.38585,0.001145,0.306}, /*cmx*/
          {-4.692102,-0.8084,-3.9232,-2.283}, /*cfx*/
          {0.6874,-0.0006,262.2927,0.09327,0.000227,0.5784}, /*cmy*/
          {-2.727072,-0.7611,-3.7867,-5.1005}, /*cfy*/
          {1.0753,0.00249,246.3152,0.13684,0.000402,0.7358}, /*cmz*/
          {-4.221143,-3.9584,-0.9364,-0.0409} /*cfz*/
     },
     {
          2452872.5,
          {0.2407,-0.0021,93.9762,0.16075,0.001122,0.3359}, /*cmx*/
          {-2.358773,-1.7087,-4.7458,-1.9208}, /*cfx*/
          {0.3509,0.00043,260.0613,0.10321,0.000432,0.7739}, /*cmy*/
          {-0.200135,-1.7133,-4.8151,-6.1268}, /*cfy*/
          {1.2476,0.00226,254.8854,0.09659,0.000437,0.363}, /*cmz*/
          {-1.707918,-3.923,-1.0852,-0.8073} /*cfz*/
     },
     {
          2453114.5,
          {0.8517,-0.00825,80.9791,0.01588,0.000323,1.7167}, /*cmx*/
          {-0.125424,-0.8806,-5.0801,-2.4991}, /*cfx*/
          {0.5228,-0.00325,258.5001,0.04974,0.000354,0.9759}, /*cmy*/
          {-3.987638,-2.2627,-5.3947,-2.0648}, /*cfy*/
          {1.2522,0.00264,260.6369,0.0435,0.000294,0.3335}, /*cmz*/
          {-5.508433,-4.0793,-1.1116,-4.5569} /*cfz*/
     },
     {
          2453356.5,
          {1.1142,-0.00719,90.1956,0.36593,0.000994,1.0707}, /*cmx*/
          {-3.770494,-6.0887,-2.986,-2.6406}, /*cfx*/
          {0.8813,-0.00517,258.9927,0.09772,0.000226,1.5004}, /*cmy*/
          {-1.522572,-6.2818,-3.3015,-2.6321}, /*cfy*/
          {1.4769,0.00137,257.5882,0.0689,0.000187,0.6525}, /*cmz*/
          {-3.034001,-2.8467,-0.0869,-4.7149} /*cfz*/
     },
     {
          2453598.5,
          {-0.2321,0.00223,75.3914,0.19798,0.001159,0.74}, /*cmx*/
          {-1.581966,-0.328,-3.4842,-5.7034}, /*cfx*/
          {0.3499,-0.00128,257.9737,0.13728,0.000546,0.5226}, /*cmy*/
          {-5.266983,-0.4754,-3.5748,-3.9101}, /*cfy*/
          {1.5943,-0.00027,263.3425,0.09095,0.000303,0.3289}, /*cmz*/
          {-0.518725,-2.4833,-5.8817,-5.7399} /*cfz*/
     },
     {
          2453840.5,
          {-0.7762,0.00195,70.9067,0.02311,0.000351,0.3008}, /*cmx*/
          {-5.669885,-2.2484,-4.4854,-0.0061}, /*cfx*/
          {-0.3004,0.001,257.1126,0.0487,0.000347,0.8145}, /*cmy*/
          {-2.773742,-1.2753,-4.3814,-5.638}, /*cfy*/
          {1.7388,-0.00132,265.5759,0.05005,0.000267,0.6287}, /*cmz*/
          {-4.328447,-2.6508,-5.9222,-1.369} /*cfz*/
     },
     {
          2454082.5,
          {0.1534,-0.00446,73.2498,0.30166,0.000635,0.9052}, /*cmx*/
          {-2.952548,-4.8477,-1.7126,-2.5609}, /*cfx*/
          {0.0423,-0.0023,258.0922,0.07608,6.5e-05,0.5027}, /*cmy*/
          {-0.311045,-4.8098,-1.347,-1.1135}, /*cfy*/
          {1.7712,-0.00167,263.9997,0.03049,9e-05,0.7555}, /*cmz*/
          {-1.849925,-1.4348,-5.3649,-2.211} /*cfz*/
     },
     {
          2454324.5,
          {-0.089,0.00142,69.9728,0.25955,0.001315,0.4058}, /*cmx*/
          {-0.931166,-5.5494,-2.4049,-5.0336}, /*cfx*/
          {0.0764,-0.00193,256.6731,0.13837,0.000522,0.7974}, /*cmy*/
          {-4.047343,-5.6584,-2.5127,-2.2971}, /*cfy*/
          {1.6131,-7e-05,265.6993,0.07606,0.000192,0.4566}, /*cmz*/
          {-5.617364,-0.8938,-4.0474,-3.7148} /*cfz*/
     },
     {
          2454566.5,
          {-1.3413,0.00932,71.4106,0.11003,0.000643,1.8632}, /*cmx*/
          {-4.917435,-5.6857,-2.7185,-5.6444}, /*cfx*/
          {-0.4597,0.00198,256.5388,0.08876,0.000479,0.4088}, /*cmy*/
          {-1.560679,-6.1044,-2.9932,-3.9258}, /*cfy*/
          {1.4718,0.00025,265.4121,0.05378,0.000273,0.6263}, /*cmz*/
          {-3.146669,-1.5194,-4.6371,-4.9844} /*cfz*/
     },
     {
          2454808.5,
          {-1.0912,0.00477,70.6181,0.32497,0.000682,0.9409}, /*cmx*/
          {-2.224193,-3.769,-0.6232,-5.8715}, /*cfx*/
          {-0.6902,0.00165,256.4063,0.08221,7.7e-05,0.735}, /*cmy*/
          {-5.375952,-3.7752,-0.6233,-5.1268}, /*cfy*/
          {1.5499,-0.00198,266.6452,0.03297,0.000182,0.2579}, /*cmz*/
          {-0.6601,-2.7915,-5.378,-0.8982} /*cfz*/
     },
     {
          2455050.5,
          {-0.225,0.00068,82.2255,0.26233,0.001211,0.2644}, /*cmx*/
          {-0.213826,-4.3723,-1.2596,-2.7795}, /*cfx*/
          {-0.5692,0.00072,256.1443,0.14566,0.000501,0.598}, /*cmy*/
          {-2.819618,-4.3806,-1.2303,-5.9376}, /*cfy*/
          {1.7843,-0.00251,263.3484,0.07125,0.000194,0.8654}, /*cmz*/
          {-4.434052,-5.7114,-2.2982,-1.9028} /*cfz*/
     },
     {
          2455292.5,
          {-0.5087,0.00554,85.3015,0.192,0.00097,0.965}, /*cmx*/
          {-4.088756,-5.055,-1.9055,-5.3101}, /*cfx*/
          {-0.549,0.00191,256.1148,0.12455,0.000578,0.5351}, /*cmy*/
          {-0.346743,-5.0928,-1.9412,-0.2258}, /*cfy*/
          {1.38,0.00104,261.9766,0.08287,0.000369,0.2476}, /*cmz*/
          {-1.96792,-6.099,-2.8905,-2.9638} /*cfz*/
     },
     {
          2455534.5,
          {-1.0392,0.00796,81.4575,0.22322,0.00034,1.8828}, /*cmx*/
          {-1.506781,-2.8748,-0.2673,-5.7032}, /*cfx*/
          {-0.8821,0.00342,255.7618,0.04006,0.000156,0.2704}, /*cmy*/
          {-4.148482,-3.293,-1.8733,-5.749}, /*cfy*/
          {0.9283,0.00334,263.269,0.03874,8.6e-05,0.9122}, /*cmz*/
          {-5.76037,-2.4638,-4.3212,-5.0452} /*cfz*/
     },
     {
          2451178.5,
          {-0.2634,-0.00253,263.6198,0.58666,0.002066,0.2137}, /*cmx*/
          {2.279238,5.9429,2.8275,-4.0768}, /*cfx*/
          {1.0547,-0.0022,435.4987,0.08693,0.000227,0.5259}, /*cmy*/
          {3.946897,5.9322,2.9567,-1.9852}, /*cfy*/
          {-1.0217,0.00018,350.0757,0.381,0.001303,0.297}, /*cmz*/
          {2.4363,2.7851,5.8726,-3.8314} /*cfz*/
     },
     {
          2451401.5,
          {-0.7256,0.00336,239.7902,0.25873,0.001891,0.3256}, /*cmx*/
          {6.093209,0.3044,3.4763,-1.6246}, /*cfx*/
          {0.6429,0.00051,433.6467,0.06657,0.000339,0.3986}, /*cmy*/
          {1.543956,0.2738,3.4998,-0.572}, /*cfy*/
          {-0.7365,-0.00254,367.1188,0.17148,0.0012,0.4521}, /*cmz*/
          {0.039666,3.5522,0.3466,-2.4698} /*cfz*/
     },
     {
          2451624.5,
          {-0.3278,0.00201,210.438,0.11885,0.001055,0.4907}, /*cmx*/
          {3.57504,0.968,4.1882,-0.5198}, /*cfx*/
          {0.9433,-0.00129,432.1748,0.06813,0.000325,0.4611}, /*cmy*/
          {5.409111,0.9432,4.1691,-5.7066}, /*cfy*/
          {-1.1947,-0.00081,386.719,0.10011,0.000689,0.2014}, /*cmz*/
          {3.913477,4.6154,1.2618,-0.442} /*cfz*/
     },
     {
          2451847.5,
          {0.392,-0.00395,230.3044,0.35446,0.000296,0.2575}, /*cmx*/
          {1.22984,5.0181,2.1912,-6.0129}, /*cfx*/
          {0.6816,0.00144,433.2472,0.03368,0.00016,0.5629}, /*cmy*/
          {2.983235,5.0375,4.6499,-4.155}, /*cfy*/
          {-1.3885,0.00286,374.3992,0.18022,0.000213,0.2675}, /*cmz*/
          {1.484221,1.6904,3.9464,-6.0348} /*cfz*/
     },
     {
          2452070.5,
          {0.3421,-0.00593,178.9225,0.46396,0.001661,0.2989}, /*cmx*/
          {4.879997,5.714,2.5836,-4.631}, /*cfx*/
          {1.1737,-0.00269,428.3815,0.08678,0.000269,0.5094}, /*cmy*/
          {0.594407,5.7873,2.6908,-2.2142}, /*cfy*/
          {-1.3744,0.00294,406.6481,0.21617,0.00076,0.3192}, /*cmz*/
          {5.380154,2.5248,5.6286,-4.4346} /*cfz*/
     },
     {
          2452293.5,
          {-0.3003,-0.00081,193.9951,0.59562,0.002209,0.173}, /*cmx*/
          {2.531556,0.0396,3.1967,-2.8124}, /*cfx*/
          {0.891,-0.00046,430.5351,0.19107,0.00061,0.4612}, /*cmy*/
          {4.438114,6.2455,3.1545,-0.88}, /*cfy*/
          {-0.8268,-0.00055,397.7278,0.26026,0.000909,0.5982}, /*cmz*/
          {2.944274,3.4226,0.1957,-3.1346} /*cfz*/
     },
     {
          2452516.5,
          {-0.5341,0.00351,176.1075,0.21841,0.001826,0.4239}, /*cmx*/
          {0.041259,0.7339,3.8947,-0.8931}, /*cfx*/
          {0.8607,-0.0002,428.6204,0.09378,0.000621,0.3173}, /*cmy*/
          {2.042813,0.7029,3.8451,-5.9585}, /*cfy*/
          {-0.9678,-0.00112,406.6481,0.09618,0.000742,0.384}, /*cmz*/
          {0.542512,4.314,1.0367,-1.3292} /*cfz*/
     },
     {
          2452739.5,
          {0.3056,-0.00175,148.4749,0.07015,0.000911,0.4211}, /*cmx*/
          {3.703176,1.3105,4.6219,-0.4067}, /*cfx*/
          {0.908,0.00083,426.1627,0.06769,0.000436,0.4106}, /*cmy*/
          {5.927236,1.3533,4.5653,-4.9912}, /*cfy*/
          {-1.0852,0.00075,420.4808,0.07111,0.000464,0.3397}, /*cmz*/
          {4.415063,5.4896,2.06,-5.9148} /*cfz*/
     },
     {
          2452962.5,
          {0.574,-0.00576,165.9063,0.42444,0.000557,0.2195}, /*cmx*/
          {1.437423,5.4185,2.418,-5.5036}, /*cfx*/
          {1.2279,-0.00231,429.1215,0.10087,6.3e-05,0.3661}, /*cmy*/
          {3.490339,5.4091,4.6161,-2.7396}, /*cfy*/
          {-1.1985,0.00221,412.1388,0.131,0.000218,0.3151}, /*cmz*/
          {1.987296,2.3081,4.7436,-5.0913} /*cfz*/
     },
     {
          2453185.5,
          {0.2229,-0.00472,127.2592,0.50123,0.001914,0.0945}, /*cmx*/
          {4.907722,6.0811,2.9507,-3.7435}, /*cfx*/
          {1.1733,-0.002,424.0172,0.16543,0.000597,0.3486}, /*cmy*/
          {1.124788,6.0198,2.9104,-1.6303}, /*cfy*/
          {-0.9877,0.00133,430.8146,0.1342,0.000488,0.7454}, /*cmz*/
          {5.878271,3.1819,6.283,-3.5034} /*cfz*/
     },
     {
          2453408.5,
          {-0.4023,0.00123,135.3349,0.57229,0.002228,0.2634}, /*cmx*/
          {2.593294,0.4487,3.5977,-1.0559}, /*cfx*/
          {0.8878,-0.00028,425.1061,0.24898,0.000862,0.448}, /*cmy*/
          {4.965211,0.4151,3.5748,-0.5019}, /*cfy*/
          {-0.762,-0.00064,427.3734,0.13758,0.000462,0.5027}, /*cmz*/
          {3.446362,4.2695,0.9471,-1.4456} /*cfz*/
     },
     {
          2453631.5,
          {-0.1252,0.00148,126.3819,0.16712,0.00169,0.3565}, /*cmx*/
          {0.069881,1.1722,4.3292,-0.766}, /*cfx*/
          {0.9464,0.00088,423.7816,0.09182,0.000761,0.5269}, /*cmy*/
          {2.569084,1.1985,4.3177,-5.2314}, /*cfy*/
          {-0.9128,-0.00032,429.9968,0.0628,0.000458,0.3024}, /*cmz*/
          {1.04044,5.3127,2.0263,-0.3419} /*cfz*/
     },
     {
          2453854.5,
          {0.6857,-0.00492,115.8422,0.01642,0.00071,0.2922}, /*cmx*/
          {3.54314,0.7141,5.0266,-0.0724}, /*cfx*/
          {1.2237,-0.00145,421.0258,0.05325,0.000444,0.1721}, /*cmy*/
          {0.186233,1.7006,4.9985,-2.8898}, /*cfy*/
          {-0.9364,0.00138,435.3064,0.06264,0.000334,0.4575}, /*cmz*/
          {4.912449,0.0506,3.0487,-5.5782} /*cfz*/
     },
     {
          2454077.5,
          {0.5982,-0.00658,119.9089,0.47937,0.000823,0.118}, /*cmx*/
          {1.401658,5.8062,2.7294,-5.7138}, /*cfx*/
          {1.3736,-0.00298,423.6873,0.1785,0.000189,0.3362}, /*cmy*/
          {4.021229,5.7752,2.8523,-2.2922}, /*cfy*/
          {-0.8714,0.00087,432.5776,0.06667,0.000137,0.6742}, /*cmz*/
          {2.485637,3.2935,5.4215,-3.7492} /*cfz*/
     },
     {
          2454300.5,
          {0.0114,-0.00272,115.4794,0.50737,0.002065,0.1924}, /*cmx*/
          {4.692474,0.1707,3.3244,-0.8436}, /*cfx*/
          {1.0936,-0.00125,420.7565,0.2017,0.000774,0.5093}, /*cmy*/
          {1.670908,0.1749,3.3314,-0.8776}, /*cfy*/
          {-0.6161,-0.00086,436.3996,0.05233,0.000169,0.3831}, /*cmz*/
          {0.09078,4.5486,1.3091,-2.2614} /*cfz*/
     },
     {
          2454523.5,
          {-0.3916,0.00226,114.9198,0.53012,0.002167,0.3699}, /*cmx*/
          {2.362151,0.8774,4.0168,-1.0278}, /*cfx*/
          {1.0475,-0.00071,421.0409,0.25463,0.000941,0.4695}, /*cmy*/
          {5.516153,0.8637,4.0134,-5.631}, /*cfy*/
          {-0.7819,-0.00017,436.8156,0.11022,0.000341,0.5878}, /*cmz*/
          {3.944182,5.7901,2.7029,-0.9038} /*cfz*/
     },
     {
          2454746.5,
          {0.3276,-0.00158,115.2777,0.10853,0.001516,0.2502}, /*cmx*/
          {6.141327,1.6012,4.7652,-0.503}, /*cfx*/
          {1.0103,0.00108,421.116,0.07929,0.000788,0.1294}, /*cmy*/
          {3.115122,1.5789,4.7488,-4.2327}, /*cfy*/
          {-0.7992,0.00084,436.2133,0.05278,0.000397,0.5241}, /*cmz*/
          {1.536919,0.2027,3.4785,-5.8675} /*cfz*/
     },
     {
          2454969.5,
          {0.8901,-0.00751,136.8808,0.07107,0.000431,0.234}, /*cmx*/
          {3.334692,5.7095,5.3649,-0.2762}, /*cfx*/
          {1.515,-0.00366,419.8655,0.01869,0.00034,0.2697}, /*cmy*/
          {0.743399,2.0021,5.4175,-2.8525}, /*cfy*/
          {-0.6352,0.00015,431.2134,0.0425,0.000221,0.6163}, /*cmz*/
          {5.410691,0.4729,3.9917,-4.1205} /*cfz*/
     },
     {
          2455192.5,
          {0.4222,-0.00592,120.5114,0.51376,0.001067,0.1396}, /*cmx*/
          {1.151364,6.1852,3.0656,-5.7954}, /*cfx*/
          {1.3016,-0.00182,420.6012,0.21774,0.000354,0.4323}, /*cmy*/
          {4.571737,6.1799,3.0801,-1.6437}, /*cfy*/
          {-0.2624,-0.00309,436.301,0.09196,0.000119,0.3848}, /*cmz*/
          {2.982612,5.5673,3.3553,-2.5588} /*cfz*/
     },
     {
          2455415.5,
          {-0.2148,2e-05,150.5617,0.48315,0.002094,0.3015}, /*cmx*/
          {4.615303,0.5679,3.7155,-1.1589}, /*cfx*/
          {1.1739,-0.00222,421.3322,0.20718,0.000855,0.7076}, /*cmy*/
          {2.222781,0.585,3.7501,-0.0895}, /*cfy*/
          {-0.7608,0.00032,425.3341,0.10978,0.000445,0.3453}, /*cmz*/
          {0.58751,0.0276,3.2425,-1.2882} /*cfz*/
     },
     {
          2451178.4,
          {-0.1722,-0.00181,352.8978,0.76368,0.002649,0.2271}, /*cmx*/
          {2.766042,0.1334,3.2845,2.6267}, /*cfx*/
          {-0.2442,-0.00075,581.7678,0.07586,0.000215,0.4808}, /*cmy*/
          {4.437088,0.2166,3.4829,0.0077}, /*cfy*/
          {-0.8224,0.00102,467.7271,0.49669,0.0017,0.3219}, /*cmz*/
          {2.925511,3.2312,0.0744,3.7746} /*cfz*/
     },
     {
          2451384.4,
          {-0.5392,0.00039,313.8796,0.52135,0.003,0.107}, /*cmx*/
          {4.590869,5.1581,2.0322,2.5961}, /*cfx*/
          {-0.1823,0.00097,579.9238,0.07443,0.000322,0.4476}, /*cmy*/
          {0.056463,5.0864,2.0699,3.072}, /*cfy*/
          {-0.8801,0.00125,496.2722,0.34589,0.001923,0.3172}, /*cmz*/
          {4.839403,2.0582,5.1438,2.0899} /*cfz*/
     },
     {
          2451590.4,
          {-0.2862,-0.00181,300.2584,0.5888,0.002875,0.1196}, /*cmx*/
          {0.162394,3.879,0.7535,1.765}, /*cfx*/
          {-0.39,0.00028,579.0232,0.11965,0.000537,0.4978}, /*cmy*/
          {1.94477,3.8022,0.6786,0.6281}, /*cfy*/
          {-0.8525,0.00015,505.8015,0.32941,0.001587,0.3848}, /*cmz*/
          {0.447246,0.8334,3.9607,6.0018} /*cfz*/
     },
     {
          2451796.4,
          {-0.2878,-0.00109,299.8308,0.15204,0.002221,0.8154}, /*cmx*/
          {2.060534,2.4714,5.7385,2.5405}, /*cfx*/
          {-0.0404,-0.00074,578.9143,0.07229,0.000535,0.1216}, /*cmy*/
          {3.841205,2.3986,5.6582,4.716}, /*cfy*/
          {-0.7604,0.00081,505.0806,0.08338,0.001161,0.1464}, /*cmz*/
          {2.341945,6.1537,2.7355,3.836} /*cfz*/
     },
     {
          2452002.4,
          {-0.7601,0.00363,250.7582,0.15232,0.001633,0.3292}, /*cmx*/
          {3.810184,1.3089,4.4973,3.3981}, /*cfx*/
          {-0.394,0.00164,575.1397,0.05706,0.000475,0.2146}, /*cmy*/
          {5.747766,1.2193,4.4149,2.4622}, /*cfy*/
          {-0.872,-0.00101,535.7795,0.0888,0.000848,0.6753}, /*cmz*/
          {4.249728,4.857,1.5877,0.5058} /*cfz*/
     },
     {
          2452208.4,
          {-0.7725,0.00501,279.4735,0.34662,0.000363,0.6067}, /*cmx*/
          {5.787177,3.297,3.0621,4.7812}, /*cfx*/
          {-0.318,0.00091,577.8224,0.03213,0.000321,0.5877}, /*cmy*/
          {1.344349,3.6956,3.0221,5.9993}, /*cfy*/
          {-0.4635,-0.00269,519.014,0.17158,0.000186,0.292}, /*cmz*/
          {6.130733,0.0106,1.2927,2.8171} /*cfz*/
     },
     {
          2452414.4,
          {-0.2042,-0.00103,213.7788,0.36072,0.000684,0.9398}, /*cmx*/
          {1.155505,2.0455,5.276,6.2364}, /*cfx*/
          {0.0305,-0.00097,571.626,0.08374,9.8e-05,0.1442}, /*cmy*/
          {3.269706,2.0491,5.62,4.4244}, /*cfy*/
          {-1.0866,0.00117,555.5428,0.13537,0.000205,0.5264}, /*cmz*/
          {1.765388,5.246,1.7871,2.398} /*cfz*/
     },
     {
          2452620.4,
          {0.1859,-0.00366,245.9942,0.7025,0.001598,0.4167}, /*cmx*/
          {3.181183,0.7323,3.8836,0.9143}, /*cfx*/
          {-0.1341,-0.00148,574.4285,0.17788,0.000313,0.6751}, /*cmy*/
          {5.138176,0.6614,3.8497,0.634}, /*cfy*/
          {-1.059,0.00157,539.597,0.26364,0.000629,0.0979}, /*cmz*/
          {3.641129,4.0156,0.7566,6.027} /*cfz*/
     },
     {
          2452826.4,
          {-0.0913,-0.00166,191.7299,0.64315,0.002673,0.4823}, /*cmx*/
          {4.810497,5.7645,2.6294,2.6627}, /*cfx*/
          {0.0432,-0.00059,569.6657,0.19882,0.000738,0.277}, /*cmy*/
          {0.788126,5.7093,2.5958,4.0347}, /*cfy*/
          {-1.0356,0.00155,565.9952,0.22813,0.000915,0.2665}, /*cmz*/
          {5.556882,2.852,5.914,3.5321} /*cfz*/
     },
     {
          2453032.4,
          {-0.4299,0.00194,204.5317,0.78693,0.002912,0.2389}, /*cmx*/
          {0.497625,4.4952,1.3595,3.2387}, /*cfx*/
          {-0.3359,0.00084,571.3088,0.26795,0.000934,0.1628}, /*cmy*/
          {2.662715,4.4357,1.2944,3.2947}, /*cfy*/
          {-1.1001,0.00072,559.9721,0.22598,0.000807,0.5674}, /*cmz*/
          {1.155045,1.725,4.8293,0.4633} /*cfz*/
     },
     {
          2453238.4,
          {-0.2075,-0.00037,180.6333,0.50362,0.003108,0.3597}, /*cmx*/
          {2.230255,3.2139,0.0868,2.6809}, /*cfx*/
          {-0.1304,0.00018,568.6332,0.19016,0.001067,0.3462}, /*cmy*/
          {4.580873,3.1734,0.0458,6.2065}, /*cfy*/
          {-0.9461,0.00136,569.7684,0.15302,0.000864,0.3257}, /*cmz*/
          {3.060788,0.5846,3.633,4.5352} /*cfz*/
     },
     {
          2453444.4,
          {-0.2175,0.00078,168.8927,0.55143,0.002891,0.2643}, /*cmx*/
          {3.988513,1.965,5.1051,2.1835}, /*cfx*/
          {-0.1423,0.00051,567.2649,0.22832,0.001157,0.3849}, /*cmy*/
          {0.199899,1.9036,5.049,3.8152}, /*cfy*/
          {-1.1038,0.0,574.9375,0.13119,0.00064,0.2472}, /*cmz*/
          {4.953824,5.8257,2.6373,0.9656} /*cfz*/
     },
     {
          2453650.4,
          {-0.5789,0.00507,172.6125,0.0621,0.00198,0.4738}, /*cmx*/
          {5.925469,0.6614,3.8555,4.4094}, /*cfx*/
          {-0.2764,0.00079,567.8379,0.06769,0.000887,0.3195}, /*cmy*/
          {2.09016,0.5455,3.7868,0.1881}, /*cfy*/
          {-0.7842,-0.00095,573.1483,0.04632,0.000464,0.398}, /*cmz*/
          {0.563503,5.3763,1.636,0.2947} /*cfz*/
     },
     {
          2453856.4,
          {-0.1951,0.0014,152.282,0.05129,0.001238,0.7953}, /*cmx*/
          {1.111813,5.5975,2.5581,5.7699}, /*cfx*/
          {-0.0561,0.00107,564.3047,0.05018,0.000636,0.6524}, /*cmy*/
          {4.02477,5.5801,2.496,5.0658}, /*cfy*/
          {-1.0428,-0.00019,582.3659,0.03383,0.000327,0.1983}, /*cmz*/
          {2.468863,3.7426,0.4607,3.1602} /*cfz*/
     },
     {
          2454062.4,
          {0.3611,-0.00326,160.6665,0.4191,4.9e-05,0.6822}, /*cmx*/
          {3.259081,1.3553,0.5553,0.349}, /*cfx*/
          {-0.0805,-0.00142,565.965,0.12859,0.000196,0.1731}, /*cmy*/
          {5.8892,1.2986,1.254,0.4501}, /*cfy*/
          {-0.9357,-0.001,578.6439,0.06009,0.00018,0.4328}, /*cmz*/
          {4.350913,4.9457,0.4532,1.1057} /*cfz*/
     },
     {
          2454268.4,
          {0.5138,-0.0052,154.1771,0.4442,0.00114,0.6203}, /*cmx*/
          {4.576891,0.0559,3.1896,2.0076}, /*cfx*/
          {0.3657,-0.00328,562.9933,0.16698,0.000335,0.2456}, /*cmy*/
          {1.560775,0.0277,3.1571,1.2828}, /*cfy*/
          {-1.0776,0.0014,583.6321,0.04538,1.6e-05,0.4276}, /*cmz*/
          {6.264684,4.5698,1.2454,4.4379} /*cfz*/
     },
     {
          2454474.4,
          {-0.1243,0.00168,151.1576,0.73898,0.001907,0.5725}, /*cmx*/
          {0.466994,5.1105,1.9773,2.8887}, /*cfx*/
          {-0.2285,0.0011,564.2348,0.29424,0.000683,0.5947}, /*cmy*/
          {3.417842,5.0811,1.9567,3.7202}, /*cfy*/
          {-1.2484,0.0009,584.007,0.09121,0.000169,0.1942}, /*cmz*/
          {1.859584,3.5628,0.1771,1.3554} /*cfz*/
     },
     {
          2454680.4,
          {-0.3066,0.00275,162.0801,0.62958,0.00281,0.4253}, /*cmx*/
          {1.900859,3.8291,0.6905,3.7305}, /*cfx*/
          {-0.1553,0.00057,562.7343,0.27092,0.001123,0.1967}, /*cmy*/
          {5.366225,3.8131,0.6815,1.8755}, /*cfy*/
          {-0.8105,-0.00081,581.529,0.104,0.000385,0.3883}, /*cmz*/
          {3.772075,2.5105,5.7008,6.1809} /*cfz*/
     },
     {
          2454886.4,
          {-0.0019,0.00121,158.2642,0.75809,0.002963,0.1953}, /*cmx*/
          {3.867122,2.5726,5.7085,0.8759}, /*cfx*/
          {0.0713,-7e-05,562.8127,0.3402,0.001279,0.4747}, /*cmy*/
          {0.959162,2.5559,5.6931,4.8091}, /*cfy*/
          {-1.1635,5e-05,582.9345,0.14938,0.000565,0.2268}, /*cmz*/
          {5.655904,1.6424,4.8332,4.9104} /*cfz*/
     },
     {
          2455092.4,
          {-0.0106,0.00193,169.3567,0.42872,0.002961,0.1274}, /*cmx*/
          {5.589666,1.3392,4.4713,4.3657}, /*cfx*/
          {-0.1753,0.00052,562.4832,0.20757,0.001301,0.1772}, /*cmy*/
          {2.878341,1.3022,4.4441,2.9232}, /*cfy*/
          {-0.9461,-0.00034,579.4978,0.10838,0.000621,0.3775}, /*cmz*/
          {1.276063,0.2424,3.5275,0.8786} /*cfz*/
     },
     {
          2455298.4,
          {0.028,0.00208,186.0789,0.45362,0.002555,0.3774}, /*cmx*/
          {1.028911,0.0577,3.1957,5.4133}, /*cfx*/
          {0.1787,-7e-05,562.7482,0.2203,0.001191,0.2079}, /*cmy*/
          {4.79133,0.0447,3.183,6.0697}, /*cfy*/
          {-1.0324,-0.00018,574.0926,0.13424,0.000708,0.621}, /*cmz*/
          {3.170043,5.5589,2.4771,5.0324} /*cfz*/
     },
     {
          2455504.4,
          {0.3031,-0.00022,177.6174,0.0319,0.001597,0.6891}, /*cmx*/
          {2.993259,2.0335,1.9189,6.1786}, /*cfx*/
          {0.0357,-0.0011,562.8256,0.02162,0.000802,0.4234}, /*cmy*/
          {0.391075,4.9141,1.9157,4.9531}, /*cfy*/
          {-1.014,-0.00121,576.2519,0.0356,0.000599,0.2876}, /*cmz*/
          {5.061383,4.0969,1.2942,1.4863} /*cfz*/
     },
     {
          2451178.0,
          {-0.4241,0.00051,89.6553,4.40972,0.064837,0.3229}, /*cmx*/
          {1.416259,5.8487,3.5638,-3.3468}, /*cfx*/
          {0.1339,-0.00043,132.2766,6.98294,0.116091,0.0115}, /*cmy*/
          {3.129269,1.3914,5.3562,-5.1267}, /*cfy*/
          {-0.4631,4e-05,103.2531,4.95218,0.075229,0.3696}, /*cmz*/
          {1.617673,6.1303,3.9202,-3.3337} /*cfz*/
     },
     {
          2451219.0,
          {-0.4093,0.00113,85.761,4.1804,0.061063,0.2996}, /*cmx*/
          {1.426245,5.8602,3.5803,-3.2965}, /*cfx*/
          {0.1876,-0.00149,132.1501,6.92881,0.114272,0.0455}, /*cmy*/
          {3.167152,1.428,5.3929,-5.5492}, /*cfy*/
          {-0.479,0.00065,106.418,5.05474,0.076976,0.3766}, /*cmz*/
          {1.658714,6.1776,3.973,-3.2967} /*cfz*/
     },
     {
          2451260.0,
          {-0.3734,0.00052,81.9111,3.94266,0.057489,0.2775}, /*cmx*/
          {1.449241,5.9003,3.6382,-3.3299}, /*cfx*/
          {0.1968,-0.00019,132.0811,6.90109,0.113078,0.0626}, /*cmy*/
          {3.218558,1.477,5.4407,-6.2777}, /*cfy*/
          {-0.4729,0.00028,109.185,5.14948,0.078638,0.3791}, /*cmz*/
          {1.711004,6.2298,4.0256,-3.3236} /*cfz*/
     },
     {
          2451301.0,
          {-0.3626,0.00067,79.4827,3.76915,0.055294,0.2638}, /*cmx*/
          {1.491547,5.9717,3.7386,-3.2902}, /*cfx*/
          {0.2575,-0.00149,132.2248,6.9224,0.11288,0.0971}, /*cmy*/
          {3.277794,1.5311,5.4917,-6.0316}, /*cfy*/
          {-0.4748,0.00046,110.7063,5.19844,0.079662,0.3804}, /*cmz*/
          {1.767777,6.2818,4.076,-3.3138} /*cfz*/
     },
     {
          2451342.0,
          {-0.352,0.00023,79.2364,3.72777,0.055664,0.2633}, /*cmx*/
          {1.554398,6.0653,3.858,-3.3099}, /*cfx*/
          {0.2629,-0.0003,132.5646,6.99092,0.113796,0.114}, /*cmy*/
          {3.336609,1.5834,5.5385,-0.088}, /*cfy*/
          {-0.4659,0.00039,110.5066,5.19885,0.08005,0.3778}, /*cmz*/
          {1.822087,0.0459,4.1189,-3.3267} /*cfz*/
     },
     {
          2451383.0,
          {-0.3621,0.00019,81.0843,3.81866,0.058145,0.2786}, /*cmx*/
          {1.625954,6.1523,3.9559,-3.3036}, /*cfx*/
          {0.3245,-0.00181,133.0968,7.07883,0.115095,0.1463}, /*cmy*/
          {3.386709,1.6256,5.575,-6.2021}, /*cfy*/
          {-0.4491,0.00023,108.7905,5.14255,0.079549,0.3712}, /*cmz*/
          {1.865876,0.0852,4.1562,-3.3398} /*cfz*/
     },
     {
          2451424.0,
          {-0.3813,0.00034,83.7297,3.97721,0.061246,0.3011}, /*cmx*/
          {1.689232,6.2087,4.0048,-3.3005}, /*cfx*/
          {0.3215,-0.00054,133.5465,7.15496,0.116264,0.1596}, /*cmy*/
          {3.425061,1.6572,5.6013,-0.1256}, /*cfy*/
          {-0.4412,0.00063,106.4441,5.06907,0.079005,0.3607}, /*cmz*/
          {1.897806,0.122,4.1941,-3.3181} /*cfz*/
     },
     {
          2451465.0,
          {-0.3874,0.00014,85.4065,4.08505,0.062774,0.3183}, /*cmx*/
          {1.730953,6.2282,4.0094,-3.3344}, /*cfx*/
          {0.3564,-0.00173,133.8623,7.19062,0.116539,0.1704}, /*cmy*/
          {3.452898,1.68,5.6211,-6.2629}, /*cfy*/
          {-0.4158,1e-05,104.9491,5.02129,0.078969,0.3524}, /*cmz*/
          {1.921574,0.1602,4.2386,-3.3535} /*cfz*/
     },
     {
          2451506.0,
          {-0.3924,0.00067,84.8667,4.07183,0.062064,0.3201}, /*cmx*/
          {1.751701,6.2258,3.9921,-3.3125}, /*cfx*/
          {0.3425,-0.00066,133.9175,7.17486,0.115714,0.1665}, /*cmy*/
          {3.476722,1.7013,5.6415,-0.1142}, /*cfy*/
          {-0.4175,0.0006,105.2837,5.04441,0.080134,0.3491}, /*cmz*/
          {1.945913,0.2029,4.2872,-3.3037} /*cfz*/
     },
     {
          2451547.0,
          {-0.3628,0.00025,82.0846,3.92839,0.059247,0.302}, /*cmx*/
          {1.760867,6.22,3.9783,-3.3532}, /*cfx*/
          {0.3776,-0.00163,133.8717,7.11139,0.113765,0.1838}, /*cmy*/
          {3.505035,1.7284,5.6704,-0.0058}, /*cfy*/
          {-0.3897,-0.00029,107.3778,5.12695,0.081941,0.3416}, /*cmz*/
          {1.978432,0.2489,4.3372,-3.3566} /*cfz*/
     },
     {
          2451588.0,
          {-0.3469,0.00088,77.9768,3.70754,0.055608,0.2742}, /*cmx*/
          {1.770874,6.2309,3.9915,-3.3062}, /*cfx*/
          {0.3867,-0.00083,133.7281,7.03452,0.111492,0.1995}, /*cmy*/
          {3.545166,1.7674,5.7123,-0.0841}, /*cfy*/
          {-0.4005,0.00073,110.2483,5.24034,0.084157,0.3358}, /*cmz*/
          {2.022756,0.3004,4.3878,-3.2886} /*cfz*/
     },
     {
          2451629.0,
          {-0.3043,0.00016,73.9435,3.48129,0.052266,0.2459}, /*cmx*/
          {1.793487,6.2721,4.0477,-3.3712}, /*cfx*/
          {0.4207,-0.00122,133.7163,6.97992,0.10967,0.2287}, /*cmy*/
          {3.598012,1.8173,5.7653,-0.0545}, /*cfy*/
          {-0.3685,-0.00044,112.8027,5.34274,0.086066,0.3296}, /*cmz*/
          {2.077882,0.3556,4.4398,-3.3828} /*cfz*/
     },
     {
          2451670.0,
          {-0.2923,0.00071,71.2949,3.32755,0.050719,0.2258}, /*cmx*/
          {1.836814,0.0675,4.149,-3.2958}, /*cfx*/
          {0.4461,-0.00093,133.8698,6.97529,0.108913,0.2514}, /*cmy*/
          {3.658009,1.872,5.8213,-0.0813}, /*cfy*/
          {-0.3804,0.00065,114.1968,5.41528,0.087717,0.3303}, /*cmz*/
          {2.137527,0.4121,4.4894,-3.303} /*cfz*/
     },
     {
          2451711.0,
          {-0.2598,-0.00017,70.8553,3.30555,0.051711,0.2117}, /*cmx*/
          {1.902805,0.1709,4.2694,-3.3626}, /*cfx*/
          {0.4784,-0.00106,134.2718,7.01725,0.109205,0.2826}, /*cmy*/
          {3.716087,1.9233,5.8716,-0.0971}, /*cfy*/
          {-0.3414,-0.00063,114.1132,5.44182,0.088573,0.3209}, /*cmz*/
          {2.194284,0.4621,4.5321,-3.3906} /*cfz*/
     },
     {
          2451752.0,
          {-0.2703,0.00046,72.5374,3.4173,0.054942,0.2148}, /*cmx*/
          {1.978999,0.268,4.3665,-3.2724}, /*cfx*/
          {0.5122,-0.00138,134.7685,7.08344,0.110057,0.302}, /*cmy*/
          {3.764815,1.9647,5.9105,-0.0843}, /*cfy*/
          {-0.3486,0.00052,112.6714,5.42228,0.088759,0.3121}, /*cmz*/
          {2.239868,0.5037,4.5667,-3.3082} /*cfz*/
     },
     {
          2451793.0,
          {-0.2611,-0.00043,75.1025,3.58241,0.058303,0.2292}, /*cmx*/
          {2.046432,0.3282,4.4142,-3.3733}, /*cfx*/
          {0.5183,-0.00095,135.2334,7.14055,0.110813,0.3205}, /*cmy*/
          {3.801639,1.9956,5.9385,-0.1427}, /*cfy*/
          {-0.3105,-0.00057,110.7037,5.37687,0.088446,0.2979}, /*cmz*/
          {2.273287,0.5392,4.5999,-3.4078} /*cfz*/
     },
     {
          2451834.0,
          {-0.2856,0.00035,76.6903,3.68492,0.059877,0.2509}, /*cmx*/
          {2.089941,0.3479,4.418,-3.3033}, /*cfx*/
          {0.5441,-0.00166,135.5108,7.15891,0.110735,0.3281}, /*cmy*/
          {3.828798,2.0183,5.96,-0.0936}, /*cfy*/
          {-0.3115,0.00044,109.4365,5.35592,0.088729,0.2899}, /*cmz*/
          {2.298253,0.5759,4.6368,-3.3231} /*cfz*/
     },
     {
          2451875.0,
          {-0.2722,-0.00025,76.0429,3.65798,0.058771,0.2547}, /*cmx*/
          {2.111043,0.3414,4.3987,-3.3738}, /*cfx*/
          {0.5308,-0.00081,135.5343,7.12307,0.109596,0.3329}, /*cmy*/
          {3.853163,2.0415,5.9844,-0.1529}, /*cfy*/
          {-0.2743,-0.00045,109.8361,5.39503,0.089874,0.2732}, /*cmz*/
          {2.324807,0.616,4.6779,-3.3906} /*cfz*/
     },
     {
          2451916.0,
          {-0.2719,0.00043,73.1138,3.50328,0.05562,0.2439}, /*cmx*/
          {2.11807,0.3305,4.381,-3.3204}, /*cfx*/
          {0.5587,-0.00185,135.3855,7.03837,0.107383,0.3319}, /*cmy*/
          {3.883056,2.0716,6.0195,-0.0694}, /*cfy*/
          {-0.2682,0.00025,111.7825,5.48905,0.091779,0.2612}, /*cmz*/
          {2.359141,0.6611,4.7214,-3.3213} /*cfz*/
     },
     {
          2451957.0,
          {-0.2391,-3e-05,68.8687,3.28017,0.051618,0.2184}, /*cmx*/
          {2.125528,0.3352,4.3872,-3.3905}, /*cfx*/
          {0.5409,-0.00056,135.1575,6.93899,0.104953,0.3411}, /*cmy*/
          {3.925318,2.115,6.0698,-0.1633}, /*cfy*/
          {-0.2356,-0.00042,114.4388,5.60798,0.093833,0.2432}, /*cmz*/
          {2.40628,0.7116,4.7681,-3.3996} /*cfz*/
     },
     {
          2451998.0,
          {-0.2187,0.00039,64.7136,3.0617,0.048225,0.1911}, /*cmx*/
          {2.14459,0.3729,4.4354,-3.344}, /*cfx*/
          {0.5877,-0.00181,135.0471,6.85737,0.102872,0.3624}, /*cmy*/
          {3.979455,2.1683,6.1317,-0.0769}, /*cfy*/
          {-0.219,-9e-05,116.7767,5.7232,0.095857,0.2327}, /*cmz*/
          {2.463454,0.7673,4.8167,-3.3666} /*cfz*/
     },
     {
          2452039.0,
          {-0.1842,8e-05,61.9734,2.92729,0.046732,0.1609}, /*cmx*/
          {2.187423,0.4514,4.5274,-3.3825}, /*cfx*/
          {0.5809,-0.00035,135.0639,6.82489,0.101984,0.3853}, /*cmy*/
          {4.039998,2.2271,6.1972,-0.1628}, /*cfy*/
          {-0.1939,-0.00033,118.1473,5.81776,0.097615,0.2164}, /*cmz*/
          {2.526031,0.8235,4.8634,-3.3979} /*cfz*/
     },
     {
          2452080.0,
          {-0.1622,0.00015,61.4654,2.92693,0.047925,0.1402}, /*cmx*/
          {2.255173,0.5587,4.6404,-3.3455}, /*cfx*/
          {0.6314,-0.00172,135.3392,6.8396,0.102042,0.4044}, /*cmy*/
          {4.097219,2.2801,6.2548,-0.084}, /*cfy*/
          {-0.1724,-0.00051,118.2272,5.8737,0.098847,0.2099}, /*cmz*/
          {2.584098,0.8737,4.9032,-3.4048} /*cfz*/
     },
     {
          2452121.0,
          {-0.1449,-9e-05,63.1005,3.06067,0.051339,0.1315}, /*cmx*/
          {2.336966,0.6596,4.7315,-3.3639}, /*cfx*/
          {0.6199,-0.00038,135.712,6.88771,0.102832,0.4208}, /*cmy*/
          {4.144713,2.3231,0.0149,-0.1774}, /*cfy*/
          {-0.161,-0.00037,117.1492,5.88347,0.09929,0.1972}, /*cmz*/
          {2.631518,0.9143,4.9355,-3.3996} /*cfz*/
     },
     {
          2452162.0,
          {-0.1387,-0.00032,65.6327,3.2376,0.054945,0.1409}, /*cmx*/
          {2.408472,0.7216,4.7757,-3.3692}, /*cfx*/
          {0.6632,-0.0018,136.1141,6.92514,0.103292,0.4392}, /*cmy*/
          {4.179456,2.3532,0.0449,-0.1137}, /*cfy*/
          {-0.1306,-0.00081,115.575,5.86318,0.099169,0.1854}, /*cmz*/
          {2.665393,0.9475,4.9642,-3.4522} /*cfz*/
     },
     {
          2452203.0,
          {-0.1497,-0.00014,67.1708,3.34098,0.056591,0.156}, /*cmx*/
          {2.454435,0.7394,4.7763,-3.3422}, /*cfx*/
          {0.6451,-0.00065,136.2619,6.93008,0.1032,0.446}, /*cmy*/
          {4.205885,2.3778,0.0697,-0.1753}, /*cfy*/
          {-0.1238,-5e-05,114.6182,5.85923,0.099298,0.1648}, /*cmz*/
          {2.691682,0.9797,4.9946,-3.3817} /*cfz*/
     },
     {
          2452244.0,
          {-0.1498,-0.00046,66.4175,3.29848,0.055309,0.1698}, /*cmx*/
          {2.473081,0.7281,4.7542,-3.3939}, /*cfx*/
          {0.6627,-0.00168,136.2128,6.87835,0.101917,0.4422}, /*cmy*/
          {4.230359,2.4027,0.0985,-0.1208}, /*cfy*/
          {-0.0854,-0.00082,115.1008,5.9015,0.10006,0.1526}, /*cmz*/
          {2.718354,1.0149,5.029,-3.4994} /*cfz*/
     },
     {
          2452285.0,
          {-0.1559,-1e-05,63.3449,3.12768,0.051806,0.1679}, /*cmx*/
          {2.475522,0.7093,4.7308,-3.3566}, /*cfx*/
          {0.6365,-0.00077,135.9087,6.78471,0.099973,0.4337}, /*cmy*/
          {4.262208,2.4381,0.1412,-0.1662}, /*cfy*/
          {-0.0789,6e-05,116.9245,5.99139,0.101434,0.1337}, /*cmz*/
          {2.75396,1.0559,5.0676,-3.3767} /*cfz*/
     },
     {
          2452326.0,
          {-0.133,-0.00036,58.9984,2.8908,0.047376,0.1511}, /*cmx*/
          {2.474775,0.7034,4.7281,-3.4255}, /*cfx*/
          {0.6485,-0.0014,135.5501,6.67076,0.097714,0.4351}, /*cmy*/
          {4.306137,2.4862,0.201,-0.1314}, /*cfy*/
          {-0.022,-0.00113,119.3699,6.10128,0.102908,0.1128}, /*cmz*/
          {2.801634,1.1031,5.1107,-3.6097} /*cfz*/
     },
     {
          2452367.0,
          {-0.1216,0.00022,54.8052,2.67111,0.043594,0.1239}, /*cmx*/
          {2.485656,0.73,4.7631,-3.3648}, /*cfx*/
          {0.6441,-0.0009,135.1844,6.58163,0.0963,0.441}, /*cmy*/
          {4.362354,2.5473,0.2745,-0.1495}, /*cfy*/
          {-0.013,4e-05,121.5296,6.21349,0.104434,0.0843}, /*cmz*/
          {2.860069,1.156,5.1564,-3.4171} /*cfz*/
     },
     {
          2452408.0,
          {-0.0866,-0.00019,52.0841,2.53616,0.041611,0.0962}, /*cmx*/
          {2.521762,0.8002,4.8444,-3.4882}, /*cfx*/
          {0.6535,-0.00086,135.0282,6.53736,0.095841,0.4531}, /*cmy*/
          {4.423477,2.6112,0.3494,-0.151}, /*cfy*/
          {0.0395,-0.00129,122.8915,6.30903,0.10579,0.0748}, /*cmz*/
          {2.922882,1.2095,5.2014,-3.8481} /*cfz*/
     },
     {
          2452449.0,
          {-0.0686,0.00027,51.58,2.54151,0.042391,0.0705}, /*cmx*/
          {2.589684,0.9052,4.9506,-3.3711}, /*cfx*/
          {0.6645,-0.00085,135.0742,6.54631,0.096517,0.4677}, /*cmy*/
          {4.480707,2.6693,0.4141,-0.1491}, /*cfy*/
          {0.0388,-0.00022,123.147,6.38042,0.106979,0.0563}, /*cmz*/
          {2.981753,1.2579,5.2398,-3.5155} /*cfz*/
     },
     {
          2452490.0,
          {-0.032,-0.00043,53.2328,2.68093,0.045513,0.0539}, /*cmx*/
          {2.67653,1.0069,5.0392,-3.5833}, /*cfx*/
          {0.6687,-0.00055,135.3042,6.58311,0.097465,0.4816}, /*cmy*/
          {4.52656,2.7135,0.4608,-0.1706}, /*cfy*/
          {0.0865,-0.00157,122.4706,6.4086,0.107469,0.0516}, /*cmz*/
          {3.029231,1.2961,5.2705,-4.0963} /*cfz*/
     },
     {
          2452531.0,
          {-0.0314,-5e-05,55.7656,2.86812,0.049162,0.0533}, /*cmx*/
          {2.753995,1.0692,5.0791,-3.3297}, /*cfx*/
          {0.6881,-0.00121,135.5331,6.61704,0.098285,0.4902}, /*cmy*/
          {4.559896,2.7454,0.4927,-0.1446}, /*cfy*/
          {0.0837,-0.00041,121.2887,6.40499,0.107383,0.0263}, /*cmz*/
          {3.063198,1.3264,5.2961,-3.7746} /*cfz*/
     },
     {
          2452572.0,
          {-0.0254,-0.00075,57.2827,2.97186,0.050918,0.0686}, /*cmx*/
          {2.801423,1.0843,5.0756,-3.525}, /*cfx*/
          {0.6702,-0.00045,135.6248,6.6155,0.098172,0.4924}, /*cmy*/
          {4.585054,2.77,0.5181,-0.1949}, /*cfy*/
          {0.119,-0.00128,120.6295,6.39919,0.107116,0.0339}, /*cmz*/
          {3.088858,1.3542,5.3232,-4.7418} /*cfz*/
     },
     {
          2452613.0,
          {-0.0471,-0.00031,56.4183,2.92495,0.049804,0.0879}, /*cmx*/
          {2.816232,1.0668,5.0463,-3.3617}, /*cfx*/
          {0.6796,-0.00146,135.4674,6.5632,0.097234,0.4886}, /*cmy*/
          {4.609862,2.7979,0.5503,-0.1442}, /*cfy*/
          {0.1247,-0.00036,121.1224,6.42952,0.107274,0.0161}, /*cmz*/
          {3.115012,1.3847,5.3536,-5.2466} /*cfz*/
     },
     {
          2452654.0,
          {-0.047,-0.0007,53.2569,2.74103,0.046232,0.094}, /*cmx*/
          {2.808682,1.0364,5.0133,-3.4741}, /*cfx*/
          {0.639,-0.00032,135.0511,6.47282,0.09569,0.4734}, /*cmy*/
          {4.643272,2.8374,0.5977,-0.1965}, /*cfy*/
          {0.1684,-0.0011,122.8101,6.49029,0.10769,0.0439}, /*cmz*/
          {3.149775,1.4212,5.3898,-5.6989} /*cfz*/
     },
     {
          2452695.0,
          {-0.054,-0.00022,48.8646,2.49458,0.041655,0.0884}, /*cmx*/
          {2.792074,1.014,4.9956,-3.3966}, /*cfx*/
          {0.6474,-0.00155,134.5197,6.37224,0.094441,0.4584}, /*cmy*/
          {4.689622,2.8928,0.6642,-0.1271}, /*cfy*/
          {0.1948,-0.00066,124.9264,6.56902,0.108211,0.0564}, /*cmz*/
          {3.196413,1.4649,5.4312,-6.0621} /*cfz*/
     },
     {
          2452736.0,
          {-0.0405,-0.00034,44.7528,2.26284,0.037436,0.0706}, /*cmx*/
          {2.78419,1.0212,5.0155,-3.5228}, /*cfx*/
          {0.6046,1e-05,134.0078,6.30179,0.093986,0.4495}, /*cmy*/
          {4.748148,2.9602,0.7419,-0.2142}, /*cfy*/
          {0.2316,-0.00096,126.8474,6.64631,0.108744,0.0872}, /*cmz*/
          {3.253819,1.5151,5.4779,-6.1329} /*cfz*/
     },
     {
          2452777.0,
          {-0.0256,3e-05,42.1226,2.11675,0.034877,0.0474}, /*cmx*/
          {2.805028,1.0766,5.0854,-3.5041}, /*cfx*/
          {0.6262,-0.00124,133.6745,6.27604,0.094702,0.456}, /*cmy*/
          {4.810488,3.0303,0.8202,-0.1395}, /*cfy*/
          {0.2665,-0.00102,128.0728,6.72236,0.109405,0.1061}, /*cmz*/
          {3.315534,1.5662,5.5233,-6.1838} /*cfz*/
     },
     {
          2452818.0,
          {0.0042,-4e-05,41.6752,2.10436,0.034867,0.0206}, /*cmx*/
          {2.869183,1.177,5.1925,-3.8997}, /*cfx*/
          {0.5953,0.00029,133.5404,6.30412,0.096258,0.4597}, /*cmy*/
          {4.868316,3.0924,0.8848,-0.2118}, /*cfy*/
          {0.2901,-0.00093,128.5001,6.78394,0.110145,0.1293}, /*cmz*/
          {3.373464,1.6128,5.5633,-6.2799} /*cfz*/
     },
     {
          2452859.0,
          {0.0317,-9e-05,43.28,2.23238,0.037428,0.009}, /*cmx*/
          {2.96275,1.2827,5.2855,-5.1502}, /*cfx*/
          {0.6231,-0.001,133.6359,6.35251,0.097971,0.4662}, /*cmy*/
          {4.913071,3.1387,0.9305,-0.142}, /*cfy*/
          {0.322,-0.00149,128.1093,6.81924,0.110547,0.14}, /*cmz*/
          {3.419859,1.6492,5.5936,-6.223} /*cfz*/
     },
     {
          2452900.0,
          {0.0471,-0.00029,45.7837,2.41699,0.040898,0.0112}, /*cmx*/
          {3.049851,1.3485,5.3267,-5.8346}, /*cfx*/
          {0.5957,0.00027,133.7814,6.39469,0.099024,0.468}, /*cmy*/
          {4.945202,3.1701,0.9593,-0.2236}, /*cfy*/
          {0.3208,-0.00086,127.3085,6.81996,0.110431,0.1528}, /*cmz*/
          {3.453121,1.6778,5.6193,-0.0765} /*cfz*/
     },
     {
          2452941.0,
          {0.05,-0.00066,47.2603,2.53047,0.04295,0.0095}, /*cmx*/
          {3.100439,1.361,5.3152,-4.451}, /*cfx*/
          {0.6124,-0.00099,133.8267,6.39325,0.099095,0.4714}, /*cmy*/
          {4.968717,3.1945,0.9836,-0.1647}, /*cfy*/
          {0.3559,-0.00161,126.8401,6.80954,0.109877,0.1681}, /*cmz*/
          {3.477534,1.7022,5.6441,-6.2576} /*cfz*/
     },
     {
          2452982.0,
          {0.03,-0.00055,46.3877,2.4922,0.042293,0.023}, /*cmx*/
          {3.109009,1.334,5.2735,-3.5116}, /*cfx*/
          {0.5764,-0.00012,133.6062,6.35486,0.098424,0.4583}, /*cmy*/
          {4.994275,3.2236,1.014,-0.2134}, /*cfy*/
          {0.3538,-0.00051,127.2944,6.81094,0.109374,0.184}, /*cmz*/
          {3.502344,1.7299,5.674,-0.1082} /*cfz*/
     },
     {
          2453023.0,
          {0.0158,-0.00078,43.2494,2.31786,0.039212,0.0425}, /*cmx*/
          {3.083071,1.2853,5.2211,-3.5702}, /*cfx*/
          {0.5658,-0.00089,133.1774,6.28138,0.097444,0.4384}, /*cmy*/
          {5.028794,3.266,1.0609,-0.1687}, /*cfy*/
          {0.3999,-0.00162,128.6423,6.82947,0.108809,0.1981}, /*cmz*/
          {3.535012,1.7632,5.7098,-6.2565} /*cfz*/
     },
     {
          2453064.0,
          {-0.0041,-0.0004,39.0537,2.07821,0.034953,0.0463}, /*cmx*/
          {3.037227,1.2364,5.1801,-3.4435}, /*cfx*/
          {0.5225,-0.00019,132.6019,6.21649,0.09698,0.4129}, /*cmy*/
          {5.078075,3.3251,1.1241,-0.213}, /*cfy*/
          {0.399,-0.00042,130.3021,6.85569,0.108325,0.214}, /*cmz*/
          {3.57994,1.8057,5.7539,-0.1227} /*cfz*/
     },
     {
          2453105.0,
          {-0.001,-0.00046,35.2862,1.85103,0.030777,0.0405}, /*cmx*/
          {2.992769,1.2118,5.1735,-3.61}, /*cfx*/
          {0.4988,-0.00036,132.0706,6.18064,0.09745,0.3955}, /*cmy*/
          {5.138437,3.3958,1.1978,-0.1947}, /*cfy*/
          {0.4609,-0.00181,131.7876,6.88309,0.107792,0.2438}, /*cmz*/
          {3.635016,1.8542,5.8034,-0.0059} /*cfz*/
     },
     {
          2453146.0,
          {0.0028,3e-05,32.9984,1.69456,0.02779,0.0212}, /*cmx*/
          {2.984088,1.242,5.2273,-3.6177}, /*cfx*/
          {0.4764,-0.00019,131.6798,6.20361,0.099179,0.3823}, /*cmy*/
          {5.203298,3.4684,1.2683,-0.2021}, /*cfy*/
          {0.4647,-0.00046,132.726,6.91627,0.107701,0.2686}, /*cmz*/
          {3.694898,1.906,5.8544,-0.1311} /*cfz*/
     },
     {
          2453187.0,
          {0.0304,-0.00011,32.6195,1.65497,0.026969,0.0132}, /*cmx*/
          {3.039067,1.3371,5.3391,-5.1315}, /*cfx*/
          {0.4587,0.00021,131.5369,6.26329,0.101475,0.3811}, /*cmy*/
          {5.261237,3.5307,1.326,-0.2147}, /*cfy*/
          {0.516,-0.00179,133.1387,6.95446,0.107894,0.289}, /*cmz*/
          {3.750843,1.9519,5.8984,-0.0367} /*cfz*/
     },
     {
          2453228.0,
          {0.0517,0.00016,34.0293,1.75248,0.02878,0.0261}, /*cmx*/
          {3.146292,1.4572,5.4519,-6.2733}, /*cfx*/
          {0.4588,-5e-05,131.5739,6.33995,0.103711,0.3828}, /*cmy*/
          {5.305995,3.5763,1.3651,-0.1986}, /*cfy*/
          {0.5072,-0.00065,132.9563,6.98626,0.108278,0.2989}, /*cmz*/
          {3.796289,1.989,5.9321,-0.1449} /*cfz*/
     },
     {
          2453269.0,
          {0.0819,-0.00045,36.3234,1.9269,0.031987,0.0393}, /*cmx*/
          {3.252496,1.5359,5.5019,-6.1851}, /*cfx*/
          {0.4364,0.00058,131.7039,6.38857,0.104899,0.3819}, /*cmy*/
          {5.336313,3.6057,1.3904,-0.2357}, /*cfy*/
          {0.5463,-0.00188,132.4769,6.98994,0.108109,0.3155}, /*cmz*/
          {3.828238,2.0158,5.9577,-0.0737} /*cfz*/
     },
     {
          2453310.0,
          {0.0775,-0.00034,37.7388,2.05381,0.034421,0.0309}, /*cmx*/
          {3.311861,1.5495,5.4838,-0.1452}, /*cfx*/
          {0.4428,-0.00044,131.727,6.40047,0.105087,0.3748}, /*cmy*/
          {5.359341,3.6287,1.4102,-0.1882}, /*cfy*/
          {0.5378,-0.00084,132.1058,6.97251,0.107558,0.3247}, /*cmz*/
          {3.85177,2.0399,5.9834,-0.1415} /*cfz*/
     },
     {
          2453351.0,
          {0.0672,-0.00084,37.0046,2.04679,0.034596,0.013}, /*cmx*/
          {3.310321,1.5082,5.422,-5.7872}, /*cfx*/
          {0.4032,0.00048,131.5705,6.36604,0.104274,0.3625}, /*cmy*/
          {5.384397,3.6562,1.4375,-0.2593}, /*cfy*/
          {0.5617,-0.00152,132.4196,6.94769,0.106582,0.3343}, /*cmz*/
          {3.874946,2.0656,6.0134,-0.0933} /*cfz*/
     },
     {
          2453392.0,
          {0.0349,-0.00055,34.2608,1.91399,0.032604,0.0136}, /*cmx*/
          {3.253454,1.4317,5.3405,-3.4211}, /*cfx*/
          {0.3953,-0.00068,131.1822,6.3172,0.10348,0.343}, /*cmy*/
          {5.42053,3.6984,1.479,-0.189}, /*cfy*/
          {0.5602,-0.00089,133.2947,6.92354,0.105461,0.3384}, /*cmz*/
          {3.906177,2.0987,6.052,-0.1269} /*cfz*/
     },
     {
          2453433.0,
          {0.0181,-0.00071,30.8385,1.72057,0.029359,0.0275}, /*cmx*/
          {3.155959,1.341,5.2621,-3.6251}, /*cfx*/
          {0.3273,0.0007,130.7314,6.27988,0.103144,0.3097}, /*cmy*/
          {5.471668,3.7563,1.5358,-0.2822}, /*cfy*/
          {0.5853,-0.00131,134.369,6.89473,0.104124,0.3534}, /*cmz*/
          {3.948879,2.1409,6.1002,-0.1061} /*cfz*/
     },
     {
          2453474.0,
          {0.0003,-0.00024,28.1143,1.53394,0.025889,0.0291}, /*cmx*/
          {3.051854,1.2684,5.2147,-3.4386}, /*cfx*/
          {0.3132,-0.00055,130.314,6.28963,0.104039,0.2787}, /*cmy*/
          {5.534401,3.8254,1.5993,-0.1878}, /*cfy*/
          {0.6045,-0.00118,135.1871,6.86838,0.103022,0.3678}, /*cmz*/
          {4.002184,2.192,6.1576,-0.1092} /*cfz*/
     },
     {
          2453515.0,
          {0.0049,-0.0002,26.7278,1.39208,0.022924,0.0218}, /*cmx*/
          {2.998593,1.257,5.2343,-3.8007}, /*cfx*/
          {0.2544,0.001,130.0906,6.34558,0.105854,0.257}, /*cmy*/
          {5.600537,3.8943,1.6607,-0.3241}, /*cfy*/
          {0.6195,-0.00093,135.7088,6.85817,0.102406,0.3891}, /*cmz*/
          {4.060206,2.2459,6.2167,-0.1368} /*cfz*/
     },
     {
          2453556.0,
          {0.0176,0.00015,26.5421,1.32686,0.021385,0.0066}, /*cmx*/
          {3.042004,1.3383,5.3407,-4.7262}, /*cfx*/
          {0.2571,-0.00013,130.0123,6.4409,0.108455,0.2508}, /*cmy*/
          {5.659198,3.9533,1.7096,-0.2062}, /*cfy*/
          {0.6473,-0.0013,135.9481,6.87115,0.102473,0.4084}, /*cmz*/
          {4.114985,2.2951,6.2688,-0.1152} /*cfz*/
     },
     {
          2453597.0,
          {0.0484,0.0,27.4577,1.37578,0.022204,0.0255}, /*cmx*/
          {3.170758,1.4811,5.4843,-6.0847}, /*cfx*/
          {0.2147,0.00128,130.1309,6.53522,0.110704,0.242}, /*cmy*/
          {5.703758,3.9951,1.7431,-0.3203}, /*cfy*/
          {0.6507,-0.00077,135.9099,6.89566,0.102842,0.4251}, /*cmz*/
          {4.159419,2.3337,0.0243,-0.1566} /*cfz*/
     },
     {
          2453638.0,
          {0.0721,-0.00011,29.1203,1.523,0.024986,0.0392}, /*cmx*/
          {3.311032,1.5929,5.5645,-0.0256}, /*cfx*/
          {0.2247,0.00013,130.2584,6.59769,0.112008,0.2385}, /*cmy*/
          {5.733004,4.022,1.7634,-0.2102}, /*cfy*/
          {0.6779,-0.00166,135.6303,6.90391,0.102966,0.4316}, /*cmz*/
          {4.191002,2.3619,0.0529,-0.112} /*cfz*/
     },
     {
          2453679.0,
          {0.0793,-0.00042,30.341,1.66459,0.027836,0.0387}, /*cmx*/
          {3.389029,1.6198,5.5519,-0.0836}, /*cfx*/
          {0.194,0.00105,130.339,6.60464,0.111846,0.2295}, /*cmy*/
          {5.755113,4.0423,1.7813,-0.3303}, /*cfy*/
          {0.6583,-0.00061,135.3792,6.8886,0.102555,0.4373}, /*cmz*/
          {4.214122,2.3856,0.0786,-0.1819} /*cfz*/
     },
     {
          2453720.0,
          {0.0667,-0.00064,29.988,1.71128,0.029194,0.0205}, /*cmx*/
          {3.376149,1.5675,5.4741,-0.0383}, /*cfx*/
          {0.1884,7e-05,130.2081,6.57298,0.110833,0.2205}, /*cmy*/
          {5.779809,4.068,1.8055,-0.2494}, /*cfy*/
          {0.6843,-0.00176,135.4966,6.84772,0.101553,0.4424}, /*cmz*/
          {4.23653,2.4111,0.1098,-0.1156} /*cfz*/
     },
     {
          2453761.0,
          {0.0397,-0.00065,28.3245,1.65801,0.028814,0.0025}, /*cmx*/
          {3.277447,1.4619,5.3664,-4.2092}, /*cfx*/
          {0.1432,0.00063,129.983,6.52798,0.109573,0.1923}, /*cmy*/
          {5.817098,4.1071,1.8434,-0.337}, /*cfy*/
          {0.6577,-0.00045,135.8597,6.7931,0.100246,0.4426}, /*cmz*/
          {4.266802,2.4454,0.1513,-0.1787} /*cfz*/
     },
     {
          2453802.0,
          {0.0139,-0.00058,26.6523,1.5584,0.027265,0.0221}, /*cmx*/
          {3.121518,1.3328,5.2569,-3.4713}, /*cfx*/
          {0.1068,0.0003,129.6998,6.5067,0.108953,0.1636}, /*cmy*/
          {5.869054,4.1612,1.8936,-0.3128}, /*cfy*/
          {0.6864,-0.0018,136.2378,6.723,0.098742,0.4394}, /*cmz*/
          {4.308313,2.4901,0.2059,-0.0994} /*cfz*/
     },
     {
          2453843.0,
          {-0.0055,-0.00036,25.9817,1.45617,0.025128,0.0303}, /*cmx*/
          {2.972095,1.223,5.178,-3.4653}, /*cfx*/
          {0.0614,0.00058,129.54,6.52817,0.109326,0.1266}, /*cmy*/
          {5.933155,4.225,1.9512,-0.4053}, /*cfy*/
          {0.6573,-0.00026,136.3658,6.66202,0.097625,0.4415}, /*cmz*/
          {4.36086,2.5454,0.271,-0.1897} /*cfz*/
     },
     {
          2453884.0,
          {-0.0082,-0.00017,26.0855,1.36292,0.022752,0.0291}, /*cmx*/
          {2.900253,1.178,5.1615,-3.5624}, /*cfx*/
          {0.0152,0.00086,129.51,6.60072,0.110804,0.1022}, /*cmy*/
          {5.999574,4.2884,2.0055,-0.4808}, /*cfy*/
          {0.6952,-0.0016,136.3907,6.6201,0.097109,0.4571}, /*cmz*/
          {4.417881,2.6041,0.34,-0.1175} /*cfz*/
     },
     {
          2453925.0,
          {0.0018,0.00011,26.2303,1.28713,0.020759,0.0148}, /*cmx*/
          {2.941098,1.2326,5.2368,-3.808}, /*cfx*/
          {-0.0074,0.00061,129.6408,6.705,0.11298,0.076}, /*cmy*/
          {6.058799,4.342,2.0494,-0.4729}, /*cfy*/
          {0.6779,-0.00016,136.3653,6.62287,0.097601,0.4718}, /*cmz*/
          {4.472705,2.6594,0.401,-0.1873} /*cfz*/
     },
     {
          2453966.0,
          {0.0304,0.0,26.3357,1.27636,0.020399,0.0132}, /*cmx*/
          {3.077985,1.3768,5.3861,-5.5414}, /*cfx*/
          {-0.0398,0.00135,129.8273,6.80744,0.11502,0.0758}, /*cmy*/
          {6.10246,4.3798,2.0785,-0.638}, /*cfy*/
          {0.7127,-0.00139,136.4194,6.64603,0.098384,0.4831}, /*cmz*/
          {4.517019,2.7017,0.4463,-0.1271} /*cfz*/
     },
     {
          2454007.0,
          {0.0528,5e-05,26.865,1.36988,0.022367,0.0285}, /*cmx*/
          {3.242099,1.5245,5.5086,-0.0244}, /*cfx*/
          {-0.0347,0.00066,129.9993,6.86775,0.116088,0.0635}, /*cmy*/
          {6.131294,4.4044,2.0973,-0.4469}, /*cfy*/
          {0.6913,-0.00027,136.3378,6.67023,0.099009,0.488}, /*cmz*/
          {4.549373,2.7323,0.4766,-0.195} /*cfz*/
     },
     {
          2454048.0,
          {0.0723,-0.00046,27.587,1.51347,0.025433,0.0355}, /*cmx*/
          {3.34062,1.5831,5.5279,-6.2633}, /*cfx*/
          {-0.0711,0.00157,130.0795,6.86959,0.115682,0.0651}, /*cmy*/
          {6.152249,4.4229,2.1136,-0.7884}, /*cfy*/
          {0.7105,-0.00133,136.2301,6.65891,0.098811,0.493}, /*cmz*/
          {4.572284,2.7558,0.5023,-0.1501} /*cfz*/
     },
     {
          2454089.0,
          {0.0599,-0.00039,27.8119,1.61999,0.027994,0.025}, /*cmx*/
          {3.327439,1.5444,5.4647,-0.214}, /*cfx*/
          {-0.0675,0.00027,130.0147,6.82574,0.114209,0.0396}, /*cmy*/
          {6.176989,4.4469,2.1374,-0.558}, /*cfy*/
          {0.6887,-0.00062,136.1288,6.62233,0.098193,0.4895}, /*cmz*/
          {4.595152,2.7826,0.5328,-0.1838} /*cfz*/
     },
     {
          2454130.0,
          {0.0434,-0.00073,27.7828,1.66547,0.029344,0.0064}, /*cmx*/
          {3.214931,1.4417,5.3635,-5.603}, /*cfx*/
          {-0.1191,0.00138,129.8889,6.76829,0.112333,0.047}, /*cmy*/
          {6.213804,4.4832,2.1738,-1.3351}, /*cfy*/
          {0.6869,-0.0011,136.0803,6.55213,0.096983,0.4802}, /*cmz*/
          {4.624765,2.8175,0.575,-0.1577} /*cfz*/
     },
     {
          2454171.0,
          {0.0127,-0.0004,28.367,1.67474,0.029592,0.0162}, /*cmx*/
          {3.060963,1.3212,5.263,-3.2888}, /*cfx*/
          {-0.1296,0.00015,129.7737,6.73472,0.111022,0.0179}, /*cmy*/
          {6.266161,4.5339,2.2227,-2.1632}, /*cfy*/
          {0.6634,-0.00071,135.8089,6.47129,0.095879,0.4676}, /*cmz*/
          {4.666397,2.8657,0.6319,-0.1754} /*cfz*/
     },
     {
          2454212.0,
          {0.0017,-0.00056,29.7433,1.66227,0.028846,0.0284}, /*cmx*/
          {2.939652,1.2253,5.1919,-3.596}, /*cfx*/
          {-0.2042,0.0016,129.8364,6.74401,0.110591,0.0643}, /*cmy*/
          {0.046445,4.5927,2.2777,-2.5489}, /*cfy*/
          {0.65,-0.00067,135.3439,6.39294,0.095085,0.4591}, /*cmz*/
          {4.718401,2.9249,0.7015,-0.1743} /*cfz*/
     },
     {
          2454253.0,
          {-0.0101,-4e-05,31.0409,1.62016,0.02722,0.0292}, /*cmx*/
          {2.898176,1.1875,5.1716,-3.4328}, /*cfx*/
          {-0.2211,0.00036,129.9916,6.80182,0.111299,0.0824}, /*cmy*/
          {0.112426,4.6515,2.3304,-3.1126}, /*cfy*/
          {0.6465,-0.00079,134.8561,6.35602,0.095473,0.4567}, /*cmz*/
          {4.77628,2.9908,0.7753,-0.164} /*cfz*/
     },
     {
          2454294.0,
          {0.0041,-0.00015,31.4003,1.54747,0.025117,0.023}, /*cmx*/
          {2.945915,1.2267,5.2212,-3.8798}, /*cfx*/
          {-0.276,0.00167,130.2642,6.89128,0.112741,0.1135}, /*cmy*/
          {0.170485,4.7008,2.3727,-2.9381}, /*cfy*/
          {0.6347,-0.00013,134.6867,6.36476,0.096651,0.4629}, /*cmz*/
          {4.831514,3.0513,0.8406,-0.1966} /*cfz*/
     },
     {
          2454335.0,
          {0.0212,0.00019,30.846,1.49323,0.023858,0.0071}, /*cmx*/
          {3.067908,1.3432,5.3411,-4.7225}, /*cfx*/
          {-0.2736,0.00068,130.487,6.98458,0.114371,0.1148}, /*cmy*/
          {0.213627,4.7362,2.4009,-3.1799}, /*cfy*/
          {0.6492,-0.00071,134.8024,6.41029,0.098339,0.4747}, /*cmz*/
          {4.877137,3.099,0.8883,-0.1652} /*cfz*/
     },
     {
          2454376.0,
          {0.0556,-0.00018,30.3206,1.52834,0.024776,0.0257}, /*cmx*/
          {3.217174,1.485,5.4699,-6.0187}, /*cfx*/
          {-0.3101,0.00182,130.6915,7.03597,0.115095,0.131}, /*cmy*/
          {0.241374,4.7586,2.4188,-3.0425}, /*cfy*/
          {0.6296,0.00013,134.9684,6.45025,0.099393,0.4781}, /*cmz*/
          {4.910174,3.131,0.919,-0.2096} /*cfz*/
     },
     {
          2454417.0,
          {0.0709,-0.00017,30.4269,1.6534,0.027618,0.0369}, /*cmx*/
          {3.317102,1.5669,5.5234,-0.0792}, /*cfx*/
          {-0.3059,0.00093,130.714,7.02689,0.114465,0.1313}, /*cmy*/
          {0.261595,4.7765,2.4353,-3.1785}, /*cfy*/
          {0.6452,-0.00105,134.9747,6.46122,0.099783,0.4758}, /*cmz*/
          {4.934021,3.1555,0.9422,-0.1575} /*cfz*/
     },
     {
          2454458.0,
          {0.0752,-0.00054,31.0899,1.79808,0.030857,0.0361}, /*cmx*/
          {3.318456,1.5589,5.4953,-0.0322}, /*cfx*/
          {-0.328,0.00141,130.6578,6.96432,0.112582,0.1455}, /*cmy*/
          {0.285483,4.7998,2.4605,-3.0985}, /*cfy*/
          {0.6075,0.00013,134.8274,6.4306,0.099205,0.4676}, /*cmz*/
          {4.95686,3.1806,0.9684,-0.2297} /*cfz*/
     },
     {
          2454499.0,
          {0.0583,-0.00045,32.3542,1.91805,0.033429,0.02}, /*cmx*/
          {3.237231,1.4914,5.4264,-0.1357}, /*cfx*/
          {-0.3405,0.0009,130.531,6.88634,0.110237,0.1541}, /*cmy*/
          {0.321755,4.8352,2.4985,-3.1515}, /*cfy*/
          {0.6134,-0.00119,134.434,6.36573,0.098308,0.4584}, /*cmz*/
          {4.986311,3.2157,1.0067,-0.1604} /*cfz*/
     },
     {
          2454540.0,
          {0.0443,-0.00062,34.4439,2.00359,0.034897,0.0076}, /*cmx*/
          {3.132924,1.4097,5.3568,-5.6377}, /*cfx*/
          {-0.3741,0.00107,130.526,6.82383,0.108208,0.1829}, /*cmy*/
          {0.372942,4.884,2.5499,-3.1565}, /*cfy*/
          {0.5572,0.00024,133.7071,6.28738,0.097367,0.4348}, /*cmz*/
          {5.027932,3.2644,1.0598,-0.2315} /*cfz*/
     },
     {
          2454581.0,
          {0.028,-0.00036,36.8883,2.04887,0.03511,0.0092}, /*cmx*/
          {3.062051,1.3498,5.3102,-3.7676}, /*cfx*/
          {-0.4144,0.00121,130.6263,6.80271,0.107037,0.2081}, /*cmy*/
          {0.434849,4.9407,2.6075,-3.1546}, /*cfy*/
          {0.5563,-0.00106,132.7813,6.2239,0.097251,0.4128}, /*cmz*/
          {5.08017,3.3266,1.1258,-0.1532} /*cfz*/
     },
     {
          2454622.0,
          {0.0249,-0.00036,38.7125,2.03562,0.033975,0.0148}, /*cmx*/
          {3.052107,1.3333,5.3028,-4.027}, /*cfx*/
          {-0.4391,0.00087,130.86,6.82744,0.106975,0.2409}, /*cmy*/
          {0.499149,4.9978,2.6634,-3.2308}, /*cfy*/
          {0.5048,0.00052,132.0254,6.20718,0.098141,0.3955}, /*cmz*/
          {5.138955,3.3949,1.1957,-0.2519} /*cfz*/
     },
     {
          2454663.0,
          {0.0314,-0.00016,39.1052,1.96564,0.031875,0.0129}, /*cmx*/
          {3.105451,1.3708,5.3444,-4.2777}, /*cfx*/
          {-0.4834,0.00151,131.1279,6.88954,0.107744,0.2665}, /*cmy*/
          {0.555707,5.0451,2.7077,-3.1915}, /*cfy*/
          {0.5159,-0.00062,131.7802,6.24625,0.100218,0.397}, /*cmz*/
          {5.195119,3.4593,1.2584,-0.1724} /*cfz*/
     },
     {
          2454704.0,
          {0.0503,-4e-05,38.2005,1.88536,0.030027,0.0157}, /*cmx*/
          {3.211161,1.4635,5.44,-5.7016}, /*cfx*/
          {-0.4886,0.00082,131.3432,6.95957,0.108864,0.2858}, /*cmy*/
          {0.597609,5.0795,2.7376,-3.2702}, /*cfy*/
          {0.4839,0.00067,132.063,6.32587,0.102581,0.3964}, /*cmz*/
          {5.242635,3.5093,1.3035,-0.242} /*cfz*/
     },
     {
          2454745.0,
          {0.0805,-0.0002,37.0437,1.87874,0.030066,0.0363}, /*cmx*/
          {3.336059,1.5811,5.5531,-6.1021}, /*cfx*/
          {-0.5206,0.00186,131.4555,6.99712,0.109281,0.2889}, /*cmy*/
          {0.624262,5.1009,2.756,-3.1953}, /*cfy*/
          {0.4988,-0.00036,132.4982,6.39553,0.104344,0.4002}, /*cmz*/
          {5.276483,3.5426,1.3316,-0.1765} /*cfz*/
     },
     {
          2454786.0,
          {0.0985,-0.00015,36.7241,1.97759,0.032374,0.0553}, /*cmx*/
          {3.425482,1.6632,5.6191,-0.088}, /*cfx*/
          {-0.5,0.00077,131.4149,6.97703,0.108554,0.2906}, /*cmy*/
          {0.643832,5.1194,2.7741,-3.2967}, /*cfy*/
          {0.4718,0.0005,132.7146,6.42502,0.104853,0.3949}, /*cmz*/
          {5.30128,3.5653,1.3508,-0.2459} /*cfz*/
     },
     {
          2454827.0,
          {0.1143,-0.00056,37.5449,2.13428,0.035707,0.0623}, /*cmx*/
          {3.439548,1.6753,5.6158,-0.0421}, /*cfx*/
          {-0.5334,0.00194,131.2936,6.90113,0.106494,0.2974}, /*cmy*/
          {0.666838,5.1426,2.8013,-3.1991}, /*cfy*/
          {0.4682,-0.00028,132.5573,6.4011,0.104325,0.3898}, /*cmz*/
          {5.323482,3.5883,1.3724,-0.2032} /*cfz*/
     },
     {
          2454868.0,
          {0.1048,-0.00034,39.4426,2.29091,0.038802,0.0573}, /*cmx*/
          {3.391631,1.6386,5.5746,-0.161}, /*cfx*/
          {-0.5167,0.00053,131.1053,6.80175,0.104011,0.3069}, /*cmy*/
          {0.702321,5.1797,2.8448,-3.2909}, /*cfy*/
          {0.4349,6e-05,131.9731,6.34482,0.103247,0.3695}, /*cmz*/
          {5.353173,3.6204,1.4036,-0.235} /*cfz*/
     },
     {
          2454909.0,
          {0.1021,-0.0007,42.1716,2.41682,0.04087,0.0448}, /*cmx*/
          {3.328058,1.5888,5.5292,-6.2399}, /*cfx*/
          {-0.5598,0.00178,131.0413,6.71204,0.101643,0.3184}, /*cmy*/
          {0.752008,5.229,2.902,-3.1896}, /*cfy*/
          {0.4059,-9e-05,130.98,6.27224,0.102229,0.3467}, /*cmz*/
          {5.393787,3.6666,1.4494,-0.2212} /*cfz*/
     },
     {
          2454950.0,
          {0.0854,-0.0003,45.0063,2.48998,0.041571,0.0331}, /*cmx*/
          {3.291159,1.5565,5.5026,-0.0866}, /*cfx*/
          {-0.5513,0.00041,131.0687,6.66149,0.100239,0.3343}, /*cmy*/
          {0.812584,5.2877,2.967,-3.2955}, /*cfy*/
          {0.3693,4e-05,129.8156,6.22518,0.102018,0.316}, /*cmz*/
          {5.446565,3.7265,1.5073,-0.2397} /*cfz*/
     },
     {
          2454991.0,
          {0.0934,-0.00069,46.9579,2.48955,0.040673,0.0318}, /*cmx*/
          {3.299502,1.5559,5.5056,-5.9777}, /*cfx*/
          {-0.6056,0.00171,131.2387,6.65253,0.099698,0.3635}, /*cmy*/
          {0.87494,5.3449,3.0291,-3.2225}, /*cfy*/
          {0.3258,0.00047,128.9589,6.22993,0.103052,0.2911}, /*cmz*/
          {5.505438,3.7935,1.5703,-0.2624} /*cfz*/
     },
     {
          2455032.0,
          {0.0894,-0.00011,47.2901,2.41495,0.038521,0.0324}, /*cmx*/
          {3.35561,1.5958,5.5478,-6.2482}, /*cfx*/
          {-0.6062,0.00052,131.3525,6.68516,0.100227,0.388}, /*cmy*/
          {0.930427,5.3947,3.0802,-3.3006}, /*cfy*/
          {0.3097,4e-05,128.8102,6.30653,0.10545,0.2714}, /*cmz*/
          {5.563579,3.8571,1.6262,-0.229} /*cfz*/
     },
     {
          2455073.0,
          {0.1128,-0.00047,46.1539,2.31363,0.036227,0.0471}, /*cmx*/
          {3.449688,1.675,5.6318,-6.0685}, /*cfx*/
          {-0.6433,0.00156,131.4661,6.73058,0.100949,0.4039}, /*cmy*/
          {0.971213,5.4291,3.1136,-3.2495}, /*cfy*/
          {0.2797,0.00091,129.3692,6.41857,0.108233,0.2701}, /*cmz*/
          {5.612019,3.9064,1.6673,-0.2871} /*cfz*/
     },
     {
          2455114.0,
          {0.126,-1e-05,44.634,2.27376,0.035584,0.066}, /*cmx*/
          {3.557126,1.7749,5.7345,-0.0671}, /*cfx*/
          {-0.6302,0.00073,131.4449,6.75686,0.101328,0.4068}, /*cmy*/
          {0.997657,5.452,3.1345,-3.3072}, /*cfy*/
          {0.2883,0.00011,130.1128,6.51939,0.110388,0.2714}, /*cmz*/
          {5.647655,3.939,1.6922,-0.218} /*cfz*/
     },
     {
          2455155.0,
          {0.1595,-0.0005,44.0348,2.34452,0.037234,0.0921}, /*cmx*/
          {3.635702,1.8492,5.8027,-0.0309}, /*cfx*/
          {-0.6471,0.00156,131.3466,6.72751,0.100465,0.409}, /*cmy*/
          {1.016504,5.4702,3.1541,-3.2704}, /*cfy*/
          {0.2519,0.0012,130.5631,6.56137,0.111005,0.2674}, /*cmz*/
          {5.672672,3.9601,1.709,-0.3056} /*cfz*/
     },
     {
          2455196.0,
          {0.1687,-0.00022,44.843,2.49462,0.040307,0.1059}, /*cmx*/
          {3.656158,1.8706,5.8132,-0.1458}, /*cfx*/
          {-0.6355,0.00106,131.0881,6.64808,0.098735,0.406}, /*cmy*/
          {1.039594,5.4966,3.1862,-3.2921}, /*cfy*/
          {0.2593,-0.00015,130.4491,6.54503,0.110349,0.255}, /*cmz*/
          {5.69525,3.9803,1.726,-0.2109} /*cfz*/
     },
     {
          2455237.0,
          {0.1799,-0.00063,46.9703,2.66256,0.043403,0.1085}, /*cmx*/
          {3.628457,1.8507,5.7876,-0.0883}, /*cfx*/
          {-0.6364,0.00117,130.8461,6.54094,0.096443,0.4056}, /*cmy*/
          {1.074626,5.5359,3.2355,-3.2832}, /*cfy*/
          {0.2119,0.00105,129.7872,6.47872,0.10872,0.2412}, /*cmz*/
          {5.723856,4.0082,1.7526,-0.3437} /*cfz*/
     },
     {
          2455278.0,
          {0.1717,-0.00036,49.9042,2.80493,0.045646,0.0995}, /*cmx*/
          {3.589629,1.8206,5.757,-0.1401}, /*cfx*/
          {-0.6364,0.00106,130.6557,6.44257,0.094533,0.4077}, /*cmy*/
          {1.124123,5.5897,3.3014,-3.278}, /*cfy*/
          {0.2062,-0.00024,128.6164,6.40354,0.107185,0.2195}, /*cmz*/
          {5.764066,4.0501,1.7919,-0.2307} /*cfz*/
     },
     {
          2455319.0,
          {0.1761,-0.00071,52.8288,2.88813,0.046461,0.0938}, /*cmx*/
          {3.571735,1.804,5.7419,-0.0543}, /*cfx*/
          {-0.638,0.00075,130.5783,6.3754,0.093327,0.4169}, /*cmy*/
          {1.183781,5.6518,3.375,-3.2953}, /*cfy*/
          {0.1368,0.00117,127.3824,6.35284,0.10632,0.1852}, /*cmz*/
          {5.816392,4.1053,1.8439,-0.3988} /*cfz*/
     },
     {
          2455360.0,
          {0.1721,-0.00048,54.7178,2.88917,0.045637,0.0864}, /*cmx*/
          {3.590427,1.8141,5.753,-0.0727}, /*cfx*/
          {-0.6604,0.0012,130.5385,6.35158,0.093237,0.4296}, /*cmy*/
          {1.245901,5.7147,3.4466,-3.2682}, /*cfy*/
          {0.1189,-2e-05,126.5466,6.36972,0.106968,0.1483}, /*cmz*/
          {5.875737,4.1681,1.9003,-0.2642} /*cfz*/
     },
     {
          2455401.0,
          {0.1753,-0.00054,54.9275,2.80535,0.043391,0.0865}, /*cmx*/
          {3.647358,1.8565,5.7984,-0.0392}, /*cfx*/
          {-0.657,0.00035,130.5074,6.36742,0.093861,0.4474}, /*cmy*/
          {1.301182,5.7678,3.504,-3.3258}, /*cfy*/
          {0.0628,0.00126,126.6283,6.45864,0.109003,0.125}, /*cmz*/
          {5.934689,4.2281,1.9526,-0.5087} /*cfz*/
     },
     {
          2455442.0,
          {0.183,-0.00044,53.5693,2.68386,0.040817,0.0932}, /*cmx*/
          {3.734352,1.9305,5.8806,-0.0373}, /*cfx*/
          {-0.6864,0.00124,130.4442,6.3993,0.094753,0.465}, /*cmy*/
          {1.342268,5.8058,3.543,-3.281}, /*cfy*/
          {0.0594,0.00033,127.4795,6.59798,0.111903,0.1138}, /*cmz*/
          {5.984689,4.2756,1.9904,-0.3128} /*cfz*/
     },
     {
          2455483.0,
          {0.197,-0.00026,51.7725,2.61255,0.039638,0.1137}, /*cmx*/
          {3.830004,2.0209,5.9811,-0.0917}, /*cfx*/
          {-0.6685,0.00027,130.3014,6.41651,0.095081,0.47}, /*cmy*/
          {1.369001,5.8304,3.5666,-3.3357}, /*cfy*/
          {0.0237,0.00139,128.6122,6.71853,0.114149,0.1078}, /*cmz*/
          {6.021882,4.3068,2.014,-0.5029} /*cfz*/
     },
     {
          2455524.0,
          {0.2235,-0.00045,50.9037,2.65297,0.04072,0.1372}, /*cmx*/
          {3.900758,2.0906,6.0535,-0.0783}, /*cfx*/
          {-0.6882,0.00156,130.0965,6.38741,0.094529,0.4635}, /*cmy*/
          {1.388393,5.8512,3.5896,-3.2732}, /*cfy*/
          {0.0241,0.00066,129.2649,6.77583,0.114912,0.1045}, /*cmz*/
          {6.047682,4.3268,2.0284,-0.3459} /*cfz*/
     },
     {
          2455565.0,
          {0.2354,-0.00018,51.6187,2.78581,0.043356,0.157}, /*cmx*/
          {3.923605,2.1158,6.0724,-0.1596}, /*cfx*/
          {-0.6488,0.00025,129.8038,6.31724,0.093179,0.4534}, /*cmy*/
          {1.412257,5.88,3.624,-3.3522}, /*cfy*/
          {0.0026,0.00116,129.2392,6.75093,0.113926,0.097}, /*cmz*/
          {6.070483,4.3451,2.0445,-0.517} /*cfz*/
     }

};

static unsigned idn_list[] = {2,20,39,59,81};
static double freq_list[] = {2.493,1.5162,0.7217,0.4667,4.488};
static double delt_list[] = {258.0,242.0,223.0,206.0,41.0};

BDL_Dataset uranus_9910 = {
     5, /*nsat*/
     2451178.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
