/***********************************************************************

 HiSIM (Hiroshima University STARC IGFET Model)
 Copyright (C) 2012 Hiroshima University & STARC

 MODEL NAME : HiSIM_HV 
 ( VERSION : 1  SUBVERSION : 2  REVISION : 4 )
 Model Parameter VERSION : 1.23
 FILE : hsmhv.c

 DATE : 2013.04.30


 released by
                Hiroshima University &
                Semiconductor Technology Academic Research Center (STARC)
***********************************************************************/

#include "ngspice/ngspice.h"
#include "ngspice/devdefs.h"
#include "hsmhvdef.h"
#include "ngspice/suffix.h"

IFparm HSMHVpTable[] = { /* parameters */
 IOP( "coselfheat", HSMHV_COSELFHEAT, IF_INTEGER, "Calculation of self heating model"),
 IOP( "cosubnode", HSMHV_COSUBNODE, IF_INTEGER, "Switch tempNode to subNode"),
 IOP( "l",   HSMHV_L,      IF_REAL   , "Length"),
 IOP( "w",   HSMHV_W,      IF_REAL   , "Width"),
 IOP( "ad",  HSMHV_AD,     IF_REAL   , "Drain area"),
 IOP( "as",  HSMHV_AS,     IF_REAL   , "Source area"),
 IOP( "pd",  HSMHV_PD,     IF_REAL   , "Drain perimeter"),
 IOP( "ps",  HSMHV_PS,     IF_REAL   , "Source perimeter"),
 IOP( "nrd", HSMHV_NRD,    IF_REAL   , "Number of squares in drain"),
 IOP( "nrs", HSMHV_NRS,    IF_REAL   , "Number of squares in source"),
 IOP( "dtemp", HSMHV_DTEMP,IF_REAL   , ""),
 IOP( "off", HSMHV_OFF,    IF_FLAG   , "Device is initially off"),
 IP ( "ic",  HSMHV_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
 IOP("corbnet", HSMHV_CORBNET, IF_INTEGER, "Activate body resistance (1) or not (0)"),
 IOP("rbpb", HSMHV_RBPB, IF_REAL, ""),
 IOP("rbpd", HSMHV_RBPD, IF_REAL, ""),
 IOP("rbps", HSMHV_RBPS, IF_REAL, ""),
 IOP("rbdb", HSMHV_RBDB, IF_REAL, ""),
 IOP("rbsb", HSMHV_RBSB, IF_REAL, ""),
 IOP("corg", HSMHV_CORG, IF_INTEGER, "Activate gate resistance (1) or not (0)"),
 IOP("ngcon", HSMHV_NGCON, IF_REAL, "Number of gate contacts"),
 IOP("xgw", HSMHV_XGW, IF_REAL, "Distance from gate contact to channel edge"),
 IOP("xgl", HSMHV_XGL, IF_REAL, "Offset of gate length due to variation in patterning"),
 IOP("nf", HSMHV_NF, IF_REAL, "Number of fingers"),
 IOP("sa", HSMHV_SA, IF_REAL, "Distance from STI edge to Gate edge [m]"),
 IOP("sb", HSMHV_SB, IF_REAL, "Distance from STI edge to Gate edge [m]"),
 IOP("sd", HSMHV_SD, IF_REAL, "Distance from Gate edge to Gate edge [m]"),
 IOP("nsubcdfm", HSMHV_NSUBCDFM, IF_REAL, "Constant part of Nsub for DFM [1/cm^3]"),
 IOP("m", HSMHV_M, IF_REAL, "Multiplication factor [-]"),
 IOP("subld1", HSMHV_SUBLD1, IF_REAL, "Parameter for impact-ionization current in the drift region [-]"),
 IOP("subld2", HSMHV_SUBLD2, IF_REAL, "Parameter for impact-ionization current in the drift region [m^{-1}*V^{3/2}]"),
 IOP("lover", HSMHV_LOVER, IF_REAL, "Overlap length on source side [m]"),
 IOP("lovers", HSMHV_LOVERS, IF_REAL, "Overlap length on source side [m]"),
 IOP("loverld", HSMHV_LOVERLD, IF_REAL, "Overlap length on drain side [m]"),
 IOP("ldrift1", HSMHV_LDRIFT1, IF_REAL, "Parameter for drift region length-1 [m]"),  
 IOP("ldrift2", HSMHV_LDRIFT2, IF_REAL, "Parameter for drift region length-2 [m]"),  
 IOP("ldrift1s", HSMHV_LDRIFT1S, IF_REAL, "Parameter for drift region length-1 on source side[m]"),  
 IOP("ldrift2s", HSMHV_LDRIFT2S, IF_REAL, "Parameter for drift region length-2 on source side[m]"),  

 /* Output Physical Values: */
 OP ( "ids",   HSMHV_CD,    IF_REAL   , "Ids"),  /* Drain-Source current */
 OP ( "isub",  HSMHV_ISUB,  IF_REAL   , "Isub"),  /* Substrate current */
 OP ( "igidl", HSMHV_IGIDL, IF_REAL   , "Igidl"), /* Gate-Induced Drain Leakage current */
 OP ( "igisl", HSMHV_IGISL, IF_REAL   , "Igisl"), /* Gate-Induced Source Leakage current */
 OP ( "igd",   HSMHV_IGD,   IF_REAL   , "Igd"),  /* Gate-Drain current */
 OP ( "igs",   HSMHV_IGS,   IF_REAL   , "Igs"),  /* Gate-Source current */
 OP ( "igb",   HSMHV_IGB,   IF_REAL   , "Igb"),  /* Gate-Substrate current */
 OP ( "gm",    HSMHV_GM,    IF_REAL   , "Gm"),   /* Transconductance */
 OP ( "gds",   HSMHV_GDS,   IF_REAL   , "Gds"),  /* Channel conductance */
 OP ( "gmbs",  HSMHV_GMBS,  IF_REAL   , "Gmbs"), /* Body effect (Back gate) transconductance */
 OP ( "gmt",   HSMHV_GMT,   IF_REAL   , "GmT"),   /* Temp - transconductance ----SHE----*/
 OP ( "von",   HSMHV_VON,   IF_REAL   , "Von"),  /* Threshold voltage */
 OP ( "vdsat", HSMHV_VDSAT, IF_REAL   , "Vdsat"), /* Saturation voltage */
 OP ( "qb",    HSMHV_QB,    IF_REAL   , "Qb"),   /* Bulk charge */
 OP ( "qg",    HSMHV_QG,    IF_REAL   , "Qg"),   /* Gate charge */
 OP ( "qd",    HSMHV_QD,    IF_REAL   , "Qd"),   /* Drain charge */
 OP ( "cgg",   HSMHV_CGG,   IF_REAL   , "Cgg"),  /* MOSFET capacitance */
 OP ( "cgd",   HSMHV_CGD,   IF_REAL   , "Cgd"),  /* MOSFET capacitance */
 OP ( "cgs",   HSMHV_CGS,   IF_REAL   , "Cgs"),  /* MOSFET capacitance */
 OP ( "cbg",   HSMHV_CBG,   IF_REAL   , "Cbg"),  /* MOSFET capacitance */
 OP ( "cbs",   HSMHV_CBSB,  IF_REAL   , "Cbs"),  /* MOSFET capacitance */
 OP ( "cbd",   HSMHV_CBDB,  IF_REAL   , "Cbd"),  /* MOSFET capacitance */
 OP ( "cdg",   HSMHV_CDG,   IF_REAL   , "Cdg"),  /* MOSFET capacitance */
 OP ( "cdd",   HSMHV_CDD,   IF_REAL   , "Cdd"),  /* MOSFET capacitance */
 OP ( "cds",   HSMHV_CDS,   IF_REAL   , "Cds"),  /* MOSFET capacitance */
 OP ( "cgdo",  HSMHV_CGDO,  IF_REAL   , "Cgdo"), /* MOSFET overlap capacitance */
 OP ( "cgso",  HSMHV_CGSO,  IF_REAL   , "Cgso"), /* MOSFET overlap capacitance */
 OP ( "cgbo",  HSMHV_CGBO,  IF_REAL   , "Cgbo"), /* MOSFET overlap capacitance */
 OP ( "ibd",   HSMHV_CBD,   IF_REAL   , "Ibd"),  /* Diode current */
 OP ( "ibs",   HSMHV_CBS,   IF_REAL   , "Ibs"),  /* Diode current */
 OP ( "gbd",   HSMHV_GBD,   IF_REAL   , "Gbd"),  /* Diode conductance */
 OP ( "gbs",   HSMHV_GBS,   IF_REAL   , "Gbs"),  /* Diode conductance */
 OP ( "capbd", HSMHV_CAPBD, IF_REAL   , "Capbd"), /* Diode capacitance */
 OP ( "capbs", HSMHV_CAPBS, IF_REAL   , "Capbs") /* Diode capacitance */
};

IFparm HSMHVmPTable[] = { /* model parameters */
  IP("nmos", HSMHV_MOD_NMOS, IF_FLAG, ""),
  IP("pmos", HSMHV_MOD_PMOS, IF_FLAG, ""),
  IOP("level", HSMHV_MOD_LEVEL, IF_INTEGER, ""),
  IOP("info", HSMHV_MOD_INFO, IF_INTEGER, "Information level (for debug, etc.)"),
  IOP("noise", HSMHV_MOD_NOISE, IF_INTEGER, "Noise model selector"),
  IOP("version", HSMHV_MOD_VERSION, IF_STRING, "Model version"),
  IOP("show", HSMHV_MOD_SHOW, IF_INTEGER, "Show physical value"),
  IOP("corsrd", HSMHV_MOD_CORSRD, IF_INTEGER, "Handling of Rs and Rd"),
  IOP("corg", HSMHV_MOD_CORG, IF_INTEGER, "Activate gate resistance (1) or not (0)"),
  IOP("coiprv", HSMHV_MOD_COIPRV, IF_INTEGER, "Use ids_prv as initial guess of Ids (internal flag)"),
  IOP("copprv", HSMHV_MOD_COPPRV, IF_INTEGER, "Use ps{0/l}_prv as initial guess of Ps{0/l} (internal flag)"),
  IOP("coadov", HSMHV_MOD_COADOV, IF_INTEGER, "Add overlap to intrisic"),
  IOP("coisub", HSMHV_MOD_COISUB, IF_INTEGER, "Calculate isub"),
  IOP("coiigs", HSMHV_MOD_COIIGS, IF_INTEGER, "Calculate igate"),
  IOP("cogidl", HSMHV_MOD_COGIDL, IF_INTEGER, "Calculate igidl"),
  IOP("coovlp", HSMHV_MOD_COOVLP, IF_INTEGER, "Calculate overlap charge on the drain side"),
  IOP("coovlps", HSMHV_MOD_COOVLPS, IF_INTEGER, "Calculate overlap charge on the source side"),
  IOP("coflick", HSMHV_MOD_COFLICK, IF_INTEGER, "Calculate 1/f noise"),
  IOP("coisti", HSMHV_MOD_COISTI, IF_INTEGER, "Calculate STI"),
  IOP("conqs", HSMHV_MOD_CONQS, IF_INTEGER, "Calculate in nqs mode or qs mode"),
  IOP("corbnet", HSMHV_MOD_CORBNET, IF_INTEGER, ""),
  IOP("cothrml", HSMHV_MOD_COTHRML, IF_INTEGER, "Calculate thermal noise"),
  IOP("coign", HSMHV_MOD_COIGN, IF_INTEGER, "Calculate induced gate noise"),
  IOP("codfm", HSMHV_MOD_CODFM, IF_INTEGER, "Calculation of model for DFM"),
  IOP("coqovsm", HSMHV_MOD_COQOVSM, IF_INTEGER, "select smoothing method of Qover"),
  IOP("coselfheat", HSMHV_MOD_COSELFHEAT, IF_INTEGER, "Calculation of self heating model"),
  IOP("cosubnode", HSMHV_MOD_COSUBNODE, IF_INTEGER, "Switch tempNode to subNode"),
  IOP("cosym", HSMHV_MOD_COSYM, IF_INTEGER, "Model selector for symmetry device"), 
  IOP("cotemp", HSMHV_MOD_COTEMP, IF_INTEGER, "Model flag for temperature dependence"), 
  IOP("coldrift", HSMHV_MOD_COLDRIFT, IF_INTEGER, "selector for Ldrift parameter"),

  IOP("vbsmin", HSMHV_MOD_VBSMIN, IF_REAL, "Minimum back bias voltage to be treated in hsmhveval [V]"),

  IOP("vmax", HSMHV_MOD_VMAX, IF_REAL, "Saturation velocity [cm/s]"),
  IOP("vmaxt1", HSMHV_MOD_VMAXT1, IF_REAL, "Saturation velocity coeff. [-]"),
  IOP("vmaxt2", HSMHV_MOD_VMAXT2, IF_REAL, "Saturation velocity coeff. [-]"),
  IOP("bgtmp1", HSMHV_MOD_BGTMP1, IF_REAL, "First order temp. coeff. for band gap [V/K]"),
  IOP("bgtmp2", HSMHV_MOD_BGTMP2, IF_REAL, "Second order temp. coeff. for band gap [V/K^2]"),
  IOP("eg0", HSMHV_MOD_EG0, IF_REAL, ""),
  IOP("tox", HSMHV_MOD_TOX, IF_REAL, "Oxide thickness [m]"),
  IOP("xld", HSMHV_MOD_XLD, IF_REAL, "Lateral diffusion of S/D under the gate [m]"),
  IOP("xldld", HSMHV_MOD_XLDLD, IF_REAL, "Lateral diffusion of Drain under the gate [m]"),
  IOP("xwdld", HSMHV_MOD_XWDLD, IF_REAL, ""),
  IOP("lover", HSMHV_MOD_LOVER, IF_REAL, "Overlap length on source side [m], alias for lovers"),
  IOP("lovers", HSMHV_MOD_LOVERS, IF_REAL, "Overlap length on source side [m]"),
  IOP("rdov11", HSMHV_MOD_RDOV11, IF_REAL, "Dependence coeff. for overlap length"),
  IOP("rdov12", HSMHV_MOD_RDOV12, IF_REAL, "Dependence coeff. for overlap length"),
  IOP("rdov13", HSMHV_MOD_RDOV13, IF_REAL, "Dependence coeff. for overlap length"),
  IOP("rdslp1", HSMHV_MOD_RDSLP1, IF_REAL, "LDRIFT1 dependence of resistance for CORSRD=1,3"),
  IOP("rdict1", HSMHV_MOD_RDICT1, IF_REAL, "LDRIFT1 dependence of resistance for CORSRD=1,3"),
  IOP("rdslp2", HSMHV_MOD_RDSLP2, IF_REAL, "LDRIFT2 dependence of resistance for CORSRD=1,3"),
  IOP("rdict2", HSMHV_MOD_RDICT2, IF_REAL, "LDRIFT2 dependence of resistance for CORSRD=1,3"),
  IOP("loverld", HSMHV_MOD_LOVERLD, IF_REAL, "Overlap length on the drain side"), 
  IOP("ldrift1", HSMHV_MOD_LDRIFT1, IF_REAL, "Drift region length-1 on the drain side[m]"), 
  IOP("ldrift2", HSMHV_MOD_LDRIFT2, IF_REAL, "Drift region length-2 on the drain side[m]"), 
  IOP("ldrift1s", HSMHV_MOD_LDRIFT1S, IF_REAL, "Drift region length-1 on the source side[m]"), 
  IOP("ldrift2s", HSMHV_MOD_LDRIFT2S, IF_REAL, "Drift region length-2 on the source side[m]"), 
  IOP("subld1", HSMHV_MOD_SUBLD1, IF_REAL, "Impact-ionization current in the drift region [-]"),
  IOP("subld2", HSMHV_MOD_SUBLD2, IF_REAL, "Impact-ionization current in the drift region [m^{-1}*V^{3/2}]"),
  IOP("ddltmax", HSMHV_MOD_DDLTMAX, IF_REAL, ""), /* Vdseff */
  IOP("ddltslp", HSMHV_MOD_DDLTSLP, IF_REAL, ""), /* Vdseff */
  IOP("ddltict", HSMHV_MOD_DDLTICT, IF_REAL, ""), /* Vdseff */
  IOP("vfbover", HSMHV_MOD_VFBOVER, IF_REAL, ""),
  IOP("nover", HSMHV_MOD_NOVER, IF_REAL, ""),
  IOP("novers", HSMHV_MOD_NOVERS, IF_REAL, ""),
  IOP("xwd", HSMHV_MOD_XWD, IF_REAL, "Lateral diffusion along the width dir. [m]"),
  IOP("xwdc", HSMHV_MOD_XWDC, IF_REAL, "Lateral diffusion along the width dir. for capacitance [m]"),
  IOP("xl", HSMHV_MOD_XL, IF_REAL, "Gate length offset due to mask/etch effect [m]"),
  IOP("xw", HSMHV_MOD_XW, IF_REAL, "Gate width offset due to mask/etch effect [m]"),
  IOP("saref", HSMHV_MOD_SAREF, IF_REAL, "Reference distance from STI edge to Gate edge [m]"),
  IOP("sbref", HSMHV_MOD_SBREF, IF_REAL, "Reference distance from STI edge to Gate edge [m]"),
  IOP("ll", HSMHV_MOD_LL, IF_REAL, "Gate length parameter"),
  IOP("lld", HSMHV_MOD_LLD, IF_REAL, "Gate length parameter"),
  IOP("lln", HSMHV_MOD_LLN, IF_REAL, "Gate length parameter"),
  IOP("wl", HSMHV_MOD_WL, IF_REAL, "Gate width parameter"),
  IOP("wl1", HSMHV_MOD_WL1, IF_REAL, "Gate width parameter"),
  IOP("wl1p", HSMHV_MOD_WL1P, IF_REAL, "Gate width parameter"),
  IOP("wl2", HSMHV_MOD_WL2, IF_REAL, "Gate width parameter"),
  IOP("wl2p", HSMHV_MOD_WL2P, IF_REAL, "Gate width parameter"),
  IOP("wld", HSMHV_MOD_WLD, IF_REAL, "Gate width parameter"),
  IOP("wln", HSMHV_MOD_WLN, IF_REAL, "Gate width parameter"),
  IOP("xqy", HSMHV_MOD_XQY, IF_REAL, "[m]"),
  IOP("xqy1", HSMHV_MOD_XQY1, IF_REAL, "[F m^{XQY2}]"),
  IOP("xqy2", HSMHV_MOD_XQY2, IF_REAL, "[-]"),
  IOP("rs", HSMHV_MOD_RS, IF_REAL, "Source contact resistance [ohm m]"),
  IOP("rd", HSMHV_MOD_RD, IF_REAL, "Drain contact resistance  [ohm m]"),
  IOP("rsh", HSMHV_MOD_RSH, IF_REAL, "Source/drain diffusion sheet  resistance  [ohm]"),
  IOP("rshg", HSMHV_MOD_RSHG, IF_REAL, "Gate-elecrode sheet resistance"),
  IOP("vfbc", HSMHV_MOD_VFBC, IF_REAL, "Constant part of Vfb [V]"),
  IOP("vbi", HSMHV_MOD_VBI, IF_REAL, "Built-in potential [V]"),
  IOP("nsubc", HSMHV_MOD_NSUBC, IF_REAL, "Constant part of Nsub [1/cm^3]"),
  IOP("parl2", HSMHV_MOD_PARL2, IF_REAL, "Under diffusion [m]"),
  IOP("lp", HSMHV_MOD_LP, IF_REAL, "Length of pocket potential [m]"),
  IOP("nsubp", HSMHV_MOD_NSUBP, IF_REAL, "[1/cm^3]"),
  IOP("nsubp0", HSMHV_MOD_NSUBP0, IF_REAL, "Pocket implant parameter"),
  IOP("nsubwp", HSMHV_MOD_NSUBWP, IF_REAL, "Pocket implant parameter"),
  IOP("scp1", HSMHV_MOD_SCP1, IF_REAL, "Parameter for pocket [-]"),
  IOP("scp2", HSMHV_MOD_SCP2, IF_REAL, "Parameter for pocket [1/V]"),
  IOP("scp3", HSMHV_MOD_SCP3, IF_REAL, "Parameter for pocket [m/V]"),
  IOP("sc1", HSMHV_MOD_SC1, IF_REAL, "Parameter for SCE [-]"),
  IOP("sc2", HSMHV_MOD_SC2, IF_REAL, "Parameter for SCE [1/V]"),
  IOP("sc3", HSMHV_MOD_SC3, IF_REAL, "Parameter for SCE [m/V]"),
  IOP("sc4", HSMHV_MOD_SC4, IF_REAL, "Parameter for SCE [1/V]"), 
  IOP("pgd1", HSMHV_MOD_PGD1, IF_REAL, "Parameter for gate-poly depletion [V]"),
  IOP("pgd2", HSMHV_MOD_PGD2, IF_REAL, "Parameter for gate-poly depletion [V]"),
  IOP("pgd3", HSMHV_MOD_PGD3, IF_REAL, "Parameter for gate-poly depletion [-]"),
  IOP("pgd4", HSMHV_MOD_PGD4, IF_REAL, "Parameter for gate-poly depletion [-]"),
  IOP("ndep", HSMHV_MOD_NDEP, IF_REAL, "Coeff. of Qbm for Eeff [-]"),
  IOP("ndepl", HSMHV_MOD_NDEPL, IF_REAL, "Coeff. of Qbm for Eeff [-]"),
  IOP("ndeplp", HSMHV_MOD_NDEPLP, IF_REAL, "Coeff. of Qbm for Eeff [-]"),
  IOP("ninv", HSMHV_MOD_NINV, IF_REAL, "Coeff. of Qnm for Eeff [-]"),
  IOP("ninvd", HSMHV_MOD_NINVD, IF_REAL, "Modification of Vdse dependence on Eeff [1/V]"),
  IOP("ninvdw", HSMHV_MOD_NINVDW, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("ninvdwp", HSMHV_MOD_NINVDWP, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("ninvdt1", HSMHV_MOD_NINVDT1, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("ninvdt2", HSMHV_MOD_NINVDT2, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("muecb0", HSMHV_MOD_MUECB0, IF_REAL, "Const. part of coulomb scattering [cm^2/Vs]"),
  IOP("muecb1", HSMHV_MOD_MUECB1, IF_REAL, "Coeff. for coulomb scattering [cm^2/Vs]"),
  IOP("mueph0", HSMHV_MOD_MUEPH0, IF_REAL, "Power of Eeff for phonon scattering [-]"),
  IOP("mueph1", HSMHV_MOD_MUEPH1, IF_REAL, ""),
  IOP("muephw", HSMHV_MOD_MUEPHW, IF_REAL, ""),
  IOP("muepwp", HSMHV_MOD_MUEPWP, IF_REAL, "Phonon scattering parameter"),
  IOP("muephl", HSMHV_MOD_MUEPHL, IF_REAL, "Phonon scattering parameter"),
  IOP("mueplp", HSMHV_MOD_MUEPLP, IF_REAL, "Phonon scattering parameter"),
  IOP("muephs", HSMHV_MOD_MUEPHS, IF_REAL, ""),
  IOP("muepsp", HSMHV_MOD_MUEPSP, IF_REAL, ""),
  IOP("vtmp", HSMHV_MOD_VTMP, IF_REAL, ""),
  IOP("wvth0", HSMHV_MOD_WVTH0, IF_REAL, ""),
  IOP("muesr0", HSMHV_MOD_MUESR0, IF_REAL, "Power of Eeff for S.R. scattering [-]"),
  IOP("muesr1", HSMHV_MOD_MUESR1, IF_REAL, "Coeff. for S.R. scattering [-]"),
  IOP("muesrl", HSMHV_MOD_MUESRL, IF_REAL, "Surface roughness parameter"),
  IOP("muesrw", HSMHV_MOD_MUESRW, IF_REAL, "Change of surface roughness related mobility"),
  IOP("mueswp", HSMHV_MOD_MUESWP, IF_REAL, "Change of surface roughness related mobility"),
  IOP("mueslp", HSMHV_MOD_MUESLP, IF_REAL, "Surface roughness parameter"),
  IOP("muetmp", HSMHV_MOD_MUETMP, IF_REAL, "Parameter for mobility [-]"),
  IOP("bb", HSMHV_MOD_BB, IF_REAL, "Empirical mobility model coefficient [-]"),
  IOP("sub1", HSMHV_MOD_SUB1, IF_REAL, "Parameter for Isub [1/V]"),
  IOP("sub2", HSMHV_MOD_SUB2, IF_REAL, "Parameter for Isub [V]"),
  IOP("svgs", HSMHV_MOD_SVGS, IF_REAL, "Coefficient for Vg of Psislsat"),
  IOP("svbs", HSMHV_MOD_SVBS, IF_REAL, "Coefficient for Vbs of Psislsat"),
  IOP("svbsl", HSMHV_MOD_SVBSL, IF_REAL, " "),
  IOP("svds", HSMHV_MOD_SVDS, IF_REAL, " "),
  IOP("slg", HSMHV_MOD_SLG, IF_REAL, " "),
  IOP("sub1l", HSMHV_MOD_SUB1L, IF_REAL, " "),
  IOP("sub2l", HSMHV_MOD_SUB2L, IF_REAL, " "),
  IOP("fn1", HSMHV_MOD_FN1, IF_REAL, " "),
  IOP("fn2", HSMHV_MOD_FN2, IF_REAL, " "),
  IOP("fn3", HSMHV_MOD_FN3, IF_REAL, " "),
  IOP("fvbs", HSMHV_MOD_FVBS, IF_REAL, " "),
  IOP("svgsl", HSMHV_MOD_SVGSL, IF_REAL, " "),
  IOP("svgslp", HSMHV_MOD_SVGSLP, IF_REAL, " "),
  IOP("svgswp", HSMHV_MOD_SVGSWP, IF_REAL, " "),
  IOP("svgsw", HSMHV_MOD_SVGSW, IF_REAL, " "),
  IOP("svbslp", HSMHV_MOD_SVBSLP, IF_REAL, " "),
  IOP("slgl", HSMHV_MOD_SLGL, IF_REAL, " "),
  IOP("slglp", HSMHV_MOD_SLGLP, IF_REAL, " "),
  IOP("sub1lp", HSMHV_MOD_SUB1LP, IF_REAL, " "),
  IOP("nsti", HSMHV_MOD_NSTI, IF_REAL, "Parameter for STI [1/cm^3]"),
  IOP("wsti", HSMHV_MOD_WSTI, IF_REAL, "Parameter for STI [m]"),
  IOP("wstil", HSMHV_MOD_WSTIL, IF_REAL, "Parameter for STI [?]"),
  IOP("wstilp", HSMHV_MOD_WSTILP, IF_REAL, "Parameter for STI [?]"),
  IOP("wstiw", HSMHV_MOD_WSTIW, IF_REAL, "Parameter for STI [?]"),
  IOP("wstiwp", HSMHV_MOD_WSTIWP, IF_REAL, "Parameter for STI [?]"),
  IOP("scsti1", HSMHV_MOD_SCSTI1, IF_REAL, "Parameter for STI [-]"),
  IOP("scsti2", HSMHV_MOD_SCSTI2, IF_REAL, "Parameter for STI [1/V]"),
  IOP("vthsti", HSMHV_MOD_VTHSTI, IF_REAL, "Parameter for STI"),
  IOP("vdsti", HSMHV_MOD_VDSTI, IF_REAL, "Parameter for STI [-]"),
  IOP("muesti1", HSMHV_MOD_MUESTI1, IF_REAL, "STI Stress mobility parameter"),
  IOP("muesti2", HSMHV_MOD_MUESTI2, IF_REAL, "STI Stress mobility parameter"),
  IOP("muesti3", HSMHV_MOD_MUESTI3, IF_REAL, "STI Stress mobility parameter"),
  IOP("nsubpsti1", HSMHV_MOD_NSUBPSTI1, IF_REAL, "STI Stress pocket implant parameter"),
  IOP("nsubpsti2", HSMHV_MOD_NSUBPSTI2, IF_REAL, "STI Stress pocket implant parameter"),
  IOP("nsubpsti3", HSMHV_MOD_NSUBPSTI3, IF_REAL, "STI Stress pocket implant parameter"),
  IOP("lpext", HSMHV_MOD_LPEXT, IF_REAL, "Pocket extension"),
  IOP("npext", HSMHV_MOD_NPEXT, IF_REAL, "Pocket extension"),
  IOP("scp22", HSMHV_MOD_SCP22, IF_REAL, ""),
  IOP("scp21", HSMHV_MOD_SCP21, IF_REAL, ""),
  IOP("bs1", HSMHV_MOD_BS1, IF_REAL, ""),
  IOP("bs2", HSMHV_MOD_BS2, IF_REAL, ""),
  IOP("cgso", HSMHV_MOD_CGSO, IF_REAL, "G-S overlap capacitance per unit W [F/m]"),
  IOP("cgdo", HSMHV_MOD_CGDO, IF_REAL, "G-D overlap capacitance per unit W [F/m]"),
  IOP("cgbo", HSMHV_MOD_CGBO, IF_REAL, "G-B overlap capacitance per unit L [F/m]"),
  IOP("tpoly", HSMHV_MOD_TPOLY, IF_REAL, "Height of poly gate on the source side[m]"),
  IOP("js0", HSMHV_MOD_JS0, IF_REAL, "Saturation current density [A/m^2]"),
  IOP("js0sw", HSMHV_MOD_JS0SW, IF_REAL, "Side wall saturation current density [A/m]"),
  IOP("nj", HSMHV_MOD_NJ, IF_REAL, "Emission coefficient [-]"),
  IOP("njsw", HSMHV_MOD_NJSW, IF_REAL, "Sidewall emission coefficient"),
  IOP("xti", HSMHV_MOD_XTI, IF_REAL, "Junction current temparature exponent coefficient [-]"),
  IOP("cj", HSMHV_MOD_CJ, IF_REAL, "Bottom junction capacitance per unit area at zero bias [F/m^2]"),
  IOP("cjsw", HSMHV_MOD_CJSW, IF_REAL, "Source/drain sidewall junction capacitance grading coefficient per unit length at zero bias [F/m]"),
  IOP("cjswg", HSMHV_MOD_CJSWG, IF_REAL, "Source/drain gate sidewall junction capacitance per unit length at zero bias [F/m]"),
  IOP("mj", HSMHV_MOD_MJ, IF_REAL, "Bottom junction capacitance grading coefficient"),
  IOP("mjsw", HSMHV_MOD_MJSW, IF_REAL, "Source/drain sidewall junction capacitance grading coefficient"),
  IOP("mjswg", HSMHV_MOD_MJSWG, IF_REAL, "Source/drain gate sidewall junction capacitance grading coefficient"),
  IOP("pb", HSMHV_MOD_PB, IF_REAL, "Bottom junction build-in potential  [V]"),
  IOP("pbsw", HSMHV_MOD_PBSW, IF_REAL, "Source/drain sidewall junction build-in potential [V]"),
  IOP("pbswg", HSMHV_MOD_PBSWG, IF_REAL, "Source/drain gate sidewall junction build-in potential [V]"),

  IOP("xti2", HSMHV_MOD_XTI2, IF_REAL, "Temperature coefficient [-]"),
  IOP("cisb", HSMHV_MOD_CISB, IF_REAL, "Reverse bias saturation current [-]"),
  IOP("cvb", HSMHV_MOD_CVB, IF_REAL, "Bias dependence coefficient of cisb [-]"),
  IOP("ctemp", HSMHV_MOD_CTEMP, IF_REAL, "Temperature coefficient [-]"),
  IOP("cisbk", HSMHV_MOD_CISBK, IF_REAL, "Reverse bias saturation current [A]"),
  IOP("cvbk", HSMHV_MOD_CVBK, IF_REAL, "Bias dependence coefficient of cisb [-]"),
  IOP("divx", HSMHV_MOD_DIVX, IF_REAL, "  [1/V]"),

  IOP("clm1", HSMHV_MOD_CLM1, IF_REAL, "Parameter for CLM [-]"),
  IOP("clm2", HSMHV_MOD_CLM2, IF_REAL, "Parameter for CLM [1/m]"),
  IOP("clm3", HSMHV_MOD_CLM3, IF_REAL, "Parameter for CLM [-]"),
  IOP("clm5", HSMHV_MOD_CLM5, IF_REAL, "Parameter for CLM [-]"),
  IOP("clm6", HSMHV_MOD_CLM6, IF_REAL, "Parameter for CLM [um^{-clm5}]"),
  IOP("vover", HSMHV_MOD_VOVER, IF_REAL, "Parameter for overshoot [m^{voverp}]"),
  IOP("voverp", HSMHV_MOD_VOVERP, IF_REAL, "Parameter for overshoot [-]"),
  IOP("vovers", HSMHV_MOD_VOVERS, IF_REAL, "Parameter for overshoot [-]"),
  IOP("voversp", HSMHV_MOD_VOVERSP, IF_REAL, "Parameter for overshoot [-]"),

  IOP("wfc", HSMHV_MOD_WFC, IF_REAL, "Parameter for narrow channel effect [m*F/(cm^2)]"),
  IOP("nsubcw", HSMHV_MOD_NSUBCW, IF_REAL, "Parameter for narrow channel effect "),
  IOP("nsubcwp", HSMHV_MOD_NSUBCWP, IF_REAL, "Parameter for narrow channel effect "),
  IOP("qme1", HSMHV_MOD_QME1, IF_REAL, "Parameter for quantum effect [mV]"),
  IOP("qme2", HSMHV_MOD_QME2, IF_REAL, "Parameter for quantum effect [V]"),
  IOP("qme3", HSMHV_MOD_QME3, IF_REAL, "Parameter for quantum effect [m]"),
  IOP("gidl1", HSMHV_MOD_GIDL1, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl2", HSMHV_MOD_GIDL2, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl3", HSMHV_MOD_GIDL3, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl4", HSMHV_MOD_GIDL4, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl5", HSMHV_MOD_GIDL5, IF_REAL, "Parameter for GIDL [?]"),
  IOP("glpart1", HSMHV_MOD_GLPART1, IF_REAL, "Parameter for gate current [-]"),
  IOP("gleak1", HSMHV_MOD_GLEAK1, IF_REAL, "Parameter for gate current [A*V^(-3/2)/C]"),
  IOP("gleak2", HSMHV_MOD_GLEAK2, IF_REAL, "Parameter for gate current [V^(-1/2)/m ]"),
  IOP("gleak3", HSMHV_MOD_GLEAK3, IF_REAL, "Parameter for gate current [-]"),
  IOP("gleak4", HSMHV_MOD_GLEAK4, IF_REAL, "Parameter for gate current [1/m]"),
  IOP("gleak5", HSMHV_MOD_GLEAK5, IF_REAL, "Parameter for gate current [V/m]"),
  IOP("gleak6", HSMHV_MOD_GLEAK6, IF_REAL, "Parameter for gate current [V]"),
  IOP("gleak7", HSMHV_MOD_GLEAK7, IF_REAL, "Parameter for gate current [m^2]"),
  IOP("glksd1", HSMHV_MOD_GLKSD1, IF_REAL, "Parameter for gate current [A*m/V^2]"),
  IOP("glksd2", HSMHV_MOD_GLKSD2, IF_REAL, "Parameter for gate current [1/(V*m)]"),
  IOP("glksd3", HSMHV_MOD_GLKSD3, IF_REAL, "Parameter for gate current [1/m]"),
  IOP("glkb1", HSMHV_MOD_GLKB1, IF_REAL, "Parameter for gate current [A/V^2]"),
  IOP("glkb2", HSMHV_MOD_GLKB2, IF_REAL, "Parameter for gate current [m/V]"),
  IOP("glkb3", HSMHV_MOD_GLKB3, IF_REAL, "Parameter for gate current [V]"),
  IOP("egig", HSMHV_MOD_EGIG, IF_REAL, "Parameter for gate current [V]"),
  IOP("igtemp2", HSMHV_MOD_IGTEMP2, IF_REAL, "Parameter for gate current [V*k]"),
  IOP("igtemp3", HSMHV_MOD_IGTEMP3, IF_REAL, "Parameter for gate current [V*k^2]"),
  IOP("vzadd0", HSMHV_MOD_VZADD0, IF_REAL, "Vzadd at Vds=0  [V]"),
  IOP("pzadd0", HSMHV_MOD_PZADD0, IF_REAL, "Pzadd at Vds=0  [V]"),
  IOP("nftrp", HSMHV_MOD_NFTRP, IF_REAL, ""),
  IOP("nfalp", HSMHV_MOD_NFALP, IF_REAL, ""),
  IOP("cit", HSMHV_MOD_CIT, IF_REAL, ""),
  IOP("falph", HSMHV_MOD_FALPH, IF_REAL, "Parameter for 1/f noise"),
  IOP("kappa", HSMHV_MOD_KAPPA, IF_REAL, "Dielectric constant for high-k stacked gate"),
  IOP("pthrou", HSMHV_MOD_PTHROU, IF_REAL, "Modify subthreshold slope [-]"),
  IOP("vdiffj", HSMHV_MOD_VDIFFJ, IF_REAL, "Threshold voltage for S/D junction diode [V]"),
  IOP("dly1", HSMHV_MOD_DLY1, IF_REAL, "Parameter for transit time [-]"),
  IOP("dly2", HSMHV_MOD_DLY2, IF_REAL, "Parameter for transit time [-]"),
  IOP("dly3", HSMHV_MOD_DLY3, IF_REAL, "Parameter for transforming bulk charge [s/F]"),
  IOP("dlyov", HSMHV_MOD_DLYOV, IF_REAL, "Parameter for transforming overlap charge [s/F]"),  /* not used */
  IOP("tnom", HSMHV_MOD_TNOM, IF_REAL, "Nominal temperature [K]"),
  IOP("ovslp", HSMHV_MOD_OVSLP, IF_REAL, ""),
  IOP("ovmag", HSMHV_MOD_OVMAG, IF_REAL, ""),

  IOP("gbmin", HSMHV_MOD_GBMIN, IF_REAL, ""),
  IOP("rbpb", HSMHV_MOD_RBPB, IF_REAL, ""),
  IOP("rbpd", HSMHV_MOD_RBPD, IF_REAL, ""),  /* not used */
  IOP("rbps", HSMHV_MOD_RBPS, IF_REAL, ""),  /* not used */
  IOP("rbdb", HSMHV_MOD_RBDB, IF_REAL, ""),
  IOP("rbsb", HSMHV_MOD_RBSB, IF_REAL, ""),

  IOP("ibpc1", HSMHV_MOD_IBPC1, IF_REAL, "Parameter for impact-ionization induced bulk potential change"),
  IOP("ibpc2", HSMHV_MOD_IBPC2, IF_REAL, "Parameter for impact-ionization induced bulk potential change"),

  IOP("mphdfm", HSMHV_MOD_MPHDFM, IF_REAL, "NSUBCDFM dependence of phonon scattering for DFM"),

  IOP("rdvg11", HSMHV_MOD_RDVG11, IF_REAL, ""), 
  IOP("rdvg12", HSMHV_MOD_RDVG12, IF_REAL, ""), 
  IOP("rth0", HSMHV_MOD_RTH0, IF_REAL, "Thermal resistance"), /* Self-heating model --SHE---*/
  IOP("cth0", HSMHV_MOD_CTH0, IF_REAL, "Thermal capacitance"), /* Self-heating model --SHE--- */
  IOP("powrat", HSMHV_MOD_POWRAT, IF_REAL, ""), /* Self-heating model --SHE--- */

  IOP("rthtemp1", HSMHV_MOD_RTHTEMP1, IF_REAL, "Thermal resistance"), /* Self-heating model --SHE---*/
  IOP("rthtemp2", HSMHV_MOD_RTHTEMP2, IF_REAL, "Thermal resistance"), /* Self-heating model --SHE---*/
  IOP("prattemp1", HSMHV_MOD_PRATTEMP1, IF_REAL, ""), /* Self-heating model --SHE--- */
  IOP("prattemp2", HSMHV_MOD_PRATTEMP2, IF_REAL, ""), /* Self-heating model --SHE--- */

  IOP("tcjbd", HSMHV_MOD_TCJBD, IF_REAL, "Temperature dependence of cjbd"), /* Self-heating model --SHE--- */
  IOP("tcjbs", HSMHV_MOD_TCJBS, IF_REAL, "Temperature dependence of cjbs"), /* Self-heating model --SHE--- */
  IOP("tcjbdsw", HSMHV_MOD_TCJBDSW, IF_REAL, "Temperature dependence of cjbdsw"), /* Self-heating model --SHE--- */
  IOP("tcjbssw", HSMHV_MOD_TCJBSSW, IF_REAL, "Temperature dependence of cjbssw"), /* Self-heating model --SHE--- */
  IOP("tcjbdswg", HSMHV_MOD_TCJBDSWG, IF_REAL, "Temperature dependence of cjbdswg"), /* Self-heating model --SHE--- */
  IOP("tcjbsswg", HSMHV_MOD_TCJBSSWG, IF_REAL, "Temperature dependence of cjbsswg"), /* Self-heating model --SHE--- */

  IOP("qdftvd", HSMHV_MOD_QDFTVD, IF_REAL, "Qdrift Vd dependence "),
  IOP("rdvd", HSMHV_MOD_RDVD, IF_REAL, ""), 
  IOP("rdvb", HSMHV_MOD_RDVB, IF_REAL, ""), 
  IOP("rd20", HSMHV_MOD_RD20, IF_REAL, ""), 
  IOP("rd21", HSMHV_MOD_RD21, IF_REAL, ""), 
  IOP("rd22", HSMHV_MOD_RD22, IF_REAL, ""), 
  IOP("rd22d", HSMHV_MOD_RD22D, IF_REAL, ""), 
  IOP("rd23", HSMHV_MOD_RD23, IF_REAL, ""), 
  IOP("rd24", HSMHV_MOD_RD24, IF_REAL, ""), 
  IOP("rd25", HSMHV_MOD_RD25, IF_REAL, ""), 
  IOP("rd26", HSMHV_MOD_RD26, IF_REAL, "alias for qovsm"), 
  IOP("rdvdl", HSMHV_MOD_RDVDL, IF_REAL, ""), 
  IOP("rdvdlp", HSMHV_MOD_RDVDLP, IF_REAL, ""), 
  IOP("rdvds", HSMHV_MOD_RDVDS, IF_REAL, ""), 
  IOP("rdvdsp", HSMHV_MOD_RDVDSP, IF_REAL, ""), 
  IOP("rd23l", HSMHV_MOD_RD23L, IF_REAL, ""), 
  IOP("rd23lp", HSMHV_MOD_RD23LP, IF_REAL, ""), 
  IOP("rd23s", HSMHV_MOD_RD23S, IF_REAL, ""), 
  IOP("rd23sp", HSMHV_MOD_RD23SP, IF_REAL, ""), 
  IOP("rds", HSMHV_MOD_RDS, IF_REAL, ""), 
  IOP("rdsp", HSMHV_MOD_RDSP, IF_REAL, ""), 
  IOP("qovsm", HSMHV_MOD_QOVSM, IF_REAL, "Smoothing Qover at depletion/inversion transition"), 
  IOP("ldrift", HSMHV_MOD_LDRIFT, IF_REAL, "alias for ldrift2"),
  IOP("rdtemp1", HSMHV_MOD_RDTEMP1, IF_REAL, "Temperature-dependence of Rd"), 
  IOP("rdtemp2", HSMHV_MOD_RDTEMP2, IF_REAL, "Temperature-dependence of Rd"), 
  IOP("rth0r", HSMHV_MOD_RTH0R, IF_REAL, "Heat radiation for SHE"),   /* not used */
  IOP("rdvdtemp1", HSMHV_MOD_RDVDTEMP1, IF_REAL, "Temperature-dependence of RDVD"), 
  IOP("rdvdtemp2", HSMHV_MOD_RDVDTEMP2, IF_REAL, "Temperature-dependence of RDVD"), 
  IOP("rth0w", HSMHV_MOD_RTH0W, IF_REAL, "Width-dependence of RTH0"), 
  IOP("rth0wp", HSMHV_MOD_RTH0WP, IF_REAL, "Width-dependence of RTH0"), 
  IOP("rth0nf", HSMHV_MOD_RTH0NF, IF_REAL, "nf-dependence of RTH0"), 
  IOP("cvdsover", HSMHV_MOD_CVDSOVER, IF_REAL, "vds drop along the overlap"), 

  IOP("rdvsub", HSMHV_MOD_RDVSUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("rdvdsub", HSMHV_MOD_RDVDSUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("ddrift", HSMHV_MOD_DDRIFT, IF_REAL, "model parameter for the substrate effect"),
  IOP("vbisub", HSMHV_MOD_VBISUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("nsubsub", HSMHV_MOD_NSUBSUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("shemax",  HSMHV_MOD_SHEMAX, IF_REAL,  "Maximum rise temperatue for SHE [C]"),

  /* binning parameters */
  IOP("lmin", HSMHV_MOD_LMIN, IF_REAL, "Minimum length for the model"),
  IOP("lmax", HSMHV_MOD_LMAX, IF_REAL, "Maximum length for the model"),
  IOP("wmin", HSMHV_MOD_WMIN, IF_REAL, "Minimum width for the model"),
  IOP("wmax", HSMHV_MOD_WMAX, IF_REAL, "Maximum width for the model"),
  IOP("lbinn", HSMHV_MOD_LBINN, IF_REAL, "L modulation coefficient for binning"),
  IOP("wbinn", HSMHV_MOD_WBINN, IF_REAL, "W modulation coefficient for binning"),

  /* Length dependence */
  IOP("lvmax", HSMHV_MOD_LVMAX, IF_REAL, "Length dependence of vmax"),
  IOP("lbgtmp1", HSMHV_MOD_LBGTMP1, IF_REAL, "Length dependence of bgtmp1"),
  IOP("lbgtmp2", HSMHV_MOD_LBGTMP2, IF_REAL, "Length dependence of bgtmp2"),
  IOP("leg0", HSMHV_MOD_LEG0, IF_REAL, "Length dependence of eg0"),
  IOP("lvfbover", HSMHV_MOD_LVFBOVER, IF_REAL, "Length dependence of vfbover"),
  IOP("lnover", HSMHV_MOD_LNOVER, IF_REAL, "Length dependence of nover"),
  IOP("lnovers", HSMHV_MOD_LNOVERS, IF_REAL, "Length dependence of nover on source size"),
  IOP("lwl2", HSMHV_MOD_LWL2, IF_REAL, "Length dependence of wl2"),
  IOP("lvfbc", HSMHV_MOD_LVFBC, IF_REAL, "Length dependence of vfbc"),
  IOP("lnsubc", HSMHV_MOD_LNSUBC, IF_REAL, "Length dependence of nsubc"),
  IOP("lnsubp", HSMHV_MOD_LNSUBP, IF_REAL, "Length dependence of nsubp"),
  IOP("lscp1", HSMHV_MOD_LSCP1, IF_REAL, "Length dependence of scp1"),
  IOP("lscp2", HSMHV_MOD_LSCP2, IF_REAL, "Length dependence of scp2"),
  IOP("lscp3", HSMHV_MOD_LSCP3, IF_REAL, "Length dependence of scp3"),
  IOP("lsc1", HSMHV_MOD_LSC1, IF_REAL, "Length dependence of sc1"),
  IOP("lsc2", HSMHV_MOD_LSC2, IF_REAL, "Length dependence of sc2"),
  IOP("lsc3", HSMHV_MOD_LSC3, IF_REAL, "Length dependence of sc3"),
  IOP("lpgd1", HSMHV_MOD_LPGD1, IF_REAL, "Length dependence of pgd1"),
  IOP("lpgd3", HSMHV_MOD_LPGD3, IF_REAL, "Length dependence of pgd3"),
  IOP("lndep", HSMHV_MOD_LNDEP, IF_REAL, "Length dependence of ndep"),
  IOP("lninv", HSMHV_MOD_LNINV, IF_REAL, "Length dependence of ninv"),
  IOP("lmuecb0", HSMHV_MOD_LMUECB0, IF_REAL, "Length dependence of muecb0"),
  IOP("lmuecb1", HSMHV_MOD_LMUECB1, IF_REAL, "Length dependence of muecb1"),
  IOP("lmueph1", HSMHV_MOD_LMUEPH1, IF_REAL, "Length dependence of mueph1"),
  IOP("lvtmp", HSMHV_MOD_LVTMP, IF_REAL, "Length dependence of vtmp"),
  IOP("lwvth0", HSMHV_MOD_LWVTH0, IF_REAL, "Length dependence of wvth0"),
  IOP("lmuesr1", HSMHV_MOD_LMUESR1, IF_REAL, "Length dependence of muesr1"),
  IOP("lmuetmp", HSMHV_MOD_LMUETMP, IF_REAL, "Length dependence of muetmp"),
  IOP("lsub1", HSMHV_MOD_LSUB1, IF_REAL, "Length dependence of sub1"),
  IOP("lsub2", HSMHV_MOD_LSUB2, IF_REAL, "Length dependence of sub2"),
  IOP("lsvds", HSMHV_MOD_LSVDS, IF_REAL, "Length dependence of svds"),
  IOP("lsvbs", HSMHV_MOD_LSVBS, IF_REAL, "Length dependence of svbs"),
  IOP("lsvgs", HSMHV_MOD_LSVGS, IF_REAL, "Length dependence of svgs"),
  IOP("lfn1", HSMHV_MOD_LFN1, IF_REAL, "Length dependence of fn1"),
  IOP("lfn2", HSMHV_MOD_LFN2, IF_REAL, "Length dependence of fn2"),
  IOP("lfn3", HSMHV_MOD_LFN3, IF_REAL, "Length dependence of fn3"),
  IOP("lfvbs", HSMHV_MOD_LFVBS, IF_REAL, "Length dependence of fvbs"),
  IOP("lnsti", HSMHV_MOD_LNSTI, IF_REAL, "Length dependence of nsti"),
  IOP("lwsti", HSMHV_MOD_LWSTI, IF_REAL, "Length dependence of wsti"),
  IOP("lscsti1", HSMHV_MOD_LSCSTI1, IF_REAL, "Length dependence of scsti1"),
  IOP("lscsti2", HSMHV_MOD_LSCSTI2, IF_REAL, "Length dependence of scsti2"),
  IOP("lvthsti", HSMHV_MOD_LVTHSTI, IF_REAL, "Length dependence of vthsti"),
  IOP("lmuesti1", HSMHV_MOD_LMUESTI1, IF_REAL, "Length dependence of muesti1"),
  IOP("lmuesti2", HSMHV_MOD_LMUESTI2, IF_REAL, "Length dependence of muesti2"),
  IOP("lmuesti3", HSMHV_MOD_LMUESTI3, IF_REAL, "Length dependence of muesti3"),
  IOP("lnsubpsti1", HSMHV_MOD_LNSUBPSTI1, IF_REAL, "Length dependence of nsubpsti1"),
  IOP("lnsubpsti2", HSMHV_MOD_LNSUBPSTI2, IF_REAL, "Length dependence of nsubpsti2"),
  IOP("lnsubpsti3", HSMHV_MOD_LNSUBPSTI3, IF_REAL, "Length dependence of nsubpsti3"),
  IOP("lcgso", HSMHV_MOD_LCGSO, IF_REAL, "Length dependence of cgso"),
  IOP("lcgdo", HSMHV_MOD_LCGDO, IF_REAL, "Length dependence of cgdo"),
  IOP("ljs0", HSMHV_MOD_LJS0, IF_REAL, "Length dependence of js0"),
  IOP("ljs0sw", HSMHV_MOD_LJS0SW, IF_REAL, "Length dependence of js0sw"),
  IOP("lnj", HSMHV_MOD_LNJ, IF_REAL, "Length dependence of nj"),
  IOP("lcisbk", HSMHV_MOD_LCISBK, IF_REAL, "Length dependence of cisbk"),
  IOP("lclm1", HSMHV_MOD_LCLM1, IF_REAL, "Length dependence of clm1"),
  IOP("lclm2", HSMHV_MOD_LCLM2, IF_REAL, "Length dependence of clm2"),
  IOP("lclm3", HSMHV_MOD_LCLM3, IF_REAL, "Length dependence of clm3"),
  IOP("lwfc", HSMHV_MOD_LWFC, IF_REAL, "Length dependence of wfc"),
  IOP("lgidl1", HSMHV_MOD_LGIDL1, IF_REAL, "Length dependence of gidl1"),
  IOP("lgidl2", HSMHV_MOD_LGIDL2, IF_REAL, "Length dependence of gidl2"),
  IOP("lgleak1", HSMHV_MOD_LGLEAK1, IF_REAL, "Length dependence of gleak1"),
  IOP("lgleak2", HSMHV_MOD_LGLEAK2, IF_REAL, "Length dependence of gleak2"),
  IOP("lgleak3", HSMHV_MOD_LGLEAK3, IF_REAL, "Length dependence of gleak3"),
  IOP("lgleak6", HSMHV_MOD_LGLEAK6, IF_REAL, "Length dependence of gleak6"),
  IOP("lglksd1", HSMHV_MOD_LGLKSD1, IF_REAL, "Length dependence of glksd1"),
  IOP("lglksd2", HSMHV_MOD_LGLKSD2, IF_REAL, "Length dependence of glksd2"),
  IOP("lglkb1", HSMHV_MOD_LGLKB1, IF_REAL, "Length dependence of glkb1"),
  IOP("lglkb2", HSMHV_MOD_LGLKB2, IF_REAL, "Length dependence of glkb2"),
  IOP("lnftrp", HSMHV_MOD_LNFTRP, IF_REAL, "Length dependence of nftrp"),
  IOP("lnfalp", HSMHV_MOD_LNFALP, IF_REAL, "Length dependence of nfalp"),
  IOP("lpthrou", HSMHV_MOD_LPTHROU, IF_REAL, "Length dependence of pthrou"),
  IOP("lvdiffj", HSMHV_MOD_LVDIFFJ, IF_REAL, "Length dependence of vdiffj"),
  IOP("libpc1", HSMHV_MOD_LIBPC1, IF_REAL, "Length dependence of ibpc1"),
  IOP("libpc2", HSMHV_MOD_LIBPC2, IF_REAL, "Length dependence of ibpc2"),
  IOP("lcgbo", HSMHV_MOD_LCGBO, IF_REAL, "Length dependence of cgbo"),
  IOP("lcvdsover", HSMHV_MOD_LCVDSOVER, IF_REAL, "Length dependence of cvdsover"),
  IOP("lfalph", HSMHV_MOD_LFALPH, IF_REAL, "Length dependence of falph"),
  IOP("lnpext", HSMHV_MOD_LNPEXT, IF_REAL, "Length dependence of npext"),
  IOP("lpowrat", HSMHV_MOD_LPOWRAT, IF_REAL, "Length dependence of powrat"),
  IOP("lrd", HSMHV_MOD_LRD, IF_REAL, "Length dependence of rd"),
  IOP("lrd22", HSMHV_MOD_LRD22, IF_REAL, "Length dependence of rd22"),
  IOP("lrd23", HSMHV_MOD_LRD23, IF_REAL, "Length dependence of rd23"),
  IOP("lrd24", HSMHV_MOD_LRD24, IF_REAL, "Length dependence of rd24"),
  IOP("lrdict1", HSMHV_MOD_LRDICT1, IF_REAL, "Length dependence of rdict1"),
  IOP("lrdov13", HSMHV_MOD_LRDOV13, IF_REAL, "Length dependence of rdov13"),
  IOP("lrdslp1", HSMHV_MOD_LRDSLP1, IF_REAL, "Length dependence of rdslp1"),
  IOP("lrdvb", HSMHV_MOD_LRDVB, IF_REAL, "Length dependence of rdvb"),
  IOP("lrdvd", HSMHV_MOD_LRDVD, IF_REAL, "Length dependence of rdvd"),
  IOP("lrdvg11", HSMHV_MOD_LRDVG11, IF_REAL, "Length dependence of rdvg11"),
  IOP("lrs", HSMHV_MOD_LRS, IF_REAL, "Length dependence of rs"),
  IOP("lrth0", HSMHV_MOD_LRTH0, IF_REAL, "Length dependence of rth0"),
  IOP("lvover", HSMHV_MOD_LVOVER, IF_REAL, "Length dependence of vover"),

  /* Width dependence */
  IOP("wvmax", HSMHV_MOD_WVMAX, IF_REAL, "Width dependence of vmax"),
  IOP("wbgtmp1", HSMHV_MOD_WBGTMP1, IF_REAL, "Width dependence of bgtmp1"),
  IOP("wbgtmp2", HSMHV_MOD_WBGTMP2, IF_REAL, "Width dependence of bgtmp2"),
  IOP("weg0", HSMHV_MOD_WEG0, IF_REAL, "Width dependence of eg0"),
  IOP("wvfbover", HSMHV_MOD_WVFBOVER, IF_REAL, "Width dependence of vfbover"),
  IOP("wnover", HSMHV_MOD_WNOVER, IF_REAL, "Width dependence of nover"),
  IOP("wnovers", HSMHV_MOD_WNOVERS, IF_REAL, "Width dependence of novers on source size"),
  IOP("wwl2", HSMHV_MOD_WWL2, IF_REAL, "Width dependence of wl2"),
  IOP("wvfbc", HSMHV_MOD_WVFBC, IF_REAL, "Width dependence of vfbc"),
  IOP("wnsubc", HSMHV_MOD_WNSUBC, IF_REAL, "Width dependence of nsubc"),
  IOP("wnsubp", HSMHV_MOD_WNSUBP, IF_REAL, "Width dependence of nsubp"),
  IOP("wscp1", HSMHV_MOD_WSCP1, IF_REAL, "Width dependence of scp1"),
  IOP("wscp2", HSMHV_MOD_WSCP2, IF_REAL, "Width dependence of scp2"),
  IOP("wscp3", HSMHV_MOD_WSCP3, IF_REAL, "Width dependence of scp3"),
  IOP("wsc1", HSMHV_MOD_WSC1, IF_REAL, "Width dependence of sc1"),
  IOP("wsc2", HSMHV_MOD_WSC2, IF_REAL, "Width dependence of sc2"),
  IOP("wsc3", HSMHV_MOD_WSC3, IF_REAL, "Width dependence of sc3"),
  IOP("wpgd1", HSMHV_MOD_WPGD1, IF_REAL, "Width dependence of pgd1"),
  IOP("wpgd3", HSMHV_MOD_WPGD3, IF_REAL, "Width dependence of pgd3"),
  IOP("wndep", HSMHV_MOD_WNDEP, IF_REAL, "Width dependence of ndep"),
  IOP("wninv", HSMHV_MOD_WNINV, IF_REAL, "Width dependence of ninv"),
  IOP("wmuecb0", HSMHV_MOD_WMUECB0, IF_REAL, "Width dependence of muecb0"),
  IOP("wmuecb1", HSMHV_MOD_WMUECB1, IF_REAL, "Width dependence of muecb1"),
  IOP("wmueph1", HSMHV_MOD_WMUEPH1, IF_REAL, "Width dependence of mueph1"),
  IOP("wvtmp", HSMHV_MOD_WVTMP, IF_REAL, "Width dependence of vtmp"),
  IOP("wwvth0", HSMHV_MOD_WWVTH0, IF_REAL, "Width dependence of wvth0"),
  IOP("wmuesr1", HSMHV_MOD_WMUESR1, IF_REAL, "Width dependence of muesr1"),
  IOP("wmuetmp", HSMHV_MOD_WMUETMP, IF_REAL, "Width dependence of muetmp"),
  IOP("wsub1", HSMHV_MOD_WSUB1, IF_REAL, "Width dependence of sub1"),
  IOP("wsub2", HSMHV_MOD_WSUB2, IF_REAL, "Width dependence of sub2"),
  IOP("wsvds", HSMHV_MOD_WSVDS, IF_REAL, "Width dependence of svds"),
  IOP("wsvbs", HSMHV_MOD_WSVBS, IF_REAL, "Width dependence of svbs"),
  IOP("wsvgs", HSMHV_MOD_WSVGS, IF_REAL, "Width dependence of svgs"),
  IOP("wfn1", HSMHV_MOD_WFN1, IF_REAL, "Width dependence of fn1"),
  IOP("wfn2", HSMHV_MOD_WFN2, IF_REAL, "Width dependence of fn2"),
  IOP("wfn3", HSMHV_MOD_WFN3, IF_REAL, "Width dependence of fn3"),
  IOP("wfvbs", HSMHV_MOD_WFVBS, IF_REAL, "Width dependence of fvbs"),
  IOP("wnsti", HSMHV_MOD_WNSTI, IF_REAL, "Width dependence of nsti"),
  IOP("wwsti", HSMHV_MOD_WWSTI, IF_REAL, "Width dependence of wsti"),
  IOP("wscsti1", HSMHV_MOD_WSCSTI1, IF_REAL, "Width dependence of scsti1"),
  IOP("wscsti2", HSMHV_MOD_WSCSTI2, IF_REAL, "Width dependence of scsti2"),
  IOP("wvthsti", HSMHV_MOD_WVTHSTI, IF_REAL, "Width dependence of vthsti"),
  IOP("wmuesti1", HSMHV_MOD_WMUESTI1, IF_REAL, "Width dependence of muesti1"),
  IOP("wmuesti2", HSMHV_MOD_WMUESTI2, IF_REAL, "Width dependence of muesti2"),
  IOP("wmuesti3", HSMHV_MOD_WMUESTI3, IF_REAL, "Width dependence of muesti3"),
  IOP("wnsubpsti1", HSMHV_MOD_WNSUBPSTI1, IF_REAL, "Width dependence of nsubpsti1"),
  IOP("wnsubpsti2", HSMHV_MOD_WNSUBPSTI2, IF_REAL, "Width dependence of nsubpsti2"),
  IOP("wnsubpsti3", HSMHV_MOD_WNSUBPSTI3, IF_REAL, "Width dependence of nsubpsti3"),
  IOP("wcgso", HSMHV_MOD_WCGSO, IF_REAL, "Width dependence of cgso"),
  IOP("wcgdo", HSMHV_MOD_WCGDO, IF_REAL, "Width dependence of cgdo"),
  IOP("wjs0", HSMHV_MOD_WJS0, IF_REAL, "Width dependence of js0"),
  IOP("wjs0sw", HSMHV_MOD_WJS0SW, IF_REAL, "Width dependence of js0sw"),
  IOP("wnj", HSMHV_MOD_WNJ, IF_REAL, "Width dependence of nj"),
  IOP("wcisbk", HSMHV_MOD_WCISBK, IF_REAL, "Width dependence of cisbk"),
  IOP("wclm1", HSMHV_MOD_WCLM1, IF_REAL, "Width dependence of clm1"),
  IOP("wclm2", HSMHV_MOD_WCLM2, IF_REAL, "Width dependence of clm2"),
  IOP("wclm3", HSMHV_MOD_WCLM3, IF_REAL, "Width dependence of clm3"),
  IOP("wwfc", HSMHV_MOD_WWFC, IF_REAL, "Width dependence of wfc"),
  IOP("wgidl1", HSMHV_MOD_WGIDL1, IF_REAL, "Width dependence of gidl1"),
  IOP("wgidl2", HSMHV_MOD_WGIDL2, IF_REAL, "Width dependence of gidl2"),
  IOP("wgleak1", HSMHV_MOD_WGLEAK1, IF_REAL, "Width dependence of gleak1"),
  IOP("wgleak2", HSMHV_MOD_WGLEAK2, IF_REAL, "Width dependence of gleak2"),
  IOP("wgleak3", HSMHV_MOD_WGLEAK3, IF_REAL, "Width dependence of gleak3"),
  IOP("wgleak6", HSMHV_MOD_WGLEAK6, IF_REAL, "Width dependence of gleak6"),
  IOP("wglksd1", HSMHV_MOD_WGLKSD1, IF_REAL, "Width dependence of glksd1"),
  IOP("wglksd2", HSMHV_MOD_WGLKSD2, IF_REAL, "Width dependence of glksd2"),
  IOP("wglkb1", HSMHV_MOD_WGLKB1, IF_REAL, "Width dependence of glkb1"),
  IOP("wglkb2", HSMHV_MOD_WGLKB2, IF_REAL, "Width dependence of glkb2"),
  IOP("wnftrp", HSMHV_MOD_WNFTRP, IF_REAL, "Width dependence of nftrp"),
  IOP("wnfalp", HSMHV_MOD_WNFALP, IF_REAL, "Width dependence of nfalp"),
  IOP("wpthrou", HSMHV_MOD_WPTHROU, IF_REAL, "Width dependence of pthrou"),
  IOP("wvdiffj", HSMHV_MOD_WVDIFFJ, IF_REAL, "Width dependence of vdiffj"),
  IOP("wibpc1", HSMHV_MOD_WIBPC1, IF_REAL, "Width dependence of ibpc1"),
  IOP("wibpc2", HSMHV_MOD_WIBPC2, IF_REAL, "Width dependence of ibpc2"),
  IOP("wcgbo", HSMHV_MOD_WCGBO, IF_REAL, "Width dependence of cgbo"),
  IOP("wcvdsover", HSMHV_MOD_WCVDSOVER, IF_REAL, "Width dependence of cvdsover"),
  IOP("wfalph", HSMHV_MOD_WFALPH, IF_REAL, "Width dependence of falph"),
  IOP("wnpext", HSMHV_MOD_WNPEXT, IF_REAL, "Width dependence of npext"),
  IOP("wpowrat", HSMHV_MOD_WPOWRAT, IF_REAL, "Width dependence of powrat"),
  IOP("wrd", HSMHV_MOD_WRD, IF_REAL, "Width dependence of rd"),
  IOP("wrd22", HSMHV_MOD_WRD22, IF_REAL, "Width dependence of rd22"),
  IOP("wrd23", HSMHV_MOD_WRD23, IF_REAL, "Width dependence of rd23"),
  IOP("wrd24", HSMHV_MOD_WRD24, IF_REAL, "Width dependence of rd24"),
  IOP("wrdict1", HSMHV_MOD_WRDICT1, IF_REAL, "Width dependence of rdict1"),
  IOP("wrdov13", HSMHV_MOD_WRDOV13, IF_REAL, "Width dependence of rdov13"),
  IOP("wrdslp1", HSMHV_MOD_WRDSLP1, IF_REAL, "Width dependence of rdslp1"),
  IOP("wrdvb", HSMHV_MOD_WRDVB, IF_REAL, "Width dependence of rdvb"),
  IOP("wrdvd", HSMHV_MOD_WRDVD, IF_REAL, "Width dependence of rdvd"),
  IOP("wrdvg11", HSMHV_MOD_WRDVG11, IF_REAL, "Width dependence of rdvg11"),
  IOP("wrs", HSMHV_MOD_WRS, IF_REAL, "Width dependence of rs"),
  IOP("wrth0", HSMHV_MOD_WRTH0, IF_REAL, "Width dependence of rth0"),
  IOP("wvover", HSMHV_MOD_WVOVER, IF_REAL, "Width dependence of vover"),

  /* Cross-term dependence */
  IOP("pvmax", HSMHV_MOD_PVMAX, IF_REAL, "Cross-term dependence of vmax"),
  IOP("pbgtmp1", HSMHV_MOD_PBGTMP1, IF_REAL, "Cross-term dependence of bgtmp1"),
  IOP("pbgtmp2", HSMHV_MOD_PBGTMP2, IF_REAL, "Cross-term dependence of bgtmp2"),
  IOP("peg0", HSMHV_MOD_PEG0, IF_REAL, "Cross-term dependence of eg0"),
  IOP("pvfbover", HSMHV_MOD_PVFBOVER, IF_REAL, "Cross-term dependence of vfbover"),
  IOP("pnover", HSMHV_MOD_PNOVER, IF_REAL, "Cross-term dependence of nover"),
  IOP("pnovers", HSMHV_MOD_PNOVERS, IF_REAL, "Cross-term dependence of nover on source size"),
  IOP("pwl2", HSMHV_MOD_PWL2, IF_REAL, "Cross-term dependence of wl2"),
  IOP("pvfbc", HSMHV_MOD_PVFBC, IF_REAL, "Cross-term dependence of vfbc"),
  IOP("pnsubc", HSMHV_MOD_PNSUBC, IF_REAL, "Cross-term dependence of nsubc"),
  IOP("pnsubp", HSMHV_MOD_PNSUBP, IF_REAL, "Cross-term dependence of nsubp"),
  IOP("pscp1", HSMHV_MOD_PSCP1, IF_REAL, "Cross-term dependence of scp1"),
  IOP("pscp2", HSMHV_MOD_PSCP2, IF_REAL, "Cross-term dependence of scp2"),
  IOP("pscp3", HSMHV_MOD_PSCP3, IF_REAL, "Cross-term dependence of scp3"),
  IOP("psc1", HSMHV_MOD_PSC1, IF_REAL, "Cross-term dependence of sc1"),
  IOP("psc2", HSMHV_MOD_PSC2, IF_REAL, "Cross-term dependence of sc2"),
  IOP("psc3", HSMHV_MOD_PSC3, IF_REAL, "Cross-term dependence of sc3"),
  IOP("ppgd1", HSMHV_MOD_PPGD1, IF_REAL, "Cross-term dependence of pgd1"),
  IOP("ppgd3", HSMHV_MOD_PPGD3, IF_REAL, "Cross-term dependence of pgd3"),
  IOP("pndep", HSMHV_MOD_PNDEP, IF_REAL, "Cross-term dependence of ndep"),
  IOP("pninv", HSMHV_MOD_PNINV, IF_REAL, "Cross-term dependence of ninv"),
  IOP("pmuecb0", HSMHV_MOD_PMUECB0, IF_REAL, "Cross-term dependence of muecb0"),
  IOP("pmuecb1", HSMHV_MOD_PMUECB1, IF_REAL, "Cross-term dependence of muecb1"),
  IOP("pmueph1", HSMHV_MOD_PMUEPH1, IF_REAL, "Cross-term dependence of mueph1"),
  IOP("pvtmp", HSMHV_MOD_PVTMP, IF_REAL, "Cross-term dependence of vtmp"),
  IOP("pwvth0", HSMHV_MOD_PWVTH0, IF_REAL, "Cross-term dependence of wvth0"),
  IOP("pmuesr1", HSMHV_MOD_PMUESR1, IF_REAL, "Cross-term dependence of muesr1"),
  IOP("pmuetmp", HSMHV_MOD_PMUETMP, IF_REAL, "Cross-term dependence of muetmp"),
  IOP("psub1", HSMHV_MOD_PSUB1, IF_REAL, "Cross-term dependence of sub1"),
  IOP("psub2", HSMHV_MOD_PSUB2, IF_REAL, "Cross-term dependence of sub2"),
  IOP("psvds", HSMHV_MOD_PSVDS, IF_REAL, "Cross-term dependence of svds"),
  IOP("psvbs", HSMHV_MOD_PSVBS, IF_REAL, "Cross-term dependence of svbs"),
  IOP("psvgs", HSMHV_MOD_PSVGS, IF_REAL, "Cross-term dependence of svgs"),
  IOP("pfn1", HSMHV_MOD_PFN1, IF_REAL, "Cross-term dependence of fn1"),
  IOP("pfn2", HSMHV_MOD_PFN2, IF_REAL, "Cross-term dependence of fn2"),
  IOP("pfn3", HSMHV_MOD_PFN3, IF_REAL, "Cross-term dependence of fn3"),
  IOP("pfvbs", HSMHV_MOD_PFVBS, IF_REAL, "Cross-term dependence of fvbs"),
  IOP("pnsti", HSMHV_MOD_PNSTI, IF_REAL, "Cross-term dependence of nsti"),
  IOP("pwsti", HSMHV_MOD_PWSTI, IF_REAL, "Cross-term dependence of wsti"),
  IOP("pscsti1", HSMHV_MOD_PSCSTI1, IF_REAL, "Cross-term dependence of scsti1"),
  IOP("pscsti2", HSMHV_MOD_PSCSTI2, IF_REAL, "Cross-term dependence of scsti2"),
  IOP("pvthsti", HSMHV_MOD_PVTHSTI, IF_REAL, "Cross-term dependence of vthsti"),
  IOP("pmuesti1", HSMHV_MOD_PMUESTI1, IF_REAL, "Cross-term dependence of muesti1"),
  IOP("pmuesti2", HSMHV_MOD_PMUESTI2, IF_REAL, "Cross-term dependence of muesti2"),
  IOP("pmuesti3", HSMHV_MOD_PMUESTI3, IF_REAL, "Cross-term dependence of muesti3"),
  IOP("pnsubpsti1", HSMHV_MOD_PNSUBPSTI1, IF_REAL, "Cross-term dependence of nsubpsti1"),
  IOP("pnsubpsti2", HSMHV_MOD_PNSUBPSTI2, IF_REAL, "Cross-term dependence of nsubpsti2"),
  IOP("pnsubpsti3", HSMHV_MOD_PNSUBPSTI3, IF_REAL, "Cross-term dependence of nsubpsti3"),
  IOP("pcgso", HSMHV_MOD_PCGSO, IF_REAL, "Cross-term dependence of cgso"),
  IOP("pcgdo", HSMHV_MOD_PCGDO, IF_REAL, "Cross-term dependence of cgdo"),
  IOP("pjs0", HSMHV_MOD_PJS0, IF_REAL, "Cross-term dependence of js0"),
  IOP("pjs0sw", HSMHV_MOD_PJS0SW, IF_REAL, "Cross-term dependence of js0sw"),
  IOP("pnj", HSMHV_MOD_PNJ, IF_REAL, "Cross-term dependence of nj"),
  IOP("pcisbk", HSMHV_MOD_PCISBK, IF_REAL, "Cross-term dependence of cisbk"),
  IOP("pclm1", HSMHV_MOD_PCLM1, IF_REAL, "Cross-term dependence of clm1"),
  IOP("pclm2", HSMHV_MOD_PCLM2, IF_REAL, "Cross-term dependence of clm2"),
  IOP("pclm3", HSMHV_MOD_PCLM3, IF_REAL, "Cross-term dependence of clm3"),
  IOP("pwfc", HSMHV_MOD_PWFC, IF_REAL, "Cross-term dependence of wfc"),
  IOP("pgidl1", HSMHV_MOD_PGIDL1, IF_REAL, "Cross-term dependence of gidl1"),
  IOP("pgidl2", HSMHV_MOD_PGIDL2, IF_REAL, "Cross-term dependence of gidl2"),
  IOP("pgleak1", HSMHV_MOD_PGLEAK1, IF_REAL, "Cross-term dependence of gleak1"),
  IOP("pgleak2", HSMHV_MOD_PGLEAK2, IF_REAL, "Cross-term dependence of gleak2"),
  IOP("pgleak3", HSMHV_MOD_PGLEAK3, IF_REAL, "Cross-term dependence of gleak3"),
  IOP("pgleak6", HSMHV_MOD_PGLEAK6, IF_REAL, "Cross-term dependence of gleak6"),
  IOP("pglksd1", HSMHV_MOD_PGLKSD1, IF_REAL, "Cross-term dependence of glksd1"),
  IOP("pglksd2", HSMHV_MOD_PGLKSD2, IF_REAL, "Cross-term dependence of glksd2"),
  IOP("pglkb1", HSMHV_MOD_PGLKB1, IF_REAL, "Cross-term dependence of glkb1"),
  IOP("pglkb2", HSMHV_MOD_PGLKB2, IF_REAL, "Cross-term dependence of glkb2"),
  IOP("pnftrp", HSMHV_MOD_PNFTRP, IF_REAL, "Cross-term dependence of nftrp"),
  IOP("pnfalp", HSMHV_MOD_PNFALP, IF_REAL, "Cross-term dependence of nfalp"),
  IOP("ppthrou", HSMHV_MOD_PPTHROU, IF_REAL, "Cross-term dependence of pthrou"),
  IOP("pvdiffj", HSMHV_MOD_PVDIFFJ, IF_REAL, "Cross-term dependence of vdiffj"),
  IOP("pibpc1", HSMHV_MOD_PIBPC1, IF_REAL, "Cross-term dependence of ibpc1"),
  IOP("pibpc2", HSMHV_MOD_PIBPC2, IF_REAL, "Cross-term dependence of ibpc2"),
  IOP("pcgbo", HSMHV_MOD_PCGBO, IF_REAL, "Cross-term dependence of cgbo"),
  IOP("pcvdsover", HSMHV_MOD_PCVDSOVER, IF_REAL, "Cross-term dependence of cvdsover"),
  IOP("pfalph", HSMHV_MOD_PFALPH, IF_REAL, "Cross-term dependence of falph"),
  IOP("pnpext", HSMHV_MOD_PNPEXT, IF_REAL, "Cross-term dependence of npext"),
  IOP("ppowrat", HSMHV_MOD_PPOWRAT, IF_REAL, "Cross-term dependence of powrat"),
  IOP("prd", HSMHV_MOD_PRD, IF_REAL, "Cross-term dependence of rd"),
  IOP("prd22", HSMHV_MOD_PRD22, IF_REAL, "Cross-term dependence of rd22"),
  IOP("prd23", HSMHV_MOD_PRD23, IF_REAL, "Cross-term dependence of rd23"),
  IOP("prd24", HSMHV_MOD_PRD24, IF_REAL, "Cross-term dependence of rd24"),
  IOP("prdict1", HSMHV_MOD_PRDICT1, IF_REAL, "Cross-term dependence of rdict1"),
  IOP("prdov13", HSMHV_MOD_PRDOV13, IF_REAL, "Cross-term dependence of rdov13"),
  IOP("prdslp1", HSMHV_MOD_PRDSLP1, IF_REAL, "Cross-term dependence of rdslp1"),
  IOP("prdvb", HSMHV_MOD_PRDVB, IF_REAL, "Cross-term dependence of rdvb"),
  IOP("prdvd", HSMHV_MOD_PRDVD, IF_REAL, "Cross-term dependence of rdvd"),
  IOP("prdvg11", HSMHV_MOD_PRDVG11, IF_REAL, "Cross-term dependence of rdvg11"),
  IOP("prs", HSMHV_MOD_PRS, IF_REAL, "Cross-term dependence of rs"),
  IOP("prth0", HSMHV_MOD_PRTH0, IF_REAL, "Cross-term dependence of rth0"),
  IOP("pvover", HSMHV_MOD_PVOVER, IF_REAL, "Cross-term dependence of vover"),

  IOP("vgs_max", HSMHV_MOD_VGS_MAX, IF_REAL, "maximum voltage G-S branch"),
  IOP("vgd_max", HSMHV_MOD_VGD_MAX, IF_REAL, "maximum voltage G-D branch"),
  IOP("vgb_max", HSMHV_MOD_VGB_MAX, IF_REAL, "maximum voltage G-B branch"),
  IOP("vds_max", HSMHV_MOD_VDS_MAX, IF_REAL, "maximum voltage D-S branch"),
  IOP("vbs_max", HSMHV_MOD_VBS_MAX, IF_REAL, "maximum voltage B-S branch"),
  IOP("vbd_max", HSMHV_MOD_VBD_MAX, IF_REAL, "maximum voltage B-D branch"),
  IOP("vgsr_max", HSMHV_MOD_VGSR_MAX, IF_REAL, "maximum voltage G-S branch"),
  IOP("vgdr_max", HSMHV_MOD_VGDR_MAX, IF_REAL, "maximum voltage G-D branch"),
  IOP("vgbr_max", HSMHV_MOD_VGBR_MAX, IF_REAL, "maximum voltage G-B branch"),
  IOP("vbsr_max", HSMHV_MOD_VBSR_MAX, IF_REAL, "maximum voltage B-S branch"),
  IOP("vbdr_max", HSMHV_MOD_VBDR_MAX, IF_REAL, "maximum voltage B-D branch")

};

char *HSMHVnames[] = {
    "Drain",
    "Gate",
    "Source",
    "Bulk",
    "Substrate",
    "Temp"
};

int	HSMHVnSize = NUMELEMS(HSMHVnames);
int	HSMHVpTSize = NUMELEMS(HSMHVpTable);
int	HSMHVmPTSize = NUMELEMS(HSMHVmPTable);
int	HSMHViSize = sizeof(HSMHVinstance);
int	HSMHVmSize = sizeof(HSMHVmodel);

