/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.PushOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Updates {
    public static Bson combine(Bson ... updates) {
        return Updates.combine(Arrays.asList(updates));
    }

    public static Bson combine(List<Bson> updates) {
        Assertions.notNull("updates", updates);
        return new CompositeUpdate(updates);
    }

    public static <TItem> Bson set(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$set");
    }

    public static Bson unset(String fieldName) {
        return new SimpleUpdate<String>(fieldName, "", "$unset");
    }

    public static <TItem> Bson setOnInsert(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$setOnInsert");
    }

    public static Bson rename(String fieldName, String newFieldName) {
        Assertions.notNull("newFieldName", newFieldName);
        return new SimpleUpdate<String>(fieldName, newFieldName, "$rename");
    }

    public static Bson inc(String fieldName, Number number) {
        Assertions.notNull("number", number);
        return new SimpleUpdate<Number>(fieldName, number, "$inc");
    }

    public static Bson mul(String fieldName, Number number) {
        Assertions.notNull("number", number);
        return new SimpleUpdate<Number>(fieldName, number, "$mul");
    }

    public static <TItem> Bson min(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$min");
    }

    public static <TItem> Bson max(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$max");
    }

    public static Bson currentDate(String fieldName) {
        return new SimpleUpdate<Boolean>(fieldName, true, "$currentDate");
    }

    public static Bson currentTimestamp(String fieldName) {
        return new SimpleUpdate<BsonDocument>(fieldName, new BsonDocument("$type", new BsonString("timestamp")), "$currentDate");
    }

    public static <TItem> Bson addToSet(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$addToSet");
    }

    public static <TItem> Bson addEachToSet(String fieldName, List<TItem> values) {
        return new WithEachUpdate<TItem>(fieldName, values, "$addToSet");
    }

    public static <TItem> Bson push(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$push");
    }

    public static <TItem> Bson pushEach(String fieldName, List<TItem> values) {
        return new PushUpdate<TItem>(fieldName, values, new PushOptions());
    }

    public static <TItem> Bson pushEach(String fieldName, List<TItem> values, PushOptions options) {
        return new PushUpdate<TItem>(fieldName, values, options);
    }

    public static <TItem> Bson pull(String fieldName, TItem value) {
        return new SimpleUpdate<TItem>(fieldName, value, "$pull");
    }

    public static Bson pullByFilter(final Bson filter) {
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
                writer.writeStartDocument();
                writer.writeName("$pull");
                BuildersHelper.encodeValue(writer, filter, codecRegistry);
                writer.writeEndDocument();
                return writer.getDocument();
            }
        };
    }

    public static <TItem> Bson pullAll(String fieldName, List<TItem> values) {
        return new PullAllUpdate<TItem>(fieldName, values);
    }

    public static Bson popFirst(String fieldName) {
        return new SimpleUpdate<Integer>(fieldName, -1, "$pop");
    }

    public static Bson popLast(String fieldName) {
        return new SimpleUpdate<Integer>(fieldName, 1, "$pop");
    }

    public static Bson bitwiseAnd(String fieldName, int value) {
        return Updates.createBitUpdateDocument(fieldName, "and", value);
    }

    public static Bson bitwiseAnd(String fieldName, long value) {
        return Updates.createBitUpdateDocument(fieldName, "and", value);
    }

    public static Bson bitwiseOr(String fieldName, int value) {
        return Updates.createBitUpdateDocument(fieldName, "or", value);
    }

    public static Bson bitwiseOr(String fieldName, long value) {
        return Updates.createBitUpdateDocument(fieldName, "or", value);
    }

    public static Bson bitwiseXor(String fieldName, int value) {
        return Updates.createBitUpdateDocument(fieldName, "xor", value);
    }

    public static Bson bitwiseXor(String fieldName, long value) {
        return Updates.createBitUpdateDocument(fieldName, "xor", value);
    }

    private static Bson createBitUpdateDocument(String fieldName, String bitwiseOperator, int value) {
        return Updates.createBitUpdateDocument(fieldName, bitwiseOperator, new BsonInt32(value));
    }

    private static Bson createBitUpdateDocument(String fieldName, String bitwiseOperator, long value) {
        return Updates.createBitUpdateDocument(fieldName, bitwiseOperator, new BsonInt64(value));
    }

    private static Bson createBitUpdateDocument(String fieldName, String bitwiseOperator, BsonValue value) {
        return new BsonDocument("$bit", new BsonDocument(fieldName, new BsonDocument(bitwiseOperator, value)));
    }

    private Updates() {
    }

    private static class CompositeUpdate
    implements Bson {
        private final List<Bson> updates;

        public CompositeUpdate(List<Bson> updates) {
            this.updates = updates;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocument document = new BsonDocument();
            for (Bson update : this.updates) {
                BsonDocument rendered = update.toBsonDocument(tDocumentClass, codecRegistry);
                for (Map.Entry<String, BsonValue> element : rendered.entrySet()) {
                    if (document.containsKey(element.getKey())) {
                        BsonDocument currentOperatorDocument = (BsonDocument)element.getValue();
                        BsonDocument existingOperatorDocument = document.getDocument(element.getKey());
                        for (Map.Entry<String, BsonValue> currentOperationDocumentElements : currentOperatorDocument.entrySet()) {
                            existingOperatorDocument.append(currentOperationDocumentElements.getKey(), currentOperationDocumentElements.getValue());
                        }
                        continue;
                    }
                    document.append(element.getKey(), element.getValue());
                }
            }
            return document;
        }

        public String toString() {
            return "Updates{updates=" + this.updates + '}';
        }
    }

    private static class PullAllUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final List<TItem> values;

        public PullAllUpdate(String fieldName, List<TItem> values) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.values = Assertions.notNull("values", values);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$pullAll");
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartArray();
            for (TItem value : this.values) {
                BuildersHelper.encodeValue(writer, value, codecRegistry);
            }
            writer.writeEndArray();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Update{fieldName='" + this.fieldName + '\'' + ", operator='$pullAll'" + ", value=" + this.values + '}';
        }
    }

    private static class PushUpdate<TItem>
    extends WithEachUpdate<TItem> {
        private final PushOptions options;

        public PushUpdate(String fieldName, List<TItem> values, PushOptions options) {
            super(fieldName, values, "$push");
            this.options = Assertions.notNull("options", options);
        }

        @Override
        protected <TDocument> void writeAdditionalFields(BsonDocumentWriter writer, Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            if (this.options.getPosition() != null) {
                writer.writeInt32("$position", this.options.getPosition());
            }
            if (this.options.getSlice() != null) {
                writer.writeInt32("$slice", this.options.getSlice());
            }
            if (this.options.getSort() != null) {
                writer.writeInt32("$sort", this.options.getSort());
            } else if (this.options.getSortDocument() != null) {
                writer.writeName("$sort");
                BuildersHelper.encodeValue(writer, this.options.getSortDocument(), codecRegistry);
            }
        }

        @Override
        protected String additionalFieldsToString() {
            return ", options=" + this.options;
        }
    }

    private static class WithEachUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final List<TItem> values;
        private final String operator;

        public WithEachUpdate(String fieldName, List<TItem> values, String operator) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.values = Assertions.notNull("values", values);
            this.operator = operator;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.operator);
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeStartArray("$each");
            for (TItem value : this.values) {
                BuildersHelper.encodeValue(writer, value, codecRegistry);
            }
            writer.writeEndArray();
            this.writeAdditionalFields(writer, tDocumentClass, codecRegistry);
            writer.writeEndDocument();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        protected <TDocument> void writeAdditionalFields(BsonDocumentWriter writer, Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
        }

        protected String additionalFieldsToString() {
            return "";
        }

        public String toString() {
            return "Each Update{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operator + '\'' + ", values=" + this.values + this.additionalFieldsToString() + '}';
        }
    }

    private static class SimpleUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;
        private final String operator;

        public SimpleUpdate(String fieldName, TItem value, String operator) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value;
            this.operator = operator;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.operator);
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            BuildersHelper.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Update{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operator + '\'' + ", value=" + this.value + '}';
        }
    }
}

