package ui

import (
	"fmt"
	"strings"

	"github.com/charmbracelet/lipgloss"
)

var (
	headerStyle = lipgloss.NewStyle().
		Bold(true).
		Foreground(lipgloss.Color("#00D7FF")).
		Background(lipgloss.Color("#1a1a1a")).
		Padding(0, 1).
		Margin(1, 0)

	boxStyle = lipgloss.NewStyle().
		Border(lipgloss.RoundedBorder()).
		BorderForeground(lipgloss.Color("#00D7FF")).
		Padding(1, 2).
		Margin(0, 1)
)

// ShowHeader displays a styled header
func ShowHeader(title string) {
	header := headerStyle.Render("📦 " + title)
	fmt.Println(header)
}

// ShowBox displays content in a styled box
func ShowBox(content string) {
	box := boxStyle.Render(content)
	fmt.Println(box)
}

// ShowSeparator displays a separator line
func ShowSeparator() {
	separator := strings.Repeat("─", 60)
	separatorStyle := lipgloss.NewStyle().
		Foreground(lipgloss.Color("#444444")).
		MarginTop(1).
		MarginBottom(1)

	fmt.Println(separatorStyle.Render(separator))
}
