"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackToTop = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const back_to_top_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/BackToTop/back-to-top"));
const react_styles_1 = require("@patternfly/react-styles");
const angle_up_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/angle-up-icon'));
const util_1 = require("../../helpers/util");
const Button_1 = require("../Button");
const BackToTopBase = (_a) => {
    var { className, title = 'Back to top', innerRef, scrollableSelector, isAlwaysVisible = false } = _a, props = tslib_1.__rest(_a, ["className", "title", "innerRef", "scrollableSelector", "isAlwaysVisible"]);
    const [visible, setVisible] = (0, react_1.useState)(isAlwaysVisible);
    (0, react_1.useEffect)(() => {
        setVisible(isAlwaysVisible);
    }, [isAlwaysVisible]);
    const [scrollElement, setScrollElement] = (0, react_1.useState)(null);
    const toggleVisible = () => {
        if (scrollElement) {
            const scrolled = scrollElement.scrollY ? scrollElement.scrollY : scrollElement.scrollTop;
            if (!isAlwaysVisible) {
                if (scrolled > 400) {
                    setVisible(true);
                }
                else {
                    setVisible(false);
                }
            }
        }
    };
    (0, react_1.useEffect)(() => {
        const hasScrollSpy = Boolean(scrollableSelector);
        if (hasScrollSpy) {
            const scrollEl = document.querySelector(scrollableSelector);
            if (!util_1.canUseDOM || !(scrollEl instanceof HTMLElement)) {
                return;
            }
            setScrollElement(scrollEl);
            scrollEl.addEventListener('scroll', toggleVisible);
            return () => {
                scrollEl.removeEventListener('scroll', toggleVisible);
            };
        }
        else {
            if (!util_1.canUseDOM) {
                return;
            }
            const scrollEl = window;
            setScrollElement(scrollEl);
            scrollEl.addEventListener('scroll', toggleVisible);
            return () => {
                scrollEl.removeEventListener('scroll', toggleVisible);
            };
        }
    }, [scrollableSelector, toggleVisible]);
    const handleClick = () => {
        scrollElement.scrollTo({ top: 0, behavior: 'smooth' });
    };
    return ((0, jsx_runtime_1.jsx)("div", Object.assign({ className: (0, react_styles_1.css)(back_to_top_1.default.backToTop, !visible && back_to_top_1.default.modifiers.hidden, className), ref: innerRef, onClick: handleClick }, props, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: "primary", icon: (0, jsx_runtime_1.jsx)(angle_up_icon_1.default, {}), iconPosition: "end", children: title }) })));
};
exports.BackToTop = (0, react_1.forwardRef)((props, ref) => ((0, jsx_runtime_1.jsx)(BackToTopBase, Object.assign({ innerRef: ref }, props))));
exports.BackToTop.displayName = 'BackToTop';
//# sourceMappingURL=BackToTop.js.map