/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/ScriptExecutionContext.h>
#include <wtf/AbstractCanMakeCheckedPtr.h>

namespace WebCore {

class CacheStorageConnection;
class StorageConnection;
struct ReportingClient;

// A proxy to talk to the loader context. Normally, the document on the main thread
// provides loading services for the subordinate workers.
class WorkerLoaderProxy : public AbstractCanMakeCheckedPtr {
public:
    virtual ~WorkerLoaderProxy() = default;

    virtual bool isWorkerMessagingProxy() const { return false; }
    virtual ReportingClient* reportingClient() const { return nullptr; }

    // Creates a cache storage connection to be used on the main thread. Method must be called on the main thread.
    virtual RefPtr<CacheStorageConnection> createCacheStorageConnection() = 0;

    virtual RefPtr<RTCDataChannelRemoteHandlerConnection> createRTCDataChannelRemoteHandlerConnection() = 0;

    virtual ScriptExecutionContextIdentifier loaderContextIdentifier() const = 0;

    // Posts a task to the thread which runs the loading code (normally, the main thread).
    virtual void postTaskToLoader(ScriptExecutionContext::Task&&) = 0;
};

} // namespace WebCore
