/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * This file is intended to be included after different definitions of
 * PKIX_ERRORENTRY. It is included in pkixt.h to define a number for each error
 * by defining PKIX_ERRORENTRY(x,y) as PKIX_ ## x  and then listing thim within
 * an enum. It is included in pkix_error.c to define an array of error strings
 * by defining PKIX_ERRORENTRY(x,y) #y and then listing thim within an array
 * const char * const PKIX_ErrorText[]
 */
/* ALLOCERROR should always be the first */
PKIX_ERRORENTRY(ALLOCERROR,Allocation Error,SEC_ERROR_NO_MEMORY),
PKIX_ERRORENTRY(ADDHEADERFUNCTIONNOTSUPPORTED,AddHeader function not supported,0),
PKIX_ERRORENTRY(ADDTOVERIFYLOGFAILED,pkix_AddToVerifyLog failed,0),
PKIX_ERRORENTRY(AIAMGRCREATEFAILED,PKIX_PL_AIAMgr_Create failed,0),
PKIX_ERRORENTRY(AIAMGRFINDLDAPCLIENTFAILED,pkix_pl_AiaMgr_FindLDAPClient failed,0),
PKIX_ERRORENTRY(AIAMGRGETAIACERTSFAILED,PKIX_PL_AIAMgr_GetAIACerts failed,SEC_ERROR_UNKNOWN_ISSUER),
PKIX_ERRORENTRY(AIAMGRGETHTTPCERTSFAILED,pkix_pl_AIAMgr_GetHTTPCerts failed,0),
PKIX_ERRORENTRY(AIAMGRGETLDAPCERTSFAILED,pkix_pl_AIAMgr_GetLDAPCerts failed,0),
PKIX_ERRORENTRY(ALGORITHMBYTESLENGTH0,Algorithm bytes length is 0,0),
PKIX_ERRORENTRY(ALLOCATENEWCERTGENERALNAMEFAILED,Allocate new CERTGeneralName failed,0),
PKIX_ERRORENTRY(AMBIGUOUSPARENTAGEOFVERIFYNODE,Ambiguous parentage of VerifyNode,0),
PKIX_ERRORENTRY(ANCHORDIDNOTCHAINTOCERT,Anchor did not chain to Cert,SEC_ERROR_UNKNOWN_ISSUER),
PKIX_ERRORENTRY(ANCHORDIDNOTPASSCERTSELECTORCRITERIA,Anchor did not pass CertSelector criteria,0),
PKIX_ERRORENTRY(APPENDLISTFAILED,pkix_pl_AppendList failed,0),
PKIX_ERRORENTRY(ARGUMENTNOTSTRING,Argument is not a String,0),
PKIX_ERRORENTRY(ARGUMENTSNOTBIGINTS,Arguments are not BigInts,0),
PKIX_ERRORENTRY(ARGUMENTSNOTBYTEARRAYS,Arguments are not Byte Arrays,0),
PKIX_ERRORENTRY(ARGUMENTSNOTDATES,Arguments are not Dates,0),
PKIX_ERRORENTRY(ARGUMENTSNOTOIDS,Arguments are not OIDs,0),
PKIX_ERRORENTRY(ATTEMPTTOADDDUPLICATEKEY,Attempt to add duplicate key,0),
PKIX_ERRORENTRY(ATTEMPTTODECODEANINCOMPLETERESPONSE,Attempt to decode an incomplete response,SEC_ERROR_BAD_DER),
PKIX_ERRORENTRY(ATTEMPTTODECREFALLOCERROR,Attempt to DecRef Alloc Error,0),
PKIX_ERRORENTRY(ATTEMPTTOINCREFALLOCERROR,Attempt to IncRef Alloc Error,0),
PKIX_ERRORENTRY(BADHTTPRESPONSE,Bad Http Response,SEC_ERROR_BAD_HTTP_RESPONSE),
PKIX_ERRORENTRY(BASICCONSTRAINTSCHECKERINITIALIZEFAILED,pkix_BasicConstraintsChecker_Initialize failed,0),
PKIX_ERRORENTRY(BASICCONSTRAINTSCHECKERSTATECREATEFAILED,PKIX_BasicConstraintsCheckerState_Create failed,0),
PKIX_ERRORENTRY(BASICCONSTRAINTSGETCAFLAGFAILED,PKIX_PL_BasicConstraints_GetCAFlag failed,0),
PKIX_ERRORENTRY(BASICCONSTRAINTSGETPATHLENCONSTRAINTFAILED,PKIX_PL_BasicConstraints_GetPathLenConstraint failed,0),
PKIX_ERRORENTRY(BASICCONSTRAINTSVALIDATIONFAILEDCA,PKIX_BasicConstraints validation failed: CA Flag not set,SEC_ERROR_CA_CERT_INVALID),
PKIX_ERRORENTRY(BASICCONSTRAINTSVALIDATIONFAILEDLN,PKIX_BasicConstraints validation failed: maximum length mismatch,SEC_ERROR_PATH_LEN_CONSTRAINT_INVALID),
PKIX_ERRORENTRY(BIGINTCOMPARATORFAILED,pkix_pl_BigInt_Comparator failed,0),
PKIX_ERRORENTRY(BIGINTCREATEWITHBYTESFAILED,pkix_pl_BigInt_CreateWithBytes failed,0),
PKIX_ERRORENTRY(BIGINTEQUALSFAILED,PKIX_PL_BigInt_Equals failed,0),
PKIX_ERRORENTRY(BIGINTLENGTH0INVALID,BigInt length 0 is invalid,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(BIGINTTOSTRINGFAILED,pkix_pl_BigInt_ToString failed,0),
PKIX_ERRORENTRY(BIGINTTOSTRINGHELPERFAILED,PKIX_PL_BigInt_ToString_Helper failed,0),
PKIX_ERRORENTRY(BINDREJECTEDBYSERVER,BIND rejected by server,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(BUILDANDVALIDATECHAINFAILED,Failed to build and validate a chain,0),
PKIX_ERRORENTRY(BUILDBUILDSELECTORANDPARAMSFAILED,pkix_Build_BuildSelectorAndParams failed,0),
PKIX_ERRORENTRY(BUILDCOMBINEWITHTRUSTFAILED,pkix_Build_CombineWithTrust failed,0),
PKIX_ERRORENTRY(BUILDFORWARDDEPTHFIRSTSEARCHFAILED,pkix_BuildForwardDepthFirstSearch failed,0),
PKIX_ERRORENTRY(BUILDGATHERCERTSFAILED,pkix_Build_GatherCerts failed,0),
PKIX_ERRORENTRY(BUILDGETRESOURCELIMITSFAILED,pkix_Build_GetResourceLimits failed,0),
PKIX_ERRORENTRY(BUILDINITIATEBUILDCHAINFAILED,pkix_Build_InitiateBuildChain failed,0),
PKIX_ERRORENTRY(BUILDRESULTCREATEFAILED,pkix_BuildResult_Create failed,0),
PKIX_ERRORENTRY(BUILDRESULTGETCERTCHAINFAILED,PKIX_BuildResult_GetCertChain failed,0),
PKIX_ERRORENTRY(BUILDRESULTGETVALIDATERESULTFAILED,PKIX_BuildResult_GetValidateResult failed,0),
PKIX_ERRORENTRY(BUILDREVCHECKPREPFAILED,pkix_Build_RevCheckPrep failed,0),
PKIX_ERRORENTRY(BUILDSORTCANDIDATECERTSFAILED,pkix_Build_SortCandidateCerts failed,0),
PKIX_ERRORENTRY(BUILDSTATECREATEFAILED,pkix_BuildState_Create failed,0),
PKIX_ERRORENTRY(BUILDTRYSHORTCUTFAILED,pkix_Build_TryShortcut failed,0),
PKIX_ERRORENTRY(BUILDUPDATEDATEFAILED,pkix_Build_UpdateDate failed,0),
PKIX_ERRORENTRY(BUILDVALIDATEENTIRECHAINFAILED,pkix_Build_ValidateEntireChain failed,0),
PKIX_ERRORENTRY(BUILDVALIDATIONCHECKERSFAILED,pkix_Build_ValidationCheckers failed,0),
PKIX_ERRORENTRY(BUILDVERIFYCERTIFICATEFAILED,pkix_Build_VerifyCertificate failed,0),
PKIX_ERRORENTRY(BYTEARRAYCOMPARATORFAILED,pkix_pl_ByteArray_Comparator failed,0),
PKIX_ERRORENTRY(BYTEARRAYCREATEFAILED,PKIX_PL_ByteArray_Create failed,0),
PKIX_ERRORENTRY(BYTEARRAYEQUALSFAILED,PKIX_PL_ByteArray_Equals failed,0),
PKIX_ERRORENTRY(BYTEARRAYGETLENGTHFAILED,PKIX_PL_ByteArray_GetLength failed,0),
PKIX_ERRORENTRY(BYTEARRAYGETPOINTERFAILED,PKIX_PL_ByteArray_GetPointer failed,0),
PKIX_ERRORENTRY(BYTEARRAYTOHEXSTRINGFAILED,pkix_pl_ByteArray_ToHexString failed,0),
PKIX_ERRORENTRY(BYTEARRAYTOSTRINGFAILED,PKIX_PL_ByteArray_ToString failed,0),
PKIX_ERRORENTRY(CACHECERTADDFAILED,pkix_CacheCert_Add failed,0),
PKIX_ERRORENTRY(CACHECERTCHAINADDFAILED,pkix_CacheCertChain_Add failed,0),
PKIX_ERRORENTRY(CACHECERTCHAINLOOKUPFAILED,pkix_CacheCertChain_Lookup failed,0),
PKIX_ERRORENTRY(CACHECERTCHAINREMOVEFAILED,pkix_CacheCertChain_Remove failed,0),
PKIX_ERRORENTRY(CACHECRLENTRYADDFAILED,pkix_CacheCrlEntry_Add failed,0),
PKIX_ERRORENTRY(CACHECRLENTRYLOOKUPFAILED,pkix_CacheCrlEntry_Lookup failed,0),
PKIX_ERRORENTRY(CALLOCFAILED,PKIX_PL_Calloc failed,0),
PKIX_ERRORENTRY(CANNOTAQUIRECRLDER,Failed to get DER CRL,0),
PKIX_ERRORENTRY(CANNOTCONVERTCERTUSAGETOPKIXKEYANDEKUSAGES, Fail to convert certificate usage to pkix KU and EKU,0),
PKIX_ERRORENTRY(CANNOTOPENCOLLECTIONCERTSTORECONTEXTDIRECTORY,Cannot open CollectionCertStoreContext directory,0),
PKIX_ERRORENTRY(CANTCREATESTRING,Cannot create PKIX_PL_String,0),
PKIX_ERRORENTRY(CANTDECODEBINDRESPONSEFROMSERVER,Cannot decode BIND response from server,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(CANTDECODESEARCHRESPONSEFROMSERVER,Cannot decode SEARCH response from server,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(CANTENABLEREVOCATIONWITHOUTCERTSTORE,Cannot enable Revocation without CertStore,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(CANTLOADLIBSMIME,Cannot load smime3 library,0),
PKIX_ERRORENTRY(CANTREREGISTERSYSTEMTYPE,Cannot reregister system type,0),
PKIX_ERRORENTRY(CERTARECERTPOLICIESCRITICALFAILED,PKIX_PL_Cert_AreCertPoliciesCritical failed,0),
PKIX_ERRORENTRY(CERTBASICCONSTRAINTSCREATEFAILED,pkix_pl_CertBasicConstraints_Create failed,0),
PKIX_ERRORENTRY(CERTBASICCONSTRAINTSTOSTRINGFAILED,PKIX_PL_CertBasicConstraints_ToString failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERCHECKCALLBACKFAILED,PKIX_CertChainChecker_CheckCallback failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERCHECKFAILED,PKIX_CertChainChecker_Check failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERCREATEFAILED,PKIX_CertChainChecker_Create failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERGETCERTCHAINCHECKERSTATEFAILED,PKIX_CertChainChecker_GetCertChainCheckerState failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERGETCHECKCALLBACKFAILED,PKIX_CertChainChecker_GetCheckCallback failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERGETSUPPORTEDEXTENSIONSFAILED,PKIX_CertChainChecker_GetSupportedExtensions failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERISFORWARDCHECKINGSUPPORTEDFAILED,PKIX_CertChainChecker_IsForwardCheckingSupported failed,0),
PKIX_ERRORENTRY(CERTCHAINCHECKERSETCERTCHAINCHECKERSTATEFAILED,PKIX_CertChainChecker_SetCertChainCheckerState failed,0),
PKIX_ERRORENTRY(CERTCHAINFAILSCERTIFICATEPOLICYVALIDATION,CertChain fails Certificate Policy validation,SEC_ERROR_POLICY_VALIDATION_FAILED),
PKIX_ERRORENTRY(CERTCHAINTONSSCHAINFAILED,Fail to convert pkix cert chain to nss cert chain,0),
PKIX_ERRORENTRY(CERTCHAINTOPKIXCERTLISTFAILED,Failed to convert nss cert chain to pkix cert chain,0),
PKIX_ERRORENTRY(CERTCHECKCERTTYPEFAILED,Check cert type failed,SEC_ERROR_INADEQUATE_CERT_TYPE),
PKIX_ERRORENTRY(CERTCHECKCERTVALIDTIMESFAILED,CERT_CheckCertValidTimes failed,SEC_ERROR_EXPIRED_CERTIFICATE),
PKIX_ERRORENTRY(CERTCHECKCRLFAILED,Fail to get crl cache issued by cert,0),
PKIX_ERRORENTRY(CERTCHECKEXTENDEDKEYUSAGEFAILED,pkix_pl_Cert_CheckExtendedKeyUsage failed,0),
PKIX_ERRORENTRY(CERTCHECKKEYUSAGEFAILED,CERT_CheckKeyUsage failed,SEC_ERROR_INADEQUATE_KEY_USAGE),
PKIX_ERRORENTRY(CERTCHECKNAMECONSTRAINTSFAILED,PKIX_PL_Cert_CheckNameConstraints failed,0),
PKIX_ERRORENTRY(CERTCHECKVALIDITYFAILED,PKIX_PL_Cert_CheckValidity failed,0),
PKIX_ERRORENTRY(CERTCOMPLETECRLDECODEDENTRIESFAILED,CERT_CompleteCRLDecodedEntries failed,0),
PKIX_ERRORENTRY(CERTCOPYNAMECONSTRAINTFAILED,CERT_CopyNameConstraint failed,0),
PKIX_ERRORENTRY(CERTCOPYNAMEFAILED,CERT_CopyName failed,0),
PKIX_ERRORENTRY(CERTCREATEFAILED,PKIX_PL_Cert_Create failed,0),
PKIX_ERRORENTRY(CERTCREATEGENERALNAMELISTFAILED,CERT_CreateGeneralNameList failed,0),
PKIX_ERRORENTRY(CERTCREATETOLISTFAILED,pkix_pl_Cert_CreateToList failed,0),
PKIX_ERRORENTRY(CERTCREATEWITHNSSCERTFAILED,pkix_pl_Cert_CreateWithNSSCert failed,0),
PKIX_ERRORENTRY(CERTDECODEALTNAMEEXTENSIONFAILED,CERT_DecodeAltNameExtension failed,0),
PKIX_ERRORENTRY(CERTDECODECERTIFICATEPOLICIESEXTENSIONFAILED,CERT_DecodeCertificatePoliciesExtension failed,0),
PKIX_ERRORENTRY(CERTDECODEDERCERTIFICATEFAILED,CERT_DecodeDERCertificate failed,0),
PKIX_ERRORENTRY(CERTDECODEDERCRLFAILED,CERT_DecodeDERCrl failed,0),
PKIX_ERRORENTRY(CERTDECODEINHIBITANYEXTENSIONFAILED,CERT_DecodeInhibitAnyExtension failed,0),
PKIX_ERRORENTRY(CERTDECODEINHIBITANYPOLICYFAILED,pkix_pl_Cert_DecodeInhibitAnyPolicy failed,0),
PKIX_ERRORENTRY(CERTDECODEOIDSEQUENCEFAILED,CERT_DecodeOidSequence failed,0),
PKIX_ERRORENTRY(CERTDECODEPOLICYCONSTRAINTSEXTENSIONFAILED,CERT_DecodePolicyConstraintsExtension failed,0),
PKIX_ERRORENTRY(CERTDECODEPOLICYCONSTRAINTSFAILED,pkix_pl_Cert_DecodePolicyConstraints failed,0),
PKIX_ERRORENTRY(CERTDECODEPOLICYINFOFAILED,pkix_pl_Cert_DecodePolicyInfo failed,0),
PKIX_ERRORENTRY(CERTDECODEPOLICYMAPPINGFAILED,pkix_pl_Cert_DecodePolicyMapping failed,0),
PKIX_ERRORENTRY(CERTDECODEPOLICYMAPPINGSEXTENSIONFAILED,CERT_DecodePolicyMappingsExtension failed,0),
PKIX_ERRORENTRY(CERTEQUALSFAILED,pkix_pl_Cert_Equals failed,0),
PKIX_ERRORENTRY(CERTFAILEDNAMECONSTRAINTSCHECKING,Cert failed NameConstraints checking,SEC_ERROR_CERT_NOT_IN_NAME_SPACE),
PKIX_ERRORENTRY(CERTGETALLSUBJECTNAMESFAILED,PKIX_PL_Cert_GetAllSubjectNames failed,0),
PKIX_ERRORENTRY(CERTGETAUTHORITYINFOACCESSFAILED,PKIX_PL_Cert_GetAuthorityInfoAccess failed,0),
PKIX_ERRORENTRY(CERTGETAUTHORITYKEYIDENTIFIERFAILED,PKIX_PL_Cert_GetAuthorityKeyIdentifier failed,0),
PKIX_ERRORENTRY(CERTGETBASICCONSTRAINTFAILED,PKIX_PL_Cert_GetBasicConstraint failed,0),
PKIX_ERRORENTRY(CERTGETBASICCONSTRAINTSFAILED,PKIX_PL_Cert_GetBasicConstraints failed,0),
PKIX_ERRORENTRY(CERTGETCACHEFLAGFAILED,PKIX_Cert_GetCacheFlag failed,0),
PKIX_ERRORENTRY(CERTGETCERTCERTIFICATEFAILED,PKIX_PL_Cert_GetCERTCertificate failed,0),
PKIX_ERRORENTRY(CERTGETCRITICALEXTENSIONOIDSFAILED,PKIX_PL_Cert_GetCriticalExtensionOIDs failed,0),
PKIX_ERRORENTRY(CERTGETCRLDPFAILED,Failed to get cert crldp extension, 0),
PKIX_ERRORENTRY(CERTGETEXTENDEDKEYUSAGEFAILED,PKIX_PL_Cert_GetExtendedKeyUsage failed,0),
PKIX_ERRORENTRY(CERTGETINHIBITANYPOLICYFAILED,PKIX_PL_Cert_GetInhibitAnyPolicy failed,0),
PKIX_ERRORENTRY(CERTGETISSUERFAILED,PKIX_PL_Cert_GetIssuer failed,0),
PKIX_ERRORENTRY(CERTGETNAMECONSTRAINTSFAILED,PKIX_PL_CertGetNameConstraints failed,0),
PKIX_ERRORENTRY(CERTGETNSSSUBJECTALTNAMESFAILED,pkix_pl_Cert_GetNssSubjectAltNames failed,0),
PKIX_ERRORENTRY(CERTGETPOLICYINFORMATIONFAILED,PKIX_PL_Cert_GetPolicyInformation failed,0),
PKIX_ERRORENTRY(CERTGETPOLICYMAPPINGINHIBITEDFAILED,PKIX_PL_Cert_GetPolicyMappingInhibited failed,0),
PKIX_ERRORENTRY(CERTGETPOLICYMAPPINGSFAILED,PKIX_PL_Cert_GetPolicyMappings failed,0),
PKIX_ERRORENTRY(CERTGETREQUIREEXPLICITPOLICYFAILED,PKIX_PL_Cert_GetRequireExplicitPolicy failed,0),
PKIX_ERRORENTRY(CERTGETSERIALNUMBERFAILED,PKIX_PL_Cert_GetSerialNumber failed,0),
PKIX_ERRORENTRY(CERTGETSUBJALTNAMESFAILED,PKIX_PL_Cert_GetSubjAltNames failed,0),
PKIX_ERRORENTRY(CERTGETSUBJECTALTNAMESFAILED,PKIX_PL_Cert_GetSubjectAltNames failed,0),
PKIX_ERRORENTRY(CERTGETSUBJECTFAILED,PKIX_PL_Cert_GetSubject failed,0),
PKIX_ERRORENTRY(CERTGETSUBJECTINFOACCESSFAILED,PKIX_PL_Cert_GetSubjectInfoAccess failed,0),
PKIX_ERRORENTRY(CERTGETSUBJECTKEYIDENTIFIERFAILED,PKIX_PL_Cert_GetSubjectKeyIdentifier failed,0),
PKIX_ERRORENTRY(CERTGETSUBJECTPUBLICKEYALGIDFAILED,PKIX_PL_Cert_GetSubjectPublicKeyAlgId failed,0),
PKIX_ERRORENTRY(CERTGETSUBJECTPUBLICKEYFAILED,PKIX_PL_Cert_GetSubjectPublicKey failed,0),
PKIX_ERRORENTRY(CERTGETVALIDITYNOTAFTERFAILED,PKIX_PL_Cert_GetValidityNotAfter failed,0),
PKIX_ERRORENTRY(CERTGETVERSIONFAILED,PKIX_PL_Cert_GetVersion failed,0),
PKIX_ERRORENTRY(CERTHASHCODEFAILED,PKIX_PL_Cert_Hashcode failed,0),
PKIX_ERRORENTRY(CERTIFICATEDOESNTHAVEVALIDCRL,Certificate does not have a valid CRL,SEC_ERROR_CRL_NOT_FOUND),
PKIX_ERRORENTRY(CERTIFICATEREVOKED,Certificate is revoked,SEC_ERROR_REVOKED_CERTIFICATE),
PKIX_ERRORENTRY(CERTIMPORTCERTIFICATEFUNCTIONFAILED,CERTImportCertificate function failed,0),
PKIX_ERRORENTRY(CERTISCERTTRUSTEDFAILED,PKIX_PL_Cert_IsCertTrusted failed,SEC_ERROR_UNTRUSTED_CERT),
PKIX_ERRORENTRY(CERTISEXTENSIONCRITICALFAILED,pkix_pl_Cert_IsExtensionCritical failed,0),
PKIX_ERRORENTRY(CERTMERGENAMECONSTRAINTSFAILED,PKIX_PL_Cert_MergeNameConstraints failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCHECKNAMEINNAMESPACEFAILED,PKIX_PL_CertNameConstraints_CheckNameInNameSpace failed,SEC_ERROR_CERT_NOT_IN_NAME_SPACE),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCHECKNAMESINNAMESPACEFAILED,PKIX_PL_CertNameConstraints_CheckNamesInNameSpace failed,SEC_ERROR_CERT_NOT_IN_NAME_SPACE),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCHECKNAMESPACENSSNAMESFAILED,pkix_pl_CertNameConstraints_CheckNameSpaceNssNames failed,SEC_ERROR_CERT_NOT_IN_NAME_SPACE),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCOPYNSSNAMECONSTRAINTSFAILED,pkix_pl_CertNameConstraints_CopyNssNameConstraints failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCREATEBYMERGEFAILED,pkix_pl_CertNameConstraints_CreateByMerge failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCREATEFAILED,pkix_pl_CertNameConstraints_Create failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCREATEHELPERFAILED,pkix_pl_CertNameConstraints_Create_Helper failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSGETEXCLUDEDFAILED,pkix_pl_CertNameConstraints_GetExcluded failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSGETPERMITTEDFAILED,pkix_pl_CertNameConstraints_GetPermitted failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSMERGEFAILED,pkix_pl_CertNameConstraints_Merge failed,0),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSTOSTRINGHELPERFAILED,pkix_pl_CertNameConstraints_ToString_Helper failed,0),
PKIX_ERRORENTRY(CERTNAMETOASCIIFAILED,CERT_NameToAscii failed,0),
PKIX_ERRORENTRY(CERTNOTALLOWEDTOSIGNCERTIFICATES,Cert not allowed to sign certificates,SEC_ERROR_CA_CERT_INVALID),
PKIX_ERRORENTRY(CERTPOLICYINFOCREATEFAILED,pkix_pl_CertPolicyInfo_Create failed,0),
PKIX_ERRORENTRY(CERTPOLICYINFOGETPOLICYIDFAILED,PKIX_PL_CertPolicyInfo_GetPolicyId failed,0),
PKIX_ERRORENTRY(CERTPOLICYINFOGETPOLQUALIFIERSFAILED,PKIX_PL_CertPolicyInfo_GetPolQualifiers failed,0),
PKIX_ERRORENTRY(CERTPOLICYMAPCREATEFAILED,pkix_pl_CertPolicyMap_Create failed,0),
PKIX_ERRORENTRY(CERTPOLICYMAPGETISSUERDOMAINPOLICYFAILED,PKIX_PL_CertPolicyMap_GetIssuerDomainPolicy failed,0),
PKIX_ERRORENTRY(CERTPOLICYMAPGETSUBJECTDOMAINPOLICYFAILED,PKIX_PL_CertPolicyMap_GetSubjectDomainPolicy failed,0),
PKIX_ERRORENTRY(CERTPOLICYQUALIFIERCREATEFAILED,pkix_pl_CertPolicyQualifier_Create failed,0),
PKIX_ERRORENTRY(CERTREJECTEDBYREVOCATIONCHECKER,Cert rejected by revocation checker,0),
PKIX_ERRORENTRY(CERTSELECTORCHECKFAILED,Validation failed: CertSelector check failed,0),
PKIX_ERRORENTRY(CERTSELECTORCREATEFAILED,PKIX_CertSelector_Create failed,0),
PKIX_ERRORENTRY(CERTSELECTORFAILED,certSelector failed,0),
PKIX_ERRORENTRY(CERTSELECTORGETCOMCERTSELPARAMSFAILED,PKIX_CertSelector_GetComCertSelParams failed,0),
PKIX_ERRORENTRY(CERTSELECTORGETCOMMONCERTSELECTORPARAMFAILED,PKIX_CertSelector_GetCommonCertSelectorParam failed,0),
PKIX_ERRORENTRY(CERTSELECTORGETCOMMONCERTSELECTORPARAMSFAILED,PKIX_CertSelector_GetCommonCertSelectorParams failed,0),
PKIX_ERRORENTRY(CERTSELECTORGETMATCHCALLBACKFAILED,PKIX_CertSelector_GetMatchCallback failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHAUTHKEYIDFAILED,pkix_CertSelector_Match_AuthKeyId failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHBASICCONSTRAINTFAILED,pkix_CertSelector_Match_BasicConstraint failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCALLBACKFAILED,PKIX_CertSelector_MatchCallback failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTIFICATEVALIDFAILED,pkix_CertSelector_Match_CertificateValid failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTISSUERFAILED,cert does not match issuer name,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTOBJECTFAILED,cert does not match cert object,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTSERIALNUMFAILED,cert does not match serial number,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTSUBJECTFAILED,cert does not match subject name,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTVERSIONFAILED,cert does not match cert version,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHEXTENDEDKEYUSAGEFAILED,pkix_CertSelector_Match_ExtendedKeyUsage failed,SEC_ERROR_INADEQUATE_CERT_TYPE),
PKIX_ERRORENTRY(CERTSELECTORMATCHFAILED,certSelectorMatch failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHKEYUSAGEFAILED,pkix_CertSelector_Match_KeyUsage failed,SEC_ERROR_INADEQUATE_KEY_USAGE),
PKIX_ERRORENTRY(CERTSELECTORMATCHNAMECONSTRAINTSFAILED,pkix_CertSelector_Match_NameConstraints failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHPATHTONAMESFAILED,pkix_CertSelector_Match_PathToNames failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHPOLICIESFAILED,pkix_CertSelector_Match_Policies failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJALTNAMESFAILED,pkix_CertSelector_Match_SubjAltNames failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJKEYIDFAILED,pkix_CertSelector_Match_SubjKeyId failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJPKALGIDFAILED,pkix_CertSelector_Match_SubjPKAlgId failed,0),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJPUBKEYFAILED,pkix_CertSelector_Match_SubjPubKey failed,0),
PKIX_ERRORENTRY(CERTSELECTORSELECTFAILED,pkix_CertSelector_Select failed,0),
PKIX_ERRORENTRY(CERTSELECTORSETCOMMONCERTSELECTORPARAMSFAILED,PKIX_CertSelector_SetCommonCertSelectorParams failed,0),
PKIX_ERRORENTRY(CERTSETASTRUSTANCHORFAILED, PKIX_PL_Cert_SetAsTrustAnchor failed, 0),
PKIX_ERRORENTRY(CERTSETCACHEFLAGFAILED,PKIX_PL_Cert_SetCacheFlag failed,0),
PKIX_ERRORENTRY(CERTSETTRUSTCERTSTOREFAILED,PKIX_PL_Cert_SetTrustCertStore failed,0),
PKIX_ERRORENTRY(CERTSTORECERTCONTINUEFAILED,PKIX_CertStore_CertContinue failed,0),
PKIX_ERRORENTRY(CERTSTORECERTCONTINUEFUNCTIONFAILED,PKIX_CertStore_CertContinueFunction failed,0),
PKIX_ERRORENTRY(CERTSTORECREATEFAILED,PKIX_CertStore_Create failed,0),
PKIX_ERRORENTRY(CERTSTORECRLCONTINUEFAILED,PKIX_CertStore_CrlContinue failed,0),
PKIX_ERRORENTRY(CERTSTOREEQUALSFAILED,pkix_CertStore_Equals failed,0),
PKIX_ERRORENTRY(CERTSTORECRLCHECKFAILED,Fail to check cert crl revocation,0),
PKIX_ERRORENTRY(CERTSTOREGETCHECKREVBYCRLFAILED,Can not get revocation check function,0),
PKIX_ERRORENTRY(CERTSTOREFAILTOIMPORTCRLLIST,Fail to import crls,0),
PKIX_ERRORENTRY(CERTSTOREGETCERTCALLBACKFAILED,PKIX_CertStore_GetCertCallback failed,0),
PKIX_ERRORENTRY(CERTSTOREGETCERTSTORECACHEFLAGFAILED,PKIX_CertStore_GetCertStoreCacheFlag failed,0),
PKIX_ERRORENTRY(CERTSTOREGETCERTSTORECONTEXTFAILED,PKIX_CertStore_GetCertStoreContext failed,0),
PKIX_ERRORENTRY(CERTSTOREGETCRLCALLBACKFAILED,PKIX_CertStore_GetCRLCallback failed,0),
PKIX_ERRORENTRY(CERTSTOREGETLOCALFLAGFAILED,PKIX_CertStore_GetLocalFlag failed,0),
PKIX_ERRORENTRY(CERTSTOREGETTRUSTCALLBACKFAILED,PKIX_CertStore_GetTrustCallback failed,0),
PKIX_ERRORENTRY(CERTSTOREHASHCODEFAILED,pkix_CertStore_Hashcode failed,0),
PKIX_ERRORENTRY(CERTTOSTRINGFAILED,PKIX_PL_Cert_ToString failed,0),
PKIX_ERRORENTRY(CERTTOSTRINGHELPERFAILED,pkix_pl_Cert_ToString_Helper failed,0),
PKIX_ERRORENTRY(CERTVERIFYCERTTYPEFAILED,PKIX_PL_Cert_VerifyCertAndKeyType failed,0),
PKIX_ERRORENTRY(CERTVERIFYKEYUSAGEFAILED,PKIX_PL_Cert_VerifyKeyUsage failed,0),
PKIX_ERRORENTRY(CERTVERIFYSIGNATUREFAILED,PKIX_PL_Cert_VerifySignature failed,0),
PKIX_ERRORENTRY(CHAINVERIFYCALLBACKFAILED,Chain rejected by Application Callback,SEC_ERROR_APPLICATION_CALLBACK_ERROR),
PKIX_ERRORENTRY(CHECKCERTAGAINSTANCHORFAILED,pkix_CheckCertAgainstAnchor failed,0),
PKIX_ERRORENTRY(CHECKCERTFAILED,pkix_CheckCert failed,0),
PKIX_ERRORENTRY(CHECKCHAINFAILED,pkix_CheckChain failed,0),
PKIX_ERRORENTRY(CHECKTRUSTCALLBACKFAILED,CheckTrustCallback failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTOREPOPULATECERTFAILED,pkix_pl_CollectionCertStoreContext_PopulateCert failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTOREPOPULATECRLFAILED,pkix_pl_CollectionCertStoreContext_PopulateCrl failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTCREATECERTFAILED,pkix_pl_CollectionCertStoreContext_CreateCert failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTCREATECRLFAILED,pkix_pl_CollectionCertStoreContext_CreateCRL failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTGETSELECTCERTFAILED,pkix_pl_CollectionCertStoreContext_GetSelectCert failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTGETSELECTCRLFAILED,pkix_pl_CollectionCertStoreContext_GetSelectCRL failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTPOPULATECERTFAILED,pkix_pl_CollectionCertStoreContext_PopulateCert failed,0),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTPOPULATECRLFAILED,pkix_pl_CollectionCertStoreContext_PopulateCRL failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSCREATEFAILED,PKIX_ComCertSelParams_Create failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETAUTHORITYKEYIDENTIFIERFAILED,PKIX_ComCertSelParams_GetAuthorityKeyIdentifier failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETBASICCONSTRAINTSFAILED,PKIX_ComCertSelParams_GetBasicConstraints failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETCERTIFICATEFAILED,PKIX_ComCertSelParams_GetCertificate failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETCERTIFICATEVALIDFAILED,PKIX_ComCertSelParams_GetCertificateValid failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETEXTENDEDKEYUSAGEFAILED,PKIX_ComCertSelParams_GetExtendedKeyUsage failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETISSUERFAILED,PKIX_ComCertSelParams_GetIssuer failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETKEYUSAGEFAILED,PKIX_ComCertSelParams_GetKeyUsage failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETLEAFCERTFLAGFAILED,PKIX_ComCertSelParams_GetLeafCertFlag failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETMATCHALLSUBJALTNAMESFAILED,PKIX_ComCertSelParams_GetMatchAllSubjAltNames failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETNAMECONSTRAINTSFAILED,PKIX_ComCertSelParams_GetNameConstraints failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETPATHTONAMESFAILED,PKIX_ComCertSelParams_GetPathToNames failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETPOLICYFAILED,PKIX_ComCertSelParams_GetPolicy failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSERIALNUMBERFAILED,PKIX_ComCertSelParams_GetSerialNumber failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJALTNAMESFAILED,PKIX_ComCertSelParams_GetSubjAltNames failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJECTFAILED,PKIX_ComCertSelParams_GetSubject failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJKEYIDENTIFIERFAILED,PKIX_ComCertSelParams_GetSubjKeyIdentifier failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJPKALGIDFAILED,PKIX_ComCertSelParams_GetSubjPKAlgId failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJPUBKEYFAILED,PKIX_ComCertSelParams_GetSubjPubKey failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETVERSIONFAILED,PKIX_ComCertSelParams_GetVersion failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETBASICCONSTRAINTSFAILED,PKIX_ComCertSelParams_SetBasicConstraints failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETCERTIFICATEFAILED,PKIX_ComCertSelParams_SetCertificate failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETCERTIFICATEVALIDFAILED,PKIX_ComCertSelParams_SetCertificateValid failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETEXTKEYUSAGEFAILED,PKIX_ComCertSelParams_SetExtendedKeyUsage failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETKEYUSAGEFAILED,PKIX_ComCertSelParams_SetKeyUsage failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETLEAFCERTFLAGFAILED,PKIX_ComCertSelParams_SetLeafCertFlag failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETNISTPOLICYENABLEDFAILED,PKIX_ComCertSelParams_SetNISTPolicyEnabled failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETPATHTONAMESFAILED,PKIX_ComCertSelParams_SetPathToNames failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETSUBJECTFAILED,PKIX_ComCertSelParams_SetSubject failed,0),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETSUBJKEYIDENTIFIERFAILED,PKIX_ComCertSelParams_SetSubjKeyIdentifier failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSADDISSUERNAMEFAILED,PKIX_ComCRLSelParams_AddIssuerName failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSCREATEFAILED,PKIX_ComCRLSelParams_Create failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSEQUALSFAILED,pkix_ComCRLSelParams_Equals failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETDATEANDTIMEFAILED,PKIX_ComCRLSelParams_GetDateAndTime failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETISSUERNAMESFAILED,PKIX_ComCRLSelParams_GetIssuerNames failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETMAXCRLNUMBERFAILED,PKIX_ComCRLSelParams_GetMaxCRLNumber failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETMINCRLNUMBERFAILED,PKIX_ComCRLSelParams_GetMinCRLNumber failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETNISTPOLICYENABLEDFAILED,PKIX_ComCRLSelParams_GetNISTPolicyEnabled failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSSETCERTFAILED,PKIX_ComCRLSelParams_SetCertificateChecking failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSSETDATEANDTIMEFAILED,PKIX_ComCRLSelParams_SetDateAndTime failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSTOSTRINGFAILED,pkix_ComCRLSelParams_ToString failed,0),
PKIX_ERRORENTRY(COMCRLSELPARAMSTOSTRINGHELPERFAILED,pkix_ComCRLSelParams_ToString_Helper failed,0),
PKIX_ERRORENTRY(COMPARATORCALLBACKFAILED,comparator callback failed,0),
PKIX_ERRORENTRY(CONTENTTYPENOTPKCS7MIME,Content type is not application/pkcs7-mime,0),
PKIX_ERRORENTRY(CONTENTTYPENOTPKIXCRL,Content type is not application/pkix-crl,SEC_ERROR_BAD_HTTP_RESPONSE),
PKIX_ERRORENTRY(COULDNOTALLOCATEMEMORY,Could not allocate memory,0),
PKIX_ERRORENTRY(COULDNOTALLOCATENEWSTRINGOBJECT,Could not allocate new string object,0),
PKIX_ERRORENTRY(COULDNOTAPPENDCHILDTOPARENTSPOLICYNODELIST,Could not append child to parent PolicyNode list,0),
PKIX_ERRORENTRY(COULDNOTAPPENDCHILDTOPARENTSVERIFYNODELIST,Could not append child to parent VerifyNode list,0),
PKIX_ERRORENTRY(COULDNOTCREATEAIAMGROBJECT,Could not create AiaMgr object,0),
PKIX_ERRORENTRY(COULDNOTCREATEBASICCONSTRAINTSSTATEOBJECT,Could not create basic constraints state object,0),
PKIX_ERRORENTRY(COULDNOTCREATEBUILDPARAMSOBJECT,Could not create build params object,0),
PKIX_ERRORENTRY(COULDNOTCREATEBUILDRESULTOBJECT,Could not create build result object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTBASICCONSTRAINTSOBJECT,Could not create a CertBasicConstraints object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTCHAINCHECKEROBJECT,Could not create cert chain checker object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTNAMECONSTRAINTSOBJECT,Could not create CertNameConstraints object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTPOLICYINFOOBJECT,Could not create a CertPolicyInfo object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTPOLICYMAPOBJECT,Could not create a CertPolicyMap object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTPOLICYQUALIFIEROBJECT,Could not create a CertPolicyQualifier object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTSELECTOROBJECT,Could not create cert selector object,0),
PKIX_ERRORENTRY(COULDNOTCREATECERTSTOREOBJECT,Could not create CertStore object,0),
PKIX_ERRORENTRY(COULDNOTCREATECOLLECTIONCERTSTORECONTEXTOBJECT,Could not create CollectionCertStoreContext object,0),
PKIX_ERRORENTRY(COULDNOTCREATECOMMONCERTSELPARAMSOBJECT,Could not create common certsel params object,0),
PKIX_ERRORENTRY(COULDNOTCREATECOMMONCRLSELECTORPARAMSOBJECT,Could not create common crl selector params object,0),
PKIX_ERRORENTRY(COULDNOTCREATECRLENTRYOBJECT,Could not create CRLENTRY object,0),
PKIX_ERRORENTRY(COULDNOTCREATECRLOBJECT,Could not create CRL object,0),
PKIX_ERRORENTRY(COULDNOTCREATECRLSELECTOROBJECT,Could not create CRLSelector object,0),
PKIX_ERRORENTRY(COULDNOTCREATECRLCHECKEROBJECT,Could not create CRLChecker object,0),
PKIX_ERRORENTRY(COULDNOTCREATEOCSPCHECKEROBJECT,Could not create OcspChecker object,0),
PKIX_ERRORENTRY(COULDNOTCREATEREVOCATIONMETHODOBJECT,Could not create RevocationMethod object,0),
PKIX_ERRORENTRY(COULDNOTCREATEDEFAULTREVOCATIONCHECKEROBJECT,Could not create DefaultRevocationChecker object,0),
PKIX_ERRORENTRY(COULDNOTCREATEEKUCHECKERSTATEOBJECT,Could not create EkuCheckerState object,0),
PKIX_ERRORENTRY(COULDNOTCREATEFORWARDBUILDERSTATEOBJECT,Could not create forwardBuilder state object,0),
PKIX_ERRORENTRY(COULDNOTCREATEHASHTABLEOBJECT,Could not create HashTable object,0),
PKIX_ERRORENTRY(COULDNOTCREATEHTTPDEFAULTCLIENTOBJECT,Could not create HttpDefaultClient object,0),
PKIX_ERRORENTRY(COULDNOTCREATEINFOACCESSOBJECT,Could not create InfoAccess object,0),
PKIX_ERRORENTRY(COULDNOTCREATELDAPDEFAULTCLIENTOBJECT,Could not create LdapDefaultClient object,0),
PKIX_ERRORENTRY(COULDNOTCREATELOCKOBJECT,Could not create lock object,0),
PKIX_ERRORENTRY(COULDNOTCREATELOGGEROBJECT,Could not create Logger object,0),
PKIX_ERRORENTRY(COULDNOTCREATENAMECONSTRAINTSCHECKERSTATEOBJECT,Could not create NameConstraintsCheckerState object,0),
PKIX_ERRORENTRY(COULDNOTCREATENSSDN,Could not create NSS DN,0),
PKIX_ERRORENTRY(COULDNOTCREATEOBJECT,Could not create object,0),
PKIX_ERRORENTRY(COULDNOTCREATEOBJECTSTORAGE,Could not create object storage,0),
PKIX_ERRORENTRY(COULDNOTCREATEPOLICYCHECKERSTATEOBJECT,Could not create policyChecker state object,0),
PKIX_ERRORENTRY(COULDNOTCREATEPOLICYNODEOBJECT,Could not create a PolicyNode object,0),
PKIX_ERRORENTRY(COULDNOTCREATEPROCESSINGPARAMSOBJECT,Could not create processing params object,0),
PKIX_ERRORENTRY(COULDNOTCREATERESOURCELIMITOBJECT,Could not create ResourceLimit object,0),
PKIX_ERRORENTRY(COULDNOTCREATESIGNATURECHECKERSTATEOBJECT,Could not create SignatureCheckerState object,0),
PKIX_ERRORENTRY(COULDNOTCREATESOCKETOBJECT,Could not create Socket object,0),
PKIX_ERRORENTRY(COULDNOTCREATESTRING,Could not create string,0),
PKIX_ERRORENTRY(COULDNOTCREATETARGETCERTCHECKERSTATEOBJECT,Could not create target cert checker state object,0),
PKIX_ERRORENTRY(COULDNOTCREATETRUSTANCHOROBJECT,Could not create trust anchor object,0),
PKIX_ERRORENTRY(COULDNOTCREATEVALIDATEPARAMSOBJECT,Could not create validate params object,0),
PKIX_ERRORENTRY(COULDNOTCREATEVALIDATERESULTOBJECT,Could not create validate result object,0),
PKIX_ERRORENTRY(COULDNOTCREATEVERIFYNODEOBJECT,Could not create a VerifyNode object,0),
PKIX_ERRORENTRY(COULDNOTCREATEX500NAMEOBJECT,Could not create X500Name object,0),
PKIX_ERRORENTRY(COULDNOTGETFIRSTOBJECTTYPE,Could not get first object type,0),
PKIX_ERRORENTRY(COULDNOTGETSECONDOBJECTTYPE,Could not get second object type,0),
PKIX_ERRORENTRY(COULDNOTGETTYPEOFSECONDARGUMENT,Could not get type of second argument,0),
PKIX_ERRORENTRY(COULDNOTLOOKUPINHASHTABLE,Could not lookup in hashtable,0),
PKIX_ERRORENTRY(COULDNOTMALLOCNEWKEY,Could not malloc new key,0),
PKIX_ERRORENTRY(COULDNOTTESTWHETHERKEYSEQUAL,Could not test whether keys are equal,0),
PKIX_ERRORENTRY(CREATECERTFAILED,CreateCert failed,0),
PKIX_ERRORENTRY(CREATECRLSELECTORDUPLICATEOBJECTFAILED,Create CRLSelector Duplicate Object failed,0),
PKIX_ERRORENTRY(CREATEPROCESSINGPARAMSFAILED,Failed to create processing parameters,0),
PKIX_ERRORENTRY(CRLCHECKERCREATEFAILED,pkix_CRLChecker_Create failed,0),
PKIX_ERRORENTRY(CRLCHECKERINITIALIZEFAILED,pkix_CRLChecker_Initialize failed,0),
PKIX_ERRORENTRY(CRLCHECKERNOLOCALCERTSTOREFOUND,No local cert store found, 0),
PKIX_ERRORENTRY(CRLCHECKERSETSELECTORFAILED,pkix_CRLChecker_SetSelector failed,0),
PKIX_ERRORENTRY(CRLCREATEFAILED,PKIX_PL_CRL_Create failed,0),
PKIX_ERRORENTRY(CRLCREATETOLISTFAILED,pkix_pl_CRL_CreateToList failed,0),
PKIX_ERRORENTRY(CRLCREATEWITHSIGNEDCRLFAILED,pkix_pl_CRL_CreateWithSignedCRL failed,0),
PKIX_ERRORENTRY(CRLCRITICALEXTENSIONOIDSNOTPROCESSED,CRL Critical Extension OIDs not processed,0),
PKIX_ERRORENTRY(CRLDPCREATEFAILED, Failed to create CRL DP,0),
PKIX_ERRORENTRY(CRLENTRYCREATEFAILED,pkix_pl_CRLEntry_Create failed,0),
PKIX_ERRORENTRY(CRLENTRYCRITICALEXTENSIONWASNOTPROCESSED,CRLEntry Critical Extension was not processed,0),
PKIX_ERRORENTRY(CRLENTRYEXTENSIONSEQUALSFAILED,PKIX_PL_CRLEntry_Extensions_Equals failed,0),
PKIX_ERRORENTRY(CRLENTRYEXTENSIONSHASHCODEFAILED,pkix_pl_CRLEntry_Extensions_Hashcode failed,0),
PKIX_ERRORENTRY(CRLENTRYGETCRITICALEXTENSIONOIDSFAILED,PKIX_PL_CRLEntry_GetCriticalExtensionOIDs failed,0),
PKIX_ERRORENTRY(CRLENTRYGETCRLENTRYREASONCODEFAILED,PKIX_PL_CRLEntry_GetCRLEntryReasonCode failed,0),
PKIX_ERRORENTRY(CRLENTRYTOSTRINGHELPERFAILED,pkix_pl_CRLEntry_ToString_Helper failed,0),
PKIX_ERRORENTRY(CRLGETCRITICALEXTENSIONOIDSFAILED,PKIX_PL_CRL_GetCriticalExtensionOIDs failed,0),
PKIX_ERRORENTRY(CRLGETCRLENTRIESFAILED,pkix_pl_CRL_GetCRLEntries failed,0),
PKIX_ERRORENTRY(CRLGETCRLENTRYFORSERIALNUMBERFAILED,PKIX_PL_CRL_GetCRLEntryForSerialNumber failed,0),
PKIX_ERRORENTRY(CRLGETCRLNUMBERFAILED,PKIX_PL_CRL_GetCRLNumber failed,0),
PKIX_ERRORENTRY(CRLGETISSUERFAILED,PKIX_PL_CRL_GetIssuer failed,0),
PKIX_ERRORENTRY(CRLGETPARTITIONEDFLAGFAILED,PKIX_PL_CRL_IsPartitioned failed,0),
PKIX_ERRORENTRY(CRLGETSIGNATUREALGIDFAILED,pkix_pl_CRL_GetSignatureAlgId failed,0),
PKIX_ERRORENTRY(CRLGETVERSIONFAILED,pkix_pl_CRL_GetVersion failed,0),
PKIX_ERRORENTRY(CRLISSUECERTEXPIRED,CRL issue cert has expired,0),
PKIX_ERRORENTRY(CRLMAXNUMBERRANGEMATCHFAILED,CRL MaxNumber Range Match Failed,0),
PKIX_ERRORENTRY(CRLSELECTORCREATEFAILED,PKIX_CRLSelector_Create failed,0),
PKIX_ERRORENTRY(CRLSELECTORFAILED,crlSelector failed,0),
PKIX_ERRORENTRY(CRLSELECTORGETCOMCERTSELPARAMSFAILED,PKIX_CRLSelector_GetComCertSelParams failed,0),
PKIX_ERRORENTRY(CRLSELECTORGETMATCHCALLBACKFAILED,PKIX_CRLSelector_GetMatchCallback failed,0),
PKIX_ERRORENTRY(CRLSELECTORMATCHCALLBACKFAILED,PKIX_CRLSelector_MatchCallback failed,0),
PKIX_ERRORENTRY(CRLSELECTORMATCHFAILED,crlSelectorMatch failed,0),
PKIX_ERRORENTRY(CRLSELECTORSELECTFAILED,pkix_CRLSelector_Select failed,0),
PKIX_ERRORENTRY(CRLSELECTORSETCOMMONCRLSELECTORPARAMSFAILED,PKIX_CRLSelector_SetCommonCRLSelectorParams failed,0),
PKIX_ERRORENTRY(CRLSELECTORTOSTRINGHELPERFAILED,pkix_CRLSelector_ToString_Helper failed,0),
PKIX_ERRORENTRY(CRLTOSTRINGHELPERFAILED,pkix_pl_CRL_ToString_Helper failed,0),
PKIX_ERRORENTRY(CRLVERIFYUPDATETIMEFAILED,pkix_pl_CRL_VerifyUpdateTime failed,0),
PKIX_ERRORENTRY(DATECREATECURRENTOFFBYSECONDSFAILED,PKIX_PL_Date_Create_CurrentOffBySeconds failed,0),
PKIX_ERRORENTRY(DATECREATEFROMPRTIMEFAILED,pkix_pl_Date_CreateFromPRTime failed,0),
PKIX_ERRORENTRY(DATECREATEUTCTIMEFAILED,PKIX_PL_Date_Create_UTCTime failed,0),
PKIX_ERRORENTRY(DATEDERTIMETOPRTIMEFAILED,Fail to convert encoded time to PRTime,0),
PKIX_ERRORENTRY(DATEEQUALSFAILED,PKIX_PL_Date_Equals failed,0),
PKIX_ERRORENTRY(DATEGETPRTIMEFAILED,pkix_pl_Date_GetPRTime failed,0),
PKIX_ERRORENTRY(DATEHASHCODEFAILED,PKIX_PL_Date_Hashcode failed,0),
PKIX_ERRORENTRY(DATETOSTRINGFAILED,PKIX_Date_ToString failed,0),
PKIX_ERRORENTRY(DATETOSTRINGHELPERFAILED,pkix_pl_Date_ToString_Helper failed,0),
PKIX_ERRORENTRY(DECIPHERONLYKEYUSAGENOTSUPPORTED,decipherOnly key usage not supported,0),
PKIX_ERRORENTRY(DECODINGCERTNAMECONSTRAINTSFAILED,Decoding Cert NameConstraints failed,0),
PKIX_ERRORENTRY(DEFAULTREVCHECKERCREATEFAILED,pkix_DefaultRevChecker_Create failed,0),
PKIX_ERRORENTRY(DEFAULTREVCHECKERINITIALIZEFAILED,pkix_DefaultRevChecker_Initialize failed,0),
PKIX_ERRORENTRY(DEPTHWOULDEXCEEDRESOURCELIMITS,Depth would exceed Resource Limits,SEC_ERROR_OUT_OF_SEARCH_LIMITS),
PKIX_ERRORENTRY(DERASCIITOTIMEFAILED,DER_AsciiToTime failed,0),
PKIX_ERRORENTRY(DERDECODETIMECHOICEFAILED,DER_DecodeTimeChoice failed,0),
PKIX_ERRORENTRY(DERDECODETIMECHOICEFORLASTUPDATEFAILED,DER_DecodeTimeChoice for lastUpdate failed,0),
PKIX_ERRORENTRY(DERDECODETIMECHOICEFORNEXTUPDATEFAILED,DER_DecodeTimeChoice for nextUpdate failed,0),
PKIX_ERRORENTRY(DERENCODETIMECHOICEFAILED,DER_EncodeTimeChoice failed,0),
PKIX_ERRORENTRY(DERGENERALIZEDDAYTOASCIIFAILED,DER_GeneralizedDayToAscii failed,0),
PKIX_ERRORENTRY(DERTIMETOUTCTIMEFAILED,DER_TimeToUTCTime failed,0),
PKIX_ERRORENTRY(DERUTCTIMETOASCIIFAILED,DER_UTCTimeToAscii failed,0),
PKIX_ERRORENTRY(DESTROYSPKIFAILED,pkix_pl_DestroySPKI failed,0),
PKIX_ERRORENTRY(DIRECTORYNAMECREATEFAILED,pkix_pl_DirectoryName_Create failed,0),
PKIX_ERRORENTRY(DUPLICATEIMMUTABLEFAILED,pkix_duplicateImmutable failed,0),
PKIX_ERRORENTRY(CANNOTSORTIMMUTABLELIST,pkix_List_BubbleSort can not sort immutable list,0),
PKIX_ERRORENTRY(EKUCHECKERGETREQUIREDEKUFAILED,pkix_pl_EkuChecker_GetRequiredEku failed,0),
PKIX_ERRORENTRY(EKUCHECKERINITIALIZEFAILED,PKIX_PL_EkuChecker_Initialize failed,0),
PKIX_ERRORENTRY(EKUCHECKERSTATECREATEFAILED,pkix_pl_EkuCheckerState_Create failed,0),
PKIX_ERRORENTRY(ENABLEREVOCATIONWITHOUTCERTSTORE,Enable Revocation without CertStore,0),
PKIX_ERRORENTRY(ERRORALLOCATINGMONITORLOCK,Error Allocating MonitorLock,0),
PKIX_ERRORENTRY(ERRORALLOCATINGRWLOCK,Error Allocating RWLock,0),
PKIX_ERRORENTRY(ERRORCREATINGCHILDSTRING,Error creating child string,0),
PKIX_ERRORENTRY(ERRORCREATINGFORMATSTRING,Error creating format string,0),
PKIX_ERRORENTRY(ERRORCREATINGINDENTSTRING,Error creating indent string,0),
PKIX_ERRORENTRY(ERRORCREATINGITEMSTRING,Error creating item string,0),
PKIX_ERRORENTRY(ERRORCREATINGLISTITEM,Error Creating List Item,0),
PKIX_ERRORENTRY(ERRORCREATINGSUBTREESTRING,Error creating subtree string,0),
PKIX_ERRORENTRY(ERRORCREATINGTABLELOCK,Error creating table lock,0),
PKIX_ERRORENTRY(ERRORFINDINGORPROCESSINGURI,Error finding or processing URI,0),
PKIX_ERRORENTRY(ERRORGETTINGCAUSESTRING,Error getting cause string,0),
PKIX_ERRORENTRY(ERRORGETTINGCLASSTABLEENTRY,Error getting class table entry,0),
PKIX_ERRORENTRY(ERRORGETTINGHASHCODE,Error getting hashcode,0),
PKIX_ERRORENTRY(ERRORGETTINGSECONDOBJECTTYPE,Error getting second object type,0),
PKIX_ERRORENTRY(ERRORINBYTEARRAYHASHCODE,Error in PKIX_PL_ByteArray_Hashcode,0),
PKIX_ERRORENTRY(ERRORINGETTINGDESTRUCTOR,Error in getting destructor,0),
PKIX_ERRORENTRY(ERRORINHASH,Error in pkix_hash,0),
PKIX_ERRORENTRY(ERRORINLISTHASHCODE,Error in PKIX_List_Hashcode,0),
PKIX_ERRORENTRY(ERRORINOBJECTDEFINEDESTROY,Error in object-defined destroy callback,0),
PKIX_ERRORENTRY(ERRORINOIDHASHCODE,Error in PKIX_PL_OID_Hashcode,0),
PKIX_ERRORENTRY(ERRORINRECURSIVEEQUALSCALL,Error in recursive equals call,0),
PKIX_ERRORENTRY(ERRORINSINGLEPOLICYNODETOSTRING,Error in pkix_SinglePolicyNode_ToString,0),
PKIX_ERRORENTRY(ERRORINSINGLEVERIFYNODETOSTRING,Error in pkix_SingleVerifyNode_ToString,0),
PKIX_ERRORENTRY(ERRORINSPRINTF,Error in PKIX_PL_Sprintf,0),
PKIX_ERRORENTRY(ERRORINSTRINGCREATE,Error in PKIX_PL_String_Create,0),
PKIX_ERRORENTRY(ERRORLOCKINGOBJECT,Error locking object,0),
PKIX_ERRORENTRY(ERRORTOSTRINGFAILED,PKIX_Error_ToString failed,0),
PKIX_ERRORENTRY(ERRORTRAVERSINGBUCKET,Error traversing bucket,0),
PKIX_ERRORENTRY(ERRORUNLOCKINGMUTEX,Error unlocking mutex,0),
PKIX_ERRORENTRY(ERRORUNLOCKINGOBJECT,Error unlocking object,0),
PKIX_ERRORENTRY(ESCASCIITOUTF16FAILED,pkix_EscASCII_to_UTF16 failed,0),
PKIX_ERRORENTRY(EXPIRATIONCHECKERINITIALIZEFAILED,pkix_ExpirationChecker_Initialize failed,0),
PKIX_ERRORENTRY(EXTENDEDKEYUSAGECHECKINGFAILED,Extended Key Usage Checking failed,SEC_ERROR_INADEQUATE_CERT_TYPE),
PKIX_ERRORENTRY(EXTENDEDKEYUSAGEUSEROBJECT,Extended Key Usage User Object,0),
PKIX_ERRORENTRY(EXTRACTPARAMETERSFAILED,pkix_ExtractParameters failed,0),
PKIX_ERRORENTRY(FAILEDINENCODINGSEARCHREQUEST,failed in encoding searchRequest,SEC_ERROR_FAILED_TO_ENCODE_DATA),
PKIX_ERRORENTRY(FAILEDTODECODECRL, failed to decode CRL,SEC_ERROR_BAD_DER),
PKIX_ERRORENTRY(FAILEDTOGETNSSTRUSTANCHORS,Failed to get nss trusted roots,0),
PKIX_ERRORENTRY(FAILEDTOGETTRUST, failed to get trust from the cert,0),
PKIX_ERRORENTRY(FAILTOREMOVEDPFROMLIST, failed to remove dp from the list,0),
PKIX_ERRORENTRY(FAILTOSELECTCERTSFROMANCHORS,failed to select certs from anchors,0),
PKIX_ERRORENTRY(FAILUREHASHINGCERT,Failure hashing Cert,0),
PKIX_ERRORENTRY(FAILUREHASHINGERROR,Failure hashing Error,0),
PKIX_ERRORENTRY(FAILUREHASHINGLISTEXPECTEDPOLICYSET,Failure hashing PKIX_List expectedPolicySet,0),
PKIX_ERRORENTRY(FAILUREHASHINGLISTQUALIFIERSET,Failure hashing PKIX_List qualifierSet,0),
PKIX_ERRORENTRY(FAILUREHASHINGOIDVALIDPOLICY,Failure hashing PKIX_PL_OID validPolicy,0),
PKIX_ERRORENTRY(FANOUTEXCEEDSRESOURCELIMITS,Fanout exceeds Resource Limits,0),
PKIX_ERRORENTRY(FETCHINGCACHEDCRLFAILED,Fetching Cached CRLfailed,0),
PKIX_ERRORENTRY(FILLINPROCESSINGPARAMSFAILED,Fail to fill in parameters,0),
PKIX_ERRORENTRY(FILLINRETURNRESULTSFAILED,Fail to fill in return results,0),
PKIX_ERRORENTRY(FIRSTARGUMENTNOTBYTEARRAY,FirstObject is not a ByteArray,0),
PKIX_ERRORENTRY(FIRSTARGUMENTNOTCERTBASICCONSTRAINTSOBJECT,First argument is not a CertBasicConstraints Object,0),
PKIX_ERRORENTRY(FIRSTDOUBLEHEXMUSTNOTBE00,First DoubleHex MUST NOT be 00,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(FIRSTFIELDMUSTBEBETWEEN02,First field must be between 0-2,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTANOCSPRESPONSE,FirstObject is not an OcspResponse,0),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTLDAPREQUEST,FirstObject is not a LdapRequest,0),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTLDAPRESPONSE,FirstObject is not a LdapResponse,0),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTOCSPREQUEST,FirstObject is not a OcspRequest,0),
PKIX_ERRORENTRY(FIRSTOBJECTARGUMENTNOTANX500NAME,FirstObject is not an X500Name,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTANERROROBJECT,FirstObject is not an Error object,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTBIGINT,FirstObject not a BigInt,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTBUILDPARAMS,FirstObject is not a BuildParams,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTBUILDRESULT,FirstObject is not a BuildResult,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERT,FirstObject is not a Cert,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTBASICCONSTRAINTS,FirstObject is not a CertBasicConstraints,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTNAMECONSTRAINTS,FirstObject is not a CertNameConstraints,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTPOLICYINFO,FirstObject is not a CertPolicyInfo,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTPOLICYMAP,FirstObject is not a CertPolicyMap,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTPOLICYQUALIFIER,FirstObject is not a CertPolicyQualifier,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCOMCRLSELPARAMS,FirstObject is not a ComCRLSelParams,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCRL,FirstObject is not a CRL,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCRLENTRY,FirstObject is not a CRLEntry,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCRLSELECTOR,FirstObject is not a CRLSelector,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTDATE,FirstObject is not a Date,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTERROR,FirstObject is not an Error,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTGENERALNAME,FirstObject is not a GeneralName,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTINFOACCESS,FirstObject is not a InfoAccess,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTLIST,FirstObject is not a List,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTLOGGER,FirstObject is not a Logger,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTPOLICYNODE,FirstObject is not a PolicyNode,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTPROCESSINGPARAMS,FirstObject is not a ProcessingParams,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTPUBLICKEY,FirstObject is not a PublicKey,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTRESOURCELIMITS,FirstObject is not a ResourceLimits,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTSTRING,FirstObject is not a String,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTTRUSTANCHOR,FirstObject is not a TrustAnchor,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTVALIDATEPARAMS,FirstObject is not a ValidateParams,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTVALIDATERESULT,FirstObject is not a ValidateResult,0),
PKIX_ERRORENTRY(FIRSTOBJECTNOTVERIFYNODE,FirstObject is not a VerifyNode,0),
PKIX_ERRORENTRY(FIRSTPUBKEYTYPENULLKEY,firstPubKeyType is nullKey,0),
PKIX_ERRORENTRY(FUNCTIONMUSTNOTBEUSED,Function MUST not be used,SEC_ERROR_LIBPKIX_INTERNAL),
PKIX_ERRORENTRY(FORWARDBUILDERSTATEDUMPSTATEFAILED,pkix_ForwardBuilderState_DumpState failed,0),
PKIX_ERRORENTRY(FORWARDBUILDERSTATEISIOPENDINGFAILED,pkix_ForwardBuilderState_IsIOPending failed,0),
PKIX_ERRORENTRY(FORWARDBUILDSTATECREATEFAILED,pkix_ForwardBuildState_Create failed,0),
PKIX_ERRORENTRY(FREEFAILED,PKIX_PL_Free failed,0),
PKIX_ERRORENTRY(GENERALNAMECREATEFAILED,pkix_pl_GeneralName_Create failed,0),
PKIX_ERRORENTRY(GENERALNAMEGETNSSGENERALNAMEFAILED,pkix_pl_GeneralName_GetNssGeneralName failed,0),
PKIX_ERRORENTRY(GENERALNAMESTRINGMISSINGDOUBLESLASH,GeneralName string missing double slash,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
PKIX_ERRORENTRY(GENERALNAMESTRINGMISSINGLOCATIONTYPE,GeneralName string missing location type,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
PKIX_ERRORENTRY(GENERALNAMESTRINGMISSINGSERVERSITE,GeneralName string missing server-site,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
PKIX_ERRORENTRY(GENERALNAMETOSTRINGFAILED,pkix_pl_GeneralName_ToString failed,0),
PKIX_ERRORENTRY(GENERALNAMETOSTRINGHELPERFAILED,pkix_pl_GeneralName_ToString_Helper failed,0),
PKIX_ERRORENTRY(GENERICCLIENTNOTANLDAPDEFAULTCLIENT,genericClient is not an LdapDefaultClient,0),
PKIX_ERRORENTRY(GETATTRIBUTESCALLEDFORNONENTRYMESSAGE,GetAttributes called for non-Entry message,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(GETCERTSFAILED,getCerts failed,0),
PKIX_ERRORENTRY(GETCRITICALEXTENSIONOIDSFAILED,pkix_GetCriticalExtensionOIDs failed,0),
PKIX_ERRORENTRY(GETCRLSFAILED,getCrls failed,0),
PKIX_ERRORENTRY(GETOIDTOKENFAILED,pkix_pl_getOIDToken failed,0),
PKIX_ERRORENTRY(GETPKIXERRORCODEFAILED,Get PKIX error code failed,0),
PKIX_ERRORENTRY(GETREQCERTIFICATEUSAGESFAILED,Fail to get required certificate usages,0),
PKIX_ERRORENTRY(GETRESULTCODECALLEDFORNONRESULTMESSAGE,GetResultCode called for non-Result message,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(GETRETCERTIFICATEUSAGESFAILED,Fail to get returned certificate usages,0),
PKIX_ERRORENTRY(GETTRUSTEDCERTLISTFAILED,Fail to get trusted cert list,0),
PKIX_ERRORENTRY(HASHFAILED,pkix_hash failed,0),
PKIX_ERRORENTRY(HASHTABLEADDFAILED,PKIX_PL_HashTable_Add failed,0),
PKIX_ERRORENTRY(HASHTABLECREATEFAILED,PKIX_PL_HashTable_Create failed,0),
PKIX_ERRORENTRY(HASHTABLELOOKUPFAILED,PKIX_PL_HashTable_Lookup failed,0),
PKIX_ERRORENTRY(HASHTABLEREMOVEFAILED,PKIX_PL_HashTable_Remove failed,0),
PKIX_ERRORENTRY(HELPERBYTES2ASCIIFAILED,pkix_pl_helperBytes2Ascii failed,0),
PKIX_ERRORENTRY(HELPERBYTES2ASCIINUMTOKENSZERO,pkix_pl_helperBytes2Ascii: numTokens is zero,0),
PKIX_ERRORENTRY(HTTPCERTSTORECREATEREQUESTSESSIONFAILED,pkix_pl_HttpCertStore_CreateRequestSession failed,0),
PKIX_ERRORENTRY(HTTPCERTSTORECREATEWITHASCIINAMEFAILED,PKIX_PL_HttpCertStore_CreateWithAsciiName failed,0),
PKIX_ERRORENTRY(HTTPCERTSTOREDECODECERTPACKAGEFAILED,pkix_pl_HttpCertStore_DecodeCertPackage failed,0),
PKIX_ERRORENTRY(HTTPCERTSTOREFINDSOCKETCONNECTIONFAILED,pkix_HttpCertStore_FindSocketConnection failed,0),
PKIX_ERRORENTRY(HTTPCERTSTOREPROCESSCERTRESPONSEFAILED,pkix_pl_HttpCertStore_ProcessCertResponse failed,0),
PKIX_ERRORENTRY(HTTPCERTSTOREPROCESSCRLRESPONSEFAILED,pkix_pl_HttpCertStore_ProcessCrlResponse failed,0),
PKIX_ERRORENTRY(HTTPCLIENTCREATESESSIONFAILED,HttpClient->CreateSession failed,0),
PKIX_ERRORENTRY(HTTPCLIENTININVALIDSTATE,HttpClient in invalid state,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTCONNECTCONTINUEFAILED,pkix_pl_HttpDefaultClient_ConnectContinue failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTCREATEFAILED,pkix_pl_HttpDefaultClient_Create failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTDISPATCHFAILED,pkix_pl_HttpDefaultClient_Dispatch failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTHDRCHECKCOMPLETEFAILED,pkix_pl_HttpDefaultClient_HdrCheckComplete failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTINILLEGALSTATE,HttpDefaultClient in illegal state,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVBODYCONTINUEFAILED,pkix_pl_HttpDefaultClient_RecvBodyContinue failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVBODYFAILED,pkix_pl_HttpDefaultClient_RecvBody failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVHDRCONTINUEFAILED,pkix_pl_HttpDefaultClient_RecvHdrContinue failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVHDRFAILED,pkix_pl_HttpDefaultClient_RecvHdr failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTSENDCONTINUEFAILED,pkix_pl_HttpDefaultClient_SendContinue failed,0),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTSENDFAILED,pkix_pl_HttpDefaultClient_Send failed,0),
PKIX_ERRORENTRY(HTTPSERVERERROR,HTTP Server Error,0),
PKIX_ERRORENTRY(ILLEGALCHARACTERINESCAPEDASCII,Illegal character in Escaped ASCII String,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(ILLEGALCHARACTERINOID,Illegal character in OID,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(ILLEGALDOTINOID,Illegal period in OID,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(ILLEGALSURROGATEPAIR,Illegal surrogate pair in EscapedASCII,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(ILLEGALUNICODECHARACTER,Illegal Unicode character in EscapedASCII,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(ILLEGALUSEOFAMP,Illegal use of ampersand character,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(IMPOSSIBLECRITERIONFORCRLQUERY,Impossible criterion for Crl Query,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(INDEXOUTOFBOUNDS,Index out of bounds,SEC_ERROR_LIBPKIX_INTERNAL),
PKIX_ERRORENTRY(INESCAPEDASCII,in EscapedASCII,0),
PKIX_ERRORENTRY(INFOACCESSCREATEFAILED,pkix_pl_InfoAccess_Create failed,0),
PKIX_ERRORENTRY(INFOACCESSCREATELISTFAILED,pkix_pl_InfoAccess_CreateList failed,0),
PKIX_ERRORENTRY(INFOACCESSGETLOCATIONFAILED,PKIX_PL_InfoAccess_GetLocation failed,0),
PKIX_ERRORENTRY(INFOACCESSGETLOCATIONTYPEFAILED,PKIX_PL_InfoAccess_GetLocationType failed,0),
PKIX_ERRORENTRY(INFOACCESSGETMETHODFAILED,PKIX_PL_InfoAccess_GetMethod failed,0),
#ifndef NSS_PKIX_NO_LDAP
PKIX_ERRORENTRY(INFOACCESSPARSELOCATIONFAILED,pkix_pl_InfoAccess_ParseLocation failed,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
#endif
PKIX_ERRORENTRY(INFOACCESSPARSETOKENSFAILED,pkix_pl_InfoAccess_ParseTokens failed,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
PKIX_ERRORENTRY(INITIALIZECHECKERSFAILED,pkix_InitializeCheckers failed,0),
PKIX_ERRORENTRY(INITIALIZEFAILED,PKIX_PL_Initialize failed,0),
PKIX_ERRORENTRY(INPUTLISTMUSTBEHEADER,Input List must be header,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(INPUTLISTSMUSTBELISTHEADERS,Input Lists must be list headers,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(INSUFFICIENTCRITERIAFORCERTQUERY,Insufficient criteria for Cert query,0),
PKIX_ERRORENTRY(INSUFFICIENTCRITERIAFORCRLQUERY,Insufficient criteria for Crl Query,0),
PKIX_ERRORENTRY(INTRUSTEDCERT,in Trusted Cert,0),
PKIX_ERRORENTRY(INVALIDCHARACTERINBIGINT,Invalid character in BigInt,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(INVALIDDERENCODINGFOROID,Invalid DER-encoding for OID,0),
PKIX_ERRORENTRY(INVALIDENCODINGOIDTOKENVALUETOOBIG,Invalid encoding: OID token value too big,0),
PKIX_ERRORENTRY(INVALIDPOLICYMAPPINGINCLUDESANYPOLICY,Invalid policyMapping includes anyPolicy,SEC_ERROR_INVALID_POLICY_MAPPING),
PKIX_ERRORENTRY(INVALIDREVOCATIONMETHOD,Invalid revocation method,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(INVALIDSIGNINGCERTINOCSPRESPONSE,Invalid signing Cert in OCSP response,SEC_ERROR_OCSP_INVALID_SIGNING_CERT),
PKIX_ERRORENTRY(INVALIDSTATUS,INVALID STATUS,0),
PKIX_ERRORENTRY(INVALIDSTORETYPEFORSETTINGCONFIGDIR,Invalid Store type for Setting ConfigDir,0),
PKIX_ERRORENTRY(IPADDRBYTES2ASCIIDATALENGTHZERO,pkix_pl_ipAddrBytes2Ascii: data length is zero,0),
PKIX_ERRORENTRY(IPADDRBYTES2ASCIIFAILED,pkix_pl_ipAddrBytes2Ascii failed,0),
PKIX_ERRORENTRY(ISCERTSELFISSUEDFAILED,pkix_IsCertSelfIssued failed,0),
PKIX_ERRORENTRY(ISCERTSELFISSUEFAILED,pkix_IsCertSelfIssue failed,0),
PKIX_ERRORENTRY(KEYUSAGEKEYCERTSIGNBITNOTON,Validation failed: KeyUsage KeyCertSign bit is not on,SEC_ERROR_CA_CERT_INVALID),
PKIX_ERRORENTRY(KEYUSAGEKEYCRLSIGNBITNOTON,Validation failed: KeyUsage CRLSign bit is not on,0),
PKIX_ERRORENTRY(LDAPCERTSTOREBUILDCERTLISTFAILED,pkix_pl_LdapCertStore_BuildCertList failed,0),
PKIX_ERRORENTRY(LDAPCERTSTOREBUILDCRLLISTFAILED,pkix_pl_LdapCertStore_BuildCrlList failed,0),
PKIX_ERRORENTRY(LDAPCERTSTOREDECODECROSSCERTPAIRFAILED,pkix_pl_LdapCertStore_DecodeCrossCertPair failed,0),
PKIX_ERRORENTRY(LDAPCERTSTOREDESTROYAVALISTFAILED,pkix_pl_LdapCertStore_DestroyAVAList failed,0),
PKIX_ERRORENTRY(LDAPCERTSTOREINILLEGALSTATE,LDAP CertStore in illegal state,0),
PKIX_ERRORENTRY(LDAPCERTSTOREMAKENAMEAVALISTFAILED,pkix_pl_LdapCertStore_MakeNameAVAList failed,0),
PKIX_ERRORENTRY(LDAPCLIENTINITIATEREQUESTFAILED,PKIX_PL_LdapClient_InitiateRequest failed,0),
PKIX_ERRORENTRY(LDAPCLIENTRESUMEREQUESTFAILED,PKIX_PL_LdapClient_ResumeRequest failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTABANDONCONTINUEFAILED,pkix_pl_LdapDefaultClient_AbandonContinue failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDCONTINUEFAILED,pkix_pl_LdapDefaultClient_BindContinue failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDFAILED,pkix_pl_LdapDefaultClient_Bind failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDRESPONSECONTINUEFAILED,pkix_pl_LdapDefaultClient_BindResponseContinue failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDRESPONSEFAILED,pkix_pl_LdapDefaultClient_BindResponse failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTCONNECTCONTINUEFAILED,pkix_pl_LdapDefaultClient_ConnectContinue failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTCREATEBYNAMEFAILED,PKIX_PL_LdapDefaultClient_CreateByName failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTCREATEHELPERFAILED,pkix_pl_LdapDefaultClient_CreateHelper failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTDECODEBINDRESPONSEFAILED,pkix_pl_LdapDefaultClient_DecodeBindResponse failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTDISPATCHFAILED,pkix_pl_LdapDefaultClient_Dispatch failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTINILLEGALSTATE,LDAP DefaultClient in illegal state,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEABANDONFAILED,pkix_pl_LdapDefaultClient_MakeAbandon failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEANDFILTERFAILED,pkix_pl_LdapDefaultClient_MakeAndFilter failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEBINDFAILED,pkix_pl_LdapDefaultClient_MakeBind failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEUNBINDFAILED,pkix_pl_LdapDefaultClient_MakeUnbind failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVCHECKCOMPLETEFAILED,pkix_pl_LdapDefaultClient_RecvCheckComplete failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVCONTINUEFAILED,pkix_pl_LdapDefaultClient_RecvContinue failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVFAILED,pkix_pl_LdapDefaultClient_Recv failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVINITIALFAILED,pkix_pl_LdapDefaultClient_RecvInitial failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVNONINITIALFAILED,pkix_pl_LdapDefaultClient_RecvNonInitial failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTSENDCONTINUEFAILED,pkix_pl_LdapDefaultClient_SendContinue failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTSENDFAILED,pkix_pl_LdapDefaultClient_Send failed,0),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTVERIFYBINDRESPONSEFAILED,pkix_pl_LdapDefaultClient_VerifyBindResponse failed,0),
PKIX_ERRORENTRY(LDAPREQUESTATTRSTRINGTOBITFAILED,pkix_pl_LdapRequest_AttrStringToBit failed,0),
PKIX_ERRORENTRY(LDAPREQUESTATTRTYPETOBITFAILED,pkix_pl_LdapRequest_AttrTypeToBit failed,0),
PKIX_ERRORENTRY(LDAPREQUESTCREATEFAILED,pkix_pl_LdapRequest_Create failed,0),
PKIX_ERRORENTRY(LDAPREQUESTENCODEATTRSFAILED,pkix_pl_LdapRequest_EncodeAttrs failed,0),
PKIX_ERRORENTRY(LDAPREQUESTGETENCODEDFAILED,pkix_pl_LdapRequest_GetEncoded failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEAPPENDFAILED,pkix_pl_LdapResponse_Append failed,0),
PKIX_ERRORENTRY(LDAPRESPONSECREATEFAILED,pkix_pl_LdapResponseCreate failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEDECODEFAILED,pkix_pl_LDAPResponse_Decode failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEGETCAPACITYFAILED,pkix_pl_LdapResponse_GetCapacity failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEGETMESSAGEFAILED,pkix_pl_LdapResponse_GetMessage failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEGETMESSAGETYPEFAILED,pkix_pl_LdapResponse_GetMessageType failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEGETRESULTCODEFAILED,pkix_pl_LdapResponse_GetResultCode failed,0),
PKIX_ERRORENTRY(LDAPRESPONSEISCOMPLETEFAILED,pkix_pl_LdapResponse_IsComplete failed,0),
PKIX_ERRORENTRY(LISTAPPENDFAILED,PKIX_List_Append failed,0),
PKIX_ERRORENTRY(LISTAPPENDITEMFAILED,PKIX_List_AppendItem failed,0),
PKIX_ERRORENTRY(LISTAPPENDLISTFAILED,pkix_List_AppendList failed,0),
PKIX_ERRORENTRY(LISTAPPENDUNIQUEFAILED,pkix_List_AppendUnique failed,0),
PKIX_ERRORENTRY(LISTBUBBLESORTFAILED,pkix_List_BubbleSort failed,0),
PKIX_ERRORENTRY(LISTCONTAINSFAILED,pkix_List_Contains failed,0),
PKIX_ERRORENTRY(LISTCREATEFAILED,PKIX_List_Create failed,0),
PKIX_ERRORENTRY(LISTCREATEINTERNALFAILED,pkix_List_Create_Internal failed,0),
PKIX_ERRORENTRY(LISTDELETEITEMFAILED,PKIX_List_DeleteItem failed,0),
PKIX_ERRORENTRY(LISTDUPLICATEFAILED,pkix_List_Duplicate failed,0),
PKIX_ERRORENTRY(LISTEQUALSFAILED,PKIX_List_Equals failed,0),
PKIX_ERRORENTRY(LISTGETELEMENTFAILED,pkix_List_GetElement failed,0),
PKIX_ERRORENTRY(LISTGETITEMFAILED,PKIX_List_GetItem failed,0),
PKIX_ERRORENTRY(LISTGETLENGTHFAILED,PKIX_List_GetLength failed,0),
PKIX_ERRORENTRY(LISTHASHCODEFAILED,pkix_List_Hashcode failed,0),
PKIX_ERRORENTRY(LISTINSERTITEMFAILED,PKIX_List_InsertItem failed,0),
PKIX_ERRORENTRY(LISTISEMPTYFAILED,PKIX_List_IsEmpty failed,0),
PKIX_ERRORENTRY(LISTMERGEFAILED,pkix_List_MergeList failed,0),
PKIX_ERRORENTRY(LISTQUICKSORTFAILED,pkix_List_QuickSort failed,0),
PKIX_ERRORENTRY(LISTREMOVEFAILED,pkix_List_Remove failed,0),
PKIX_ERRORENTRY(LISTREMOVEITEMSFAILED,pkix_List_RemoveItems failed,0),
PKIX_ERRORENTRY(LISTREVERSELISTFAILED,PKIX_List_ReverseList failed,0),
PKIX_ERRORENTRY(LISTSETIMMUTABLEFAILED,PKIX_List_SetImmutable failed,0),
PKIX_ERRORENTRY(LISTSETITEMFAILED,PKIX_List_SetItem failed,0),
PKIX_ERRORENTRY(LISTTOSTRINGFAILED,pkix_List_ToString failed,0),
PKIX_ERRORENTRY(LISTTOSTRINGHELPERFAILED,pkix_List_ToString Helper failed,0),
PKIX_ERRORENTRY(LOCATIONSTRINGNOTPROPERLYTERMINATED,Location string not properly terminated,0),
PKIX_ERRORENTRY(LOCKHASNONZEROREADCOUNT,Lock has non-zero read count,0),
PKIX_ERRORENTRY(LOCKOBJECTFAILED,pkix_LockObject failed,0),
PKIX_ERRORENTRY(LOGGERDUPLICATEFAILED,pkix_Logger_Duplicate failed,0),
PKIX_ERRORENTRY(LOGGINGLEVELEXCEEDSMAXIMUM,Logging Level exceeds Maximum,0),
PKIX_ERRORENTRY(LOOPDISCOVEREDDUPCERTSNOTALLOWED,Loop discovered: duplicate certificates not allowed,SEC_ERROR_UNTRUSTED_ISSUER),
PKIX_ERRORENTRY(LOOPOFERRORCAUSEDETECTED,Loop of error causes detected,0),
PKIX_ERRORENTRY(MAJORVERSIONSDONTMATCH,Major versions do not match,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(MALLOCFAILED,PKIX_PL_Malloc failed,0),
PKIX_ERRORENTRY(MEMLEAKGENERATEDERROR,Error generated for memory leak testing,SEC_ERROR_NO_MEMORY),
PKIX_ERRORENTRY(MINORVERSIONNOTBETWEENDESIREDMINANDMAX,Minor version does not fall between desired minimum and maximum,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(MISSINGDSAPARAMETERS,Missing DSA parameters in Trusted Cert,SEC_ERROR_INVALID_KEY),
PKIX_ERRORENTRY(MONITORLOCKCREATEFAILED,PKIX_PL_MonitorLock_Create failed,0),
PKIX_ERRORENTRY(MONITORLOCKENTERFAILED,PKIX_PL_MonitorLock_Enter failed,0),
PKIX_ERRORENTRY(MONITORLOCKEXITFAILED,PKIX_PL_MonitorLock_Exit failed,0),
PKIX_ERRORENTRY(MUTEXLOCKFAILED,PKIX_PL_Mutex_Lock failed,0),
PKIX_ERRORENTRY(NAMECHAININGCHECKERINITIALIZEFAILED,pkix_NameChainingChecker_Initialize failed,0),
PKIX_ERRORENTRY(NAMECHAININGCHECKFAILED,Name Chaining Check failed,SEC_ERROR_UNKNOWN_ISSUER),
PKIX_ERRORENTRY(NAMECOMPONENTWITHNOEQ,Name Component with no equal sign,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
PKIX_ERRORENTRY(NAMECONSTRAINTSCHECKERINITIALIZEFAILED,pkix_NameConstraintsChecker_Initialize failed,0),
PKIX_ERRORENTRY(NAMECONSTRAINTSCHECKERSTATECREATEFAILED,pkix_NameConstraintsCheckerState_Create failed,0),
PKIX_ERRORENTRY(NAMETYPENOTSUPPORTED,name type not supported,0),
PKIX_ERRORENTRY(NOCONTENTTYPEINHTTPRESPONSE,No content type in Http Response,SEC_ERROR_BAD_HTTP_RESPONSE),
PKIX_ERRORENTRY(NODESMISSINGFROMCHAIN,Nodes missing from chain,0),
PKIX_ERRORENTRY(NOREGISTEREDHTTPCLIENT,No registered Http Client,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(NORESPONSEDATAINHTTPRESPONSE,No responseData in Http Response,SEC_ERROR_BAD_HTTP_RESPONSE),
PKIX_ERRORENTRY(NOTARGETCERTSUPPLIED,No target cert supplied,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(NOTCONFORMINGCRLDP,Cert CRL DP does not conform to the rfc, 0),
PKIX_ERRORENTRY(NOTDERPACKAGE,Not a DER package,0),
PKIX_ERRORENTRY(NOTENOUGHNAMECOMPONENTSINGENERALNAME,Not enough name components in GeneralName,SEC_ERROR_BAD_INFO_ACCESS_LOCATION),
PKIX_ERRORENTRY(NSSCERTIFICATEUSAGETOPKIXKUANDEKUFAILED,Failed to convert nss certificate usage to pkix ku and eku data structures,0),
PKIX_ERRORENTRY(NSSCONTEXTCREATEFAILED,PKIX_PL_NssContext_Create failed,0),
PKIX_ERRORENTRY(NSSCONTEXTDESTROYFAILED,PKIX_PL_NssContext_Destroy failed,0),
PKIX_ERRORENTRY(NSSCONTEXTGETCHECKALLUSAGESFAILED, pkix_pl_NssContext_GetCheckAllUsages failed,0),
PKIX_ERRORENTRY(NSSCONTEXTGETRETURNUSAGESFAILED, pkix_pl_NssContext_GetReturnUsages failed,0),
PKIX_ERRORENTRY(NSSCONTEXTGETWINCXFAILED,pkix_pl_NssContext_GetWincx failed,0),
PKIX_ERRORENTRY(NSSCONTEXTSETCERTSIGNCHECKFAILED, pkix_pl_NssContext_SetCertSignatureCheck,0),
PKIX_ERRORENTRY(NSSCONTEXTSETCERTUSAGEFAILED, pkix_pl_NssContext_SetCertUsage failed,0),
PKIX_ERRORENTRY(NSSCONTEXTSETCHECKALLUSAGESFAILED, pkix_pl_NssContext_SetCheckAllUsages failed,0),
PKIX_ERRORENTRY(NSSCONTEXTSETRETURNEDCERTUSAGEFAILED, pkix_pl_NssContext_SetReturnedCertUsage,0),
PKIX_ERRORENTRY(NSSCONTEXTSETRETURNUSAGESFAILED, pkix_pl_NssContext_SetReturnUsages failed,0),
PKIX_ERRORENTRY(NSSCONTEXTVALIDATINGRESPONDERCERTFAILED,pkix_pl_NssContext_ValidatingResponderCert failed,0),
PKIX_ERRORENTRY(NSSTRUSTEDLISTISEMPTY,nss trusted roots list is empty,0),
PKIX_ERRORENTRY(NULLARGUMENT,Null argument,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(NUMBUCKETSEQUALSZERO,NumBuckets equals zero,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(OBJECTALLOCFAILED,PKIX_PL_Object_Alloc failed,0),
PKIX_ERRORENTRY(OBJECTARGUMENTNOTPOLICYMAP,object argument is not a PolicyMap,0),
PKIX_ERRORENTRY(OBJECTCOMPARATORFAILED,PKIX_PL_Object_Comparator failed,0),
PKIX_ERRORENTRY(OBJECTDEFINED,object-defined ,0),
PKIX_ERRORENTRY(OBJECTDUPLICATECERTFAILED,PKIX_PL_Object_Duplicate Cert failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATECONTEXTFAILED,PKIX_PL_Object_Duplicate Context failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATEDATEFAILED,PKIX_PL_Object_Duplicate Date failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATEFAILED,PKIX_PL_Object_Duplicate failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATEISSUERNAMESFAILED,PKIX_PL_Object_Duplicate IssuerNames failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATELISTFAILED,PKIX_PL_Object_Duplicate List failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATEMAXCRLNUMBERFAILED,PKIX_PL_Object_Duplicate maxCRLNumber failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATEMINCRLNUMBERFAILED,PKIX_PL_Object_Duplicate minCRLNumber failed,0),
PKIX_ERRORENTRY(OBJECTDUPLICATEPARAMSFAILED,PKIX_PL_Object_Duplicate Params failed,0),
PKIX_ERRORENTRY(OBJECTEQUALSFAILED,PKIX_PL_Object_Equals failed,0),
PKIX_ERRORENTRY(OBJECTEQUALSFAILEDONCHILDREN,PKIX_PL_Object_Equals failed on children,0),
PKIX_ERRORENTRY(OBJECTEQUALSFAILEDONEXPECTEDPOLICYSETS,PKIX_PL_Object_Equals failed on expectedPolicySets,0),
PKIX_ERRORENTRY(OBJECTGETTYPEFAILED,PKIX_PL_Object_GetType failed,0),
PKIX_ERRORENTRY(OBJECTHASHCODEFAILED,PKIX_PL_Object_Hashcode failed,0),
PKIX_ERRORENTRY(OBJECTINVALIDATECACHEFAILED,PKIX_PL_Object_InvalidateCache failed,0),
PKIX_ERRORENTRY(OBJECTISTYPEREGISTEREDFAILED,PKIX_PL_Object_IsTypeRegistered failed,0),
PKIX_ERRORENTRY(OBJECTLOCKFAILED,PKIX_PL_Object_Lock failed,0),
PKIX_ERRORENTRY(OBJECTNOTAIAMGR,Object is not a AIAMgr,0),
PKIX_ERRORENTRY(OBJECTNOTANEKUCHECKERSTATE,Object is not an EKU Checker State,0),
PKIX_ERRORENTRY(OBJECTNOTANERROR,Object is not an Error,0),
PKIX_ERRORENTRY(OBJECTNOTANHTTPCERTSTORECONTEXT,Object is not an HttpCertStoreContext,0),
PKIX_ERRORENTRY(OBJECTNOTANHTTPDEFAULTCLIENT,Object is not an HttpDefaultClient,0),
PKIX_ERRORENTRY(OBJECTNOTANINFOACCESS,Object is not an InfoAccess,0),
PKIX_ERRORENTRY(OBJECTNOTANLDAPDEFAULTCLIENT,Object is not an LdapDefaultClient,0),
PKIX_ERRORENTRY(OBJECTNOTANOCSPRESPONSE,Object is not an OcspResponse,0),
PKIX_ERRORENTRY(OBJECTNOTANOID,Object is not an OID,0),
PKIX_ERRORENTRY(OBJECTNOTANSOCKET,Object is not an Socket,0),
PKIX_ERRORENTRY(OBJECTNOTANX500NAME,Object is not an X500Name,0),
PKIX_ERRORENTRY(OBJECTNOTBASICCONSTRAINTSCHECKERSTATE,Object is not a basic constraints checker state,0),
PKIX_ERRORENTRY(OBJECTNOTBIGINT,Object is not a BigInt,0),
PKIX_ERRORENTRY(OBJECTNOTBUILDPARAMS,Object is not a BuildParams,0),
PKIX_ERRORENTRY(OBJECTNOTBUILDRESULT,Object is not a BuildResult,0),
PKIX_ERRORENTRY(OBJECTNOTBYTEARRAY,Object is not a bytearray,0),
PKIX_ERRORENTRY(OBJECTNOTCERT,Object is not a Cert,0),
PKIX_ERRORENTRY(OBJECTNOTCERTBASICCONSTRAINTS,Object is not a CertBasicConstraints,0),
PKIX_ERRORENTRY(OBJECTNOTCERTCHAINCHECKER,Object is not a cert chain checker,0),
PKIX_ERRORENTRY(OBJECTNOTCERTNAMECONSTRAINTS,Object is not a CertNameConstraints,0),
PKIX_ERRORENTRY(OBJECTNOTCERTPOLICYINFO,Object is not a CertPolicyInfo,0),
PKIX_ERRORENTRY(OBJECTNOTCERTPOLICYMAP,Object is not a CertPolicyMap,0),
PKIX_ERRORENTRY(OBJECTNOTCERTPOLICYQUALIFIER,Object is not a CertPolicyQualifier,0),
PKIX_ERRORENTRY(OBJECTNOTCERTSELECTOR,Object is not a cert selector,0),
PKIX_ERRORENTRY(OBJECTNOTCERTSTORE,Object is not a CertStore,0),
PKIX_ERRORENTRY(OBJECTNOTCOLLECTIONCERTSTORECONTEXT,Object is not a CollectionCertStoreContext,0),
PKIX_ERRORENTRY(OBJECTNOTCOMCERTSELPARAMS,Object is not a comCertSelParams,0),
PKIX_ERRORENTRY(OBJECTNOTCOMCRLSELPARAMS,Object is not a ComCRLSelParams,0),
PKIX_ERRORENTRY(OBJECTNOTCRL,Object is not a CRL,0),
PKIX_ERRORENTRY(OBJECTNOTCRLENTRY,Object is not a CRLEntry,0),
PKIX_ERRORENTRY(OBJECTNOTCRLSELECTOR,Object is not a CRLSelector,0),
PKIX_ERRORENTRY(OBJECTNOTDATE,Object is not a Date,0),
PKIX_ERRORENTRY(OBJECTNOTCRLCHECKER,Object is not a CRLChecker,0),
PKIX_ERRORENTRY(OBJECTNOTDEFAULTREVOCATIONCHECKER,Object is not a DefaultRevocationChecker,0),
PKIX_ERRORENTRY(OBJECTNOTFORWARDBUILDERSTATE,Object is not a PKIX_ForwardBuilderState,0),
PKIX_ERRORENTRY(OBJECTNOTGENERALNAME,Object is not a GeneralName,0),
PKIX_ERRORENTRY(OBJECTNOTHASHTABLE,Object is not a hashtable,0),
PKIX_ERRORENTRY(OBJECTNOTINFOACCESS,Object is not a InfoAccess,0),
PKIX_ERRORENTRY(OBJECTNOTLDAPREQUEST,Object is not a LdapRequest,0),
PKIX_ERRORENTRY(OBJECTNOTLDAPRESPONSE,Object is not a LdapResponse,0),
PKIX_ERRORENTRY(OBJECTNOTLIST,Object is not a list,0),
PKIX_ERRORENTRY(OBJECTNOTLOGGER,Object is not a Logger,0),
PKIX_ERRORENTRY(OBJECTNOTMONITORLOCK,Object is not a MonitorLock,0),
PKIX_ERRORENTRY(OBJECTNOTMUTEX,Object is not a Mutex,0),
PKIX_ERRORENTRY(OBJECTNOTNAMECONSTRAINTSCHECKERSTATE,Object is not a name constraints checker state,0),
PKIX_ERRORENTRY(OBJECTNOTOCSPCERTID,Object is not an OcspCertID,0),
PKIX_ERRORENTRY(OBJECTNOTOCSPCHECKER,Object is not an OCSPChecker,0),
PKIX_ERRORENTRY(OBJECTNOTOCSPREQUEST,Object is not an OcspRequest,0),
PKIX_ERRORENTRY(OBJECTNOTPOLICYCHECKERSTATE,Object is not a PKIX_PolicyCheckerState,0),
PKIX_ERRORENTRY(OBJECTNOTPOLICYNODE,Object is not a PolicyNode,0),
PKIX_ERRORENTRY(OBJECTNOTPROCESSINGPARAMS,Object is not a ProcessingParams,0),
PKIX_ERRORENTRY(OBJECTNOTPUBLICKEY,Object is not a PublicKey,0),
PKIX_ERRORENTRY(OBJECTNOTRESOURCELIMITS,Object is not a ResourceLimits,0),
PKIX_ERRORENTRY(OBJECTNOTREVOCATIONCHECKER,Object is not a revocation checker,0),
PKIX_ERRORENTRY(OBJECTNOTRWLOCK,Object is not a RWLock,0),
PKIX_ERRORENTRY(OBJECTNOTSIGNATURECHECKERSTATE,Object is not a signature checker state,0),
PKIX_ERRORENTRY(OBJECTNOTSOCKET,Object is not a Socket,0),
PKIX_ERRORENTRY(OBJECTNOTSTRING,Object is not a string,0),
PKIX_ERRORENTRY(OBJECTNOTTARGETCERTCHECKERSTATE,Object is not a target cert checker state,0),
PKIX_ERRORENTRY(OBJECTNOTTRUSTANCHOR,Object is not a trustAnchor,0),
PKIX_ERRORENTRY(OBJECTNOTVALIDATEPARAMS,Object is not a ValidateParams,0),
PKIX_ERRORENTRY(OBJECTNOTVALIDATERESULT,Object is not a ValidateResult,0),
PKIX_ERRORENTRY(OBJECTNOTVERIFYNODE,Object is not a VerifyNode,0),
PKIX_ERRORENTRY(OBJECTREGISTERTYPEFAILED,PKIX_PL_Object_RegisterType failed,0),
PKIX_ERRORENTRY(OBJECTRETRIEVEEQUALSCALLBACKFAILED,pkix_pl_Object_RetrieveEqualsCallback failed,0),
PKIX_ERRORENTRY(OBJECTSPECIFICFUNCTIONFAILED,object-specific function failed,0),
PKIX_ERRORENTRY(OBJECTSTILLREFERENCED,Object is still referenced,0),
PKIX_ERRORENTRY(OBJECTTOSTRINGFAILED,PKIX_PL_Object_ToString failed,0),
PKIX_ERRORENTRY(OBJECTTYPESDONOTMATCH,Object types do not match,0),
PKIX_ERRORENTRY(OBJECTWITHNONPOSITIVEREFERENCES,Object with non-positive references,0),
PKIX_ERRORENTRY(OCSPCERTIDCREATEFAILED,PKIX_PL_OcspCertID_Create failed,0),
PKIX_ERRORENTRY(OCSPCERTIDGETFRESHCACHESTATUSFAILED,PKIX_PL_OcspCertID_GetFreshCacheStatus returned an error,0),
PKIX_ERRORENTRY(OCSPCERTIDREMEMBEROCSPFAILUREDFAILED,PKIX_PL_OcspCertID_RememberOCSPProcessingFailure,0),
PKIX_ERRORENTRY(OCSPCHECKERCREATEFAILED,PKIX_OcspChecker_Create failed,0),
PKIX_ERRORENTRY(OCSPBADHTTPRESPONSE,Bad Http Response,SEC_ERROR_OCSP_BAD_HTTP_RESPONSE),
PKIX_ERRORENTRY(OCSPREQUESTCREATEFAILED,PKIX_PL_OcspRequest_Create failed,0),
PKIX_ERRORENTRY(OCSPREQUESTGETCERTIDFAILED,pkix_pl_OcspRequest_GetCertID failed,0),
PKIX_ERRORENTRY(OCSPREQUESTGETENCODEDFAILED,pkix_pl_OcspRequest_GetEncoded failed,0),
PKIX_ERRORENTRY(OCSPREQUESTGETLOCATIONFAILED,pkix_pl_OcspRequest_GetLocation failed,0),
PKIX_ERRORENTRY(OCSPRESPONSECREATEFAILED,pkix_pl_OcspResponse_Create failed,0),
PKIX_ERRORENTRY(OCSPRESPONSEDECODEFAILED,pkix_pl_OcspResponse_Decode failed,0),
PKIX_ERRORENTRY(OCSPRESPONSEGETSTATUSFORCERTFAILED,pkix_pl_OcspResponse_GetStatusForCert failed,0),
PKIX_ERRORENTRY(OCSPRESPONSEGETSTATUSRETURNEDANERROR,pkix_pl_OcspResponse_GetStatus returned an error,0),
PKIX_ERRORENTRY(OCSPRESPONSESAYSCERTREVOKED,OCSP response says Cert revoked,SEC_ERROR_REVOKED_CERTIFICATE_OCSP),
PKIX_ERRORENTRY(OCSPRESPONSEVERIFYSIGNATUREFAILED,pkix_pl_OcspResponse_VerifySignature failed,0),
PKIX_ERRORENTRY(OCSPSERVERERROR,OCSP Server Error,SEC_ERROR_OCSP_SERVER_ERROR),
PKIX_ERRORENTRY(OIDBYTES2ASCIIDATALENGTHZERO,pkix_pl_oidBytes2Ascii: data length is zero,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(OIDBYTES2ASCIIFAILED,pkix_pl_oidBytes2Ascii failed,0),
PKIX_ERRORENTRY(OIDBYTESLENGTH0,Oid bytes length is 0,0),
PKIX_ERRORENTRY(OIDCOMPARATORFAILED,pkix_pl_OID_Comparator failed,0),
PKIX_ERRORENTRY(OIDCOMPONENTTOOBIG,Overflow error: OID component > 2^32,0),
PKIX_ERRORENTRY(OIDCREATEFAILED,PKIX_PL_OID_Create failed,0),
PKIX_ERRORENTRY(OIDEQUALFAILED,PKIX_PL_OID_Equal failed,0),
PKIX_ERRORENTRY(OIDEQUALSFAILED,PKIX_PL_OID_Equals failed,0),
PKIX_ERRORENTRY(OIDGETNEXTTOKENFAILED,pkix_pl_OID_GetNextToken failed,0),
PKIX_ERRORENTRY(OIDHASHCODEFAILED,PKIX_PL_OID_Hashcode failed,0),
PKIX_ERRORENTRY(OIDLENGTHTOOSHORT,OID length too short,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(OIDNEEDS2ORMOREFIELDS,OID needs 2 or more fields,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(OIDTOSTRINGFAILED,PKIX_PL_OID_ToString failed,0),
PKIX_ERRORENTRY(OPERATIONNOTPERMITTEDONIMMUTABLELIST,Operation not permitted on Immutable List,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(OTHERNAMECREATEFAILED,pkix_pl_OtherName_Create failed,0),
PKIX_ERRORENTRY(OUTOFMEMORY,Out of Memory,0),
PKIX_ERRORENTRY(PATHLENCONSTRAINTINVALID,Certificate path length constraint is invalid,SEC_ERROR_PATH_LEN_CONSTRAINT_INVALID),
PKIX_ERRORENTRY(PK11CERTSTORECERTQUERYFAILED,pkix_pl_Pk11CertStore_CertQuery failed,0),
PKIX_ERRORENTRY(PK11CERTSTORECREATEFAILED,PKIX_PL_Pk11CertStore_Create failed,0),
PKIX_ERRORENTRY(PK11CERTSTORECRLQUERYFAILED,pkix_pl_Pk11CertStore_CrlQuery failed,0),
PKIX_ERRORENTRY(PKIXUNKNOWNERROR,PKIX uninitialized error code,0),
PKIX_ERRORENTRY(POLICYCHECKERCALCULATEINTERSECTIONFAILED,pkix_PolicyChecker_CalculateIntersection failed,0),
PKIX_ERRORENTRY(POLICYCHECKERCHECKANYFAILED,pkix_PolicyChecker_CheckAny failed,0),
PKIX_ERRORENTRY(POLICYCHECKERCHECKPOLICYRECURSIVEFAILED,pkix_PolicyChecker_CheckPolicyRecursive failed,0),
PKIX_ERRORENTRY(POLICYCHECKERERROR,PolicyChecker Error,0),
PKIX_ERRORENTRY(POLICYCHECKERINITIALIZEFAILED,pkix_PolicyChecker_Initialize failed,0),
PKIX_ERRORENTRY(POLICYCHECKERMAKEMUTABLECOPYFAILED,pkix_PolicyChecker_MakeMutableCopy failed,0),
PKIX_ERRORENTRY(POLICYCHECKERMAKESINGLETONFAILED,pkix_PolicyChecker_MakeSingleton failed,0),
PKIX_ERRORENTRY(POLICYCHECKERMAPCONTAINSFAILED,pkix_PolicyChecker_MapContains failed,0),
PKIX_ERRORENTRY(POLICYCHECKERMAPGETMAPPEDPOLICIESFAILED,pkix_PolicyChecker_MapGetMappedPolicies failed,0),
PKIX_ERRORENTRY(POLICYCHECKERMAPGETSUBJECTDOMAINPOLICIESFAILED,pkix_PolicyChecker_MapGetSubjectDomainPolicies failed,0),
PKIX_ERRORENTRY(POLICYCHECKERSPAWNFAILED,pkix_PolicyChecker_Spawn failed,0),
PKIX_ERRORENTRY(POLICYCHECKERSTATECREATEFAILED,PKIX_PolicyCheckerState_Create failed,0),
PKIX_ERRORENTRY(POLICYNODEADDTOPARENTFAILED,pkix_PolicyNode_AddToParent failed,0),
PKIX_ERRORENTRY(POLICYNODECREATEFAILED,pkix_PolicyNode_Create failed,0),
PKIX_ERRORENTRY(POLICYNODEDUPLICATEHELPERFAILED,pkix_PolicyNode_DuplicateHelper failed,0),
PKIX_ERRORENTRY(POLICYNODEGETCHILDRENMUTABLEFAILED,pkix_PolicyNode_GetChildrenMutable failed,0),
PKIX_ERRORENTRY(POLICYNODEGETDEPTHFAILED,PKIX_PolicyNode_GetDepth failed,0),
PKIX_ERRORENTRY(POLICYNODEGETEXPECTEDPOLICIESFAILED,PKIX_PolicyNode_GetExpectedPolicies failed,0),
PKIX_ERRORENTRY(POLICYNODEGETPARENTFAILED,PKIX_PolicyNode_GetParent failed,0),
PKIX_ERRORENTRY(POLICYNODEGETPOLICYQUALIFIERSFAILED,PKIX_PolicyNode_GetPolicyQualifiers failed,0),
PKIX_ERRORENTRY(POLICYNODEGETVALIDPOLICYFAILED,PKIX_PolicyNode_GetValidPolicy failed,0),
PKIX_ERRORENTRY(POLICYNODEISCRITICALFAILED,PKIX_PolicyNode_IsCritical failed,0),
PKIX_ERRORENTRY(POLICYNODEPRUNEFAILED,pkix_PolicyNode_Prune failed,0),
PKIX_ERRORENTRY(POLICYTREETOOIDSFAILED,Failed to convert policy tree to oid,0),
PKIX_ERRORENTRY(PORTARENAALLOCFAILED,PORT Arena Allocation failed, 0),
PKIX_ERRORENTRY(PORTUCS2UTF8CONVERSIONFAILED,PORT_UCS2_UTF8Conversion failed.,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(PRACCEPTFAILED,PR_Accept failed,0),
PKIX_ERRORENTRY(PRBINDFAILED,PR_Bind failed,0),
PKIX_ERRORENTRY(PRCONNECTCONTINUEFAILED,PR_ConnectContinue failed,0),
PKIX_ERRORENTRY(PRCONNECTFAILED,PR_Connect failed,0),
PKIX_ERRORENTRY(PRECONDITIONFAILED,Function precondition failed,SEC_ERROR_LIBPKIX_INTERNAL),
PKIX_ERRORENTRY(PRENUMERATEHOSTENTFAILED,PR_EnumerateHostEnt failed.,0),
PKIX_ERRORENTRY(PRGETHOSTBYNAMEREJECTSHOSTNAMEARGUMENT,PR_GetHostByName rejects hostname argument.,0),
PKIX_ERRORENTRY(PRIMHASHTABLEADDFAILED,pkix_pl_PrimHashTable_Add failed,0),
PKIX_ERRORENTRY(PRIMHASHTABLECREATEFAILED,pkix_pl_PrimHashTable_Create failed,0),
PKIX_ERRORENTRY(PRIMHASHTABLEDESTROYFAILED,pkix_pl_PrimHashTable_Destroy failed,0),
PKIX_ERRORENTRY(PRIMHASHTABLEGETBUCKETSIZEFAILED,pkix_pl_PrimHashTable_GetBucketSize failed,0),
PKIX_ERRORENTRY(PRIMHASHTABLELOOKUPFAILED,pkix_pl_PrimHashTable_Lookup failed,0),
PKIX_ERRORENTRY(PRIMHASHTABLEREMOVEFAILED,pkix_pl_PrimHashTable_Remove failed,0),
PKIX_ERRORENTRY(PRLISTENFAILED,PR_Listen failed,0),
PKIX_ERRORENTRY(PRNEWTCPSOCKETFAILED,PR_NewTCPSocket failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSADDCERTCHAINCHECKERFAILED,PKIX_ProcessingParams_AddCertChainChecker failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSADDCERTSTOREFAILED,PKIX_ProcessingParams_AddCertStore failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSADDREVMETHODFAILED,PKIX_ProcessingParams_AddRevocationMethod failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSCREATEFAILED,PKIX_ProcessingParams_Create failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETCERTCHAINCHECKERSFAILED,PKIX_ProcessingParams_GetCertChainCheckers failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETCERTSTORESFAILED,PKIX_ProcessingParams_GetCertStores failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETDATEFAILED,PKIX_ProcessingParams_GetDate failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETHINTCERTSFAILED,PKIX_ProcessingParams_GetHintCerts failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETINITIALPOLICIESFAILED,PKIX_ProcessingParams_GetInitialPolicies failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETNISTREVPOLICYENABLEDFAILED,pkix_ProcessingParams_GetNISTRevocationPolicyEnabled failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETPOLICYQUALIFIERSREJECTEDFAILED,PKIX_ProcessingParams_GetPolicyQualifiersRejected failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETRESOURCELIMITSFAILED,PKIX_ProcessingParams_GetResourceLimits failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETREVOCATIONCHECKERFAILED,PKIX_ProcessingParams_GetRevocationChecker failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETREVOCATIONENABLEDFAILED,PKIX_ProcessingParams_GetRevocationEnabled failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETTARGETCERTCONSTRAINTSFAILED,PKIX_ProcessingParams_GetTargetCertConstraints failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETTRUSTANCHORSFAILED,PKIX_ProcessingParams_GetTrustAnchors failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSISANYPOLICYINHIBITEDFAILED,PKIX_ProcessingParams_IsAnyPolicyInhibited failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSISEXPLICITPOLICYREQUIREDFAILED,PKIX_ProcessingParams_IsExplicitPolicyRequired failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSISPOLICYMAPPINGINHIBITEDFAILED,PKIX_ProcessingParams_IsPolicyMappingInhibited failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETANYPOLICYINHIBITED,PKIX_ProcessingParams_SetAnyPolicyInhibited failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETCERTSTORESFAILED,PKIX_ProcessingParams_SetCertStores failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETDATEFAILED,PKIX_ProcessingParams_SetDate failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETEXPLICITPOLICYREQUIRED,PKIX_ProcessingParams_SetExplicitPolicyRequired failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETHINTCERTSFAILED,PKIX_ProcessingParams_SetHintCerts failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETINITIALPOLICIESFAILED,PKIX_ProcessingParams_SetInitialPolicies failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETNISTREVOCATIONENABLEDFAILED,PKIX_ProcessingParams_SetNISTRevocationEnabled failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETPOLICYMAPPINGINHIBITED,PKIX_ProcessingParams_SetPolicyMappingInhibited failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETREVOCATIONCHECKERFAILED,PKIX_ProcessingParams_SetRevocationChecker failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETTARGETCERTCONSTRAINTSFAILED,PKIX_ProcessingParams_SetTargetCertConstraints failed,0),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETQUALIFYTARGETCERTFLAGFAILED,ProcessingParams_SetQualifyTargetCertFlag failed,0),
PKIX_ERRORENTRY(PRPOLLFAILED,PR_Poll failed,0),
PKIX_ERRORENTRY(PRPOLLRETBADFILENUM,PR_Poll failed,0),
PKIX_ERRORENTRY(PRRECVFAILED,PR_Recv failed,0),
PKIX_ERRORENTRY(PRRECVREPORTSNETWORKCONNECTIONCLOSED,PR_Recv reports network connection is closed,0),
PKIX_ERRORENTRY(PRSENDFAILED,PR_Send failed,0),
PKIX_ERRORENTRY(PRSHUTDOWNFAILED,PR_Shutdown failed,0),
PKIX_ERRORENTRY(PRSMPRINTFFAILED,PR_smprintf failed,0),
PKIX_ERRORENTRY(PRSNPRINTFFAILED,PR_snprintf failed,0),
PKIX_ERRORENTRY(PUBKEYTYPENULLKEY,pubKeyType is nullKey,0),
PKIX_ERRORENTRY(PUBLICKEYMAKEINHERITEDDSAPUBLICKEYFAILED,PKIX_PL_PublicKey_MakeInheritedDSAPublicKey failed,0),
PKIX_ERRORENTRY(PUBLICKEYNEEDSDSAPARAMETERSFAILED,PKIX_PL_PublicKey_NeedsDSAParameters failed,0),
PKIX_ERRORENTRY(PUBLICKEYTOSTRINGFAILED,PKIX_PL_PublicKey_ToString failed,0),
PKIX_ERRORENTRY(PUBLICKEYTOSTRINGHELPERFAILED,pkix_pl_PublicKey_ToString_Helper failed,0),
PKIX_ERRORENTRY(QUALIFIERSINCRITICALCERTIFICATEPOLICYEXTENSION,Qualifiers in critical Certificate Policy extension,0),
PKIX_ERRORENTRY(REALLOCFAILED,PKIX_PL_Realloc failed,0),
PKIX_ERRORENTRY(RECEIVEDCORRUPTEDOBJECTARGUMENT,Received corrupted object argument,0),
PKIX_ERRORENTRY(REGISTERCERTSTOREFAILED,RegisterCertStores failed,0),
PKIX_ERRORENTRY(REMOVEDUPUNTRUSTEDCERTSFAILED, pkix_Build_RemoveDupUntrustedCerts failed,0),
PKIX_ERRORENTRY(REQUESTNOTANHTTPDEFAULTCLIENT,request is not an HttpDefaultClient,0),
PKIX_ERRORENTRY(RESOURCELIMITSGETMAXDEPTHFAILED,PKIX_ResourceLimits_GetMaxDepth failed,0),
PKIX_ERRORENTRY(RESOURCELIMITSGETMAXFANOUTFAILED,PKIX_ResourceLimits_GetMaxFanout failed,0),
PKIX_ERRORENTRY(RESOURCELIMITSGETMAXTIMEFAILED,PKIX_ResourceLimits_GetMaxTime failed,0),
PKIX_ERRORENTRY(RETRIEVEOUTPUTSFAILED,pkix_RetrieveOutputs failed,0),
PKIX_ERRORENTRY(REVCHECKCERTFAILED,pkix_RevCheckCert failed,0),
PKIX_ERRORENTRY(REVCHECKERCHECKFAILED,revCheckerCheck failed,0),
PKIX_ERRORENTRY(REVOCATIONCHECKERADDMETHODFAILED,Can not add revocation method,0),
PKIX_ERRORENTRY(REVOCATIONCHECKERCREATEFAILED,PKIX_RevocationChecker_Create failed,0),
PKIX_ERRORENTRY(REVOCATIONCHECKERGETREVCALLBACKFAILED,PKIX_RevocationChecker_GetRevCallback failed,0),
PKIX_ERRORENTRY(REVOCATIONCHECKERGETREVCHECKERCONTEXTFAILED,PKIX_RevocationChecker_GetRevCheckerContext failed,0),
PKIX_ERRORENTRY(REVOCATIONCHECKERWASNOTSET,Revocation chekcer was not set,0),
PKIX_ERRORENTRY(REVOKEDBYUNKNOWNCRLREASONCODE,Revoked by Unknown CRL ReasonCode,0),
PKIX_ERRORENTRY(SEARCHRESPONSEPACKETOFUNKNOWNTYPE,SearchResponse packet of unknown type,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(SECASN1ENCODEITEMFAILED,SEC_ASN1EncodeItem failed,SEC_ERROR_FAILED_TO_ENCODE_DATA),
PKIX_ERRORENTRY(SECERRORUNKNOWNISSUER,Nss legacy err code: build failed. Issuer is unknown.,SEC_ERROR_UNKNOWN_ISSUER),
PKIX_ERRORENTRY(SECKEYCOPYSUBJECTPUBLICKEYINFOFAILED,SECKEY_CopySubjectPublicKeyInfo failed,0),
PKIX_ERRORENTRY(SECKEYEXTRACTPUBLICKEYFAILED,SECKEY_ExtractPublicKey failed,0),
PKIX_ERRORENTRY(SECOIDCOPYALGORITHMIDFAILED,SECOID_CopyAlgorithmID failed,0),
PKIX_ERRORENTRY(SECOIDFINDOIDTAGDESCRIPTIONFAILED,SECOID_FindOIDTag Description failed,0),
PKIX_ERRORENTRY(SECONDFIELDMUSTBEBETWEEN039,Second field must be between 0-39,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(SECONDKEYDSAPUBLICKEY,Second key is a DSA public key but has null parameters,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(SECONDKEYNOTDSAPUBLICKEY,Second key is not a DSA public key,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(SECONDPUBKEYTYPENULLKEY,secondPubKeyType is nullKey,0),
PKIX_ERRORENTRY(SECQUICKDERDECODERFAILED,SEC_QuickDERDecodeItem failed,0),
PKIX_ERRORENTRY(SECREADPKCS7CERTSFAILED,SEC_ReadPKCS7Certs failed,0),
PKIX_ERRORENTRY(SELECTORMATCHFAILED,selectorMatch failed,0),
PKIX_ERRORENTRY(SESSIONNOTANHTTPDEFAULTCLIENT,session is not an HttpDefaultClient,0),
PKIX_ERRORENTRY(SETPOLICIESFAILED,Fail to set cert validation policies,0),
PKIX_ERRORENTRY(SHUTDOWNFAILED,PKIX_PL_Shutdown failed,0),
PKIX_ERRORENTRY(SIGNATURECHECKERINITIALIZEFAILED,pkix_SignatureChecker_Initialize failed,0),
PKIX_ERRORENTRY(SIGNATURECHECKERSTATECREATEFAILED,pkix_SignatureCheckerState_Create failed,0),
PKIX_ERRORENTRY(SIGNATUREDIDNOTVERIFYWITHTHEPUBLICKEY,Signature did not verify with the public key,0),
PKIX_ERRORENTRY(SINGLEPOLICYNODEEQUALSFAILED,PKIX_PL_SinglePolicyNode_Equals failed,0),
PKIX_ERRORENTRY(SINGLEPOLICYNODEHASHCODEFAILED,pkix_SinglePolicyNode_Hashcode failed,0),
PKIX_ERRORENTRY(SINGLEPOLICYNODETOSTRINGFAILED,pkix_SinglePolicyNode_ToString failed,0),
PKIX_ERRORENTRY(SINGLEVERIFYNODEEQUALSFAILED,PKIX_PL_SingleVerifyNode_Equals failed,0),
PKIX_ERRORENTRY(SINGLEVERIFYNODEHASHCODEFAILED,pkix_SingleVerifyNode_Hashcode failed,0),
PKIX_ERRORENTRY(SOCKETCONNECTCONTINUEFAILED,pkix_pl_Socket_ConnectContinue failed,0),
PKIX_ERRORENTRY(SOCKETCONNECTFAILED,pkix_pl_Socket_Connect failed,0),
PKIX_ERRORENTRY(SOCKETCREATEBYHOSTANDPORTFAILED,pkix_pl_Socket_CreateByHostAndPort failed,0),
PKIX_ERRORENTRY(SOCKETCREATEBYNAMEFAILED,pkix_pl_Socket_CreateByName failed,0),
PKIX_ERRORENTRY(SOCKETCREATECLIENTFAILED,pkix_pl_Socket_CreateClient failed,0),
PKIX_ERRORENTRY(SOCKETCREATEFAILED,pkix_pl_Socket_Create failed,0),
PKIX_ERRORENTRY(SOCKETCREATESERVERFAILED,pkix_pl_Socket_CreateServer failed,0),
PKIX_ERRORENTRY(SOCKETEQUALSFAILED,PKIX_PL_Socket_Equals failed,0),
PKIX_ERRORENTRY(SOCKETGETCALLBACKLISTFAILED,pkix_pl_Socket_GetCallbackList failed,0),
PKIX_ERRORENTRY(SOCKETGETPRFILEDESCFAILED,pkix_pl_Socket_GetPRFileDesc failed,0),
PKIX_ERRORENTRY(SOCKETHASHCODEFAILED,PKIX_PL_Socket_Hashcode failed,0),
PKIX_ERRORENTRY(SOCKETPOLLFAILED,pkix_pl_Socket_Poll failed,0),
PKIX_ERRORENTRY(SOCKETRECVFAILED,pkix_pl_Socket_Recv failed,0),
PKIX_ERRORENTRY(SOCKETSENDFAILED,pkix_pl_Socket_Send failed,0),
PKIX_ERRORENTRY(SOCKETSETNONBLOCKINGFAILED,pkix_pl_Socket_SetNonBlocking failed,0),
PKIX_ERRORENTRY(SOURCESTRINGHASINVALIDLENGTH,Source string has invalid length,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(SPRINTFFAILED,PKIX_PL_Sprintf failed,0),
PKIX_ERRORENTRY(STRINGCOMPARATORFAILED,pkix_pl_String_Comparator failed,0),
PKIX_ERRORENTRY(STRINGCREATEFAILED,PKIX_PL_String_Create failed,0),
PKIX_ERRORENTRY(STRINGEQUALSFAILED,pkix_pl_String_Equals failed,0),
PKIX_ERRORENTRY(STRINGGETENCODEDFAILED,PKIX_PL_String_GetEncoded failed,0),
PKIX_ERRORENTRY(STRINGHASHCODEFAILED,pkix_pl_String_Hashcode failed,0),
PKIX_ERRORENTRY(SUBJALTNAMECHECKFAILED,Validation failed: SubjAltNamecheck failed,0),
PKIX_ERRORENTRY(TARGETCERTCHECKERINITIALIZEFAILED,pkix_TargetCertChecker_Initialize failed,0),
PKIX_ERRORENTRY(TARGETCERTCHECKERSTATECREATEFAILED,pkix_TargetCertCheckerState_Create failed,0),
PKIX_ERRORENTRY(TESTANOTHERERRORMESSAGE, Another Error Message,0),
PKIX_ERRORENTRY(TESTERRORMESSAGE, Error Message,0),
PKIX_ERRORENTRY(TESTNOMATCHINGPOLICY, No Matching Policy,0),
PKIX_ERRORENTRY(TESTNOTANERRORCRLSELECTMISMATCH, Not an error CRL Select mismatch,0),
PKIX_ERRORENTRY(TESTPOLICYEXTWITHNOPOLICYQUALIFIERS, Policies extension but no Policy Qualifiers,0),
PKIX_ERRORENTRY(TIMECONSUMEDEXCEEDSRESOURCELIMITS,Time consumed exceeds Resource Limits,SEC_ERROR_OUT_OF_SEARCH_LIMITS),
PKIX_ERRORENTRY(TOOLITTLEDATAINDERSEQUENCE,Too little data in DER Sequence,0),
PKIX_ERRORENTRY(TOOMUCHDATAINDERSEQUENCE,Too much data in DER Sequence,0),
PKIX_ERRORENTRY(TOSTRINGFORTHISGENERALNAMETYPENOTSUPPORTED,ToString for this GeneralName type not supported,0),
PKIX_ERRORENTRY(TRUNCATEDUNICODEINESCAPEDASCII,Truncated Unicode in EscapedASCII,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(TRUSTANCHORCREATEWITHCERTFAILED,PKIX_TrustAnchor_CreateWithCert failed,0),
PKIX_ERRORENTRY(TRUSTANCHORGETCANAMEFAILED,PKIX_TrustAnchor_GetCAName failed,0),
PKIX_ERRORENTRY(TRUSTANCHORGETCAPUBLICKEYFAILED,PKIX_TrustAnchor_GetCAPublicKey failed,0),
PKIX_ERRORENTRY(TRUSTANCHORGETNAMECONSTRAINTSFAILED,PKIX_TrustAnchor_GetNameConstraints failed,0),
PKIX_ERRORENTRY(TRUSTANCHORGETTRUSTEDCERTFAILED,PKIX_TrustAnchor_GetTrustedCert failed,0),
PKIX_ERRORENTRY(TRUSTANCHORTOCERTFAILED,Fail to convert trust anchor to cert,0),
PKIX_ERRORENTRY(TYPEALREADYREGISTERED,Type is already registered,0),
PKIX_ERRORENTRY(UNABLETOADDACCEPTABLERESPONSESTOREQUEST,Unable to add acceptableResponses to request,0),
PKIX_ERRORENTRY(UNABLETOADDCERTTOCERTLIST,Unable to add Cert to CertList,0),
PKIX_ERRORENTRY(UNABLETOBUILDCHAIN,Unable to build chain,0),
PKIX_ERRORENTRY(UNABLETOCREATECERTOCSPREQUEST,Unable to create a CertOCSPRequest,0),
PKIX_ERRORENTRY(UNABLETOCREATECRLSTRING,Unable to create crlString,0),
PKIX_ERRORENTRY(UNABLETOCREATEGENERALNAMEOFTHISTYPE,Unable to create GeneralName of this type,0),
PKIX_ERRORENTRY(UNABLETOCREATEISSUER,Unable to create Issuer,0),
PKIX_ERRORENTRY(UNABLETOCREATELIST,Unable to create list,0),
PKIX_ERRORENTRY(UNABLETOCREATENEWCERTLIST,Unable to create a new CertList,0),
PKIX_ERRORENTRY(UNABLETOCREATEPSTRING,Unable to create pString,0),
PKIX_ERRORENTRY(UNABLETOFINDSTATUSINOCSPRESPONSE,Unable to find status in OCSP response,SEC_ERROR_OCSP_UNKNOWN_RESPONSE_STATUS),
PKIX_ERRORENTRY(UNABLETOMAKELISTIMMUTABLE,Unable to make list immutable,0),
PKIX_ERRORENTRY(UNABLETOOPENCERTFILE,Unable to open cert file,0),
PKIX_ERRORENTRY(UNABLETOOPENCRLFILE,Unable to open crl file,0),
PKIX_ERRORENTRY(UNABLETOPARSEOCSPRESPONSE,Unable to parse OCSP response,SEC_ERROR_OCSP_MALFORMED_RESPONSE),
PKIX_ERRORENTRY(UNABLETOREADDERFROMCERTFILE,Unable to read DER from cert file,0),
PKIX_ERRORENTRY(UNABLETOREADDERFROMCRLFILE,Unable to read DER from crl file,0),
PKIX_ERRORENTRY(UNABLETOSETSOCKETTONONBLOCKING,Unable to set socket to non-blocking I/O,0),
PKIX_ERRORENTRY(UNDEFINEDCALLBACK,Undefined callback,0),
PKIX_ERRORENTRY(UNDEFINEDCLASSTABLEENTRY,Undefined class table entry,0),
PKIX_ERRORENTRY(UNDEFINEDCOMPARATOR,Undefined Comparator,0),
PKIX_ERRORENTRY(UNDEFINEDDUPLICATEFUNCTION,Undefined Duplicate function,0),
PKIX_ERRORENTRY(UNDEFINEDEQUALSCALLBACK,Undefined equals callback,0),
PKIX_ERRORENTRY(UNEXPECTEDERRORINESTABLISHINGCONNECTION,Unexpected error in establishing connection,0),
PKIX_ERRORENTRY(UNEXPECTEDRESULTCODEINRESPONSE,Unexpected result code in Response,SEC_ERROR_BAD_LDAP_RESPONSE),
PKIX_ERRORENTRY(UNKNOWNFORMAT,Unknown format,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(UNKNOWNINFOACCESSMETHOD,Unknown InfoAccess method,SEC_ERROR_BAD_INFO_ACCESS_METHOD),
PKIX_ERRORENTRY(UNKNOWNOBJECTOID,Unknown object OID,0),
PKIX_ERRORENTRY(UNKNOWNOBJECTTYPE,Unknown object type,0),
PKIX_ERRORENTRY(UNKNOWNTYPEARGUMENT,Unknown type argument,0),
PKIX_ERRORENTRY(UNLOCKOBJECTFAILED,pkix_UnlockObject failed,0),
PKIX_ERRORENTRY(UNRECOGNIZEDCRITICALEXTENSION,Unrecognized Critical Extension,SEC_ERROR_UNKNOWN_CRITICAL_EXTENSION),
PKIX_ERRORENTRY(UNRECOGNIZEDCRLENTRYCRITICALEXTENSION,Unrecognized CRLEntry Critical Extension,SEC_ERROR_UNKNOWN_CRITICAL_EXTENSION),
PKIX_ERRORENTRY(UNRECOGNIZEDPROTOCOLREQUESTED,Unrecognized protocol requested,0),
PKIX_ERRORENTRY(UNRECOGNIZEDREQUESTMETHOD,Unrecognized request method,0),
PKIX_ERRORENTRY(UNRECOGNIZEDTIMETYPE,Unrecognized time type,0),
PKIX_ERRORENTRY(UNSUPPORTEDCRLDPTYPE,CrlDp type is not supported,0),
PKIX_ERRORENTRY(UNSUPPORTEDVERSIONOFHTTPCLIENT,Unsupported version of Http Client,0),
PKIX_ERRORENTRY(UNSUPPORTEDCERTUSAGE,Specified certificate usage is unsupported,SEC_ERROR_CERT_USAGES_INVALID),
PKIX_ERRORENTRY(URLPARSINGFAILED,URL Parsing failed,0),
PKIX_ERRORENTRY(USERCHECKERCHECKFAILED,userCheckerCheck failed,0),
PKIX_ERRORENTRY(UTF16ALIGNMENTERROR,UTF16 Alignment Error,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(UTF16HIGHZONEALIGNMENTERROR,UTF16 High Zone Alignment Error,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(UTF16LOWZONEERROR,UTF16 Low Zone Error,SEC_ERROR_INVALID_ARGS),
PKIX_ERRORENTRY(UTF16TOESCASCIIFAILED,pkix_UTF16_to_EscASCII failed,0),
PKIX_ERRORENTRY(UTF16TOUTF8FAILED,pkix_UTF16_to_UTF8 failed,0),
PKIX_ERRORENTRY(UTF8TOUTF16FAILED,pkix_UTF8_to_UTF16 failed,0),
PKIX_ERRORENTRY(VALIDATEBUILDUSEROIDSFAILED,pkix_Validate_BuildUserOIDs failed,0),
PKIX_ERRORENTRY(VALIDATECERTCHAINFAILED,Failed to validate cert chain,0),
PKIX_ERRORENTRY(VALIDATECHAINFAILED,PKIX_ValidateChain failed,0),
PKIX_ERRORENTRY(VALIDATEPARAMSGETCERTCHAINFAILED,PKIX_ValidateParams_GetCertChain failed,0),
PKIX_ERRORENTRY(VALIDATEPARAMSGETPROCESSINGPARAMSFAILED,PKIX_ValidateParams_GetProcessingParams failed,0),
PKIX_ERRORENTRY(VALIDATERESULTCREATEFAILED,pkix_ValidateResult_Create failed,0),
PKIX_ERRORENTRY(VALIDATERESULTGETPOLICYTREEFAILED,PKIX_ValidateResult_GetPolicyTree failed,0),
PKIX_ERRORENTRY(VALIDATERESULTGETTRUSTANCHORFAILED,PKIX_ValidateResult_GetTrustAnchor failed,0),
PKIX_ERRORENTRY(VALIDATIONFAILEDCERTSIGNATURECHECKING,Validation failed: Cert Signature checking,0),
PKIX_ERRORENTRY(VALIDATIONFAILEDNULLCERTPOINTER,Validation failed: NULL Cert pointer,0),
PKIX_ERRORENTRY(VALIDATIONFAILEDPATHTONAMECHECKFAILED,Validation failed: PathToName check failed,SEC_ERROR_CERT_NOT_IN_NAME_SPACE),
PKIX_ERRORENTRY(VALUEINESCAPEDASCII,value in EscapedASCII,0),
PKIX_ERRORENTRY(VERIFYNODEADDTOCHAINFAILED,pkix_VerifyNode_AddToChain failed,0),
PKIX_ERRORENTRY(VERIFYNODEADDTOTREEFAILED,pkix_VerifyNode_AddToTree failed,0),
PKIX_ERRORENTRY(VERIFYNODECREATEFAILED,pkix_VerifyNode_Create failed,0),
PKIX_ERRORENTRY(VERIFYNODEDUPLICATEHELPERFAILED,pkix_VerifyNode_DuplicateHelper failed,0),
PKIX_ERRORENTRY(VERIFYNODEFINDERRORFAILED,pkix_VerifyNode_FindError failed,0),
PKIX_ERRORENTRY(VERIFYNODESETDEPTHFAILED,pkix_VerifyNode_SetDepth failed,0),
PKIX_ERRORENTRY(VERIFYNODESETERRORFAILED,pkix_VerifyNode_SetError failed,0),
PKIX_ERRORENTRY(VERSIONVALUEMUSTBEV1ORV2,Version value must be V1(0) or V2(1),SEC_ERROR_CRL_INVALID),
PKIX_ERRORENTRY(VERSIONVALUEMUSTBEV1V2ORV3,Version value must be v1(0) v2(1) or v3(2),SEC_ERROR_CERT_VALID),
PKIX_ERRORENTRY(X500NAMECOMPAREDERBYTESFAILED,pkix_pl_X500Name_CompareDERBytes failed,0),
PKIX_ERRORENTRY(X500NAMECREATEFAILED,PKIX_PL_X500Name_Create failed,0),
PKIX_ERRORENTRY(X500NAMECREATEFROMCERTNAMEFAILED,pkix_pl_X500Name_CreateFromCERTName failed,0),
PKIX_ERRORENTRY(X500NAMECREATEFROMUTF8FAILED,pkix_pl_X500Name_CreateFromUtf8 failed,0),
PKIX_ERRORENTRY(X500NAMEEQUALSFAILED,PKIX_PL_X500Name_Equals failed,0),
PKIX_ERRORENTRY(X500NAMEGETCOMMONNAMEFAILED,pkix_pl_X500Name_GetCommonName failed,0),
PKIX_ERRORENTRY(X500NAMEGETCOUNTRYNAMEFAILED,pkix_pl_X500Name_GetCountryName failed,0),
PKIX_ERRORENTRY(X500NAMEGETORGNAMEFAILED,pkix_pl_X500Name_GetOrgName failed,0),
PKIX_ERRORENTRY(X500NAMEGETSECNAMEFAILED,pkix_pl_X500Name_GetSECName failed,0),
PKIX_ERRORENTRY(X500NAMEHASHCODEFAILED,PKIX_PL_X500Name_Hashcode failed,0),
PKIX_ERRORENTRY(X500NAMEMATCHFAILED,PKIX_PL_X500Name_Match failed,0),
PKIX_ERRORENTRY(X500NAMETOSTRINGFAILED,PKIX_PL_X500Name_ToString failed,0),
PKIX_ERRORENTRY(ZEROLENGTHBYTEARRAYFORCRLENCODING,Zero-length ByteArray for CRL encoding,0),
PKIX_ERRORENTRY(INVALIDOCSPHTTPMETHOD,Unsupported HTTP Method for OCSP retrieval,0),
PKIX_ERRORENTRY(OCSPGETREQUESTTOOBIG,OCSP request too big for HTTP GET method,0),
PKIX_ERRORENTRY(CERTISBLOCKLISTEDATISSUANCETIME,Issuer Certificate is distrusted at the time the subordinate certifiate was issued,SEC_ERROR_UNTRUSTED_ISSUER)
