; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; In PR41658, argpromotion put an inalloca in a position that per the
; calling convention is passed in a register. This test verifies that
; we don't do that anymore. It also verifies that the combination of
; globalopt and argpromotion is able to optimize the call safely.
;
; RUN: opt -S -passes=argpromotion %s | FileCheck %s --check-prefix=ARGPROMOTION
; RUN: opt -S -passes=globalopt,argpromotion %s | FileCheck %s --check-prefix=GLOBALOPT_ARGPROMOTION

target datalayout = "e-m:x-p:32:32-i64:64-f80:32-n8:16:32-a:0:32-S32"
target triple = "i386-pc-windows-msvc19.11.0"

%struct.a = type { i8 }

define internal x86_thiscallcc void @internalfun(ptr %this, <{ %struct.a }>* inalloca(<{ %struct.a }>)) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@internalfun
; ARGPROMOTION-SAME: (ptr [[THIS:%.*]], ptr inalloca(<{ [[STRUCT_A:%.*]] }>) [[TMP0:%.*]]) {
; ARGPROMOTION-NEXT:  entry:
; ARGPROMOTION-NEXT:    [[A:%.*]] = getelementptr inbounds <{ [[STRUCT_A]] }>, ptr [[TMP0]], i32 0, i32 0
; ARGPROMOTION-NEXT:    [[ARGMEM:%.*]] = alloca inalloca <{ [[STRUCT_A]] }>, align 4
; ARGPROMOTION-NEXT:    [[TMP1:%.*]] = getelementptr inbounds <{ [[STRUCT_A]] }>, ptr [[ARGMEM]], i32 0, i32 0
; ARGPROMOTION-NEXT:    [[CALL:%.*]] = call x86_thiscallcc ptr @copy_ctor(ptr [[TMP1]], ptr dereferenceable(1) [[A]])
; ARGPROMOTION-NEXT:    call void @ext(ptr inalloca(<{ [[STRUCT_A]] }>) [[ARGMEM]])
; ARGPROMOTION-NEXT:    ret void
;
; GLOBALOPT_ARGPROMOTION-LABEL: define {{[^@]+}}@internalfun
; GLOBALOPT_ARGPROMOTION-SAME: (ptr [[TMP0:%.*]]) unnamed_addr {
; GLOBALOPT_ARGPROMOTION-NEXT:  entry:
; GLOBALOPT_ARGPROMOTION-NEXT:    [[A:%.*]] = getelementptr inbounds <{ [[STRUCT_A:%.*]] }>, ptr [[TMP0]], i32 0, i32 0
; GLOBALOPT_ARGPROMOTION-NEXT:    [[ARGMEM:%.*]] = alloca inalloca <{ [[STRUCT_A]] }>, align 4
; GLOBALOPT_ARGPROMOTION-NEXT:    [[TMP1:%.*]] = getelementptr inbounds <{ [[STRUCT_A]] }>, ptr [[ARGMEM]], i32 0, i32 0
; GLOBALOPT_ARGPROMOTION-NEXT:    [[CALL:%.*]] = call x86_thiscallcc ptr @copy_ctor(ptr [[TMP1]], ptr dereferenceable(1) [[A]])
; GLOBALOPT_ARGPROMOTION-NEXT:    call void @ext(ptr inalloca(<{ [[STRUCT_A]] }>) [[ARGMEM]])
; GLOBALOPT_ARGPROMOTION-NEXT:    ret void
;
entry:
  %a = getelementptr inbounds <{ %struct.a }>, <{ %struct.a }>* %0, i32 0, i32 0
  %argmem = alloca inalloca <{ %struct.a }>, align 4
  %1 = getelementptr inbounds <{ %struct.a }>, <{ %struct.a }>* %argmem, i32 0, i32 0
  %call = call x86_thiscallcc ptr @copy_ctor(ptr %1, ptr dereferenceable(1) %a)
  call void @ext(<{ %struct.a }>* inalloca(<{ %struct.a }>) %argmem)
  ret void
}

; This is here to ensure @internalfun is live.
define void @exportedfun(ptr %a) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@exportedfun
; ARGPROMOTION-SAME: (ptr [[A:%.*]]) {
; ARGPROMOTION-NEXT:    [[INALLOCA_SAVE:%.*]] = tail call ptr @llvm.stacksave()
; ARGPROMOTION-NEXT:    [[ARGMEM:%.*]] = alloca inalloca <{ [[STRUCT_A:%.*]] }>, align 4
; ARGPROMOTION-NEXT:    call x86_thiscallcc void @internalfun(ptr [[A]], ptr inalloca(<{ [[STRUCT_A]] }>) [[ARGMEM]])
; ARGPROMOTION-NEXT:    call void @llvm.stackrestore(ptr [[INALLOCA_SAVE]])
; ARGPROMOTION-NEXT:    ret void
;
; GLOBALOPT_ARGPROMOTION-LABEL: define {{[^@]+}}@exportedfun
; GLOBALOPT_ARGPROMOTION-SAME: (ptr [[A:%.*]]) local_unnamed_addr {
; GLOBALOPT_ARGPROMOTION-NEXT:    [[INALLOCA_SAVE:%.*]] = tail call ptr @llvm.stacksave()
; GLOBALOPT_ARGPROMOTION-NEXT:    [[ARGMEM:%.*]] = alloca inalloca <{ [[STRUCT_A:%.*]] }>, align 4
; GLOBALOPT_ARGPROMOTION-NEXT:    call fastcc void @internalfun(ptr [[ARGMEM]])
; GLOBALOPT_ARGPROMOTION-NEXT:    call void @llvm.stackrestore(ptr [[INALLOCA_SAVE]])
; GLOBALOPT_ARGPROMOTION-NEXT:    ret void
;
  %inalloca.save = tail call ptr @llvm.stacksave()
  %argmem = alloca inalloca <{ %struct.a }>, align 4
  call x86_thiscallcc void @internalfun(ptr %a, <{ %struct.a }>* inalloca(<{ %struct.a }>) %argmem)
  call void @llvm.stackrestore(ptr %inalloca.save)
  ret void
}

declare x86_thiscallcc ptr @copy_ctor(ptr returned, ptr dereferenceable(1))
declare void @ext(<{ %struct.a }>* inalloca(<{ %struct.a }>))
declare ptr @llvm.stacksave()
declare void @llvm.stackrestore(ptr)
