/*
# PostgreSQL Database Modeler (pgModeler)
#
# (c) Copyright 2006-2026 - Raphael Araújo e Silva <raphael@pgmodeler.io>
#
# DEVELOPMENT, MAINTENANCE AND COMMERCIAL DISTRIBUTION BY:
# Nullptr Labs Software e Tecnologia LTDA <contact@nullptrlabs.io>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# The complete text of GPLv3 is at LICENSE file on source code root directory.
# Also, you can get the complete GNU General Public License at <http://www.gnu.org/licenses/>
*/

/**
\ingroup libcore
\class CopyOptions
\brief Auxiliary class that helps to control LIKE (Copy tables) options
*/

#ifndef COPY_OPTIONS_H
#define COPY_OPTIONS_H

#include "coreglobal.h"
#include <QString>

class __libcore CopyOptions {
	public:
		enum CopyOpts: unsigned {
			NoOpts = 0,
			Defaults = 1,
			Constraints = 2,
			Indexes = 4,
			Storage = 8,
			Comments = 16,
			Identity = 32,
			Statistics = 64,
			All = 127
		};

		enum CopyMode: unsigned {
			NoMode,
			Including,
			Excluding
		};

	private:
		CopyMode copy_mode;

		CopyOpts copy_opts;

	public:
		CopyOptions();
		CopyOptions(CopyMode copy_mode, CopyOpts copy_op_ids);

		CopyMode getCopyMode();
		CopyOpts getCopyOptions();

		bool isOptionSet(CopyOpts op);
		bool isIncluding();
		bool isExcluding();

		QString getSQLDefinition();
		bool operator != (CopyOptions &cp);
};

#endif
