#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""Add HTTP Strict Transport Security support

Revision ID: 632152d2d32e
Revises: 0995c26fc506
Create Date: 2023-04-19 13:36:44.015581

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '632152d2d32e'
down_revision = '0995c26fc506'


def upgrade():
    op.add_column(
        'listener',
        sa.Column('hsts_max_age', sa.Integer, nullable=True)
    )
    op.add_column(
        'listener',
        sa.Column('hsts_include_subdomains', sa.Boolean, nullable=True)
    )
    op.add_column(
        'listener',
        sa.Column('hsts_preload', sa.Boolean, nullable=True)
    )
