if(NOT USE_CODEC_VORBIS)
    return()
endif()

if(NOT BUILD_CLIENT)
    return()
endif()

include(utils/disable_warnings)

set(INTERNAL_VORBIS_DIR ${SOURCE_DIR}/thirdparty/libvorbis-1.3.7)

if(USE_INTERNAL_VORBIS)
    file(GLOB_RECURSE VORBIS_SOURCES ${INTERNAL_VORBIS_DIR}/*.c)
    disable_warnings(${VORBIS_SOURCES})
    set(VORBIS_INCLUDE_DIRS ${INTERNAL_VORBIS_DIR}/include ${INTERNAL_VORBIS_DIR}/lib)
    list(APPEND CLIENT_LIBRARY_SOURCES ${VORBIS_SOURCES})
else()
    find_package(PkgConfig REQUIRED)
    pkg_check_modules(VORBIS REQUIRED vorbis)
    pkg_check_modules(VORBISFILE REQUIRED vorbisfile)
endif()

list(APPEND CLIENT_LIBRARIES ${VORBIS_LIBRARIES} ${VORBISFILE_LIBRARIES})
list(APPEND CLIENT_INCLUDE_DIRS ${VORBIS_INCLUDE_DIRS} ${VORBISFILE_INCLUDE_DIRS})
list(APPEND CLIENT_DEFINITIONS USE_CODEC_VORBIS ${VORBIS_DEFINITIONS} ${VORBISFILE_DEFINITIONS})
