/* Bluefish HTML Editor
 * languages.h - available languages
 *
 * Copyright (C) 2010 Daniel Leidert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LANGUAGES_H_
#define __LANGUAGES_H_

GList * lingua_list_sorted (void);
gchar * lingua_lang_to_locale (const gchar *lang);
const gchar * lingua_locale_to_lang (const gchar *locale);
gboolean lingua_locale_is_uptodate(const gchar *locale);
void lingua_cleanup(void);
#ifdef WIN32
gboolean lingua_set_thread_locale_on_windows (const gchar *locale);
#endif /* WIN32 */
#endif /* __LANGUAGES_H_ */
