<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace EzSystems\EzPlatformAdminUi\UI\Config;

use RuntimeException;

class ConfigWrapper implements \ArrayAccess, \JsonSerializable
{
    /** @var array */
    private $config;

    /**
     * @param array $config
     */
    public function __construct(array $config)
    {
        $this->config = $config;
    }

    public function offsetExists($offset)
    {
        return isset($this->config[$offset]);
    }

    public function offsetGet($offset)
    {
        return $this->config[$offset];
    }

    public function offsetSet($offset, $value)
    {
        throw new RuntimeException('Configuration is readonly');
    }

    public function offsetUnset($offset)
    {
        throw new RuntimeException('Configuration is readonly');
    }

    public function jsonSerialize()
    {
        return $this->config;
    }
}
