<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
namespace eZ\Publish\Core\Persistence\Legacy\Content\UrlAlias\DTO;

/**
 * @internal To be used internally by UrlAlias Persistence Handler.
 */
class SwappedLocationProperties
{
    public function __construct($id, $parentId)
    {
        $this->id = $id;
        $this->parentId = $parentId;
    }

    /** @var int */
    public $id;

    /** @var int */
    public $parentId;

    /** @var string */
    public $name;

    /** @var int */
    public $mainLanguageId;

    /** @var int */
    public $autogeneratedId;

    /** @var bool */
    public $isAlwaysAvailable;

    /**
     * Raw database records (entries).
     *
     * @var array
     */
    public $entries;
}
