<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace eZ\Publish\API\Repository\Iterator\BatchIteratorAdapter;

use eZ\Publish\API\Repository\SearchService;
use eZ\Publish\API\Repository\Values\Content\LocationQuery;
use eZ\Publish\API\Repository\Values\Content\Query;
use eZ\Publish\API\Repository\Values\Content\Search\SearchResult;

final class LocationSearchAdapter extends AbstractSearchAdapter
{
    public function __construct(
        SearchService $searchService,
        LocationQuery $query,
        array $languageFilter = [],
        bool $filterOnUserPermissions = true
    ) {
        parent::__construct($searchService, $query, $languageFilter, $filterOnUserPermissions);
    }

    protected function executeSearch(Query $query): SearchResult
    {
        return $this->searchService->findLocations(
            $query,
            $this->languageFilter,
            $this->filterOnUserPermissions
        );
    }
}
