<?php

/**
 * @copyright Copyright (C) eZ Systems AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace EzSystems\Tests\EzPlatformRichText\eZ\FieldType\RichText\Gateway;

use EzSystems\EzPlatformRichText\eZ\FieldType\RichText\RichTextStorage\Gateway\DoctrineStorage;
use eZ\Publish\Core\FieldType\Url\UrlStorage\Gateway\DoctrineStorage as UrlStorageDoctrineGateway;
use eZ\Publish\Core\Persistence\Legacy\Tests\TestCase;

/**
 * Tests the RichText DoctrineStorage.
 */
class DoctrineStorageTest extends TestCase
{
    /**
     * @var \EzSystems\EzPlatformRichText\eZ\FieldType\RichText\RichTextStorage\Gateway\DoctrineStorage
     */
    protected $storageGateway;

    public function testGetContentIds()
    {
        $this->insertDatabaseFixture(__DIR__ . '/_fixtures/contentobjects.php');

        $gateway = $this->getStorageGateway();

        $this->assertEquals(
            [
                'f5c88a2209584891056f987fd965b0ba' => 4,
                'faaeb9be3bd98ed09f606fc16d144eca' => 10,
            ],
            $gateway->getContentIds(
                [
                    'f5c88a2209584891056f987fd965b0ba',
                    'faaeb9be3bd98ed09f606fc16d144eca',
                    'fake',
                ]
            )
        );
    }

    /**
     * Return a ready to test DoctrineStorage gateway.
     *
     * @return \EzSystems\EzPlatformRichText\eZ\FieldType\RichText\RichTextStorage\Gateway\DoctrineStorage
     */
    protected function getStorageGateway()
    {
        if (!isset($this->storageGateway)) {
            $connection = $this->getDatabaseConnection();
            $urlGateway = new UrlStorageDoctrineGateway($connection);
            $this->storageGateway = new DoctrineStorage($urlGateway, $connection);
        }

        return $this->storageGateway;
    }
}
