<?php

/**
 * @copyright Copyright (C) eZ Systems AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace EzSystems\EzPlatformRest\Server\Input\Parser\Aggregation\Range;

use EzSystems\EzPlatformRest\Input\ParsingDispatcher;

final class IntRangeParser extends AbstractRangeParser
{
    protected function visitRangeValue(ParsingDispatcher $parsingDispatcher, $value): ?int
    {
        if ($value === null) {
            return null;
        }

        return (int)$value;
    }
}
