<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\AdminUi\Limitation\Mapper;

use eZ\Publish\API\Repository\RoleService;
use eZ\Publish\API\Repository\Values\User\Limitation;
use EzSystems\EzPlatformAdminUi\Limitation\LimitationValueMapperInterface;
use EzSystems\EzPlatformAdminUi\Limitation\Mapper\MultipleSelectionBasedMapper;

final class RoleLimitationMapper extends MultipleSelectionBasedMapper implements LimitationValueMapperInterface
{
    /** @var \eZ\Publish\API\Repository\RoleService */
    private $roleService;

    public function __construct(
        RoleService $roleService
    ) {
        $this->roleService = $roleService;
    }

    protected function getSelectionChoices(): array
    {
        $choices = [];
        foreach ($this->roleService->loadRoles() as $role) {
            $choices[$role->id] = $role->identifier;
        }

        return $choices;
    }

    public function mapLimitationValue(Limitation $limitation): array
    {
        $values = [];

        foreach ($limitation->limitationValues as $roleId) {
            $values[] = $this->roleService->loadRole((int)$roleId)->identifier;
        }

        return $values;
    }
}
