<?php

/**
 * @copyright Copyright (C) eZ Systems AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace EzSystems\EzPlatformContentForms\Validator\Constraints;

use eZ\Publish\API\Repository\FieldTypeService;
use EzSystems\EzPlatformContentForms\Validator\ValidationErrorsProcessor;
use Symfony\Component\Validator\ConstraintValidator;

abstract class FieldTypeValidator extends ConstraintValidator
{
    /**
     * @var FieldTypeService
     */
    protected $fieldTypeService;

    public function __construct(FieldTypeService $fieldTypeService)
    {
        $this->fieldTypeService = $fieldTypeService;
    }

    /**
     * @param \eZ\Publish\SPI\FieldType\ValidationError[] $validationErrors
     */
    protected function processValidationErrors(array $validationErrors)
    {
        $validationErrorsProcessor = $this->createValidationErrorProcessor();
        $validationErrorsProcessor->processValidationErrors($validationErrors);
    }

    /**
     * Generates the property path an error is meant to.
     * This property path depends on the error target and on the object being validated.
     *
     * Example: "validatorConfiguration[StringLengthValidator][minStringLength]"
     * Defaults to an empty string.
     *
     * @param int $errorIndex index in the error stack (0 indexed)
     * @param string $errorTarget error target, generated by API/SPI
     *
     * @return string
     */
    protected function generatePropertyPath($errorIndex, $errorTarget)
    {
        return '';
    }

    /**
     * @return \EzSystems\EzPlatformContentForms\Validator\ValidationErrorsProcessor
     */
    private function createValidationErrorProcessor(): ValidationErrorsProcessor
    {
        return new ValidationErrorsProcessor($this->context, function ($index, $target) {
            return $this->generatePropertyPath($index, $target);
        });
    }
}
