/***************************************************************************
 *   Copyright (C) 2005 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "addcatalogdlg.h"

#include <tqlabel.h>
#include <tqcombobox.h>

#include <klineedit.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <kdebug.h>

#include "docutils.h"
#include "kdevdocumentationplugin.h"

AddCatalogDlg::AddCatalogDlg( TQValueList<DocumentationPlugin*> const & plugins, 
	TQWidget* parent, const char* name, bool modal, WFlags fl)
	:AddCatalogDlgBase(parent,name, modal,fl), m_plugins( plugins )
{
	for (TQValueList<DocumentationPlugin*>::const_iterator it = m_plugins.constBegin(); it != m_plugins.constEnd(); ++it)
	{
		docTypeCombo->insertItem( (*it)->pluginName() );
	}
	
	docTypeChanged( TQString() );
}

AddCatalogDlg::~AddCatalogDlg()
{
}

void AddCatalogDlg::locationURLChanged(const TQString &text)
{
	DocumentationPlugin * plugin = this->plugin();
	if ( !plugin ) return;
	
	titleEdit->setText( plugin->catalogTitle(DocUtils::noEnvURL(text)) );
}

void AddCatalogDlg::accept()
{
    TQDialog::accept();
}

TQString AddCatalogDlg::title() const
{
    return titleEdit->text();
}

TQString AddCatalogDlg::url() const
{
    return DocUtils::envURL(locationURL);
}

void AddCatalogDlg::setTitle(const TQString &title)
{
    titleEdit->setText(title);
}

void AddCatalogDlg::setURL(const TQString &url)
{
    locationURL->setURL(url);
}

DocumentationPlugin * AddCatalogDlg::plugin( )
{
	for (TQValueList<DocumentationPlugin*>::const_iterator it = m_plugins.constBegin(); it != m_plugins.constEnd(); ++it)
	{
		if ( docTypeCombo->currentText() == (*it)->pluginName() )
		{
			return *it;
		}
	}
	return 0;
}

void AddCatalogDlg::docTypeChanged( const TQString & )
{
	kdDebug() << k_funcinfo << endl;

	DocumentationPlugin * plugin = this->plugin();
	if ( plugin )
	{
		titleLabel->setEnabled(true);
		titleEdit->setEnabled(true);
		locationURL->setMode(plugin->catalogLocatorProps().first);
		locationURL->setFilter(plugin->catalogLocatorProps().second);
	}
	
}



#include "addcatalogdlg.moc"
