/***************************************************************************
 *   Copyright (C) 2004 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTAGS2_WIDGET_H
#define CTAGS2_WIDGET_H

#include "ctags2_widgetbase.h"
#include "ctags2_part.h"
#include "tags.h"

class TQTimer;
class TQListViewItem;

class CTags2Widget : public CTags2WidgetBase
{
	TQ_OBJECT
  

public:
	CTags2Widget( CTags2Part * part, const char* name = 0, WFlags fl = 0 );
	~CTags2Widget();

	void displayHits( Tags::TagList const & );
	void displayHitsAndClear( Tags::TagList const & );
  
	void updateDBDateLabel();
	void goToNext();

protected:
	void focusInEvent( TQFocusEvent *e );
		
private slots:
    virtual void line_edit_changed();
    virtual void line_edit_changed_delayed();
	virtual void regeneratebutton_clicked();	  
	void itemExecuted( TQListViewItem * );

private: 
	void showHitCount( int );
	int calculateHitCount();
	
	CTags2Part * _part;
	TQTimer * _typeTimeout;

};

#endif
