/*
    This file is part of KAddressBook.
    Copyright (C) 1999 Don Sanders <sanders@kde.org>
                  2005 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef COMMANDS_H
#define COMMANDS_H

// Commands for undo/redo functionality.

#include <tqstring.h>
#include <tqstringlist.h>

#include <tdeabc/addressbook.h>
#include <tdeabc/addressee.h>
#include <tdeabc/vcardparser.h> // for KABC_VCARD_ENCODING_FIX define

#include <kcommand.h>

#include "kablock.h"

namespace KAB {
class Core;
}

class Command : public KCommand
{
  public:
    Command( TDEABC::AddressBook *addressBook ) { mAddressBook = addressBook; }

  protected:
    TDEABC::AddressBook *addressBook() const { return mAddressBook; }
    KABLock *lock() const { return KABLock::self( mAddressBook ); }
  bool resourceExist( TDEABC::Resource *resource );
  private:
    TDEABC::AddressBook* mAddressBook;
};

class DeleteCommand : public Command
{
  public:
    DeleteCommand( TDEABC::AddressBook *addressBook, const TQStringList &uidList );

    virtual TQString name() const;
    virtual void unexecute();
    virtual void execute();

  private:
    TDEABC::Addressee::List mAddresseeList;
    TQStringList mUIDList;
};

class PasteCommand : public Command
{
  public:
    PasteCommand( KAB::Core *core,
                  const TDEABC::Addressee::List &addressees );

    virtual TQString name() const;
    virtual void unexecute();
    virtual void execute();

  private:
    TDEABC::Addressee::List mAddresseeList;
    KAB::Core *mCore;
};

class CutCommand : public Command
{
  public:
    CutCommand( TDEABC::AddressBook *addressBook, const TQStringList &uidList );

    virtual TQString name() const;
    virtual void unexecute();
    virtual void execute();

  private:
    TDEABC::Addressee::List mAddresseeList;
    TQStringList mUIDList;
#if defined(KABC_VCARD_ENCODING_FIX)
    TQByteArray mClipText;
#else
    TQString mClipText;
#endif
    TQString mOldText;
};

class NewCommand : public Command
{
  public:
    NewCommand( TDEABC::AddressBook *addressBook,
                const TDEABC::Addressee::List &addressees );

    virtual TQString name() const;
    virtual void unexecute();
    virtual void execute();

  private:
    TDEABC::Addressee::List mAddresseeList;
};

class EditCommand : public Command
{
  public:
    EditCommand( TDEABC::AddressBook *addressBook, const TDEABC::Addressee &oldAddressee,
                 const TDEABC::Addressee &newAddressee );

    virtual TQString name() const;
    virtual void unexecute();
    virtual void execute();

  private:
    TDEABC::Addressee mOldAddressee;
    TDEABC::Addressee mNewAddressee;
};

class CopyToCommand : public Command
{
    public:
        CopyToCommand( TDEABC::AddressBook *addressBook, const TQStringList &uidList,
                               TDEABC::Resource *resource );

        virtual TQString name() const;
        virtual void unexecute();
        virtual void execute();

    private:
        TDEABC::Addressee::List mAddresseeList;
        TQStringList mUIDList;
        TDEABC::Resource *mResource;
};

class MoveToCommand : public Command
{
    public:
        MoveToCommand( KAB::Core *core, const TQStringList &uidList,
                               TDEABC::Resource *resource );

        virtual TQString name() const;
        virtual void unexecute();
        virtual void execute();
        void moveContactTo( TDEABC::Resource *resource );

    private:
        TDEABC::Addressee::List mAddresseeList;
        TQStringList mUIDList;
        TDEABC::Resource *mResource;
        KAB::Core *mCore;
};
#endif
