/*
    Naughty applet - Runaway process monitor for the TDE panel

    Copyright 2000 Rik Hemsley (rikkus) <rik@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef NAUGHTY_CONFIG_DIALOG_H
#define NAUGHTY_CONFIG_DIALOG_H

#include <kdialogbase.h>

class KEditListBox;
class KIntNumInput;

class NaughtyConfigDialog : public KDialogBase
{
  TQ_OBJECT

  public:

    NaughtyConfigDialog
      (
       const TQStringList & items,
       uint interval,
       uint threshold,
       TQWidget * parent = 0,
       const char * name = 0
      );

    ~NaughtyConfigDialog();

    TQStringList ignoreList() const;
    uint updateInterval() const;
    uint threshold() const;

  private:

    KEditListBox * listBox_;

    KIntNumInput * kini_updateInterval_;
    KIntNumInput * kini_threshold_;
};

#endif
