/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_CONF_H
#define KSV_CONF_H

#include <tqstring.h>
#include <tqpoint.h>
#include <tqfont.h>
#include <tqcolor.h>
#include <tqmap.h>

#include "ksv_core.h"

class TDEConfig;

class KSVConfig
{
public:
  
  inline ~KSVConfig() {}

  void readSettings();
  void readLegacySettings ();
  void writeSettings();

  void setPanningFactor (int val);

  inline void setShowLog( bool val = false )
  {
    mShowLog = val;
  }

  void setNewNormalColor (const TQColor& color);
  void setNewSelectedColor (const TQColor& color);
  void setChangedNormalColor (const TQColor& color);
  void setChangedSelectedColor (const TQColor& color);

  void setServiceFont (const TQFont& font);
  void setNumberFont (const TQFont& font);

  void setScriptPath (const TQString& path);
  void setRunlevelPath (const TQString& path);

  inline void setConfigured( bool val = true )
  {
    mConfigured = val;
  }

  inline void setShowDescription (bool val)
  {
	mShowDescription = val;
  }

  inline bool showLog() const
  {
    return mShowLog;
  }

  inline int panningFactor() const
  {
    return mPanningFactor;
  }

  inline const TQFont& serviceFont () const { return mServiceFont; }
  inline const TQFont& numberFont () const { return mNumberFont; }

  TQPoint position() const;

  inline const TQColor& newNormalColor () const { return mNewNormalColor; }
  inline const TQColor& newSelectedColor () const { return mNewSelectedColor; }

  inline const TQColor& changedNormalColor () const { return mChangedNormalColor; }
  inline const TQColor& changedSelectedColor () const { return mChangedSelectedColor; }
  
  bool showRunlevel (int index) const;
  void setShowRunlevel (int index, bool state);
  void readRunlevels ();
  void writeRunlevels ();

  /**
   * Have the necessary config entries
   * been written?
   */
  inline bool isConfigured() const
  {
    return mConfigured;
  }

  inline const TQString& scriptPath() const
  {
    return mScriptPath;
  }

  inline const TQString& runlevelPath() const
  {
    return mRunlevelPath;
  }

  inline bool showDescription() const
  {
	return mShowDescription;
  }

  bool showMessage (ksv::Messages msg) const;
  void setShowMessage (ksv::Messages msg, bool on);

  static KSVConfig* self ();

private:
  KSVConfig ();

  TQString mScriptPath;
  TQString mRunlevelPath;
  bool mShowLog;
  bool mConfigured;
  TDEConfig* mConfig;
  int mPanningFactor;

  TQColor mNewNormalColor, mNewSelectedColor;
  TQColor mChangedNormalColor, mChangedSelectedColor;

  bool mShowDescription;

  TQMap<int, bool> mShowRunlevel;

  TQFont mServiceFont;
  TQFont mNumberFont;
};

#endif // KSV_CONF_H

