/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KCHMSEARCHTOOLBAR_H
#define KCHMSEARCHTOOLBAR_H

#include "tde-tqt.h"

#include "forwarddeclarations.h"

#include "kqtempfile.h"

/**
@author Georgy Yunaev
*/
class KCHMSearchAndViewToolbar : public TQToolBar
{
	TQ_OBJECT
  
	public:
		KCHMSearchAndViewToolbar (KCHMMainWindow *parent);
	
		void	setEnabled (bool enable);
		void	setChosenEncodingInMenu( const LCHMTextEncoding * encoding );
	
	private slots:
		void	onReturnPressed();
		void	onBtnPrevSearchResult();
		void	onBtnNextSearchResult();
		void	onAccelFocusSearchField();
		
		void	onBtnFontInc();
		void	onBtnFontDec();
		void	onBtnViewSource();
		void	onBtnAddBookmark();
		void	onBtnNextPageInToc();
		void	onBtnPrevPageInToc();
		void	onMenuActivated ( int id );
		void	onBtnFullScreen();
		void	onBtnLocateInContentWindow();
		void	onBtnToggleContentWindow();
		
		void	setFullScreen( bool enable );
		void	showContentsWindow( bool enable );
		
	private:
		void	search (bool forward);
		
		KTQPopupMenu 		*	m_MenuView;
		TQComboBox			*	m_findBox;
		TQToolButton			*	m_buttonPrev;
		TQToolButton			*	m_buttonNext;
		TQToolButton			*	m_buttonFontInc;
		TQToolButton			*	m_buttonFontDec;
		TQToolButton			*	m_buttonViewSource;
		TQToolButton			*	m_buttonAddBookmark;
		TQToolButton			*	m_buttonNextPageInTOC;
		TQToolButton			*	m_buttonPrevPageInTOC;
		TQToolButton			*	m_buttonLocateInContent;
		
		int						m_checkedLanguageInMenu;
		int						m_checkedEncodingInMenu;
		
		int						m_menuShowFullscreenMenuID;
		int						m_menuShowContentWindowMenuID;
		
		KTQTempFileKeeper		m_tempFileKeeper;
};

#endif
