/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "reader.h"

#include "view.h"

#include <tqpixmap.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <kdebug.h>

Reader::Reader(TQObject *parent, const char *name) :
	TQObject(parent, name),
	logManager(NULL)
	{
	
	watch=new KDirWatch();
	kdDebug() << watch->internalMethod() << endl;
	connect(watch, TQ_SIGNAL(dirty(const TQString&)), this, TQ_SLOT(logChanged(const TQString&)));
}

Reader::~Reader() {
	/**
	 * Remove the watching on the monitored files
	 */
	LogFiles& files=logManager->getLogFiles();
	LogFiles::iterator it;
	
	for(it=files.begin(); it!=files.end(); ++it) {
		LogFile* file=*it;
		
		kdDebug() << "Remove the monitoring on file : " << file->url.path() << endl;
		watch->removeFile(file->url.path());
	}
	
	//Delete the watching object
	delete watch;
}


void Reader::setLogManager(LogManager* manager) {
	logManager=manager;
}

void Reader::watchLogFiles() {
	LogFiles& files=logManager->getLogFiles();
	LogFiles::iterator it;
	
	for(it=files.begin(); it!=files.end(); ++it) {
		LogFile* file=*it;
		
		watchLogFile(file);
	}

}

void Reader::watchLogFile(LogFile* file) {
	kdDebug() << "Monitoring file : " << file->url.path() << endl;
	watch->addFile(file->url.path());
}

void Reader::logChanged(LogFile* file) {
	kdDebug() << "Reader: " << file->url.path() << " has changed !" << endl;
}

void Reader::relaunchLogChanged() {
	kdDebug() << "Relaunch log changed" << endl;
	
	LogFiles& files=logManager->getLogFiles();
	LogFiles::iterator it;
	
	for(it=files.begin(); it!=files.end(); ++it) {
		LogFile* file=*it;
		
		logChanged(file);
	}
	
}


void Reader::logChanged(const TQString& name) {
	if (!logManager->isParsingPaused()) {
		LogFiles& files=logManager->getLogFiles();
		LogFiles::iterator it;
		
		for(it=files.begin(); it!=files.end(); ++it) {
			LogFile* file=*it;
			
			if (file->url.path() == name) {
				logChanged(file);
			}
		}
	}
}


void Reader::closeFile(TQFile* file) {
	file->close();
	delete file;
}

TQFile* Reader::openFile(TQString name) {
	TQString message;
	
	KURL testURL(name);

	if (testURL.isValid()==false) {
		message=i18n("This file is not valid. Please adjust it in the settings of KSystemLog.");
		KMessageBox::error(logManager->getView(), message, i18n("The File Does Not Exist"), KMessageBox::Notify);
		emit statusbarChanged(message);
		return(NULL);
	}
		
	TQString path=testURL.path();
	
	TQFile* file=new TQFile(path);
	
	//If the file does not exist
	if(! file->exists()) {
		message=i18n("The file '%1' does not exist.").arg(name);
		KMessageBox::error(logManager->getView(), message, i18n("The File Does Not Exist"), KMessageBox::Notify);
		emit statusbarChanged(message);
		return(NULL);
	}
	
	//If we can open the file
	if( !file->open( IO_ReadOnly ) ) {
		//It could not be opened
		message=i18n("You do not have sufficient permissions to read '%1'.").arg(name);
		KMessageBox::error(logManager->getView(), message, i18n("Insufficient Permissions"), KMessageBox::Notify);
		emit statusbarChanged(message);
		return(NULL);
	}
	
	return(file);

}

#include "reader.moc"
