/***************************************************************************
 *   Copyright (C) 2004 by Juanjo                                          *
 *   juanjux@yahoo.es                                                      *
 *                                                                         *
 *   Copyright (C) 2004 by Mario Bensi                                     *
 *   nef@ipsquad.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef _TDEALTERNATIVES_H_
#define _TDEALTERNATIVES_H_

#include <config.h>

#include <tdelistview.h>
#include <kpushbutton.h> 
#include <kcombobox.h> 
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tdecmodule.h>
#include <tdeaboutdata.h>

class AltFilesManager;

class TDEAlternatives : public TDECModule
{
	TQ_OBJECT

	bool m_bisRoot;
	AltFilesManager *m_mgr;
	TDEListView* m_optionsList;
	TDEListView* m_altList;
	KComboBox* m_statusCombo;
	TQLabel* m_altTilte;
	TQCheckBox* m_hideAlt;
	TDEAboutData *myAboutData;

	void clearList(TDEListView* list);

public:
	TDEAlternatives(TQWidget *parent=0, const char *name=0, const TQStringList& = TQStringList() );
	virtual ~TDEAlternatives();
	TDEListView *optionsList() const {return m_optionsList;}
	bool isBisRoot() const {return m_bisRoot;}

	virtual void load();
	virtual void save();
	virtual TQString quickHelp() const;
	virtual const TDEAboutData *aboutData()const { return myAboutData; };

public slots:
	void configChanged();

private slots:
	void slotSelectAlternativesClicked(TQListViewItem *);
	void slotHideAlternativesClicked();
	void die();
	void slotOptionClicked(TQListViewItem *option);
	void slotAddClicked();
	void slotDeleteClicked();
	void slotPropertiesClicked();
};

#endif // _TDEALTERNATIVES_H_
