/***************************************************************************
    smb4knetworkbrowseritem  -  Smb4K's network browser list item.
                             -------------------
    begin                : Mo Jan 8 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqpainter.h>

// KDE includes
#include <kiconloader.h>
#include <kicontheme.h>

// application specific includes
#include "smb4knetworkbrowseritem.h"

Smb4KNetworkBrowserItem::Smb4KNetworkBrowserItem( TQListView *parent, Smb4KWorkgroupItem *item )
: TDEListViewItem( parent, item->name() ), m_type( Workgroup ), m_workgroup( *item ),
m_mounted( false )
{
  setIcon();
}


Smb4KNetworkBrowserItem::Smb4KNetworkBrowserItem( TQListViewItem *parent, Smb4KHostItem *item )
: TDEListViewItem( parent, item->name(), TQString(), item->ip(), item->comment()  ),
m_type( Host ), m_host( *item ), m_mounted( false )
{
  setIcon();
}


Smb4KNetworkBrowserItem::Smb4KNetworkBrowserItem( TQListViewItem *parent, Smb4KShareItem *item )
: TDEListViewItem( parent, item->name(), item->plainType(), TQString(), item->comment() ),
m_type( Share ), m_share( *item ), m_mounted( false )
{
  setIcon();
}


Smb4KNetworkBrowserItem::~Smb4KNetworkBrowserItem()
{
}


void Smb4KNetworkBrowserItem::setIcon()
{
  switch ( m_type )
  {
    case Workgroup:
    {
      m_desktop_icon = DesktopIcon( "network_local" );
      setPixmap( 0, SmallIcon( "network_local" ) );
      break;
    }
    case Host:
    {
      m_desktop_icon = DesktopIcon( "server" );
      setPixmap( 0, SmallIcon( "server" ) );
      break;
    }
    case Share:
    {
      if ( m_share.isPrinter() )
      {
        m_desktop_icon = DesktopIcon( "printer" );
        setPixmap( 0, SmallIcon( "printer" ) );
      }
      else
      {
        if ( m_mounted )
        {
          m_desktop_icon = DesktopIcon( "folder_open", 0, TDEIcon::ActiveState );
          setPixmap( 0, SmallIcon( "folder_open", 0, TDEIcon::ActiveState ) );
        }
        else
        {
          m_desktop_icon = DesktopIcon( "folder", 0, TDEIcon::DefaultState );
          setPixmap( 0, SmallIcon( "folder", 0, TDEIcon::DefaultState ) );
        }
      }
      break;
    }
    default:
    {
      break;
    }
  }
}


Smb4KNetworkBrowserItem::ItemType Smb4KNetworkBrowserItem::type()
{
  return m_type;
}


Smb4KWorkgroupItem *Smb4KNetworkBrowserItem::workgroupItem()
{
  return (m_type == Workgroup ? &m_workgroup : NULL);
}


Smb4KHostItem *Smb4KNetworkBrowserItem::hostItem()
{
  return (m_type == Host ? &m_host : NULL);
}


Smb4KShareItem *Smb4KNetworkBrowserItem::shareItem()
{
  return (m_type == Share ? &m_share : NULL);
}


void Smb4KNetworkBrowserItem::update( Smb4KWorkgroupItem *item )
{
  m_workgroup = *item;
}


void Smb4KNetworkBrowserItem::update( Smb4KHostItem *item )
{
  m_host = *item;

  if ( !m_host.ip().isEmpty() && TQString::compare( text( IP ).stripWhiteSpace(), m_host.ip() ) != 0 )
  {
    setText( IP, m_host.ip() );
  }

  if ( TQString::compare( text( Comment ).stripWhiteSpace(), m_host.comment() ) != 0 )
  {
    setText( Comment, m_host.comment() );
  }
}


void Smb4KNetworkBrowserItem::update( Smb4KShareItem *item )
{
  m_share = *item;

  if ( !m_share.comment().isEmpty() && TQString::compare( text( Comment ).stripWhiteSpace(), m_share.comment() ) != 0 )
  {
    setText( Comment, m_share.comment() );
  }
}


bool Smb4KNetworkBrowserItem::isPrinter()
{
  bool is_printer = false;

  if ( m_type == Share )
  {
    is_printer = m_share.isPrinter();
  }

  return is_printer;
}


void Smb4KNetworkBrowserItem::setMounted( bool mounted )
{
  if ( m_type == Share && TQString::compare( m_share.plainType(), "Disk" ) == 0 )
  {
    m_mounted = mounted;

    setIcon();
  }
  else
  {
    // Do nothing
  }
}


bool Smb4KNetworkBrowserItem::isMounted()
{
  return m_mounted;
}


void Smb4KNetworkBrowserItem::paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int align )
{
  TQFont f( p->font() );
  TQColorGroup colorgrp( cg );

  if ( m_type == Share && m_mounted )
  {
    f.setItalic( true );
  }
  else
  {
    f.setItalic( false );
  }

  if ( m_type == Host && m_host.isMaster() )
  {
    colorgrp.setColor( TQColorGroup::Text, TQt::darkBlue );
  }
  else
  {
    colorgrp.setColor( TQColorGroup::Text, cg.text() );
  }

  p->setFont( f );

  TQListViewItem::paintCell( p, colorgrp, column, width, align );
}
