/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-08-02
 * Description : theme engine methods
 * 
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef THEMEENGINE_H
#define THEMEENGINE_H

// TQt includes.

#include <tqstringlist.h>
#include <tqobject.h>
#include <tqcolor.h>
#include <tqpixmap.h>
#include <tqdom.h>

// Digikam includes.

#include "digikam_export.h"

namespace Digikam
{

class Theme;
class ThemeEnginePriv;

class DIGIKAM_EXPORT ThemeEngine : public TQObject
{
    TQ_OBJECT
  

public:

    ~ThemeEngine();
    static ThemeEngine* instance();

    void        scanThemes();
    TQStringList themeNames() const;
    bool        saveTheme();

    void    setCurrentTheme(const TQString& name);
    void    setCurrentTheme(const Theme& theme, const TQString& name,
                            bool loadFromDisk=false);

    Theme*  getCurrentTheme() const;
    TQString getCurrentThemeName() const;

    TQColor  baseColor()     const;
    TQColor  thumbSelColor() const;
    TQColor  thumbRegColor() const;

    TQColor  textRegColor() const;
    TQColor  textSelColor() const;
    TQColor  textSpecialRegColor() const;
    TQColor  textSpecialSelColor() const;

    TQPixmap bannerPixmap(int w, int h);
    TQPixmap thumbRegPixmap(int w, int h);
    TQPixmap thumbSelPixmap(int w, int h);
    TQPixmap listRegPixmap(int w, int h);
    TQPixmap listSelPixmap(int w, int h);

private:

    ThemeEngine();
    static ThemeEngine* m_instance;

    void    buildDefaultTheme();
    bool    loadTheme();
    void    changePalette();
    TQString resourceValue(const TQDomElement &rootElem, const TQString& key);

signals:

    void signalThemeChanged();

public slots:

    void slotChangeTheme(const TQString& name);

private:

    ThemeEnginePriv* d;
};

}  // NameSpace Digikam

#endif /* THEMEENGINE_H */
