/***************************************************************************
                          knightspixcache.h  -  description
                             -------------------
    begin                : Mon Aug 20 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNIGHTSPIXCACHE_H
#define KNIGHTSPIXCACHE_H

#include <tqvaluelist.h>
#include <tqpixmap.h>
#include <tqimage.h>

/**
  *@author Troy Corbin Jr.
  */

struct cacheItem
{
	TQString				label;
	TQPixmap				item;
	unsigned int	bytes;
	unsigned int	age;
};

typedef TQValueList<cacheItem> pixmapList;

class KnightsPixCache
{
		public:
		TQPixmap								SquareLight;
		TQPixmap								SquareDark;
		TQPixmap								HighlightSelect;
		TQPixmap								HighlightMove;
		TQPixmap								HighlightAttack;
		TQPixmap								BlackKing;
		TQPixmap								BlackQueen;
		TQPixmap								BlackBishop;
		TQPixmap								BlackKnight;
		TQPixmap								BlackRook;
		TQPixmap								BlackPawn;
		TQPixmap								WhiteKing;
		TQPixmap								WhiteQueen;
		TQPixmap								WhiteBishop;
		TQPixmap								WhiteKnight;
		TQPixmap								WhiteRook;
		TQPixmap								WhitePawn;
		TQPixmap								Border;
		TQPixmap								BorderLightOn;
		TQPixmap								BorderLightOff;

		TQImage								Orig_SquareLight;
		TQImage								Orig_SquareDark;
		TQImage								Orig_HighlightSelect;
		TQImage								Orig_HighlightMove;
		TQImage								Orig_HighlightAttack;
		TQImage								Orig_BlackKing;
		TQImage								Orig_BlackQueen;
		TQImage								Orig_BlackBishop;
		TQImage								Orig_BlackKnight;
		TQImage								Orig_BlackRook;
		TQImage								Orig_BlackPawn;
		TQImage								Orig_WhiteKing;
		TQImage								Orig_WhiteQueen;
		TQImage								Orig_WhiteBishop;
		TQImage								Orig_WhiteKnight;
		TQImage								Orig_WhiteRook;
		TQImage								Orig_WhitePawn;
		TQImage								Orig_Border;
		TQImage								Orig_BorderLightOn;
		TQImage								Orig_BorderLightOff;

													KnightsPixCache();
													~KnightsPixCache();
		void									clear( void );
		void									setCacheLimit( const unsigned int &limit );
		unsigned int					cacheLimit( void );
		void									add( const TQString &label, const TQPixmap &pixmap );
		bool									find( const TQString &label, TQPixmap &pixmap);
		void									resize( const int &size );
		
		private:
		
		pixmapList						list;
		pixmapList::Iterator	IT;
		
		unsigned int					bytesUsed;
		unsigned int					bytesTotal;
		
		void									cleanCache( const unsigned int &space );
};

#endif
