# Copyright 2023 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="optional"
TRINITY_BUILD_ADMIN="yes"

TRINITY_LANGS="bg bs ca cs da de el en_GB es fr hu it ja lt \
		nl pl pt_BR pt ru sk sl sr@Latn sr sv tr uk zh_CN"
TRINITY_MODULE_TYPE="applications/system"
inherit trinity-base-2

DESCRIPTION="Twin-panel file manager for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi

rm_lang() {
	local x
	for x in ${TRINITY_LANGS}
	do
		if ! has ${x} ${L10N} ; then
			rm "${S}/po/${x}.po"
		fi
	done
}

src_prepare() {
	rm_lang
	trinity-base-2_src_prepare
}

src_configure() {
	local myconf=(
		--enable-final=no
	)
	trinity-econf "${myconf[@]}"
}
