# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

VERIFY_SIG_OPENPGP_KEY_PATH=/usr/share/openpgp-keys/gnupg.asc
inherit autotools verify-sig

DESCRIPTION="A tqt version of pinentry passphrase dialog"
HOMEPAGE="https://gnupg.org/aegypten2"
MY_PN=pinentry
SRC_URI="mirror://gnupg/${MY_PN}/${MY_PN}-${PV}.tar.bz2"
SRC_URI+=" verify-sig? ( mirror://gnupg/${MY_PN}/${MY_PN}-${PV}.tar.bz2.sig )"
S="${WORKDIR}/${MY_PN}-${PV}"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~x86"
IUSE="caps keyring ncurses"

DEPEND="
	>=dev-libs/libassuan-2.1
	>=dev-libs/libgpg-error-1.17
	keyring? ( app-crypt/libsecret )
	ncurses? ( sys-libs/ncurses:= )
	>=dev-tqt/tqt-14.1.1
"
RDEPEND="
	${DEPEND}
	app-crypt/pinentry
"
BDEPEND="
	sys-devel/gettext
	virtual/pkgconfig
	verify-sig? ( sec-keys/openpgp-keys-gnupg )
"
IDEPEND=">=app-eselect/eselect-pinentry-0.7.2"

# DOCS=( AUTHORS ChangeLog NEWS README THANKS TODO )
DOCS=( )

PATCHES=(
	"${FILESDIR}/${PN}-1.0.0-AR.patch"
	"${FILESDIR}/${PN}-1.2.1-automagic-capslock.patch" # bug #819939, bug #837719
)

src_prepare() {
	default

	sed "s/Q_EXPORT/TQ_EXPORT/g" -i "${S}/tqt/secqinternal_p.h" || die
	sed "s/Q_EXPORT/TQ_EXPORT/g" -i "${S}/tqt/secqlineedit.h" || die
	sed "s/Q_EXPORT/TQ_EXPORT/g" -i "${S}/tqt/secqstring.cpp" || die
	sed "s/Q_EXPORT/TQ_EXPORT/g" -i "${S}/tqt/secqstring.h" || die

	eautoreconf
}

src_configure() {
	local myeconfargs=(
		$(use_enable keyring libsecret)
		$(use_enable ncurses fallback-curses)
		--enable-pinentry-tqt
		--disable-kf5-wayland
		--disable-pinentry-{tty,efl,emacs,gnome3,curses,qt,fltk,gtk2}
		--disable-pinentry-fltk
		--disable-pinentry-gtk2
		--disable-doc

		$("${S}/configure" --help | grep -- '--without-.*-prefix' | sed -e 's/^ *\([^ ]*\) .*/\1/g')
	)

	econf "${myeconfargs[@]}"
}

src_install() {
	default

	rm "${ED}"/usr/bin/pinentry || die
}

pkg_postinst() {
#	eselect pinentry update ifunset
	ewarn "As for now eselect doesn't support pinentry-tqt, So in order to use it as"
	ewarn "your default pinentry input method you will have to symlink it manually:"
	ewarn "  ln -nsf pinentry-tqt /usr/bin/pinentry"
	ewarn
	ewarn "Alternatively you may add the following line to your gpg-agent.conf:"
	ewarn "  pinentry-program /usr/bin/pinentry-tqt"
}

pkg_postrm() {
	eselect pinentry update ifunset
}
