/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2005-07-07
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2005-2008 by Vardhman Jain <vardhman at gmail dot com>
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef FLICKRTALKER_H
#define FLICKRTALKER_H

// TQt includes.

#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqobject.h>
#include <tqprogressdialog.h>

// KDE includes.

#include <kurl.h>
#include <tdeio/job.h>

class TQProgressDialog;

namespace KIPIFlickrExportPlugin
{

class GAlbum;
class GPhoto;
class FPhotoInfo;
class FPhotoSet;

class FlickrTalker : public TQObject
{
    TQ_OBJECT
  

public:

    enum State 
    {
        FE_LOGIN = 0,
        FE_LISTPHOTOSETS,
        FE_LISTPHOTOS,
        FE_GETPHOTOPROPERTY,
        FE_ADDPHOTO,
        FE_GETFROB,
        FE_CHECKTOKEN,
        FE_GETTOKEN,
        FE_GETAUTHORIZED
    };

public:

    FlickrTalker(TQWidget* parent);
    ~FlickrTalker();

    TQString getUserName();
    TQString getUserId();
    void    getFrob();
    void    getToken();
    void    checkToken(const TQString& token);
    void    getPhotoProperty(const TQString& method, const TQStringList& argList);
    void    cancel();

    void    listPhotoSets();
    void    listPhotos(const TQString& albumName);
    void    createAlbum(const TQString& parentAlbumName,
                        const TQString& albumName,
                        const TQString& albumTitle,
                        const TQString& albumCaption);

    bool    addPhoto(const TQString& photoPath, const FPhotoInfo& info,
                     bool rescale=false, int maxDim=600, int imageQuality=85);

public:

    TQProgressDialog *m_authProgressDlg;

signals:

    void signalError(const TQString& msg);
//  void signalLoginFailed( const TQString& msg );
    void signalBusy(bool val);
    void signalAlbums(const TQValueList<GAlbum>& albumList);
    void signalPhotos(const TQValueList<GPhoto>& photoList);
    void signalAddPhotoSucceeded();
    void signalListPhotoSetsSucceeded(const TQValueList <FPhotoSet>& photoSetList);
    void signalAddPhotoFailed(const TQString& msg);
    void signalListPhotoSetsFailed(const TQString& msg);
    void signalAuthenticate();
    void signalTokenObtained(const TQString& token);

private:

//  void parseResponseLogin(const TQByteArray& data);
    void parseResponseListPhotoSets(const TQByteArray& data);
    void parseResponseListPhotos(const TQByteArray& data);
    void parseResponseCreateAlbum(const TQByteArray& data);
    void parseResponseAddPhoto(const TQByteArray& data);
    void parseResponseGetFrob(const TQByteArray& data);
    void parseResponseGetToken(const TQByteArray& data);
    void parseResponseCheckToken(const TQByteArray& data);
    void parseResponsePhotoProperty(const TQByteArray& data);

    TQString getApiSig(const TQString& secret, const KURL& url);

private slots:

    void slotError(const TQString& msg);
    void slotAuthenticate();
    void data(TDEIO::Job *job, const TQByteArray& data);
    void slotResult(TDEIO::Job *job);

private:

    TQWidget*   m_parent;

//  TQString    m_cookie;
    TQByteArray m_buffer;

    TQString    m_apikey;
    TQString    m_secret;
    TQString    m_frob;
    TQString    m_token;
    TQString    m_username;
    TQString    m_userId;

    TDEIO::Job*  m_job;

    State      m_state;
};

} // namespace KIPIFlickrExportPlugin

#endif /* FLICKRTALKER_H */
