// This module implements the TQextScintillaLexerCSharp class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <tqcolor.h>
#include <tqfont.h>

#include "tqextscintillalexercsharp.h"


// The ctor.
TQextScintillaLexerCSharp::TQextScintillaLexerCSharp(TQObject *parent,const char *name)
	: TQextScintillaLexerCPP(parent,name)
{
}


// The dtor.
TQextScintillaLexerCSharp::~TQextScintillaLexerCSharp()
{
}


// Returns the language name.
const char *TQextScintillaLexerCSharp::language() const
{
	return "C#";
}


// Returns the foreground colour of the text for a style.
TQColor TQextScintillaLexerCSharp::color(int style) const
{
	if (style == VerbatimString)
		return TQColor(0x00,0x7f,0x00);

	return TQextScintillaLexerCPP::color(style);
}


// Returns the end-of-line fill for a style.
bool TQextScintillaLexerCSharp::eolFill(int style) const
{
	if (style == VerbatimString)
		return true;

	return TQextScintillaLexerCPP::eolFill(style);
}


// Returns the font of the text for a style.
TQFont TQextScintillaLexerCSharp::font(int style) const
{
	if (style == VerbatimString)
#if defined(Q_OS_WIN)
		return TQFont("Courier New",10);
#else
		return TQFont("Bitstream Vera Sans Mono",9);
#endif

	return TQextScintillaLexerCPP::font(style);
}


// Returns the set of keywords.
const char *TQextScintillaLexerCSharp::keywords(int set) const
{
	if (set != 1)
		return 0;

	return "abstract as base bool break byte case catch char checked "
	       "class const continue decimal default delegate do double else "
	       "enum event explicit extern false finally fixed float for "
	       "foreach goto if implicit in int interface internal is lock "
	       "long namespace new null object operator out override params "
	       "private protected public readonly ref return sbyte sealed "
	       "short sizeof stackalloc static string struct switch this "
	       "throw true try typeof uint ulong unchecked unsafe ushort "
	       "using virtual void while";
}


// Returns the user name of a style.
TQString TQextScintillaLexerCSharp::description(int style) const
{
	if (style == VerbatimString)
		return tr("Verbatim string");

	return TQextScintillaLexerCPP::description(style);
}


// Returns the background colour of the text for a style.
TQColor TQextScintillaLexerCSharp::paper(int style) const
{
	if (style == VerbatimString)
		return TQColor(0xe0,0xff,0xe0);

	return TQextScintillaLexer::paper(style);
}

#include "tqextscintillalexercsharp.moc"
