
#include <pwd.h>
#include <tqstring.h>
#include "core/polkit-tqt-identity.h"

#define TEST_PASSED 0
#define TEST_FAILED 1

using namespace PolkitTQt;

int main(void)
{
  int test_result = TEST_PASSED;

  // Get real name and id of current user and group
  struct passwd *userinfo = getpwuid(getuid());
  TQString userName = userinfo->pw_name;
  unsigned int userId = userinfo->pw_uid;
  unsigned int groupId = userinfo->pw_gid;

  // Create generic Identity from UnixUser via string representation
  UnixUserIdentity user(userName);
  if (!user.identity())
  {
    return TEST_FAILED;
  }
  Identity id = Identity::fromString(user.toString());
  if (static_cast<UnixUserIdentity*>(&id)->uid() != userId)
  {
    return TEST_FAILED;
  }

  UnixGroupIdentity group(groupId);
  if (!group.identity())
  {
    return TEST_FAILED;
  }
  id = Identity::fromString(group.toString());
  if (static_cast<UnixGroupIdentity*>(&id)->gid() != groupId)
  {
    return TEST_FAILED;
  }

  // Test setting gid to another value
  group.setGid(9999U);
  id = Identity::fromString(group.toString());
  if (static_cast<UnixGroupIdentity*>(&id)->gid() != 9999U)
  {
    return TEST_FAILED;
  }

  return TEST_PASSED;
}
