/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2002-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/


#ifndef SELECTOPDLG_H
#define SELECTOPDLG_H

#include <kdialogbase.h>

#include <tqgroupbox.h>
#include <kcombobox.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include "../classifier.h"

class UMLView;

#define OP     0
#define CUSTOM  1

/**
 * A dialog used to select an operation.
 *
 * @short A dialog to select an operation.
 * @author Paul Hensgen <phensgen@techie.com>
 * Bugs and comments to uml-devel@lists.sf.net or http://bugs.trinitydesktop.org
 */

class SelectOpDlg : public KDialogBase
{
    TQ_OBJECT
  
public:
    /**
     *  Constructs a SelectOpDlg instance.
     *
     *  @param  parent  The parent to this instance.
     *  @param  c       The concept to get the operations from.
     */
    SelectOpDlg(UMLView * parent, UMLClassifier * c);

    /**
     *  Standard deconstructor.
     */
    ~SelectOpDlg();

    /**
     *  Returns the operation to display.
     *
     *  @return The operation to display.
     */
    TQString getOpText();

    /**
     * Return whether the user selected a class operation
     * or a custom operation.
     *
     * @return  True if user selected a class operation,
     *          false if user selected a custom operation
     */
    bool isClassOp() const;

    /**
     *  Returns the sequence number for the operation.
     *
     *  @return Returns the sequence number for the operation.
     */
    TQString getSeqNumber();

    /**
     * Set the sequence number text.
     *
     *  @param  num     The number to set the sequence to.
     */
    void setSeqNumber(const TQString &num);

    /**
     * Set the custom operation text.
     *
     *  @param op The operation to set as the custom operation.
     */
    void setCustomOp(const TQString &op);
    /**
     * Set the class operation text.
     *
     *  @param op The operation to set as the class operation.
     * @return false if no such operation exists.
     */
    bool setClassOp(const TQString &op);
protected:
    /**
    * Inserts @p type into the type-combobox as well as its completion object.
    */
    void insertOperation( const TQString& type, int index = -1 );
private:
    TQGroupBox * m_pOpGB;
    KComboBox * m_pOpCB;
    TQLabel * m_pSeqL;
    TQLineEdit * m_pOpLE, * m_pSeqLE;
    TQRadioButton * m_pCustomRB, * m_pOpRB;
    TQButtonGroup * m_pOpBG, * m_pDocGB;
    TQString m_Text;
    int m_nOpCount;
    int m_id;  ///< takes on the value OP or CUSTOM according to what the user selected
    UMLView *m_pView;
public slots:
    void slotSelected(int id);
};

#endif

