/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002-203 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.
      
**************************************************************************** */
#ifndef VALIDATEDLG_H
#define VALIDATEDLG_H

#include <tqmap.h>

#include <kdialogbase.h>
#include <kurl.h>

class CatManListItem;
class ValidateProgressWidget;
class KDataToolInfo;
class KDataTool;
class TDEPopupMenu;

struct IgnoreItem
{
    KURL fileURL;
    TQStringList msgid;
    TQStringList msgstr;
    uint index;
    TQString validationTool;
};

TQDataStream & operator<<( TQDataStream & stream, const IgnoreItem &ident );
TQDataStream & operator>>( TQDataStream & stream, IgnoreItem & ident);

class ValidateProgressDialog : public KDialogBase
{
    TQ_OBJECT
  

public:
    ValidateProgressDialog(const TQString& ignoreURL, TQWidget* parent, const char *name=0);
    virtual ~ValidateProgressDialog();
    
    void setIgnoreFuzzy(bool enable) { _ignoreFuzzy = enable; }
    void setMarkAsFuzzy(bool enable) { _setAsFuzzy = enable; }

public slots:
    void validate(const KDataToolInfo &tool, const TQPtrList<CatManListItem> files);

signals:
    void errorDoubleClicked(const TQString file, const int messageNumber);

private slots:
    /** implementation of the validation itself */
    void validate_internal();
    
    /** call this to stop current validation*/
    void stop();
    
    /** If user doubleclicked an item, this slot will be invoked.
     *  It emits errorDoubleClicked signal for corresponding error*/
    void errorItemDoubleClicked(TQListBoxItem * item);
    
    /** show our context menu */
    void showContextMenu(TQListBoxItem * item, const TQPoint & pos);

private:
    void readIgnores();
    void writeIgnores();
    
    ValidateProgressWidget *_mainWidget;
    TQString _ignoreURL;
    KDataTool* _tool;
    TQString _toolID;
    TQPtrList<CatManListItem> _files;
    bool _stopped;
    TDEPopupMenu* _errorMenu;
    
    bool _ignoreFuzzy;
    bool _setAsFuzzy;
    
    TQValueList<IgnoreItem> _ignores;
    TQMap<TQString,IgnoreItem> _errors;
};

#endif // VALIDATEDLG_H
