#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqwidget.h>

#include <tdelocale.h>
#include <kdialog.h>
#include <kdebug.h>

#include "printdialogpage.h"

PrintDialogPage::PrintDialogPage(TQWidget *parent, const char *name)
	: KPrintDialogPage( parent, name )
{
	setTitle(i18n("Kolf Options"));

	TQVBoxLayout *layout = new TQVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());

	titleCheck = new TQCheckBox(i18n("Draw title text"), this);
	titleCheck->setChecked(true);
	layout->addWidget(titleCheck);
}

void PrintDialogPage::getOptions(TQMap<TQString, TQString> &opts, bool /*incldef*/)
{
	opts["kde-kolf-title"] = titleCheck->isChecked()? "true" : "false";
}

void PrintDialogPage::setOptions(const TQMap<TQString, TQString> &opts)
{
	TQString setting = opts["kde-kolf-title"];
	if (!!setting)
		titleCheck->setChecked(setting == "true");
}

#include "printdialogpage.moc"
