//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.QtSupport;

/**

 An abstract base class for adding a completion feature
 into widgets.
 This is a convenience class that provides the basic functions
 needed to add text completion support into widgets.  All that
 is required is an implementation for the pure function
 setCompletedText.  Refer to KLineEdit or KComboBox
 to see how easily such support can be added using this as a base
 class.
		@author Dawit Alemayehu <adawit@kde.org>

		@short An abstract class for adding text completion support to widgets.

*/
public class TDECompletionBase implements QtSupport, TDECompletionBaseInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected TDECompletionBase(Class dummy){}

	/**
		 Constants that represent the items whose short-cut
		 key-binding is programmable.  The default key-bindings
		 for these items are defined in TDEStdAccel.
		     		@short    Constants that represent the items whose short-cut  key-binding is programmable.
	*/
	public static final int TextCompletion = 0;
	public static final int PrevCompletionMatch = 1;
	public static final int NextCompletionMatch = 2;
	public static final int SubstringCompletion = 3;

	/**
		 Default constructor.
		     		@short    Default constructor.
	*/
	/**
		 Returns a pointer to the current completion object.
			 If the completion object does not exist, it is automatically created and
		 by default handles all the completion signals internally unless <code>hsig</code>
		 is set to false. It is also automatically destroyed when the destructor
		 is called. You can change this default behavior using the
		 {@link #setAutoDeleteCompletionObject} and {@link #setHandleSignals} member
		 functions.
			 See also {@link #compObj}.
			@param hsig if true, handles completion signals internally.
				@return a pointer the completion object.

		@short    Returns a pointer to the current completion object.
	*/
	public native TDECompletion completionObject(boolean hsig);
	public native TDECompletion completionObject();
	/**
		 Sets up the completion object to be used.
			 This method assigns the completion object and sets it up to automatically
		 handle the completion and rotation signals internally.  You should use
		 this function if you want to share one completion object among your
		 widgets or need to use a customized completion object.
			 The object assigned through this method is not deleted when this object's
		 destructor is invoked unless you explicitly call {@link #setAutoDeleteCompletionObject}
		 after calling this method. Be sure to set the boolean argument to false, if
		 you want to handle the completion signals yourself.
			@param compObj a TDECompletion() or a derived child object.
			@param hsig if true, handles completion signals internally.
		     		@short    Sets up the completion object to be used.
	*/
	public native void setCompletionObject(TDECompletion compObj, boolean hsig);
	public native void setCompletionObject(TDECompletion compObj);
	/**
		 Enables this object to handle completion and rotation
		 events internally.
			 This function simply assigns a booleanean value that
		 indicates whether it should handle rotation and
		 completion events or not.  Note that this does not
		 stop the object from emitting signals when these
		 events occur.
			@param handle if true, handle completion & rotation internally.
		     		@short    Enables this object to handle completion and rotation  events internally.
	*/
	public native void setHandleSignals(boolean handle);
	/**
		 Returns true if the completion object is deleted
		 upon this widget's destruction.
			 See setCompletionObject() and enableCompletion()
		 for details.
				@return true if the completion object will be deleted
              automatically

		@short    Returns true if the completion object is deleted  upon this widget's destruction.
	*/
	public native boolean isCompletionObjectAutoDeleted();
	/**
		 Sets the completion object when this widget's destructor
		 is called.
			 If the argument is set to true, the completion object
		 is deleted when this widget's destructor is called.
			@param autoDelete if true, delete completion object on destruction.
		     		@short    Sets the completion object when this widget's destructor  is called.
	*/
	public native void setAutoDeleteCompletionObject(boolean autoDelete);
	/**
		 Sets the widget's ability to emit text completion and
		 rotation signals.
			 Invoking this function with <code>enable</code> set to <code>false</code> will
		 cause the completion & rotation signals not to be emitted.
		 However, unlike setting the completion object to <code>NULL</code>
		 using setCompletionObject, disabling the emition of
		 the signals through this method does not affect the current
		 completion object.
			 There is no need to invoke this function by default.  When a
		 completion object is created through completionObject or
		 setCompletionObject, these signals are set to emit
		 automatically.  Also note that disabling this signals will not
		 necessarily interfere with the objects ability to handle these
		 events internally.  See setHandleSignals.
			@param enable if false, disables the emition of completion & rotation signals.
		     		@short    Sets the widget's ability to emit text completion and  rotation signals.
	*/
	public native void setEnableSignals(boolean enable);
	/**
		 Returns true if the object handles the signals.
				@return true if this signals are handled internally.

		@short    Returns true if the object handles the signals.
	*/
	public native boolean handleSignals();
	/**
		 Returns true if the object emits the signals.
				@return true if signals are emitted

		@short    Returns true if the object emits the signals.
	*/
	public native boolean emitSignals();
	/**
		 Sets the type of completion to be used.
			 The completion modes supported are those defined in
		 TDEGlobalSettings().  See below.
			@param mode Completion type:

			<li>
			CompletionNone:  Disables completion feature.
			</li>

			<li>
			CompletionAuto:  Attempts to find a match &
			                        fills-in the remaining text.
			</li>

			<li>
			CompletionMan:   Acts the same as the above
			                        except the action has to be
			                        manually triggered through
			                        pre-defined completion key.
			</li>

			<li>
			CompletionShell: Mimics the completion feature
			                        found in typical nix shell
			                        environments.
			</li>

			<li>
			CompletionPopup: Shows all available completions at once,
			                        in a listbox popping up.

			</li>		@short    Sets the type of completion to be used.
	*/
	public native void setCompletionMode(int mode);
	/**
		 Returns the current completion mode.
			 The return values are of type TDEGlobalSettings.Completion.
		 See setCompletionMode() for details.
				@return the completion mode.

		@short    Returns the current completion mode.
	*/
	public native int completionMode();
	/**
		 Sets the key-binding to be used for manual text
		 completion, text rotation in a history list as
		 well as a completion list.
			 When the keys set by this function are pressed, a
		 signal defined by the inheriting widget will be activated.
		 If the default value or 0 is specified by the second
		 parameter, then the key-binding as defined in the global
		 setting should be used.  This method returns false value
		 for <code>key</code> is negative or the supplied key-binding conflicts
		 with the ones set for one of the other features.
			 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
		 the key-binding simply simply <code>sum</code> up the values of the
		 modifier and the actual key.  For example, to use CTRL+E as
		 a key binding for one of the items, you would simply supply
		 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
		 function.
			@param item the feature whose key-binding needs to be set:

			<li>
			TextCompletion the manual completion key-binding.
			</li>

			<li>
			PrevCompletionMatch    the previous match key for multiple completion.
			</li>

			<li>
			NextCompletionMatch    the next match key for for multiple completion.
			</li>

			<li>
			SubstringCompletion  the key for substring completion
			</li>
				@param key key-binding used to rotate down in a list.
				@return true if key-binding can successfully be set.

		@short    Sets the key-binding to be used for manual text  completion, text rotation in a history list as  well as a completion list.
		@see #getKeyBinding
	*/
	public native boolean setKeyBinding(int item, TDEShortcut key);
	/**
		 Returns the key-binding used for the specified item.
			 This methods returns the key-binding used to activate
		 the feature feature given by <code>item.</code>  If the binding
		 contains modifier key(s), the SUM of the modifier key
		 and the actual key code are returned.
			@param item the item to check
				@return the key-binding used for the feature given by <code>item.</code>

		@short    Returns the key-binding used for the specified item.
		@see #setKeyBinding
	*/
	public native TDEShortcut getKeyBinding(int item);
	/**
		 Sets this object to use global values for key-bindings.
			 This method changes the values of the key bindings for
		 rotation and completion features to the default values
		 provided in TDEGlobalSettings.
			 NOTE: By default inheriting widgets should uses the
		 global key-bindings so that there will be no need to
		 call this method.
		     		@short    Sets this object to use global values for key-bindings.
	*/
	public native void useGlobalKeyBindings();
	/**
		 A pure function that must be implemented by
		 all inheriting classes.
			 This function is intended to allow external completion
		 implementations to set completed text appropriately.  It
		 is mostly relevant when the completion mode is set to
		 CompletionAuto and CompletionManual modes. See
		 TDECompletionBase.setCompletedText.
		 Does nothing in CompletionPopup mode, as all available
		 matches will be shown in the popup.
			@param text the completed text to be set in the widget.
		     		@short    A pure virtual function that must be implemented by  all inheriting classes.
	*/
	public native void setCompletedText(String text);
	/**
		 A pure function that must be implemented by
		 all inheriting classes.
			@param items the list of completed items
		     		@short    A pure virtual function that must be implemented by  all inheriting classes.
	*/
	public native void setCompletedItems(String[] items);
	/**
		 Returns a pointer to the completion object.
			 This method is only different from completionObject()
		 in that it does not create a new TDECompletion object even if
		 the internal pointer is <code>NULL.</code> Use this method to get the
		 pointer to a completion object when inheriting so that you
		 won't inadvertently create it!!
				@return the completion object or NULL if one does not exist.

		@short    Returns a pointer to the completion object.
	*/
	public native TDECompletion compObj();
}
