/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;
import java.math.*;



class FontDisplayer  extends TQMainWindow {



class FontRowTable  extends TQFrame {
private    TQFont tablefont;
private    int row;

FontRowTable( TQWidget parent )
{
	this(parent, null);
}

FontRowTable( TQWidget parent, String name )
{
    super(parent,name);
    setBackgroundMode(PaletteBase);
    setFrameStyle(Panel|Sunken);
    setMargin(8);
    setRow(0);
    tablefont = TQApplication.font();
}

public TQSize sizeHint()
{
	return new TQSize( 16*cellSize().width()+2*(margin()+frameWidth()),
	                  16*cellSize().height()+2*(margin()+frameWidth()) );
}

TQSize cellSize()
{
    TQFontMetrics fm = fontMetrics();
    return new TQSize( fm.maxWidth(), fm.lineSpacing()+1 );
}

protected void paintEvent( TQPaintEvent e )
{
    super.paintEvent(e);
System.out.println("In paintEvent");
    TQPainter p = new TQPainter(this);
    p.setClipRegion(e.region());
    TQRect r = e.rect();
    TQFontMetrics fm = fontMetrics();
    int ml = frameWidth()+margin() + 1 + (-fm.minLeftBearing() > 0 ? -fm.minLeftBearing() : 0);
    int mt = frameWidth()+margin();
    TQSize cell = new TQSize((width()-15-ml)/16,(height()-15-mt)/16);

    if ( cell.width() == 0 || cell.height() == 0 )
	return;

    int mini = r.left() / cell.width();
    int maxi = (r.right()+cell.width()-1) / cell.width();
    int minj = r.top() / cell.height();
    int maxj = (r.bottom()+cell.height()-1) / cell.height();

    int h = fm.height();

    TQColor body = new TQColor(255,255,192);
    TQColor negative = new TQColor(255,192,192);
    TQColor positive = new TQColor(192,192,255);
    TQColor rnegative = new TQColor(255,128,128);
    TQColor rpositive = new TQColor(128,128,255);

    for (int j = minj; j<=maxj; j++) {
	for (int i = mini; i<=maxi; i++) {
	    if ( i < 16 && j < 16 ) {
		int x = i * cell.width();
		int y = j* cell.height();

		char ch = (char) ((j*16+i) + (row*256));
		
		if ( fm.inFont(ch) ) {
		    int w = fm.width(ch);
		    int lb = fm.leftBearing(ch);
		    int rb = fm.rightBearing(ch);

		    x += ml;
		    y += mt+h;

		    p.fillRect(x,y,w,-h,new TQBrush(body));
		    if ( w != 0) {
			if ( lb != 0 ) {
			    p.fillRect(x+(lb>0?0:lb), y-h/2, Math.abs(lb),-h/2,
				       new TQBrush(lb < 0 ? negative : positive));
			}
			if ( rb != 0) {
			    p.fillRect(x+w-(rb>0?rb:0),y+2, Math.abs(rb),-h/2,
				       new TQBrush(rb < 0 ? rnegative : rpositive));
			}
		    }
		    String s = "";
		    s += ch;
		    p.setPen(new TQPen(Qt.black()));
		    p.drawText(x,y,s);
		}
	    }
	}
    }
	p.end();
}

void setRow(int r)
{
    row = r;

    TQFontMetrics fm = fontMetrics();
    String str = "mLB=" + fm.minLeftBearing() + 
	             " mRB=" + fm.minRightBearing() + 
				 " mW=" + fm.maxWidth();

    emit("fontInformation", str);
    update();
}

void chooseFont()
{
    boolean[] ok = { true };
    TQFont oldfont = tablefont;
    tablefont = TQFontDialog.getFont(ok, oldfont, this);

    if (ok[0])
	setFont(tablefont);
    else
	tablefont = oldfont;


}
}

FontDisplayer( )
{
	this(null, null);
}

FontDisplayer( TQWidget parent, String name )
{
    super(parent,name);
    FontRowTable table = new FontRowTable(this);
    TQToolBar controls = new TQToolBar(this);
    new TQLabel(tr("Row:"), controls);
    TQSpinBox row = new TQSpinBox(0,255,1,controls);
    controls.addSeparator();
    TQPushButton fontbutton = new TQPushButton(tr("Font..."), controls);

    connect(row,TQ_SIGNAL("valueChanged(int)"),table,TQ_SLOT("setRow(int)"));
    connect(fontbutton, TQ_SIGNAL("clicked()"), table, TQ_SLOT("chooseFont()"));
    connect(table,TQ_SIGNAL("fontInformation(String)"),
	    statusBar(),TQ_SLOT("message(String)"));
    table.setRow(0);
    setCentralWidget(table);
}
}
