#!/usr/bin/env kjscmd

//
// Example of loading several parts from a script
//

//
// Main
//
var qd = new TQDir();

var dir = 'file://' + qd.path() + '/../';
var file = dir + 'index.html';

// Create the UI
var mw = new KParts_MainWindow();
var ac = mw.actionCollection();

var split = new TQSplitter( mw );
mw.setCentralWidget( split );

//
// Load the sidebar
//
var side = Factory.createROPart( "inode/directory", split, "sidebar" );

//
// Load the views
//
var views = new TQSplitter( split );
views.orientation = 1;

var top = Factory.createROPart( "text/html", views, "html" );

var bottom = Factory.createROPart( "text/plain", views, "source" );

//
// Glue it together
//
top.connect(side.child(0), 'openURLRequest(const KURL&,const KParts::URLArgs&)', 'openURL(const KURL&)' )
bottom.connect(side.child(0), 'openURLRequest(const KURL&,const KParts::URLArgs&)', 'openURL(const KURL&)' )

side.openURL( dir );
top.openURL( file );
bottom.openURL( file );

//
// Activate XMLGUI and show the window
//
StdAction.quit( mw, 'close()', mw.actionCollection() );

mw.resize( 700, 500 );
split.child(1).maximumWidth = 200;

mw.show();
application.exec();
