/***************************************************************************
 *   Copyright (C) 2004 by David Sansome                                   *
 *   david@dave-linux                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _KCMTEST_H_
#define _KCMTEST_H_

#include <tdecmodule.h>
#include <tdeaboutdata.h>

#include "kcmgtkwidget.h"
#include "emacsdetails.h"
#include "searchpaths.h"

class GtkRcParser
{
public:
	GtkRcParser();
	~GtkRcParser() {}
	
	void parse(TQString fileName);
	
	TQFont font;
	TQString style;
	bool emacs;

private:
	TQFont parseFont(TQString fontString);
};

class KcmGtk: public TDECModule
{
	TQ_OBJECT
  
	
	// How to name the kde-specific gtk-rc-file
	static const TQString GTK_RC_FILE;
	// Where to search for KDE's config files
	static const TQString KDE_RC_DIR;
	// How to name gtk-qt-engines rc-file
	static const TQString GTK_TQT_RC_FILE;

	static const TQString GTK3_INI_DIR;
	static const TQString GTK3_INI_FILE;

public:
	KcmGtk( TQWidget *parent=0, const char *name=0, const TQStringList& = TQStringList() );
	~KcmGtk();
	
	virtual void load();
	virtual void save();
	virtual int buttons();
	virtual TQString quickHelp() const;
	virtual const TDEAboutData *aboutData()const
	{ return myAboutData; };

public slots:
	void styleChanged();
	void fontChangeClicked();
	void itemChanged();
	void emacsDetailsClicked();
	void searchPathsClicked();
	void searchPathsOk();
	void searchPathsAddClicked();
	void searchPathsRemoveClicked();
	void searchPathsTextChanged(const TQString& text);
	void searchPathsCurrentChanged(TQListBoxItem* item);

private:
	void updateFontPreview();
	void getInstalledThemes();

	TQString env(TQString key);

	KcmGtkWidget* widget;
	TQMap<TQString,TQString> themes;
	TQMap<TQString,TQString> gtk3Themes;
	GtkRcParser parser;
	TDEAboutData *myAboutData;
	TQFont font;
	TQMap<TQString,TQString> profiles;
	EmacsDetails* emacsDetailsDialog;
	TQStringList gtkSearchPaths;
	SearchPaths* searchPathsDialog;
	TDEConfig* config;
};

#endif
