/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SCANVIEWER_H_
#define _SCANVIEWER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include "k3bjobprogressosd_mod.h"


class KPrinter;
class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListBox;
class TQListView;
class TQListViewItem;
class TQPushButton;
class TQLabel;
class KProcIO;
class TDEConfig;
class KURLRequester;
class KProgress;
class K3bJobProgressOSD;
class KProgressDialog;
class TQDir;
class TQGridLayout;

/**
 * This class serves as the main window for ScanViewer.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class ScanViewer  : public TQWidget
{
    TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    ScanViewer(TQWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~ScanViewer();

    /**
     * Use this method to load whatever file/URL you have
     */

    //void  setDirName(TQString);
    void slotScan(const TQStringList & filepattern, int mode, bool recursive, bool dcopscan);
    void slotCancel();
    void slotStartAgain();
    bool scanGoingOn();

protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);


private slots:

    void slotProg();
    void slotOnItem( TQListViewItem * lineitem);
    void slotOffItem();
private:
    void setupAccel();
    void setupActions();
    void startProgressDialog( const TQString & text );

private:

signals:
    void itemSelected(TQString abs_filename, int line);
    void scanFinished(TQWidget *);
    void scanStartingAgain(TQWidget *);
public slots:


private slots:
    //void dirButtonClicked();
    //void templateActivated(int index);
    void childExited();
    void resetSysTray();
    void receivedOutput(KProcIO *);
    //void itemSelected(const TQString&);
    void slotClear();
    void slotRMB( TQListViewItem *, const TQPoint &, int );
    void slotQuarantineSelected();
    void slotGoogle();
    void slotTrendMicro();
	void slotCancelScanTime();
    //void patternTextChanged( const TQString &);
private:
    void processOutput();
    void finish();
    void getout();
    void Quarantine();
    void askUser();
    int countFiles( TQDir & root);
    TQString scanner;
    //void ScanViewer::startProgress();
    TQLineEdit *template_edit;
    TQComboBox *files_combo, *pattern_combo, *check_combo;
    //KComboBox *dir_combo;
    TQCheckBox *recursive_box;
    TQCheckBox *recursive_box2;
    TQListView *resultview;
    TQPushButton *search_button, *cancel_button;
    TQLabel *status_label, *status2_label,*matches_label,*matches2_label;
    KProcIO *childproc;
    TQString buf;
    TDEConfig* config;
    TQStringList lastSearchItems;
    TQStringList lastScanPaths;
    TQStringList lastQuarItems;
    TQStringList QuarantineList;
    bool errorsEncountered;
    TQPopupMenu* menu;
    TQPushButton* adv_options;
    TQPushButton* schedule;
    TQString selectedVirus;
    bool multiScan;
    TQString urlsToScan;
    bool scanInProgress;
    bool scanCancelled;
    TQString prevdir;
    TQStringList listOfUrlsToScan;
    bool multi_recursive;
    int m_mode;
    TQStringList m_filepattern;
    bool m_recursive;
    int filesscanned;
    int cnt;
    KProgressDialog* progress;
    KProgress* prog;
    K3bJobProgressOSD* progosd;
    TQBoxLayout *status2_layout;
    TQFrame *status2_frame;
    TQGridLayout *layout;
    KProgressDialog *progressDialog;
    TQTimer *timer;
	TQPushButton* scan_time;
	bool calculateTime;
	bool showProgress;
    TQFrame *status_frame;
  bool clamdscan;
};

#endif // _SCANVIEWER_H_
